/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.SystemProperties;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JSEvaluatorComplexityTracker {
    private static final int MAX_DEPTH = SystemProperties.getIntProperty((String)"idea.javascript.max.evaluation.depth", (int)12);
    private static final ThreadLocal<JSEvaluatorComplexityTracker> ourComplexityTracker = ThreadLocal.withInitial(() -> new JSEvaluatorComplexityTracker());
    private final int myAllowedDepth;
    private int myCurrentDepth;
    private int myMaxBranchDepth;
    private Object myKeyForCachingPrevention = null;
    private final RecursionGuard<Object> recursionGuard = RecursionManager.createGuard((String)"js.evaluator.depth.tracker");
    private static boolean ourAssertOnPrevention = false;

    public JSEvaluatorComplexityTracker() {
        this(MAX_DEPTH);
    }

    public JSEvaluatorComplexityTracker(int allowedDepth) {
        this.myAllowedDepth = allowedDepth;
        this.myCurrentDepth = 0;
        this.myMaxBranchDepth = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T> runTask(int ownDepth, @NotNull Supplier<? extends @Nullable T> task) {
        JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<Object> jSComplexityAwareCachedValue;
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(0);
        }
        if (this.myCurrentDepth + ownDepth > this.myAllowedDepth) {
            if (this.myKeyForCachingPrevention != null) {
                this.recursionGuard.prohibitResultCaching(this.myKeyForCachingPrevention);
            }
            JSEvaluationLogger.getInstance().cachingProhibited();
            return null;
        }
        Object key = new Object();
        boolean keyForCachingPreventionWasSet = false;
        if (this.myKeyForCachingPrevention == null) {
            this.myKeyForCachingPrevention = key;
            keyForCachingPreventionWasSet = true;
        }
        int depthBefore = this.myCurrentDepth;
        int maxBranchDepthBefore = this.myMaxBranchDepth;
        Object value = null;
        try {
            JSEvaluationLogger.getInstance().startTask(() -> String.format("%s. depthBefore = %d; maxBranchDepthBefore = %d", task, depthBefore, maxBranchDepthBefore));
            this.myCurrentDepth += ownDepth;
            this.myMaxBranchDepth = this.myCurrentDepth;
            value = this.recursionGuard.doPreventingRecursion(key, true, task::get);
            jSComplexityAwareCachedValue = new JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<Object>(this.myMaxBranchDepth - depthBefore, value);
            Object finalValue = value;
            JSEvaluationLogger.getInstance().finishTask(() -> ", maxBranchDepth = " + this.myMaxBranchDepth + ", value = " + JSEvaluationLogger.toPresentable(finalValue));
            this.myCurrentDepth = depthBefore;
        }
        catch (Throwable throwable) {
            Object finalValue = value;
            JSEvaluationLogger.getInstance().finishTask(() -> ", maxBranchDepth = " + this.myMaxBranchDepth + ", value = " + JSEvaluationLogger.toPresentable(finalValue));
            this.myCurrentDepth = depthBefore;
            this.myMaxBranchDepth = Math.max(this.myMaxBranchDepth, maxBranchDepthBefore);
            if (keyForCachingPreventionWasSet) {
                this.myKeyForCachingPrevention = null;
            }
            throw throwable;
        }
        this.myMaxBranchDepth = Math.max(this.myMaxBranchDepth, maxBranchDepthBefore);
        if (keyForCachingPreventionWasSet) {
            this.myKeyForCachingPrevention = null;
        }
        return jSComplexityAwareCachedValue;
    }

    public int getCurrentDepth() {
        return this.myCurrentDepth;
    }

    public int getAvailableDepth() {
        return this.myAllowedDepth - this.myCurrentDepth;
    }

    public void useDepth(int depth) {
        if (depth < 0 || this.myCurrentDepth + depth > this.myAllowedDepth) {
            throw new IllegalArgumentException("depth: " + depth);
        }
        this.myMaxBranchDepth = Math.max(this.myMaxBranchDepth, this.myCurrentDepth + depth);
    }

    @TestOnly
    public static void assertOnRecursionPrevention(@NotNull Disposable disposable) {
        if (disposable == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(1);
        }
        ourAssertOnPrevention = true;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertOnPrevention = false;
            }
        });
    }

    @TestOnly
    public static boolean isAssertOnPrevention() {
        return ourAssertOnPrevention;
    }

    @NotNull
    public static JSEvaluatorComplexityTracker getDefaultInstance() {
        JSEvaluatorComplexityTracker jSEvaluatorComplexityTracker = ourComplexityTracker.get();
        if (jSEvaluatorComplexityTracker == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(2);
        }
        return jSEvaluatorComplexityTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecursionPrevention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

