/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSContextLevel {
    @NotNull
    public final JSNamespace myNamespace;
    public final int myRelativeLevel;

    public JSContextLevel(@NotNull JSNamespace namespace, int relativeLevel) {
        if (namespace == null) {
            JSContextLevel.$$$reportNull$$$0(0);
        }
        this.myNamespace = namespace;
        this.myRelativeLevel = relativeLevel;
    }

    public String toString() {
        return this.myNamespace.toString() + " ," + this.myRelativeLevel;
    }

    public boolean isElementInScope(@NotNull JSPsiElementBase element, @NotNull JSNamespace elementJSNamespace) {
        PsiElement localScope;
        if (element == null) {
            JSContextLevel.$$$reportNull$$$0(1);
        }
        if (elementJSNamespace == null) {
            JSContextLevel.$$$reportNull$$$0(2);
        }
        if ((localScope = this.myNamespace.getLocalScope()) != null) {
            return JSContextLevel.isFromScope(element, localScope);
        }
        if (this.isFromComment()) {
            return true;
        }
        return !elementJSNamespace.isLocal() || this.myNamespace.isLocal();
    }

    private static boolean isFromScope(@NotNull JSPsiElementBase element, @NotNull PsiElement localScope) {
        if (element == null) {
            JSContextLevel.$$$reportNull$$$0(3);
        }
        if (localScope == null) {
            JSContextLevel.$$$reportNull$$$0(4);
        }
        JSPsiElementBase scope = element;
        while (scope != null) {
            if (localScope.equals(scope)) {
                return true;
            }
            scope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)scope);
        }
        return false;
    }

    public boolean isGlobal() {
        return !this.myNamespace.isLocal();
    }

    public boolean isFromComment() {
        return this.myNamespace.getSourceElement() instanceof PsiComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementJSNamespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localScope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSContextLevel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isElementInScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFromScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

