/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSLocalNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassResolver {
    private static JSClassResolver INSTANCE = null;
    private static final Logger LOG = Logger.getInstance(JSClassResolver.class);

    protected JSClassResolver() {
    }

    public static JSClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSClassResolver();
        }
        return INSTANCE;
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context) {
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(1);
        }
        return JSClassResolver.findClassFromNamespace(qname, context, JSResolveUtil.getResolveScope(context));
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context, @NotNull GlobalSearchScope scope) {
        JSNamedElement localElement;
        DialectOptionHolder dialect;
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(4);
        }
        if ((dialect = DialectDetector.dialectOfElement(context)) != null && (dialect.isJavaScript() || dialect.isTypeScript)) {
            return null;
        }
        VirtualFile vFile = context.getContainingFile().getVirtualFile();
        if (!"Object".equals(qname) && (vFile == null || scope.contains(vFile)) && (localElement = JSResolveUtil.findFileLocalElement(qname, context)) != null) {
            return localElement;
        }
        return JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(qname, scope);
    }

    public static long getResolveResultTimestamp(PsiElement candidate) {
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            long result2 = helper.getResolveResultTimestamp(candidate);
            if (result2 == -1L) continue;
            return result2;
        }
        return -1L;
    }

    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(6);
        }
        return this.doFindClassByQName(link, JSResolveUtil.getResolveScope(context), false);
    }

    @Nullable
    public PsiElement findClassByQName(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(8);
        }
        return TypeScriptClassResolver.getInstance().findAnyClassByQName(link, scope);
    }

    protected PsiElement doFindClassByQName(@NotNull String link, GlobalSearchScope searchScope, boolean allowFileLocalSymbols) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(9);
        }
        Project project = searchScope.getProject();
        if (LOG.isTraceEnabled()) {
            LOG.trace("doFindClassByQName: " + link);
        }
        IdFilter filter = JSClassResolver.getFilterFromScope(searchScope);
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)link.hashCode(), (Project)project, (GlobalSearchScope)searchScope, (IdFilter)filter, JSQualifiedNamedElement.class);
        for (Object _clazz : candidates) {
            PsiFile file2;
            JSQualifiedNamedElement clazz;
            if (!(_clazz instanceof JSQualifiedNamedElement) || !link.equals((clazz = (JSQualifiedNamedElement)_clazz).getQualifiedName()) || (file2 = clazz.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public List<JSClass> findClassesByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Project project;
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(11);
        }
        if ((project = scope.getProject()) == null) {
            if (scope != GlobalSearchScope.EMPTY_SCOPE) {
                Logger.getInstance(JSClassResolver.class).error("Incorrect scope: " + scope);
            }
            List<JSClass> list2 = Collections.emptyList();
            if (list2 == null) {
                JSClassResolver.$$$reportNull$$$0(12);
            }
            return list2;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("findClassesByQName: " + qName);
        }
        IdFilter filter = JSClassResolver.getFilterFromScope(scope);
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), (Project)project, (GlobalSearchScope)scope, (IdFilter)filter, JSQualifiedNamedElement.class);
        SmartList classes = new SmartList();
        for (Object _clazz : candidates) {
            JSClass clazz;
            if (!(_clazz instanceof JSClass) || !qName.equals((clazz = (JSClass)_clazz).getQualifiedName())) continue;
            classes.add((Object)clazz);
        }
        SmartList smartList = classes;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(13);
        }
        return smartList;
    }

    @Deprecated
    public Collection<JSQualifiedNamedElement> findElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Project project;
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(15);
        }
        return (project = scope.getProject()) != null ? this.findElementsByQName(qName, scope, project) : Collections.emptyList();
    }

    public boolean processElementByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Project project, @NotNull Processor<? super JSQualifiedNamedElement> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(17);
        }
        if (project == null) {
            JSClassResolver.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(19);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("processElementByQName: " + qName);
        }
        IdFilter filter = JSClassResolver.getFilterFromScope(scope);
        return StubIndex.getInstance().processElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), project, scope, filter, JSQualifiedNamedElement.class, processor);
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(21);
        }
        if (project == null) {
            JSClassResolver.$$$reportNull$$$0(22);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        this.processElementByQName(qName, scope, project, (Processor<? super JSQualifiedNamedElement>)processor);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(23);
        }
        return smartList;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(25);
        }
        Collection<JSPsiElementBase> collection = this.findNamespaceMembers(namespace, scope, null);
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(26);
        }
        return collection;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(27);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(29);
        }
        return this.processNamespaceMembers(namespace, scope, (GlobalSearchScope)null, processor);
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembersIncludingLocal(@NotNull String namespace, @NotNull GlobalSearchScope scope) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(31);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        this.processNamespaceMembers(namespace, scope, scope, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(32);
        }
        return smartList;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @Nullable GlobalSearchScope scopeToIncludeLocal) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(34);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        this.processNamespaceMembers(namespace, scope, scopeToIncludeLocal, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(35);
        }
        return smartList;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull PsiFile scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(36);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(37);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(38);
        }
        GlobalSearchScopeWithIdFilter fileScope = new GlobalSearchScopeWithIdFilter(scope);
        return this.processNamespaceMembers(namespace, (GlobalSearchScope)fileScope, (GlobalSearchScope)fileScope, processor);
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @Nullable PsiFile fileToIncludeLocal, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(39);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(40);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(41);
        }
        GlobalSearchScopeWithIdFilter localNsScope = fileToIncludeLocal != null ? new GlobalSearchScopeWithIdFilter(fileToIncludeLocal) : null;
        return this.processNamespaceMembers(namespace, scope, (GlobalSearchScope)localNsScope, processor);
    }

    private boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope globalNsScope, @Nullable GlobalSearchScope localNsScope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(42);
        }
        if (globalNsScope == null) {
            JSClassResolver.$$$reportNull$$$0(43);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(44);
        }
        JSQualifiedNameImpl namespaceQName = "".equals(namespace) ? null : JSQualifiedNameImpl.fromQualifiedName(namespace);
        Project project = globalNsScope.getProject();
        if (project == null) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("processNamespaceMembers: " + namespace);
        }
        Processor<JSElement> namespaceMembersProcessor = JSClassResolver.getNamespaceMembersProcessor(processor, namespaceQName);
        if (localNsScope != null && !StubIndex.getInstance().processElements(JSLocalNamespaceMembersIndex.KEY, (Object)namespace, project, localNsScope, JSClassResolver.getFilterFromScope(localNsScope), JSElement.class, namespaceMembersProcessor)) {
            return false;
        }
        return StubIndex.getInstance().processElements(JSNamespaceMembersIndex.KEY, (Object)namespace, project, globalNsScope, JSClassResolver.getFilterFromScope(globalNsScope), JSElement.class, namespaceMembersProcessor);
    }

    @NotNull
    private static Processor<JSElement> getNamespaceMembersProcessor(@NotNull Processor<? super JSPsiElementBase> processor, JSQualifiedNameImpl namespaceQName) {
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(45);
        }
        Processor processor2 = element -> {
            Collection implicitElements;
            JSElementIndexingData data;
            boolean emptyImplicitElements = true;
            if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
                emptyImplicitElements = false;
                for (JSImplicitElement implicitElement : implicitElements) {
                    if (!ComparatorUtil.equalsNullable((Object)namespaceQName, (Object)implicitElement.getNamespace()) || processor.process((Object)implicitElement)) continue;
                    return false;
                }
            }
            return !(element instanceof JSPsiElementBase) || !emptyImplicitElements && !ComparatorUtil.equalsNullable((Object)namespaceQName, (Object)((JSPsiElementBase)element).getNamespace()) || processor.process((Object)((JSPsiElementBase)element));
        };
        if (processor2 == null) {
            JSClassResolver.$$$reportNull$$$0(46);
        }
        return processor2;
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(47);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(48);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementsByQNameIncludingImplicit(qName, scope, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(49);
        }
        return collection;
    }

    @NotNull
    public List<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull PsiFile scope) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(50);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(51);
        }
        ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(result2);
        this.processElementsByQNameIncludingImplicit(qName, (GlobalSearchScope)new GlobalSearchScopeWithIdFilter(scope), x -> x.equals(scope), (Processor<? super JSPsiElementBase>)processor);
        ArrayList<JSPsiElementBase> arrayList = result2;
        if (arrayList == null) {
            JSClassResolver.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(53);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(54);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(55);
        }
        this.processElementsByQNameIncludingImplicit(qName, scope, x -> false, processor);
    }

    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull @NotNull Predicate<? super @NotNull PsiFile> includeLocalMembers, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(56);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(57);
        }
        if (includeLocalMembers == null) {
            JSClassResolver.$$$reportNull$$$0(58);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(59);
        }
        Project project = scope.getProject();
        assert (project != null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("processElementsByQNameIncludingImplicit: " + qName);
        }
        IdFilter filter = JSClassResolver.getFilterFromScope(scope);
        Processor<JSElement> processorForQNameIncludingImplicit = JSClassResolver.getProcessorForQNameIncludingImplicit(qName, includeLocalMembers, processor);
        StubIndex.getInstance().processElements(JSSymbolQualifiedNamesIndex.KEY, (Object)qName.hashCode(), project, scope, filter, JSElement.class, processorForQNameIncludingImplicit);
    }

    @NotNull
    private static Processor<JSElement> getProcessorForQNameIncludingImplicit(@NotNull String qName, @NotNull @NotNull Predicate<? super @NotNull PsiFile> includeLocalMembers, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(60);
        }
        if (includeLocalMembers == null) {
            JSClassResolver.$$$reportNull$$$0(61);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(62);
        }
        Processor processor2 = element -> {
            JSQualifiedName ns;
            PsiFile file2;
            Object processedElementQName;
            if (element instanceof JSPsiElementBase && qName.equals(processedElementQName = (file2 = element.getContainingFile()) != null && includeLocalMembers.test(file2) ? ((ns = ((JSPsiElementBase)element).getJSNamespace().getQualifiedName()) != null ? ns.getQualifiedName() + "." + element.getName() : element.getName()) : ((JSPsiElementBase)element).getQualifiedName()) && !processor.process((Object)((JSPsiElementBase)element))) {
                return false;
            }
            if (element instanceof JSImplicitElementProvider) {
                List elements = ((JSImplicitElementProvider)element).findElementsByQualifiedName(qName);
                for (JSImplicitElement implicitElement : elements) {
                    if (processor.process((Object)implicitElement)) continue;
                    return false;
                }
            }
            return true;
        };
        if (processor2 == null) {
            JSClassResolver.$$$reportNull$$$0(63);
        }
        return processor2;
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(64);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(65);
        }
        return JSClassResolver.findElementsByNameIncludingImplicit(name, scope, false);
    }

    @NotNull
    public static Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(66);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(67);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.processElementsByNameIncludingImplicit(name, scope, justClasses, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(68);
        }
        return collection;
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(69);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(70);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(71);
        }
        return JSClassResolver.processElementsByNameIncludingImplicit(name, scope, justClasses, JSSymbolIndex2.KEY, processor);
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses, @NotNull StubIndexKey<String, JSElement> indexKey, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(72);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(73);
        }
        if (indexKey == null) {
            JSClassResolver.$$$reportNull$$$0(74);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(75);
        }
        Project project = scope.getProject();
        assert (project != null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("processElementsByNameIncludingImplicit: " + name);
        }
        IdFilter filter = JSClassResolver.getFilterFromScope(scope);
        return StubIndex.getInstance().processElements(indexKey, (Object)name, project, scope, filter, JSElement.class, element -> {
            ProgressManager.checkCanceled();
            if (justClasses && !(element instanceof JSClass)) {
                return true;
            }
            return !(element instanceof JSPsiElementBase && name.equals(element.getName()) ? !processor.process((Object)((JSPsiElementBase)element)) : element instanceof JSImplicitElementProvider && !JSClassResolver.processImplicitElements(name, (Processor<? super JSImplicitElement>)processor, (JSImplicitElementProvider)element));
        });
    }

    public static boolean processImplicitElements(@NotNull String name, @NotNull Processor<? super JSImplicitElement> processor, @NotNull JSImplicitElementProvider element) {
        JSElementIndexingData data;
        Collection implicitElements;
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(76);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(77);
        }
        if (element == null) {
            JSClassResolver.$$$reportNull$$$0(78);
        }
        Collection collection = implicitElements = (data = element.getIndexingData()) != null ? data.getImplicitElements() : null;
        if (implicitElements != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!name.equals(implicitElement.getName()) || processor.process((Object)implicitElement)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected static IdFilter getFilterFromScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(79);
        }
        return scope instanceof GlobalSearchScopeWithIdFilter ? ((GlobalSearchScopeWithIdFilter)scope).getFilter() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 23: 
            case 26: 
            case 32: 
            case 35: 
            case 46: 
            case 49: 
            case 52: 
            case 63: 
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 23: 
            case 26: 
            case 32: 
            case 35: 
            case 46: 
            case 49: 
            case 52: 
            case 63: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 65: 
            case 67: 
            case 70: 
            case 73: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 20: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 12: 
            case 13: 
            case 23: 
            case 26: 
            case 32: 
            case 35: 
            case 46: 
            case 49: 
            case 52: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 29: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 55: 
            case 59: 
            case 62: 
            case 71: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalNsScope";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeLocalMembers";
                break;
            }
            case 64: 
            case 66: 
            case 69: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByQName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQName";
                break;
            }
            case 26: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembers";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembersIncludingLocal";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceMembersProcessor";
                break;
            }
            case 49: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorForQNameIncludingImplicit";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByNameIncludingImplicit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassFromNamespace";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassByQName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByQName";
                break;
            }
            case 12: 
            case 13: 
            case 23: 
            case 26: 
            case 32: 
            case 35: 
            case 46: 
            case 49: 
            case 52: 
            case 63: 
            case 68: {
                break;
            }
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQName";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processElementByQName";
                break;
            }
            case 24: 
            case 25: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembers";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceMembers";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembersIncludingLocal";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMembersProcessor";
                break;
            }
            case 47: 
            case 48: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByQNameIncludingImplicit";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getProcessorForQNameIncludingImplicit";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByNameIncludingImplicit";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByNameIncludingImplicit";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitElements";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getFilterFromScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 23: 
            case 26: 
            case 32: 
            case 35: 
            case 46: 
            case 49: 
            case 52: 
            case 63: 
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

