/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.processors.JSDelegatingTypeProcessor;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSCachingTypeProcessor
implements JSTypeProcessor {
    @NotNull
    private final JSTypeEvaluator myTypeEvaluator;
    @NotNull
    protected final JSAdditionalTypeTrackingProcessor myBaseProcessor;

    JSCachingTypeProcessor(@NotNull JSTypeProcessor baseProcessor, @Nullable PsiElement element, @NotNull JSEvaluateContext context) {
        if (baseProcessor == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(1);
        }
        this.myBaseProcessor = new JSAdditionalTypeTrackingProcessor(baseProcessor);
        this.myTypeEvaluator = JSTypeEvaluator.createEvaluator(this, element, context);
    }

    @Override
    public void process(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
        Object element;
        if (type == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(3);
        }
        if (type instanceof JSTypeOfPsiElementBase && context.isAstAccessAllowed((PsiElement)(element = ((JSTypeOfPsiElementBase)type).getElement())) && ((JSTypeOfPsiElementBase)type).matchesSourceElement() && !DialectDetector.isActionScript(element)) {
            boolean evaluatedAsExpression;
            boolean bl = evaluatedAsExpression = element instanceof JSExpression && JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element);
            if (!evaluatedAsExpression) {
                context = context.withSource((PsiElement)element);
            }
            this.myTypeEvaluator.startEvaluationWithContext(context);
            this.evaluateTypesFromCache((PsiElement)element);
            return;
        }
        this.doAddType(type, context, source);
    }

    protected static void evaluateTypes(@NotNull JSCachingTypeProcessor processor, @NotNull PsiElement element) {
        if (processor == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(5);
        }
        JSEvaluateContext context = processor.getTypeEvaluator().getEvaluateContext();
        JSTypeEvaluator.processWithEvaluationGuard(element, context, () -> {
            if (context.isAstAccessAllowed(element)) {
                processor.evaluateTypesFromCache(element);
            } else {
                processor.myTypeEvaluator.doEvaluateExpressionOrElementTypes(element);
            }
            return null;
        });
    }

    private void evaluateTypesFromCache(@NotNull PsiElement expression) {
        JSTypeEvaluationResult result2;
        if (expression == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(6);
        }
        if ((result2 = JSTypeEvaluator.getElementType(expression, this.myTypeEvaluator.myContext)) != null) {
            List<JSEvaluationResultElement> results = result2.getResults();
            for (JSEvaluationResultElement element : results) {
                this.addTypeEvaluationResultElement(element);
            }
        }
    }

    protected void addTypeEvaluationResultElement(JSEvaluationResultElement element) {
        this.myTypeEvaluator.addTypeEvaluationResultElement(element);
    }

    protected void doAddType(@NotNull JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement source) {
        if (type == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(8);
        }
        if (type instanceof JSEvaluableOnlyType) {
            if (type instanceof JSPropertiesOwnerType) {
                this.myBaseProcessor.process(type, context, source);
            } else {
                JSTypeEvaluator.evaluateWithRecursionGuard((JSEvaluableOnlyType)type, context, this);
            }
            return;
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            type = handler.adjustTypeBeforeAdd(type, context);
        }
        JSType unwrappedType = JSTypeUtils.unwrapDecorations(type);
        Collection<PsiElement> referencedJSDocModules = CommonJSUtil.resolveJSDocCommentModules(unwrappedType, null);
        for (PsiElement module : referencedJSDocModules) {
            if (!(module instanceof JSFile)) continue;
            JSTypeEvaluator.processWithEvaluationGuard(module, context, () -> {
                this.myTypeEvaluator.addTypeFromExternalModuleReferenceResolveResult(module);
                return null;
            });
        }
        JSTypeEvaluator.applyContextAndProcess(type, source, context, this.myBaseProcessor);
    }

    @Override
    public void processAdditionalType(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (type == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(9);
        }
        if (evaluateContext == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(10);
        }
        this.myBaseProcessor.evaluateAdditionalType(() -> JSTypeEvaluator.applyContextAndProcess(type, source, evaluateContext, this));
    }

    @NotNull
    public JSTypeEvaluator getTypeEvaluator() {
        JSTypeEvaluator jSTypeEvaluator = this.myTypeEvaluator;
        if (jSTypeEvaluator == null) {
            JSCachingTypeProcessor.$$$reportNull$$$0(11);
        }
        return jSTypeEvaluator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseProcessor";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSCachingTypeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCachingTypeProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypesFromCache";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAddType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAdditionalType";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSEvaluationResultElementKey {
        @NotNull
        private final JSResolvedTypeId myTypeId;
        private final boolean myIsAdditionalType;
        @NotNull
        private final JSEvaluateContext myContext;

        private JSEvaluationResultElementKey(@NotNull JSType type, boolean isAdditionalType, @NotNull JSEvaluateContext context) {
            if (type == null) {
                JSEvaluationResultElementKey.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JSEvaluationResultElementKey.$$$reportNull$$$0(1);
            }
            this.myTypeId = type.getResolvedTypeId();
            this.myIsAdditionalType = isAdditionalType;
            this.myContext = context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSEvaluationResultElementKey key = (JSEvaluationResultElementKey)o;
            return this.myIsAdditionalType == key.myIsAdditionalType && this.myTypeId.equals(key.myTypeId) && this.myContext.equals(key.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myTypeId, this.myIsAdditionalType, this.myContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSCachingTypeProcessor$JSEvaluationResultElementKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JSAdditionalTypeTrackingProcessor
    extends JSDelegatingTypeProcessor {
        private boolean myEvaluatingAdditionalType;
        private final Set<JSEvaluationResultElementKey> myVisitedTypes;

        private JSAdditionalTypeTrackingProcessor(@NotNull JSTypeProcessor delegate) {
            if (delegate == null) {
                JSAdditionalTypeTrackingProcessor.$$$reportNull$$$0(0);
            }
            super(delegate);
            this.myVisitedTypes = new HashSet<JSEvaluationResultElementKey>();
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (type == null) {
                JSAdditionalTypeTrackingProcessor.$$$reportNull$$$0(1);
            }
            if (evaluateContext == null) {
                JSAdditionalTypeTrackingProcessor.$$$reportNull$$$0(2);
            }
            if (this.myEvaluatingAdditionalType) {
                this.processAdditionalType(type, evaluateContext, source);
            } else if (this.myVisitedTypes.add(new JSEvaluationResultElementKey(type, false, evaluateContext))) {
                this.myDelegate.process(type, evaluateContext, source);
            }
        }

        @Override
        public void processAdditionalType(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (type == null) {
                JSAdditionalTypeTrackingProcessor.$$$reportNull$$$0(3);
            }
            if (evaluateContext == null) {
                JSAdditionalTypeTrackingProcessor.$$$reportNull$$$0(4);
            }
            if (this.myVisitedTypes.add(new JSEvaluationResultElementKey(type, true, evaluateContext))) {
                this.myDelegate.processAdditionalType(type, evaluateContext, source);
            }
        }

        public void evaluateAdditionalType(@NotNull Runnable runnable) {
            if (runnable == null) {
                JSAdditionalTypeTrackingProcessor.$$$reportNull$$$0(5);
            }
            boolean wasEvaluatingAdditionalType = this.myEvaluatingAdditionalType;
            this.myEvaluatingAdditionalType = true;
            try {
                runnable.run();
            }
            finally {
                this.myEvaluatingAdditionalType = wasEvaluatingAdditionalType;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCachingTypeProcessor$JSAdditionalTypeTrackingProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAdditionalType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateAdditionalType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

