/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionHelper;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupElementInfo;
import com.intellij.lang.javascript.completion.JSLookupElementInfoImpl;
import com.intellij.lang.javascript.completion.JSLookupElementMerger;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionResultSink
extends ResultSink {
    private final boolean myIsAfterNew;
    private JSType mySmartCompletionExpectedType;
    @NotNull
    private JSCompletionPlaceFilter myPlaceFilter;
    private int myThisClassVariantsStart;
    private int myThisClassVariantsEnd;
    protected ProcessingContext mySmartCompletionInheritanceProcessingContext;
    private String myReferencedParameterName;
    private String myQualifiedNameToSkip;
    private final PrefixMatcher myPrefixMatcher;
    private final boolean myGlobalDeclarations;
    private final int myLimit;
    private final boolean myFirstOverloadOnly;
    @NotNull
    private final Set<String> myIgnoredNames;
    private final Set<String> myVisitedNames;

    public CompletionResultSink(@Nullable PsiElement place, @Nullable PrefixMatcher matcher) {
        this(place, matcher, Collections.emptySet(), true, false);
    }

    public CompletionResultSink(@Nullable PsiElement place, @Nullable PrefixMatcher matcher, @NotNull Set<String> ignoredNames, boolean firstOverloadOnly, boolean global) {
        Condition<JSClass> filter;
        ResolveProcessor.ProcessingOptions processingOptions;
        if (ignoredNames == null) {
            CompletionResultSink.$$$reportNull$$$0(0);
        }
        super(place);
        this.myPlaceFilter = JSCompletionPlaceFilter.Holder.ANY;
        this.myThisClassVariantsStart = -1;
        this.myThisClassVariantsEnd = -1;
        this.myVisitedNames = new HashSet<String>();
        this.myIgnoredNames = ignoredNames;
        this.myGlobalDeclarations = global;
        this.myLimit = matcher == null ? Integer.MAX_VALUE : JSCompletionUtil.getCompletionLimit();
        this.myFirstOverloadOnly = firstOverloadOnly;
        if (place != null && (processingOptions = (ResolveProcessor.ProcessingOptions)place.getContainingFile().getOriginalFile().getUserData(ResolveProcessor.PROCESSING_OPTIONS)) != null && (filter = processingOptions.getFilter()) != null) {
            this.acceptOnlyClasses(filter);
        }
        boolean bl = this.myIsAfterNew = place instanceof JSReferenceExpression && place.getParent() instanceof JSNewExpression;
        if (place instanceof JSReferenceExpression) {
            PsiElement originalParent;
            JSParameterItem param;
            PsiElement parent;
            JSType expectedType;
            if (this.myPlaceFilter == JSCompletionPlaceFilter.Holder.ANY) {
                this.myPlaceFilter = CompletionResultSink.buildSimpleCompletionFilter(place);
            }
            if (this.computeExpectedType() && (expectedType = JSDialectSpecificHandlersFactory.findExpectedType(this.isTypeScript() && this.myIsAfterNew ? (JSExpression)place.getParent() : (JSExpression)place)) != null) {
                this.mySmartCompletionExpectedType = expectedType;
                this.mySmartCompletionInheritanceProcessingContext = JSSmartCompletionVariantsHandler.initProcessingContext(place);
            }
            if ((parent = place.getParent()) instanceof JSArgumentList && (param = JSResolveUtil.findParameterForUsedArgument((JSExpression)((JSReferenceExpression)place), (JSArgumentList)parent)) != null) {
                this.myReferencedParameterName = param.getName();
            }
            if (JSResolveUtil.isSelfReference(parent, place) && (originalParent = PsiUtilCore.getOriginalElement((PsiElement)parent, JSQualifiedNamedElement.class)) instanceof JSQualifiedNamedElement) {
                this.myQualifiedNameToSkip = ((JSQualifiedNamedElement)originalParent).getQualifiedName();
            }
        }
        this.myPrefixMatcher = matcher;
    }

    private boolean computeExpectedType() {
        if (this.isActionScript()) {
            return JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction();
        }
        if (this.isTypeScript()) {
            return JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction() || this.myIsAfterNew;
        }
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    public void setSmartCompletionInheritanceProcessingContext(ProcessingContext smartCompletionInheritanceProcessingContext) {
        this.mySmartCompletionInheritanceProcessingContext = smartCompletionInheritanceProcessingContext;
    }

    public ProcessingContext getSmartCompletionInheritanceProcessingContext() {
        return this.mySmartCompletionInheritanceProcessingContext;
    }

    @Override
    public boolean accepts(PsiElement element) {
        String name = ResolveProcessor.getName(element);
        if (this.myPrefixMatcher != null && name != null && (!this.prefixMatches(element, name) || this.myIgnoredNames.contains(name))) {
            return false;
        }
        if (element instanceof JSPsiElementBase && !this.myPlaceFilter.isAcceptable((JSPsiElementBase)element)) {
            return false;
        }
        String qName = this.getQualifiedNameForResultElement(element, name);
        if (this.myQualifiedNameToSkip != null && this.myQualifiedNameToSkip.equals(qName)) {
            return false;
        }
        return super.accepts(element);
    }

    private boolean prefixMatches(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            CompletionResultSink.$$$reportNull$$$0(1);
        }
        if (name == null) {
            CompletionResultSink.$$$reportNull$$$0(2);
        }
        if (this.myPrefixMatcher.prefixMatches(name)) {
            return true;
        }
        String aliasName = this.getSimilarName(element, name);
        return aliasName != null && this.myPrefixMatcher.prefixMatches(aliasName);
    }

    @Override
    public boolean addResult(@Nullable PsiElement element, @Nullable ResolveState state, @Nullable PsiElement placeTopParent) {
        String name;
        if (this.isActionScript() && this.mySmartCompletionExpectedType != null && !JSSmartCompletionVariantsHandler.isAcceptableVariant(element, this.mySmartCompletionExpectedType, this.mySmartCompletionInheritanceProcessingContext)) {
            return !this.isOverflow();
        }
        if (!(this.place instanceof JSReferenceExpression && ((JSReferenceExpression)this.place).getQualifier() instanceof JSThisExpression || this.place == null || !JSResolveUtil.isIllegalPlaceForPrivate(element, this.place))) {
            return !this.isOverflow();
        }
        if (element instanceof JSParameter && element.getParent() instanceof TypeScriptIndexSignature && (placeTopParent == null || !PsiTreeUtil.isContextAncestor((PsiElement)element.getParent(), (PsiElement)placeTopParent, (boolean)false))) {
            return !this.isOverflow();
        }
        if (element instanceof PsiNamedElement && (name = this.getElementName(element, null)) != null) {
            this.myVisitedNames.add(name);
        }
        super.addResult(element, state, placeTopParent);
        return !this.isOverflow();
    }

    public boolean isOverflow() {
        return this.myVisitedNames.size() + this.myIgnoredNames.size() > this.myLimit;
    }

    public void acceptOnlyClasses(final @NotNull Condition<? super JSClass> classFilter) {
        if (classFilter == null) {
            CompletionResultSink.$$$reportNull$$$0(3);
        }
        this.myPlaceFilter = new JSCompletionPlaceFilter(){

            @Override
            public boolean isAcceptable(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element instanceof JSPackageWrapper || element instanceof JSClass && classFilter.value((Object)((JSClass)element));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink$1", "isAcceptable"));
            }
        };
    }

    private void flushMyThisClassVariantsEnd() {
        if (this.myThisClassVariantsEnd == -1) {
            List<PsiElement> results = this.getResults();
            if (results == null) {
                this.myThisClassVariantsEnd = 0;
            } else {
                int classVariantsEnd = results.size();
                if (results.get(classVariantsEnd - 1) instanceof JSClass) {
                    --classVariantsEnd;
                }
                this.myThisClassVariantsEnd = classVariantsEnd;
            }
        }
    }

    @NotNull
    private static JSCompletionPlaceFilter buildSimpleCompletionFilter(PsiElement place) {
        if (DialectDetector.isActionScript(place) && place instanceof JSReferenceExpression && !ResolveProcessor.completeConstructorName(place) && !(place.getParent() instanceof JSReferenceListMember)) {
            JSCompletionPlaceFilter jSCompletionPlaceFilter = JSCompletionPlaceFilter.Holder.ANY;
            if (jSCompletionPlaceFilter == null) {
                CompletionResultSink.$$$reportNull$$$0(4);
            }
            return jSCompletionPlaceFilter;
        }
        JSCompletionPlaceFilter jSCompletionPlaceFilter = JSCompletionPlaceFilter.forPlace(place);
        if (jSCompletionPlaceFilter == null) {
            CompletionResultSink.$$$reportNull$$$0(5);
        }
        return jSCompletionPlaceFilter;
    }

    @NotNull
    public List<LookupElement> getResultsAsObjects() {
        List<PsiElement> processorResults = this.getResults();
        return processorResults == null ? Collections.emptyList() : this.resultsToLookupElements(processorResults);
    }

    @NotNull
    public Collection<LookupElement> pushVariantsWithOverflowHandling(@NotNull CompletionResultSet resultSet, @NotNull Set<String> pushedSmartVariants) {
        List<PsiElement> processorResults;
        if (resultSet == null) {
            CompletionResultSink.$$$reportNull$$$0(6);
        }
        if (pushedSmartVariants == null) {
            CompletionResultSink.$$$reportNull$$$0(7);
        }
        if ((processorResults = this.getResults()) == null) {
            List<LookupElement> list2 = Collections.emptyList();
            if (list2 == null) {
                CompletionResultSink.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<LookupElement> elements = this.resultsToLookupElements(processorResults);
        if (this.isOverflow() || elements.size() >= this.myLimit) {
            JSCompletionUtil.handleOverflow(resultSet);
        }
        Collection<LookupElement> collection = JSCompletionUtil.pushVariants(elements, pushedSmartVariants, resultSet);
        if (collection == null) {
            CompletionResultSink.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Nullable
    private JSType getPlaceQualifierType() {
        if (this.isActionScript()) {
            return null;
        }
        JSExpression qualifier = this.getQualifierExpression();
        if (qualifier != null) {
            return JSResolveUtil.getExpressionJSType(qualifier);
        }
        return null;
    }

    @Nullable
    private JSExpression getQualifierExpression() {
        return this.place instanceof JSReferenceExpression ? ((JSReferenceExpression)this.place).getQualifier() : null;
    }

    @NotNull
    private List<LookupElement> resultsToLookupElements(@NotNull List<? extends PsiElement> before) {
        if (before == null) {
            CompletionResultSink.$$$reportNull$$$0(10);
        }
        ArrayList<? extends PsiElement> processorResults = new ArrayList<PsiElement>(before);
        int numberOfVariants = processorResults.size();
        Set<String> variantsFromSmartCompletion = JSCompletionContributor.getInstance().getAlreadyUsedClassesSet();
        HashSet<String> processedCandidateNames = new HashSet<String>(numberOfVariants);
        if (variantsFromSmartCompletion != null) {
            processedCandidateNames.addAll(variantsFromSmartCompletion);
        }
        return this.getLookupElements(processorResults, processedCandidateNames);
    }

    @Nullable
    public static JSClass getClassFromContextualType(@Nullable JSType contextualType) {
        if (contextualType instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)contextualType).resolveType();
            return info.getDeclarationOfType(JSClass.class);
        }
        if (contextualType instanceof JSGenericTypeImpl) {
            return CompletionResultSink.getClassFromContextualType(((JSGenericTypeImpl)contextualType).getType());
        }
        return null;
    }

    @NotNull
    private List<LookupElement> getLookupElements(@NotNull List<? extends PsiElement> processorResults, @NotNull Set<String> processedCandidateNames) {
        int nestingLevel;
        JSLookupPriority priority;
        PsiElement result2;
        String name;
        if (processorResults == null) {
            CompletionResultSink.$$$reportNull$$$0(11);
        }
        if (processedCandidateNames == null) {
            CompletionResultSink.$$$reportNull$$$0(12);
        }
        SinkLookupElementMerger merger = this.createMerger();
        boolean typeScript = this.isTypeScript();
        JSType qualifierType = this.getPlaceQualifierType();
        for (int i = 0; i < processorResults.size() && ((name = this.getElementName(result2 = processorResults.get(i), null)) == null || processedCandidateNames.contains(name) || merger.expandAndAddResult(name, result2, priority = this.getPriorityForResultElement(result2, name, nestingLevel = this.getNestingLevelForResultElement(result2, i), typeScript), qualifierType)); ++i) {
        }
        List<LookupElement> list2 = merger.values();
        if (list2 == null) {
            CompletionResultSink.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private SinkLookupElementMerger createMerger() {
        JSLookupElementMerger.MergeFilter filter = new JSLookupElementMerger.MergeFilter(){

            @Override
            public boolean accept(@Nullable PsiElement element, @NotNull JSLookupPriority priority) {
                if (priority == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !(element instanceof JSPsiElementBase) || CompletionResultSink.this.myPlaceFilter.isAcceptable((JSPsiElementBase)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink$2", "accept"));
            }
        };
        return new SinkLookupElementMerger(filter, this.myLimit);
    }

    @Nullable
    private String getElementName(@NotNull PsiElement namedElement, @Nullable Set<String> exoticNames) {
        if (namedElement == null) {
            CompletionResultSink.$$$reportNull$$$0(14);
        }
        String name = ResolveProcessor.getName(namedElement);
        if (namedElement instanceof ES6ExportDefaultAssignment) {
            name = "default";
        }
        if (name == null) {
            return null;
        }
        boolean isActionScript = DialectDetector.isActionScript(namedElement);
        if (isActionScript && !JSNamesValidation.isUnqualifiedType(name) || !isActionScript && !JSSymbolUtil.isValidPropertyName(name)) {
            if (namedElement instanceof ImplicitJSVariableImpl) {
                return null;
            }
            if (namedElement instanceof TypeScriptModule) {
                return null;
            }
            name = JSSymbolUtil.handleSpecialPropertyNames(name, this.getPlaceQuoteChar(namedElement));
            if (exoticNames != null) {
                exoticNames.add(name);
            }
        }
        return name;
    }

    private char getPlaceQuoteChar(@NotNull PsiElement namedElement) {
        if (namedElement == null) {
            CompletionResultSink.$$$reportNull$$$0(15);
        }
        if (this.place != null) {
            return JSCodeStyleSettings.getQuoteChar(this.place);
        }
        PsiFile file2 = namedElement.getContainingFile();
        if (file2 != null) {
            return JSCodeStyleSettings.getQuoteChar((PsiElement)file2);
        }
        return '\"';
    }

    private JSLookupPriority getPriorityForResultElement(PsiElement namedElement, String name, int nestingLevel, boolean typeScript) {
        boolean matchesReferencedParameterName = this.myReferencedParameterName != null && this.myReferencedParameterName.equals(name);
        JSLookupPriority priority = null;
        if (this.place != null) {
            priority = JSDialectSpecificHandlersFactory.forElement(this.place).getSpecificCompletionVariantPriority(namedElement);
        }
        if (priority == null) {
            if (typeScript) {
                boolean fromTheSameFile;
                boolean bl = fromTheSameFile = !this.myGlobalDeclarations;
                priority = this.place instanceof JSReferenceExpression && ((JSReferenceExpression)this.place).getQualifier() == null && !fromTheSameFile && nestingLevel == 0 ? JSLookupPriority.TOP_LEVEL_SYMBOLS_FROM_OTHER_FILES : (fromTheSameFile ? JSLookupPriority.getSameFileValue(matchesReferencedParameterName, nestingLevel) : JSLookupPriority.getSameTypeValue(false, BaseJSSymbolProcessor.MatchType.COMPLETE, nestingLevel));
            } else {
                priority = JSLookupPriority.getSameFileValue(matchesReferencedParameterName, nestingLevel);
            }
            if (typeScript && namedElement instanceof JSImplicitElement && nestingLevel == 0 && ((JSImplicitElement)namedElement).hasMinorImportance()) {
                priority = JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false);
            }
        }
        return priority;
    }

    @Nullable
    private String getQualifiedNameForResultElement(PsiElement namedElement, String name) {
        JSClass jsClass;
        if (this.place != null && this.place.getParent() instanceof JSNewExpression && namedElement instanceof JSFunction && ((JSFunction)namedElement).isConstructor() && (jsClass = JSUtils.getMemberContainingClass(namedElement)) != null) {
            return jsClass.getQualifiedName() + "." + ((JSFunction)namedElement).getName();
        }
        return namedElement instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)namedElement).getQualifiedName() : name;
    }

    @Nullable
    protected LookupElement createLookupItem(@Nullable PsiElement namedElement, @NotNull String name, @NotNull JSLookupPriority priority, @NotNull JSTypeSubstitutor typeSubstitutor, boolean hasExoticName) {
        if (name == null) {
            CompletionResultSink.$$$reportNull$$$0(16);
        }
        if (priority == null) {
            CompletionResultSink.$$$reportNull$$$0(17);
        }
        if (typeSubstitutor == null) {
            CompletionResultSink.$$$reportNull$$$0(18);
        }
        if (!hasExoticName) {
            for (JSCompletionHelper helper : JSCompletionHelper.EP_NAME.getExtensionList()) {
                LookupElement lookupElement = helper.createLookupElement(namedElement, name, true, priority);
                if (lookupElement == null) continue;
                return lookupElement;
            }
            if (!JSLookupUtilImpl.matchElementWithContext(namedElement, this.place)) {
                return null;
            }
        }
        boolean isIndexAccess = this.place instanceof JSIndexedPropertyAccessExpression;
        if (hasExoticName && isIndexAccess) {
            if (StringUtil.isQuotedString((String)name)) {
                name = JSStringUtil.unquoteAndUnescapeString(name);
            } else {
                return null;
            }
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(namedElement, name, priority, false, typeSubstitutor, hasExoticName && !isIndexAccess, this.getSimilarName(namedElement, name));
    }

    @Nullable
    private String getSimilarName(@Nullable PsiElement namedElement, @NotNull String name) {
        if (name == null) {
            CompletionResultSink.$$$reportNull$$$0(19);
        }
        if (!(namedElement instanceof TypeScriptPropertySignature) || this.myGlobalDeclarations) {
            return null;
        }
        if ("size".equals(name)) {
            return "length";
        }
        if ("length".equals(name)) {
            return "size";
        }
        return null;
    }

    @Override
    public void startingParent(PsiElement parent, ResolveProcessor resolveProcessor) {
        if (parent instanceof JSClass) {
            int scopeBound;
            List<PsiElement> results = super.getResults();
            int n = results == null ? 0 : (scopeBound = !results.isEmpty() && results.get(results.size() - 1) == parent ? results.size() - 1 : results.size());
            if (scopeBound > 0 && !DialectDetector.isTypeScript(parent)) {
                ++this.myCurrentNestingLevel;
            }
            if (this.myThisClassVariantsStart == -1) {
                int n2 = this.myThisClassVariantsStart = results != null ? results.size() : 0;
                if (!resolveProcessor.isToProcessMembers()) {
                    this.flushMyThisClassVariantsEnd();
                }
            } else {
                this.flushMyThisClassVariantsEnd();
            }
        } else if (parent instanceof JSFunction) {
            ++this.myCurrentNestingLevel;
        }
    }

    @Override
    public boolean skipTopLevelItems() {
        return this.place instanceof JSReferenceExpression && !JSResolveUtil.isExprInTypeContext((JSReferenceExpression)this.place) && this.myPrefixMatcher != null && this.myPrefixMatcher.getPrefix().length() == 0 && !(this.place.getContainingFile() instanceof PsiCodeFragment);
    }

    @Override
    public boolean needTopLevelClassName(String name) {
        return this.myPrefixMatcher == null || this.myPrefixMatcher.prefixMatches(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFilter";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/CompletionResultSink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedSmartVariants";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processorResults";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedCandidateNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/CompletionResultSink";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSimpleCompletionFilter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "pushVariantsWithOverflowHandling";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptOnlyClasses";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pushVariantsWithOverflowHandling";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resultsToLookupElements";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceQuoteChar";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSimilarName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SinkLookupElementMerger
    extends JSLookupElementMerger {
        private final JSExpression myQualifier;

        private SinkLookupElementMerger(JSLookupElementMerger.MergeFilter filter, int limit) {
            if (filter == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(0);
            }
            super(CompletionResultSink.this.place, filter, limit, CompletionResultSink.this.myFirstOverloadOnly);
            this.myQualifier = CompletionResultSink.this.getQualifierExpression();
        }

        public boolean expandAndAddResult(@NotNull String name, @Nullable PsiElement element, @NotNull JSLookupPriority priority, @Nullable JSType qualifier) {
            PsiElement item;
            Set<PsiElement> elements;
            if (name == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(1);
            }
            if (priority == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(2);
            }
            Set<PsiElement> singleton = Collections.singleton(element);
            Collection<PsiElement> collection = elements = this.myPlace != null ? ES6PsiUtil.expandElements(this.myPlace, singleton) : singleton;
            if (elements.size() <= 1 && (element == (item = (PsiElement)ContainerUtil.getFirstItem(elements)) || item == null)) {
                return this.addResult(element, name, priority, qualifier);
            }
            for (PsiElement expandedElement : elements) {
                if (this.addResult(expandedElement, name, priority, qualifier)) continue;
                return false;
            }
            return true;
        }

        private boolean addResult(@Nullable PsiElement element, @NotNull String name, @NotNull JSLookupPriority priority, @Nullable JSType qualifier) {
            if (name == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(3);
            }
            if (priority == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(4);
            }
            if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadImplementation()) {
                List declarations = ((TypeScriptFunction)element).getOverloadDeclarations();
                for (TypeScriptFunction declaration : declarations) {
                    JSTypeSubstitutor jSTypeSubstitutor;
                    if (super.addResult((PsiElement)declaration, name, priority, BaseJSSymbolProcessor.MatchType.COMPLETE, jSTypeSubstitutor = this.getSubstitutor(qualifier, (PsiElement)declaration))) continue;
                    return false;
                }
                return true;
            }
            if (element instanceof JSVariable) {
                Collection<JSFunctionWithSubstitutor> functions = TypeScriptSignatureChooser.getFunctionsExcludeNonFunctionsInType(element);
                if (functions.size() <= 1) {
                    return super.addResult(element, name, priority, BaseJSSymbolProcessor.MatchType.COMPLETE, this.getSubstitutor(qualifier, element));
                }
                HashSet<JSFunctionItem> filteredFunctions = new HashSet<JSFunctionItem>();
                for (JSFunctionWithSubstitutor jSFunctionWithSubstitutor : functions) {
                    JSFunctionItem item = jSFunctionWithSubstitutor.myFunctionItem;
                    item = (JSFunctionItem)CompletionUtil.getOriginalOrSelf((PsiElement)item);
                    filteredFunctions.add(item);
                }
                for (JSFunctionItem jSFunctionItem : filteredFunctions) {
                    JSTypeSubstitutor typeSubstitutor;
                    if (super.addResult((PsiElement)jSFunctionItem, name, priority, BaseJSSymbolProcessor.MatchType.COMPLETE, typeSubstitutor = this.getSubstitutor(qualifier, (PsiElement)jSFunctionItem))) continue;
                    return false;
                }
                return true;
            }
            return super.addResult(element, name, priority, BaseJSSymbolProcessor.MatchType.COMPLETE, this.getSubstitutor(qualifier, element));
        }

        @NotNull
        private JSTypeSubstitutor getSubstitutor(@Nullable JSType qualifier, @Nullable PsiElement declaration) {
            JSTypeSubstitutor jSTypeSubstitutor = declaration != null && this.myPlace != null && DialectDetector.isTypeScript(this.myPlace) ? TypeScriptGenericTypesEvaluator.getInstance().getQualifierTypeSubstitutor(qualifier, (JSType)TypeScriptTypeParser.asFunctionType(declaration, null), declaration, this.myPlace) : JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(5);
            }
            return jSTypeSubstitutor;
        }

        @Override
        @NotNull
        protected JSLookupElementInfoImpl createMergeInfo(@Nullable PsiElement element, @NotNull String name, @NotNull JSLookupPriority originalPriority, @NotNull BaseJSSymbolProcessor.MatchType matchType, @Nullable JSTypeSubstitutor typeSubstitutor) {
            if (name == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(6);
            }
            if (originalPriority == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(7);
            }
            if (matchType == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(8);
            }
            return new SinkLookupElementInfo(element, name, originalPriority, matchType, typeSubstitutor);
        }

        @Override
        @NotNull
        protected Collection<LookupElement> mergeOverloads(@NotNull String name, @NotNull Collection<JSLookupElementInfo> infos, boolean firstOverloadOnly) {
            if (name == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(9);
            }
            if (infos == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(10);
            }
            if (CompletionResultSink.this.isActionScript()) {
                HashSet<String> qNames = new HashSet<String>();
                ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
                for (JSLookupElementInfo info : infos) {
                    PsiElement element = info.getElement();
                    String qName = CompletionResultSink.this.getQualifiedNameForResultElement(element, name);
                    if (!qNames.add(qName)) continue;
                    ContainerUtil.addIfNotNull(result2, (Object)info.toLookupElement());
                }
                ArrayList<LookupElement> arrayList = result2;
                if (arrayList == null) {
                    SinkLookupElementMerger.$$$reportNull$$$0(11);
                }
                return arrayList;
            }
            Collection<LookupElement> collection = super.mergeOverloads(name, infos, firstOverloadOnly);
            if (collection == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(12);
            }
            return collection;
        }

        @Override
        protected boolean areOverloads(@NotNull Collection<JSLookupElementInfo> infos, @NotNull JSLookupElementInfo.FunctionType type) {
            if (infos == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(13);
            }
            if (type == null) {
                SinkLookupElementMerger.$$$reportNull$$$0(14);
            }
            if (CompletionResultSink.this.isActionScript()) {
                return true;
            }
            return super.areOverloads(infos, type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/CompletionResultSink$SinkLookupElementMerger";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPriority";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchType";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/CompletionResultSink$SinkLookupElementMerger";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitutor";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mergeOverloads";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "expandAndAddResult";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addResult";
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createMergeInfo";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeOverloads";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "areOverloads";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private final class SinkLookupElementInfo
        extends JSLookupElementInfoImpl {
            private SinkLookupElementInfo(PsiElement element, String name, JSLookupPriority originalPriority, BaseJSSymbolProcessor.MatchType matchType, JSTypeSubstitutor typeSubstitutor) {
                super(element, name, originalPriority, matchType, typeSubstitutor);
            }

            @Override
            public int compareTo(@Nullable PsiElement element, @NotNull JSLookupPriority priority, @Nullable BaseJSSymbolProcessor.MatchType matchType, @Nullable PsiElement context) {
                int i;
                if (priority == null) {
                    SinkLookupElementInfo.$$$reportNull$$$0(0);
                }
                if ((i = super.compareTo(element, priority, matchType, context)) != 0) {
                    return i;
                }
                if (!CompletionResultSink.this.myGlobalDeclarations && SinkLookupElementMerger.this.myQualifier == null && !CompletionResultSink.this.isActionScript()) {
                    return 1;
                }
                return i;
            }

            @Override
            @Nullable
            public LookupElement toLookupElement() {
                boolean typeScript;
                JSLookupPriority priority = this.myPriority;
                boolean bl = typeScript = this.myElement != null && DialectDetector.isTypeScript(this.myElement);
                if (typeScript && this.myElement instanceof JSClass && CompletionResultSink.this.myIsAfterNew) {
                    JSClass jsClass = (JSClass)this.myElement;
                    boolean isAbstractOrInterface = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)jsClass) || jsClass.isInterface();
                    JSClass contextClass = CompletionResultSink.getClassFromContextualType(CompletionResultSink.this.mySmartCompletionExpectedType);
                    if (contextClass != null && JSInheritanceUtil.isParentClass(jsClass, contextClass, true)) {
                        if (isAbstractOrInterface) {
                            String className2 = jsClass.getName();
                            if (this.myElement != contextClass && className2 != null) {
                                return JSLookupUtilImpl.createImplementAbstractOrInterfaceLookupItem(this.myElement, className2);
                            }
                            return null;
                        }
                        priority = JSLookupPriority.MATCHED_TYPE_PRIORITY;
                    }
                    if (isAbstractOrInterface) {
                        return null;
                    }
                }
                if (this.myElement instanceof TypeScriptFunction && ((TypeScriptFunction)this.myElement).isOverloadImplementation()) {
                    return null;
                }
                boolean exotic = JSLookupUtilImpl.isExoticName(this.myName);
                return CompletionResultSink.this.createLookupItem(this.myElement, this.myName, priority, this.myTypeSubstitutor == null ? JSTypeSubstitutor.EMPTY : this.myTypeSubstitutor, exotic);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/psi/resolve/CompletionResultSink$SinkLookupElementMerger$SinkLookupElementInfo", "compareTo"));
            }
        }
    }
}

