/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSDelegatingTypeProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSExtendingTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSSymbolProcessor {
    public static final String HTML_ELEMENT_TYPE_NAME = "HTMLElement";
    protected final boolean ecmal4;
    protected final boolean typescript;
    @NotNull
    protected final JSTypeInfo myTypeInfo;
    @NotNull
    protected final PsiElement myContext;
    @NotNull
    protected final PsiFile myTargetFile;
    @Nullable
    protected final VirtualFile myTargetVirtualFile;
    @NotNull
    private final NotNullLazyValue<List<JSQualifiedName>> myContextScopesCache;
    protected final boolean myPrivateSharpFieldAccess;
    protected boolean myCheckFileLevelAccess;
    @Nullable
    protected VirtualFile myCurrentFile;
    public static final String[] TS_EXCLUDED = new String[]{"HTMLElementTagNameMap", "DocumentEventMap", "HTMLElementEventMap", "WindowEventMap", "GlobalEventHandlersEventMap", "SVGElementTagNameMap", "SVGMatrix", "WebKitCSSMatrix", "DOMMatrix", "DOMMatrixReadOnly", "DOMMatrix2DInit"};
    private final EnumSet<CompleteMatchSign> myCompleteMatchSigns;

    public static boolean isNamedGlobalType(@NotNull String typeString, @NotNull JSContext context) {
        if (typeString == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(1);
        }
        return JSSymbolUtil.GLOBAL_TYPE_QUALIFIED_NAMES.contains(typeString) && context != JSContext.STATIC || JSSymbolUtil.GLOBAL_OBJECT_NAMES.contains(typeString);
    }

    public static boolean canBeResolvedToUnqualified(@NotNull JSQualifiedName qualifierNs, @NotNull JSContext jsContext) {
        if (qualifierNs == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(2);
        }
        if (jsContext == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(3);
        }
        return qualifierNs.getParent() == null && (jsContext != JSContext.STATIC && "Window".equals(qualifierNs.getName()) || qualifierNs.getParent() == null && JSSymbolUtil.GLOBAL_OBJECT_NAMES.contains(qualifierNs.getName()));
    }

    protected BaseJSSymbolProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context) {
        if (targetFile == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(5);
        }
        this.myCompleteMatchSigns = EnumSet.noneOf(CompleteMatchSign.class);
        this.myTargetFile = targetFile;
        this.myTargetVirtualFile = targetFile.getVirtualFile();
        this.myContext = context;
        this.myTypeInfo = this.createTypeInfo(this.initGlobalStatusHint(context));
        this.myContextScopesCache = NotNullLazyValue.createValue(() -> JSVisibilityUtil.calculateContextNames(this.getContext()));
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        this.ecmal4 = holder != null && holder.isECMA4;
        this.typescript = holder != null && holder.isTypeScript;
        this.myPrivateSharpFieldAccess = holder != null && holder.hasFeature(JSLanguageFeature.PRIVATE_SHARP_SYNTAX) && JSUtils.isPrivateFieldSharpAccessContext(this.myContext);
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            handler.addContextType(this.myTypeInfo, context);
        }
        if (context instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            JSExpression qualifier = JSResolveUtil.getRealRefExprQualifier(refExpr);
            if (!this.typescript && !this.ecmal4 && qualifier == null) {
                JSNamespace ns;
                for (JSQualifiedName globalType : JSSymbolUtil.GLOBAL_TYPES) {
                    ns = JSNamedTypeFactory.createNamespace(globalType, JSContext.INSTANCE, null, true);
                    this.myTypeInfo.addNamespace(ns, false);
                    this.addSupers(ns);
                }
                for (String globalTypeName : JSSymbolUtil.GLOBAL_OBJECT_NAMES) {
                    ns = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create(globalTypeName, null), JSContext.STATIC, null, true);
                    this.myTypeInfo.addNamespace(ns, false);
                    this.addSupers(ns);
                }
            }
        }
    }

    protected JSTypeInfo createTypeInfo(@NotNull JSTypeInfo.GlobalStatusHint globalStatusHint) {
        if (globalStatusHint == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(6);
        }
        return new JSTypeInfo(globalStatusHint);
    }

    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context) {
        boolean withinWithStatement;
        if (!(context instanceof JSReferenceExpression)) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(7);
            }
            return globalStatusHint;
        }
        if (((JSReferenceExpression)context).getQualifier() != null) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(8);
            }
            return globalStatusHint;
        }
        boolean bl = withinWithStatement = PsiTreeUtil.getParentOfType((PsiElement)context, JSWithStatement.class) != null;
        if (!withinWithStatement && JSResolveUtil.getRealRefExprQualifier((JSReferenceExpression)context) == null) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(9);
            }
            return globalStatusHint;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(10);
        }
        return globalStatusHint;
    }

    protected void updateTypeInfoFromThis(@Nullable JSNamespace ns) {
        if (ns != null && JSTypeUtils.isStrictType((JSType)ns)) {
            this.setAddOnlyCompleteMatches();
        } else {
            this.myTypeInfo.setForcedUnknownContext();
        }
    }

    public void addTypeHierarchy(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(11);
        }
        this.myTypeInfo.addNamespace(namespace, true);
        this.addSupers(namespace);
    }

    public void addSupers(@NotNull JSNamespace namespace) {
        JSQualifiedName nsName;
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(12);
        }
        if ((nsName = namespace.getQualifiedName()) == null) {
            return;
        }
        JSContext staticOrInstance = namespace.getJSContext();
        boolean isStrict = namespace.isSourceStrict();
        SmartList parentClasses = new SmartList();
        Processor baseTypeProcessor = arg_0 -> BaseJSSymbolProcessor.lambda$addSupers$1(isStrict, (List)parentClasses, arg_0);
        Processor baseClassProcessor = arg_0 -> BaseJSSymbolProcessor.lambda$addSupers$2(staticOrInstance, (List)parentClasses, arg_0);
        JSTypeEvaluateManager.iterateTypeHierarchy(namespace, (Processor<JSClass>)baseClassProcessor, (Processor<JSType>)baseTypeProcessor, this.myContext, false);
        for (JSNamespace parentClass : this.addGenericArgumentsForParentClasses(namespace, (List<JSNamespace>)parentClasses)) {
            this.myTypeInfo.addNamespace(parentClass, false);
        }
    }

    @NotNull
    protected List<JSNamespace> addGenericArgumentsForParentClasses(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(13);
        }
        if (parentClasses == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(14);
        }
        List<JSNamespace> list2 = parentClasses;
        if (list2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(15);
        }
        return list2;
    }

    public abstract String getRequiredName();

    public void forceSetAddOnlyCompleteMatches() {
        this.addCompleteMatchSign(CompleteMatchSign.FORCED_COMPLETE_MATCH);
    }

    public void setAddOnlyCompleteMatches() {
        this.addCompleteMatchSign(CompleteMatchSign.COMPLETE_MATCH);
    }

    public void allowPartialResults() {
        this.addCompleteMatchSign(CompleteMatchSign.INCOMPLETE_MATCH);
    }

    private void addCompleteMatchSign(@NotNull CompleteMatchSign sign) {
        if (sign == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(16);
        }
        this.myCompleteMatchSigns.add(sign);
    }

    public boolean addOnlyCompleteMatches() {
        if (this.myCompleteMatchSigns.contains((Object)CompleteMatchSign.FORCED_COMPLETE_MATCH)) {
            return true;
        }
        return this.addOnlyCompleteMatchesEvaluated();
    }

    private boolean addOnlyCompleteMatchesEvaluated() {
        if (this.myCompleteMatchSigns.contains((Object)CompleteMatchSign.INCOMPLETE_MATCH)) {
            return false;
        }
        return this.myCompleteMatchSigns.contains((Object)CompleteMatchSign.COMPLETE_MATCH);
    }

    protected final boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean includeGlobalObjects) {
        return BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, includeGlobalObjects);
    }

    public static boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean isTypeScript, boolean includeGlobalObjects) {
        if (namespace == null) {
            return true;
        }
        if (isTypeScript) {
            return false;
        }
        String name = namespace.getName();
        return includeGlobalObjects && (JSSymbolUtil.GLOBAL_OBJECT_NAMES.contains(name) && namespace.getParent() == null || JSSymbolUtil.GLOBAL_TYPES.contains(namespace));
    }

    public boolean acceptsFile(PsiFile file2) {
        this.myCurrentFile = file2.getViewProvider().getVirtualFile();
        boolean currentFileEcma = file2.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        return this.ecmal4 == currentFileEcma;
    }

    protected boolean isFromRelevantFileOrDirectory() {
        return Comparing.equal((Object)this.myTargetVirtualFile, (Object)this.myCurrentFile);
    }

    public boolean toCheckFileLevelAccess() {
        return this.myCheckFileLevelAccess;
    }

    protected final void initCheckFileLevelAccess() {
        if (this.myTypeInfo.isNonGlobalContext()) {
            return;
        }
        if (this.myTargetFile instanceof JSFile || DialectDetector.isES6(this.myContext) || ES6PsiUtil.findExternalModule(this.myContext) != null) {
            PsiElement resolve;
            JSExpression qualifier;
            this.myCheckFileLevelAccess = true;
            if (this.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)this.myContext).getQualifier()) instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) == null || resolve instanceof JSParameter || !resolve.getContainingFile().getOriginalFile().isEquivalentTo((PsiElement)this.myTargetFile))) {
                this.myCheckFileLevelAccess = false;
            }
        }
    }

    @Nullable
    public String isAcceptable(@NotNull JSPsiElementBase element) {
        boolean isCommonJSExported;
        boolean isExternalModule;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(17);
        }
        if (!this.myPrivateSharpFieldAccess && JSUtils.isPrivateSharpItem((PsiElement)element)) {
            if (this.myContext instanceof JSReferenceExpression && ((JSReferenceExpression)this.myContext).getQualifier() instanceof JSThisExpression) {
                return "javascript.private.member.is.not.accessible.without.sharp.message";
            }
            return null;
        }
        if (!this.toCheckFileLevelAccess()) {
            return null;
        }
        if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return null;
        }
        JSElement exportScope = ES6PsiUtil.getExportScope((PsiElement)element);
        boolean bl = isExternalModule = ES6PsiUtil.isExternalModule((PsiElement)exportScope) || exportScope instanceof JSFile && ((JSFile)exportScope).getModuleStatus() == JSFile.ModuleStatus.COMMONJS;
        if (exportScope == null || !isExternalModule) {
            return null;
        }
        if (element.getContext() instanceof JSDocComment && this.myTargetFile.equals(element.getContainingFile())) {
            return null;
        }
        JSNamespace jsNamespace = element.getJSNamespace();
        JSQualifiedName namespace = jsNamespace.getQualifiedName();
        boolean bl2 = isCommonJSExported = CommonJSUtil.isExportNamespace(jsNamespace) || CommonJSUtil.isExportedWithModuleExports(element);
        if (namespace != null && !isCommonJSExported) {
            return null;
        }
        if (this.myContext instanceof JSReferenceExpression && BaseJSSymbolProcessor.isExportedElement(element, isCommonJSExported)) {
            if (((JSReferenceExpression)this.myContext).getQualifier() == null) {
                return "javascript.element.need.to.be.imported";
            }
            return null;
        }
        if (jsNamespace.isLocal()) {
            return null;
        }
        return "javascript.element.need.to.be.exported";
    }

    private static boolean isExportedElement(@NotNull JSPsiElementBase element, boolean isCommonJSExported) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(18);
        }
        return (DialectDetector.isES6((PsiElement)element) || DialectDetector.isTypeScript((PsiElement)element)) && (element.isExported() || element.isExportedWithDefault()) || isCommonJSExported;
    }

    protected void tryAddFunctionType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(19);
        }
        if (JSTypeUtils.hasFunctionType(type, false, this.myContext) || source instanceof TypeScriptClass && type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC) {
            this.myTypeInfo.addNamespace(JSTypeUtils.getFunctionTypeName(source == null || source == PsiUtilCore.NULL_PSI_ELEMENT || !source.isValid() ? type.getSource().getScope() : source.getContainingFile(), false), false, JSContext.INSTANCE, type.isSourceStrict());
        }
    }

    protected boolean isStrictTypingPossible(@Nullable PsiElement source, @NotNull JSType type) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(20);
        }
        return !(!type.isSourceStrict() && source != JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT || type instanceof JSObjectType || type instanceof JSAnyType || type instanceof TypeScriptIndexedAccessJSTypeImpl && !this.typescript || type instanceof JSRecordType && !((JSRecordType)type).hasMembers() && !this.typescript || type instanceof TypeScriptNeverJSTypeImpl || type instanceof JSGenericParameterImpl || type instanceof TypeScriptMappedJSTypeImpl && ((TypeScriptMappedJSTypeImpl)type).hasForeignGenericParameters() || type instanceof JSGenericTypeImpl && !this.isStrictGenericType((JSGenericTypeImpl)type));
    }

    private boolean isStrictGenericType(@NotNull JSGenericTypeImpl type) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(21);
        }
        if (this.typescript) {
            return true;
        }
        if (type.getType() instanceof JSObjectType) {
            return false;
        }
        for (JSType jsType : type.getArguments()) {
            if (!(jsType instanceof JSGenericParameterImpl)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidType(String parameterType) {
        return parameterType != null && !parameterType.isEmpty();
    }

    protected void addPackageScope(@Nullable JSClass jsClass, @Nullable PsiElement expression) {
        String s;
        String packageQualifier = JSResolveUtil.findPackageStatementQualifier(expression);
        if (packageQualifier != null) {
            this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(packageQualifier);
        } else if (jsClass != null) {
            int index;
            String qName = jsClass.getQualifiedName();
            if (qName != null && !qName.equals(jsClass.getName()) && (index = qName.lastIndexOf(46)) > 0) {
                this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(qName.substring(0, index));
            }
        } else if (expression != null && BaseJSSymbolProcessor.isValidType(s = ActionScriptResolveUtil.findPackageForMxml(expression))) {
            this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(s);
        }
    }

    protected List<JSQualifiedName> getContextScopeNames() {
        return (List)this.myContextScopesCache.getValue();
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    @NotNull
    public JSTypeInfo getTypeInfo() {
        JSTypeInfo jSTypeInfo = this.myTypeInfo;
        if (jSTypeInfo == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(23);
        }
        return jSTypeInfo;
    }

    @NotNull
    protected MatchType isAcceptableQualifiedItem(@NotNull JSPsiElementBase element, @NotNull Ref<Integer> typeHierarchyLevel, @NotNull Ref<Boolean> isAccessibleRef) {
        boolean isGlobalIncludeGlobalObjects;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(24);
        }
        if (typeHierarchyLevel == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(25);
        }
        if (isAccessibleRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(26);
        }
        if (!this.myPrivateSharpFieldAccess && JSUtils.isPrivateSharpItem((PsiElement)element)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(27);
            }
            return matchType;
        }
        JSQualifiedName namespace = this.getElementNamespace(element);
        JSNamespace elementJSNamespace = element.getJSNamespace();
        boolean isElementLocal = elementJSNamespace.isLocal();
        boolean isNamespaceExplicitlyDeclared = element.isNamespaceExplicitlyDeclared();
        boolean isGlobal = this.isGlobalNS(namespace, false);
        boolean bl = isGlobalIncludeGlobalObjects = isGlobal || this.isGlobalNS(namespace, true);
        if (isGlobalIncludeGlobalObjects && BaseJSSymbolProcessor.isPrivate(element) && !this.isFromRelevantFileOrDirectory()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(28);
            }
            return matchType;
        }
        if (this.myTypeInfo.isNonGlobalContext() && isNamespaceExplicitlyDeclared && isGlobal) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(29);
            }
            return matchType;
        }
        if (isGlobal && element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).isUnderCondition() && this.getContext() instanceof JSReferenceExpression && ((JSReferenceExpression)this.getContext()).getQualifier() == null && this.myTargetFile instanceof JSFile && ((JSFile)this.myTargetFile).isCommonJSModule()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(30);
            }
            return matchType;
        }
        Ref contextLevelRef = Ref.create(null);
        MatchType result2 = this.iterateContextLevels(element, (Ref<JSContextLevel>)contextLevelRef, namespace, elementJSNamespace);
        JSContextLevel contextLevel = (JSContextLevel)contextLevelRef.get();
        if (contextLevel != null) {
            typeHierarchyLevel.set((Object)contextLevel.myRelativeLevel);
            this.updateAccessible(element, isAccessibleRef, contextLevel);
        }
        if (result2 != null) {
            MatchType matchType = result2;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(31);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalContext() && !BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, true)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(32);
            }
            return matchType;
        }
        if (isNamespaceExplicitlyDeclared && isElementLocal && namespace == null && (!(this.myContext instanceof JSDocTagValue) || !(element instanceof JSClass))) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(33);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalContext() && (JSClassUtils.isClassMember((PsiElement)element) || element instanceof JSProperty)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(34);
            }
            return matchType;
        }
        if (isNamespaceExplicitlyDeclared && isGlobalIncludeGlobalObjects && this.myTypeInfo.isGlobalContext()) {
            MatchType matchType = MatchType.COMPLETE;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(35);
            }
            return matchType;
        }
        if (namespace != null && !this.typescript && BaseJSSymbolProcessor.isTSExcludedMap(namespace)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(36);
            }
            return matchType;
        }
        MatchType matchType = MatchType.PARTIAL;
        if (matchType == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(37);
        }
        return matchType;
    }

    private void updateAccessible(@NotNull JSPsiElementBase element, @NotNull Ref<Boolean> isAccessibleRef, @NotNull JSContextLevel contextLevel) {
        JSAttributeList.AccessType accessType;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(38);
        }
        if (isAccessibleRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(39);
        }
        if (contextLevel == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(40);
        }
        if ((accessType = this.getElementAccessType(element)) == JSAttributeList.AccessType.PRIVATE || accessType == JSAttributeList.AccessType.PROTECTED) {
            List<JSQualifiedName> scopeNames = this.getContextScopeNames();
            boolean withinScope = false;
            for (JSContextLevel level : this.myTypeInfo.myContextLevels) {
                if (level.myRelativeLevel == 0) {
                    withinScope = false;
                }
                if (!withinScope && scopeNames.contains(level.myNamespace.getQualifiedName())) {
                    withinScope = true;
                }
                if (level != contextLevel) continue;
                PsiFile file1 = element.getContainingFile();
                PsiFile file2 = this.myContext.getContainingFile();
                if (file1 == null || file2 == null) break;
                boolean isAccessible = JSVisibilityUtil.isAccessible(element, accessType, contextLevel.myRelativeLevel == 0, withinScope, file1.isEquivalentTo((PsiElement)file2));
                isAccessibleRef.set((Object)isAccessible);
                break;
            }
        }
    }

    @NotNull
    protected JSAttributeList.AccessType getElementAccessType(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(41);
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (accessType == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(42);
        }
        return accessType;
    }

    private static boolean isTSExcludedMap(JSQualifiedName namespace) {
        String qualifiedName = namespace.getQualifiedName();
        for (String map : TS_EXCLUDED) {
            if (!qualifiedName.equals(map)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private MatchType iterateContextLevels(@NotNull JSPsiElementBase element, @NotNull Ref<JSContextLevel> contextLevelRef, @Nullable JSQualifiedName namespace, @NotNull JSNamespace elementJSNamespace) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(43);
        }
        if (contextLevelRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(44);
        }
        if (elementJSNamespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(45);
        }
        if (this.myTypeInfo.myContextLevels.isEmpty()) {
            return null;
        }
        JSContext elementStaticOrInstance = element.getJSContext();
        boolean jsContextMismatched = false;
        for (JSContextLevel contextLevel : this.myTypeInfo.myContextLevels) {
            JSQualifiedName currentNs;
            if (!contextLevel.isElementInScope(element, elementJSNamespace)) continue;
            JSQualifiedName currentContextNamespace = contextLevel.myNamespace.getQualifiedName();
            if (currentContextNamespace == null && contextLevel.myNamespace.isSourceStrict() && element instanceof JSProperty && namespace == null && !elementJSNamespace.isSourceStrict()) continue;
            for (currentNs = namespace; currentContextNamespace != null && currentNs != null && currentContextNamespace.getName().equals(currentNs.getName()); currentNs = currentNs.getParent(), currentContextNamespace = currentContextNamespace.getParent()) {
            }
            if (currentContextNamespace != null || currentNs != null) continue;
            if (!contextLevel.myNamespace.getJSContext().isCompatibleWith(elementStaticOrInstance)) {
                jsContextMismatched = true;
                continue;
            }
            if (jsContextMismatched && contextLevel.myNamespace.getJSContext() == JSContext.UNKNOWN) continue;
            contextLevelRef.set((Object)contextLevel);
            return contextLevel.myRelativeLevel == 0 && (elementStaticOrInstance != JSContext.UNKNOWN && contextLevel.myNamespace.getJSContext() != JSContext.UNKNOWN || contextLevel == JSTypeInfo.GLOBAL_CONTEXT_LEVEL) ? MatchType.COMPLETE_WITH_CONTEXT : MatchType.COMPLETE;
        }
        return jsContextMismatched ? MatchType.NOMATCH : null;
    }

    private JSQualifiedName getElementNamespace(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(46);
        }
        PsiElement parent = element.getContext();
        return this.ecmal4 && parent instanceof JSClass ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSClass)parent)) : element.getJSNamespace().getQualifiedName();
    }

    private static boolean isPrivate(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(47);
        }
        return element.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    @Contract(value="null -> null")
    public static JSExpression getOriginalQualifier(@Nullable JSExpression rawqualifier) {
        if (rawqualifier == null) {
            return null;
        }
        JSExpression element = (JSExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)rawqualifier);
        return element != null ? element : rawqualifier;
    }

    public static boolean isCompleteOrWithContextMatchType(@Nullable MatchType matchType) {
        return matchType == MatchType.COMPLETE_WITH_CONTEXT || matchType == MatchType.COMPLETE;
    }

    public static void addResolveResultTags(@NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags, @Nullable PsiElement element, @NotNull PsiElement context) {
        if (tags == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(48);
        }
        if (context == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(49);
        }
        if (element instanceof JSElementBase && BaseJSSymbolProcessor.isJavaScriptPredefinedLibraryElement(element, DialectDetector.isTypeScript(context))) {
            if (((JSElementBase)element).getNamespace() == null) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.IS_FROM_LIBRARY);
            }
            return;
        }
        if (element instanceof JSElementBase && ((JSElementBase)element).hasJSDoc()) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).getTypeString() != null) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() || element != null && BaseJSSymbolProcessor.isTooBigForHighlighting(PsiUtilCore.getVirtualFile((PsiElement)element)) || BaseJSSymbolProcessor.isFromMinifiedFile(element)) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
        }
        if (element instanceof JSDefinitionExpression) {
            boolean nonConstructorDefinition;
            boolean bl = nonConstructorDefinition = !((JSDefinitionExpression)element).isDeclaration();
            if (!nonConstructorDefinition) {
                JSQualifiedNamedElement scopeNode = JSPsiImplUtils.getParentFunctionOrClassThroughLambdas(element);
                boolean bl2 = nonConstructorDefinition = scopeNode != null && (scopeNode instanceof JSClass || JSClassUtils.isClassMember((PsiElement)scopeNode)) && !JSResolveUtil.isConstructorFunction((PsiElement)scopeNode);
            }
            if (nonConstructorDefinition) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.NON_CONSTRUCTOR_DEFINITION);
            }
            if (context instanceof JSReferenceExpression && JSResolveUtil.isSameReference((JSReferenceExpression)context, element)) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.SELF_DEFINITION);
            }
            if (!((JSDefinitionExpression)element).isDeclaration()) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.IS_ASSIGNMENT);
            }
        }
    }

    public static boolean isTooBigForHighlighting(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        return !(file2 instanceof LightVirtualFile) && file2.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    private static boolean isFromMinifiedFile(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        return file2 instanceof JSFile && ((JSFile)file2).isMinified();
    }

    protected static boolean isJavaScriptPredefinedLibraryElement(@Nullable PsiElement sourceElement, boolean typescript) {
        SyntheticLibrary syntheticLibrary;
        ScriptingLibraryModel libraryModel;
        VirtualFile virtualFile;
        if (typescript || sourceElement == JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT || sourceElement == null) {
            return false;
        }
        if (JSCorePredefinedLibrariesProvider.isLibraryElement(sourceElement)) {
            return true;
        }
        PsiFile file2 = sourceElement.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = file2 != null ? file2.getVirtualFile() : null;
        if (virtualFile == null) {
            return false;
        }
        return FileIndexFacade.getInstance((Project)sourceElement.getProject()).isInLibrarySource(virtualFile) && (libraryModel = JSLibraryManager.getInstance(sourceElement.getProject()).getLibraryByName("Node.js Core")) instanceof ScriptingLibraryModelBackedBySyntheticLibrary && (syntheticLibrary = ((ScriptingLibraryModelBackedBySyntheticLibrary)libraryModel).getSyntheticLibrary()) != null && VfsUtilCore.isUnder((VirtualFile)virtualFile, new HashSet(syntheticLibrary.getAllRoots()));
    }

    private static /* synthetic */ boolean lambda$addSupers$2(JSContext staticOrInstance, List parentClasses, JSClass clazz) {
        JSNamespace classNs;
        String name = clazz.getQualifiedName();
        if ("Object".equals(name)) {
            return true;
        }
        if (name != null && (classNs = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)clazz, true)) != null && classNs.getQualifiedName() != null) {
            classNs = JSNamedTypeFactory.copyWithJSContext(classNs, staticOrInstance);
            parentClasses.add(classNs);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$addSupers$1(boolean isStrict, List parentClasses, JSType type) {
        JSNamespace baseNs = JSTypeUtils.getNamespaceMatchingType(type, false);
        if (baseNs == null || baseNs instanceof JSObjectType) {
            return true;
        }
        if (baseNs instanceof JSTypeWithOuterGenerics) {
            baseNs = (JSNamespace)((JSTypeWithOuterGenerics)baseNs).getType();
        }
        if ((baseNs = (JSNamespace)baseNs.copyWithStrict(baseNs.isSourceStrict() && isStrict)).getQualifiedName() != null) {
            parentClasses.add(baseNs);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 5: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierNs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalStatusHint";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 17: 
            case 18: 
            case 24: 
            case 38: 
            case 41: 
            case 43: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHierarchyLevel";
                break;
            }
            case 26: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAccessibleRef";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLevel";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLevelRef";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementJSNamespace";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "initGlobalStatusHint";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "isAcceptableQualifiedItem";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNamedGlobalType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canBeResolvedToUnqualified";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTypeInfo";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTypeHierarchy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSupers";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addCompleteMatchSign";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isExportedElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryAddFunctionType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isStrictGenericType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableQualifiedItem";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "updateAccessible";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getElementAccessType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "iterateContextLevels";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getElementNamespace";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isPrivate";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addResolveResultTags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public abstract class JSTypeProcessorBase
    implements JSTypeProcessor {
        protected void evaluateQualifier(@NotNull JSExpression qualifier, @NotNull JSExpression originalQualifier) {
            JSNamespace namespace;
            if (qualifier == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(0);
            }
            if (originalQualifier == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(1);
            }
            JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)originalQualifier, originalQualifier.getContainingFile(), new JSDelegatingTypeProcessor(this){

                @Override
                public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
                    if (type == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (evaluateContext == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (type instanceof JSModuleTypeImpl) {
                        BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches();
                    }
                    super.process(type, evaluateContext, source);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "evaluateContext";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true);
            if ((!BaseJSSymbolProcessor.this.addOnlyCompleteMatchesEvaluated() || BaseJSSymbolProcessor.this.myTypeInfo.isEmpty() || qualifier instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)qualifier)) && (namespace = JSSymbolUtil.evaluateNamespaceLocally(qualifier)) != null) {
                BaseJSSymbolProcessor.this.myTypeInfo.addNamespace(namespace, true);
            }
        }

        @Override
        public void processAdditionalType(@NotNull JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(2);
            }
            if (context == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(3);
            }
            if (!JSTypeUtils.processExpandedType(this, type, context, source)) {
                return;
            }
            if (!(type instanceof JSNamespace)) {
                return;
            }
            JSNamespace namespace = (JSNamespace)type;
            if (namespace.getQualifiedName() == null) {
                return;
            }
            namespace = (JSNamespace)namespace.copyWithStrict(true);
            BaseJSSymbolProcessor.this.addTypeHierarchy(namespace);
            if (CommonJSUtil.isExportNamespace(namespace)) {
                BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches();
            }
        }

        protected final void processCandidate(@NotNull JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement source) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(4);
            }
            if (context == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(5);
            }
            if (type instanceof JSDecoratedType) {
                return;
            }
            this.updateResolveStrictness(type, source);
            if (type instanceof JSRecordType) {
                JSTypeSource typeSource = type.getSource();
                PsiElement sourceElement = typeSource.getSourceElement();
                if (sourceElement instanceof JSDocComment) {
                    sourceElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)sourceElement);
                }
                if (sourceElement instanceof JSQualifiedNamedElement) {
                    JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSQualifiedNamedElement)sourceElement));
                    BaseJSSymbolProcessor.this.myTypeInfo.addType(JSNamedTypeFactory.createNamespace((JSQualifiedName)qName, JSContext.STATIC, sourceElement, false), true);
                }
                BaseJSSymbolProcessor.this.myTypeInfo.addBaseObjectType();
                BaseJSSymbolProcessor.this.myTypeInfo.setTypeWasProcessed();
            } else if (type instanceof JSExtendingTypeImpl) {
                this.process(((JSExtendingTypeImpl)type).getType(), context, source);
                JSNamespace mixedType = JSTypeUtils.getNamespaceMatchingType(((JSExtendingTypeImpl)type).getParentType(), false);
                if (mixedType != null) {
                    BaseJSSymbolProcessor.this.myTypeInfo.addNamespace(mixedType, false);
                    BaseJSSymbolProcessor.this.addSupers(mixedType);
                }
            }
            this.applyTypeToState(type, source);
            if (type instanceof JSAnyType) {
                return;
            }
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type, this.isMakeAddedNamespaceStrict());
            if (namespace == null) {
                return;
            }
            BaseJSSymbolProcessor.this.addTypeHierarchy(namespace);
            BaseJSSymbolProcessor.this.tryAddFunctionType(type, source);
        }

        protected boolean isMakeAddedNamespaceStrict() {
            return false;
        }

        protected void applyTypeToState(JSType type, PsiElement source) {
            if (type instanceof JSAnyType) {
                this.allowPartialResults();
            }
        }

        private void updateResolveStrictness(@NotNull JSType type, @Nullable PsiElement source) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(6);
            }
            JSTypeSource typeSource = type.getSource();
            if (BaseJSSymbolProcessor.this.typescript) {
                if (typeSource.isStrict() || BaseJSSymbolProcessor.this.isStrictTypingPossible(source, type)) {
                    BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches();
                } else if (typeSource.isTypeScript()) {
                    this.allowPartialResults();
                }
            } else if (BaseJSSymbolProcessor.this.isStrictTypingPossible(source, type)) {
                BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches();
            } else if (typeSource.isTypeScript()) {
                this.allowPartialResults();
            }
        }

        protected void allowPartialResults() {
            BaseJSSymbolProcessor.this.allowPartialResults();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalQualifier";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateQualifier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAdditionalType";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processCandidate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateResolveStrictness";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum CompleteMatchSign {
        COMPLETE_MATCH,
        INCOMPLETE_MATCH,
        FORCED_COMPLETE_MATCH;

    }

    public static enum MatchType {
        COMPLETE_WITH_CONTEXT,
        COMPLETE,
        PARTIAL,
        NOMATCH;

    }
}

