/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSImportType;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocReference
extends JSTextReference {
    private final boolean myMethodRef;

    protected JSDocReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement, boolean methodRef) {
        if (set == null) {
            JSDocReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSDocReference.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSDocReference.$$$reportNull$$$0(2);
        }
        super(set, s, rangeInElement);
        this.myMethodRef = methodRef;
    }

    @Override
    protected ResolveResult @NotNull [] doResolve() {
        JSType type;
        String name;
        PsiElement element = this.mySet.getElement();
        if ("int".equals(this.myCanonicalText) || "uint".equals(this.myCanonicalText) || ("Null".equals(this.myCanonicalText) || "null".equals(this.myCanonicalText) || "Undefined".equals(this.myCanonicalText)) && this.getElement() instanceof JSDocTagValue) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(element)};
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (element instanceof JSDocTagValue && this.myRangeInElement.getStartOffset() == 0 && this.mySet.getReferences().length == 1 && "property".equals(name = ((JSDocTag)element.getParent()).getName())) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(element)};
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        if (this.mySet.getReferences().length > 0 && this.mySet.getReferences()[0] == this && this.myCanonicalText.startsWith("import") && (type = new JSTypeParser(this.myCanonicalText, JSTypeSourceFactory.createTypeSource(this.getElement(), true)).parse()) instanceof JSImportType) {
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(((JSImportType)type).getDeclarations());
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        if (!this.myCanonicalText.startsWith("module:")) {
            String qualifiedName = this.getReferenceQualifiedName().getQualifiedName();
            JSTypeResolveResult typeResolveResult = JSDialectSpecificHandlersFactory.forElement(element).getImportHandler().resolveMainElementName(qualifiedName, element, JSContext.INSTANCE);
            Collection<? extends PsiElement> elements = typeResolveResult.getElements();
            if (!elements.isEmpty()) {
                ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array(elements, ResolveResult.class, JSResolveResult::new);
                if (resolveResultArray == null) {
                    JSDocReference.$$$reportNull$$$0(6);
                }
                return resolveResultArray;
            }
        }
        ResolveResult[] resolveResultArray = super.doResolve();
        if (resolveResultArray == null) {
            JSDocReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        if (this.mySet.getReferences().length == 1) {
            JSQualifiedName name;
            if (this.myRangeInElement.getStartOffset() > 0 && (name = this.buildQualifiedNameForRelativeLink()) != null) {
                JSQualifiedName jSQualifiedName = name;
                if (jSQualifiedName == null) {
                    JSDocReference.$$$reportNull$$$0(8);
                }
                return jSQualifiedName;
            }
            PsiElement elt = this.getElement();
            if ((elt instanceof JSDocTagValue || elt instanceof JSDocComment) && !this.myMethodRef) {
                JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.create(JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(this.myCanonicalText), null);
                if (jSQualifiedNameImpl == null) {
                    JSDocReference.$$$reportNull$$$0(9);
                }
                return jSQualifiedNameImpl;
            }
        }
        JSQualifiedName jSQualifiedName = super.getQualifiedName();
        if (jSQualifiedName == null) {
            JSDocReference.$$$reportNull$$$0(10);
        }
        return jSQualifiedName;
    }

    @Nullable
    private JSQualifiedName buildQualifiedNameForRelativeLink() {
        JSExpression expression;
        PsiElement elt = this.mySet.getElement();
        if (this.myMethodRef && elt instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)elt).getExpression()) instanceof JSAssignmentExpression) {
            JSExpression jsExpression = ((JSAssignmentExpression)expression).getLOperand();
            if (jsExpression instanceof JSDefinitionExpression) {
                jsExpression = ((JSDefinitionExpression)jsExpression).getExpression();
            }
            if (jsExpression instanceof JSReferenceExpression) {
                String qualifier;
                JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                boolean stripQualifier = true;
                if (rOperand instanceof JSFunction && ((JSFunction)rOperand).isConstructor()) {
                    stripQualifier = false;
                }
                if (stripQualifier) {
                    jsExpression = ((JSReferenceExpression)jsExpression).getQualifier();
                }
                if (jsExpression != null && (qualifier = JSSymbolUtil.getQualifierOfExprAsString((JSElement)jsExpression)) != null) {
                    return this.qNameFromNames(QualifiedName.fromDottedString((String)qualifier).getComponents());
                }
            }
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void processLocalVariants(SinkResolveProcessor<?> processor) {
        PsiFile file2 = this.getElement().getContainingFile();
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JSDocComment.class);
        if (docComment != null) {
            @NotNull @Nullable @NotNull List currentParameters = docComment.getGenericParameters();
            if (!currentParameters.isEmpty()) {
                JSDocReference.processGenericParameters(currentParameters, docComment, processor);
            } else {
                List parameters;
                JSDocComment definitionComment;
                JSQualifiedName namespace;
                PsiElement element2 = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
                if (element2 instanceof JSQualifiedNamedElement && (namespace = ((JSQualifiedNamedElement)element2).getNamespace()) != null && (definitionComment = JSGenericsIndex.findGenericParametersComment(namespace.getQualifiedName(), GlobalSearchScope.fileScope((PsiFile)file2))) != null && !(parameters = definitionComment.getGenericParameters()).isEmpty()) {
                    JSDocReference.processGenericParameters(parameters, definitionComment, processor);
                }
            }
        }
        if (this.myMethodRef && docComment != null) {
            PsiElement next = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)docComment);
            if (next instanceof JSProperty) {
                JSResolveUtil.treeWalkUp(processor, this.mySet.getElement(), this.mySet.getElement(), next);
            }
        } else {
            this.doProcessLocalVariants(processor, (Condition<? super PsiElement>)((Condition)element -> true));
        }
    }

    private static void processGenericParameters(@NotNull List<Pair<String, String>> parameters, @NotNull JSDocComment comment, @NotNull SinkResolveProcessor<?> processor) {
        if (parameters == null) {
            JSDocReference.$$$reportNull$$$0(11);
        }
        if (comment == null) {
            JSDocReference.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JSDocReference.$$$reportNull$$$0(13);
        }
        for (Pair<String, String> parameter : parameters) {
            JSImplicitElementImpl element = new JSImplicitElementImpl.Builder((String)parameter.getFirst(), (PsiElement)comment).setTypeString((String)parameter.getSecond()).toImplicitElement();
            processor.execute((PsiElement)element, ResolveState.initial());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processGenericParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

