/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.ActionScriptTextReferenceResolver;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.QualifiedName;
import com.intellij.psi.xml.XmlToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTextReference
extends JSReferenceSetElement
implements EmptyResolveMessageProvider {
    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, int offset) {
        if (set == null) {
            JSTextReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSTextReference.$$$reportNull$$$0(1);
        }
        this(set, s, new TextRange(offset, offset + s.length()));
    }

    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSTextReference.$$$reportNull$$$0(2);
        }
        if (s == null) {
            JSTextReference.$$$reportNull$$$0(3);
        }
        if (rangeInElement == null) {
            JSTextReference.$$$reportNull$$$0(4);
        }
        super(set, s, rangeInElement);
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        List<Object> qualifierComponents = null;
        PsiReference prevContextReference = null;
        for (PsiReference ref : this.mySet.myReferences) {
            if (ref == this) break;
            if (qualifierComponents == null) {
                qualifierComponents = new ArrayList<String>(3);
            }
            qualifierComponents.add(ref.getCanonicalText());
            prevContextReference = ref;
        }
        if (qualifierComponents != null) {
            String qName;
            PsiElement psiElement = prevContextReference.resolve();
            if (psiElement instanceof XmlToken) {
                JSTagContextBuilder builder = new JSTagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement instanceof JSClass && (qName = ((JSClass)psiElement).getQualifiedName()) != null) {
                qualifierComponents = new ArrayList(3);
                qualifierComponents.addAll(QualifiedName.fromDottedString((String)qName).getComponents());
            }
            if (psiElement instanceof JSFile || psiElement instanceof TypeScriptGlobalModuleExportDeclaration) {
                qualifierComponents = Collections.emptyList();
            }
        }
        JSQualifiedName jSQualifiedName = this.qNameFromNames(qualifierComponents);
        if (jSQualifiedName == null) {
            JSTextReference.$$$reportNull$$$0(5);
        }
        return jSQualifiedName;
    }

    @NotNull
    protected JSQualifiedName qNameFromNames(@Nullable List<String> contextNames) {
        JSQualifiedNameImpl qualifier = contextNames != null ? JSQualifiedNameImpl.fromComponents(contextNames) : null;
        JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.create(this.getCanonicalText(), qualifier);
        if (jSQualifiedNameImpl == null) {
            JSTextReference.$$$reportNull$$$0(6);
        }
        return jSQualifiedNameImpl;
    }

    @Override
    protected ResolveResult @NotNull [] doResolve() {
        PsiFile psiFile = this.mySet.getElement().getContainingFile();
        if (this.useActionScriptIndex(psiFile)) {
            ResolveResult[] resolveResultArray = ActionScriptTextReferenceResolver.resolve(this);
            if (resolveResultArray == null) {
                JSTextReference.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = super.doResolve();
        if (resolveResultArray == null) {
            JSTextReference.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    public boolean useActionScriptIndex(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JSTextReference.$$$reportNull$$$0(9);
        }
        return DialectDetector.isActionScript((PsiElement)psiFile);
    }

    @Override
    public void processLocalVariants(SinkResolveProcessor<?> processor) {
        this.doProcessLocalVariants(processor, (Condition<? super PsiElement>)((Condition)element -> {
            JSNamedElement namedElement = element instanceof JSNamedElement ? (JSNamedElement)element : null;
            return namedElement != null && JSUseScopeProvider.getUseScopeElement(namedElement) == null;
        }));
    }

    protected final void doProcessLocalVariants(final SinkResolveProcessor<?> processor, final Condition<? super PsiElement> filter) {
        PsiFile file2 = this.getElement().getContainingFile();
        PsiElement fileContext = file2.getContext();
        if (fileContext == null && !this.isPrimary()) {
            return;
        }
        String name = processor.getName();
        PsiElement element = this.mySet.getElement();
        JSResolveUtil.treeWalkUp(new ResolveProcessor(name){
            {
                super(name);
                this.setLocalResolve(true);
                this.setProcessingOptions(new JSResolveUtil.StructureResolveProcessor.StructureProcessingOptions());
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (filter.value((Object)element)) {
                    return processor.execute(element, state);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/impl/JSTextReference$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, element, element, element);
        if (fileContext != null) {
            JSResolveUtil.treeWalkUp(processor, (PsiElement)file2, (PsiElement)file2, element);
        }
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        Object text = this.getCanonicalText();
        text = "'" + ((String)text).replace("'", "''") + "'";
        String string = JavaScriptBundle.message((String)(this.mySet.getElement().getParent() instanceof TypeScriptImportStatement ? "javascript.unresolved.file" : "javascript.unresolved.variable.or.type.name.message2"), (Object[])new Object[]{text});
        if (string == null) {
            JSTextReference.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSTextReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSTextReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qNameFromNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "useActionScriptIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

