/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptAsExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptAttributeListImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.impl.CompositeRootCollection;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.ScriptRuntime;

public class JSPsiImplUtils {
    public static final String CONSTRUCTS_PROPERTY_NAME = "construct";
    @NonNls
    private static final String ARRAY_ELEMENT_TYPE_ANNOTATION_NAME = "ArrayElementType";
    public static final com.intellij.util.Function<JSFunctionItem, JSFunctionWithSubstitutor> TO_FUNCTION_WITH_SUBSTITUTOR = fun -> new JSFunctionWithSubstitutor((JSFunctionItem)fun, JSTypeSubstitutor.EMPTY);
    public static final Function<JSFunctionItem, Collection<JSFunctionWithSubstitutor>> TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR = fun -> fun == null ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)new JSFunctionWithSubstitutor((JSFunctionItem)fun, JSTypeSubstitutor.EMPTY));
    @NonNls
    public static final String HAS_OWN_PROPERTY = "hasOwnProperty";
    private static final Pattern ourQuotedQualifiedNamePartPattern = Pattern.compile("[^.\"']+|\"([^\"\\\\]|\\\\.)*\"|'([^'\\\\]|\\\\.)*'");
    public static final TObjectHashingStrategy<JSQualifiedNamedElement> QUALIFIED_NAME_HASHING_STRATEGY = new TObjectHashingStrategy<JSQualifiedNamedElement>(){

        public int computeHashCode(JSQualifiedNamedElement object) {
            return object == null || object.getQualifiedName() == null ? 0 : object.getQualifiedName().hashCode();
        }

        public boolean equals(JSQualifiedNamedElement o1, JSQualifiedNamedElement o2) {
            return Objects.equals(o1.getQualifiedName(), o2.getQualifiedName());
        }
    };
    private static final TokenSet FUNCTION_NAME_PREFIX_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FUNCTION_KEYWORD, JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD});
    private static final TokenSet VARIABLE_NAME_PREFIX_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.VAR_KEYWORD, JSTokenTypes.LET_KEYWORD, JSTokenTypes.CONST_KEYWORD});
    private static final ResolveProcessor.ProcessingOptions ourNsProcessingOptions = new JSResolveUtil.StructureResolveProcessor.StructureProcessingOptions(){

        @Override
        public boolean toProcessPackageImports(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
            return lastParent != null;
        }
    };
    private static final TokenSet OBJECT_LITERAL_EXPRESSION_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.OBJECT_LITERAL_EXPRESSION});
    private static final TokenSet FIND_CONSTRUCTS_STOP_AT = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, OBJECT_LITERAL_EXPRESSION_TOKEN_SET});

    @Nullable
    public static JSType getTypeFromElement(@Nullable PsiElement typePsi, JSElement element) {
        if (typePsi == null) {
            return null;
        }
        if (typePsi instanceof JSTypeDeclaration) {
            return ((JSTypeDeclaration)typePsi).getJSType();
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)element, true);
        JSType type = JSTypeUtils.createType(typePsi.getText(), typeSource);
        if (type instanceof JSArrayType && ((JSArrayType)type).isPrimitive() || type instanceof JSDecoratedTypeImpl && ((JSDecoratedTypeImpl)type).getType() instanceof JSAnyType) {
            String arrayType;
            JSAttributeListOwner attributeListOwner;
            JSAttributeList attributeList;
            String elementType;
            PsiComment psiComment = null;
            PsiElement el = typePsi.getPrevSibling();
            if (el instanceof PsiWhiteSpace) {
                el = el.getPrevSibling();
            }
            if (el instanceof PsiComment) {
                psiComment = (PsiComment)el;
            }
            if (psiComment != null && !(psiComment instanceof JSDocComment) && !(elementType = JSDocumentationUtils.unwrapCommentDelimiters(psiComment.getText()).trim()).isEmpty()) {
                return JSPsiImplUtils.getNonPrimitiveArrayOrSelf(typeSource, type, elementType);
            }
            if (element instanceof JSAttributeListOwner && (attributeList = (attributeListOwner = (JSAttributeListOwner)element).getAttributeList()) != null && (arrayType = JSPsiImplUtils.getArrayElementTypeFromAnnotation(attributeList)) != null && !arrayType.isEmpty()) {
                return JSPsiImplUtils.getNonPrimitiveArrayOrSelf(typeSource, type, arrayType);
            }
        }
        return type;
    }

    private static JSType getNonPrimitiveArrayOrSelf(JSTypeSource typeSource, JSType type, String elementType) {
        JSType baseType = JSTypeUtils.createType(elementType, typeSource);
        if (type instanceof JSArrayType && !((JSArrayType)type).isReadonly()) {
            return new JSArrayTypeImpl(baseType, typeSource);
        }
        if (type instanceof JSArrayType && ((JSArrayType)type).isReadonly()) {
            return new JSReadonlyArrayTypeImpl(baseType, typeSource);
        }
        return baseType;
    }

    @Nullable
    public static JSType getTypeFromDeclaration(JSElement element) {
        PsiElement typeElement = DialectDetector.isActionScript((PsiElement)element) ? ActionScriptPsiImplUtil.getTypeElementFromDeclaration(element) : JSPsiImplUtils.getTypeElementFromDeclaration(element);
        return JSPsiImplUtils.getTypeFromElement(typeElement, element);
    }

    @Nullable
    public static JSTypeDeclaration getTypeElementFromDeclaration(JSElement element) {
        if (element instanceof StubBasedPsiElementBase) {
            return JSPsiImplUtils.getStubOrPsiTypeElement((StubBasedPsiElementBase)element);
        }
        return (JSTypeDeclaration)PsiTreeUtil.getChildOfType((PsiElement)element, JSTypeDeclaration.class);
    }

    @Nullable
    public static JSTypeDeclaration getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase<?> element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(0);
        }
        return (JSTypeDeclaration)ArrayUtil.getFirstElement((Object[])((JSTypeDeclaration[])element.getStubOrPsiChildren(JSElementTypes.TYPESCRIPT_OR_ES6_TYPES, JSTypeDeclaration.ARRAY_FACTORY)));
    }

    @Nullable
    public static String getArrayElementTypeFromAnnotation(JSAttributeList attributeList) {
        String type = JSPsiImplUtils.getTypeFromAnnotationParameter(attributeList, ARRAY_ELEMENT_TYPE_ANNOTATION_NAME, null);
        return type != null ? type : JSPsiImplUtils.getTypeFromAnnotationParameter(attributeList, ARRAY_ELEMENT_TYPE_ANNOTATION_NAME, "elementType");
    }

    @Nullable
    public static JSPackageStatement findPackageStatement(JSFile file2) {
        JSPackageStatement packageStatement = null;
        for (JSSourceElement statement : file2.getStatements()) {
            if (!(statement instanceof JSPackageStatement)) continue;
            packageStatement = (JSPackageStatement)statement;
            break;
        }
        return packageStatement;
    }

    @Nullable
    public static JSClass findClass(JSFile file2) {
        JSQualifiedNamedElement element = JSPsiImplUtils.findQualifiedElement(file2);
        return element instanceof JSClass ? (JSClass)element : null;
    }

    @Nullable
    public static JSQualifiedNamedElement findQualifiedElement(JSFile file2) {
        JSNamedElement mainDeclaredElement = ActionScriptResolveUtil.findMainDeclaredElement((PsiFileImpl)file2);
        return mainDeclaredElement instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)mainDeclaredElement : null;
    }

    @NotNull
    public static PsiElement findTopLevelNavigatableElement(@NotNull JSQualifiedNamedElement jsClass) {
        if (jsClass == null) {
            JSPsiImplUtils.$$$reportNull$$$0(1);
        }
        if (DumbService.getInstance((Project)jsClass.getProject()).isDumb()) {
            JSQualifiedNamedElement jSQualifiedNamedElement = jsClass;
            if (jSQualifiedNamedElement == null) {
                JSPsiImplUtils.$$$reportNull$$$0(2);
            }
            return jSQualifiedNamedElement;
        }
        PsiElement sourceElement = JSPsiImplUtils.findTopLevelNavigatableElementWithSource(jsClass, null);
        if (sourceElement != null) {
            PsiElement psiElement = sourceElement;
            if (psiElement == null) {
                JSPsiImplUtils.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = jsClass;
        if (jSQualifiedNamedElement == null) {
            JSPsiImplUtils.$$$reportNull$$$0(4);
        }
        return jSQualifiedNamedElement;
    }

    @Nullable
    public static PsiElement findTopLevelNavigatableElementWithSource(@NotNull JSQualifiedNamedElement jsClass, @Nullable Consumer<? super JSQualifiedNamedElement> candidatesConsumer) {
        ProjectFileIndex fileIndex;
        PsiFile containingFile;
        VirtualFile vFile;
        if (jsClass == null) {
            JSPsiImplUtils.$$$reportNull$$$0(5);
        }
        if (candidatesConsumer != null) {
            candidatesConsumer.consume((Object)jsClass);
        }
        VirtualFile virtualFile = vFile = (containingFile = jsClass.getContainingFile()) == null ? null : containingFile.getVirtualFile();
        if (vFile != null && ((fileIndex = ProjectRootManager.getInstance((Project)jsClass.getProject()).getFileIndex()).isInSourceContent(vFile) || fileIndex.isInLibrarySource(vFile))) {
            return jsClass;
        }
        PsiElement sourceElement = JSPsiImplUtils.findNavigatableElementForLibraryClass(jsClass);
        if (sourceElement != null) {
            return sourceElement;
        }
        GlobalSearchScope searchScope = JSResolveUtil.getResolveScope((PsiElement)jsClass);
        String qName = jsClass.getQualifiedName();
        if (qName == null) {
            return null;
        }
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)qName.hashCode(), (Project)jsClass.getProject(), (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            if (qName.equals(((JSQualifiedNamedElement)i.next()).getQualifiedName())) continue;
            i.remove();
        }
        for (JSQualifiedNamedElement candidate : candidates) {
            PsiElement candidateSourceElement;
            if (candidate == jsClass) continue;
            if (candidatesConsumer != null) {
                candidatesConsumer.consume((Object)candidate);
            }
            if ((candidateSourceElement = JSPsiImplUtils.findNavigatableElementForLibraryClass(candidate)) == null) continue;
            return candidateSourceElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement findNavigatableElementForLibraryClass(JSQualifiedNamedElement jsClass) {
        PsiFile containingFile = jsClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile vFile = containingFile.getVirtualFile();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)jsClass.getProject()).getFileIndex();
        if (vFile == null || projectFileIndex.getClassRootForFile(vFile) == null) {
            return null;
        }
        List orderEntries = projectFileIndex.getOrderEntriesForFile(vFile);
        String qName = jsClass.getQualifiedName();
        String baseSourceName = jsClass.getName();
        String packageName = qName == null ? null : StringUtil.getPackageName((String)qName);
        Object relativeFilePath = StringUtil.isEmpty((String)packageName) ? baseSourceName : packageName.replace('.', '/') + "/" + baseSourceName;
        String relativeFilePath2 = (String)relativeFilePath + ".mxml";
        String relativeFilePath4 = (String)relativeFilePath + ".fxg";
        relativeFilePath = (String)relativeFilePath + ".as";
        for (OrderEntry orderEntry : orderEntries) {
            VirtualFile[] files;
            for (VirtualFile file2 : files = JSPsiImplUtils.getSourceRoots(orderEntry, vFile)) {
                PsiFile psiSource;
                VirtualFile source = file2.findFileByRelativePath((String)relativeFilePath);
                if (source != null) {
                    psiSource = jsClass.getManager().findFile(source);
                    if (!(psiSource instanceof JSFile)) continue;
                    JSPackageStatement statement = JSPsiImplUtils.findPackageStatement((JSFile)psiSource);
                    if (statement != null) {
                        for (JSSourceElement el : statement.getStatements()) {
                            if (el.getClass() == jsClass.getClass() && Objects.equals(jsClass.getName(), el.getName())) {
                                return el;
                            }
                            if (!(jsClass instanceof JSVariable) || !(el instanceof JSNamespaceDeclaration) || !Objects.equals(jsClass.getQualifiedName(), ((JSNamespaceDeclaration)el).getQualifiedName())) continue;
                            return el;
                        }
                    }
                    return psiSource;
                }
                source = file2.findFileByRelativePath(relativeFilePath2);
                if (source == null) {
                    source = file2.findFileByRelativePath(relativeFilePath4);
                }
                if (source == null || !((psiSource = jsClass.getManager().findFile(source)) instanceof XmlFile)) continue;
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)psiSource);
            }
        }
        return null;
    }

    private static VirtualFile[] getSourceRoots(OrderEntry orderEntry, VirtualFile vFile) {
        if (orderEntry instanceof ModuleJdkOrderEntry) {
            Sdk sdk = ((ModuleJdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            if (sdk instanceof CompositeRootCollection) {
                return ((CompositeRootCollection)sdk).getFiles(OrderRootType.SOURCES, vFile);
            }
        }
        return orderEntry.getFiles(OrderRootType.SOURCES);
    }

    @Nullable
    public static JSQualifiedName getNamespace(@NotNull JSNamedElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(6);
        }
        JSQualifiedName result2 = JSPsiImplUtils.getPrefixFromName(element);
        JSNamespace namespaceFromParent = JSPsiImplUtils.getNamespaceFromParent(element);
        if (namespaceFromParent != null && !namespaceFromParent.isLocal()) {
            result2 = JSQualifiedNameImpl.concat(namespaceFromParent.getQualifiedName(), result2);
        }
        return result2;
    }

    @Nullable
    public static JSQualifiedName getPrefixFromName(@NotNull JSNamedElement element) {
        PsiElement nameIdentifier;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(7);
        }
        String name = (nameIdentifier = element.getNameIdentifier()) != null ? nameIdentifier.getText() : null;
        JSQualifiedName result2 = null;
        if (name != null && StringUtil.containsChar((String)name, (char)'.')) {
            Matcher matcher = ourQuotedQualifiedNamePartPattern.matcher(name);
            while (matcher.find()) {
                result2 = JSQualifiedNameImpl.create(matcher.group(0), result2);
            }
            if (result2 != null) {
                result2 = result2.getParent();
            }
        }
        return result2;
    }

    @Nullable
    public static JSNamespace getNamespaceFromParent(@NotNull JSNamedElement element) {
        PsiElement responsibleParent;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(8);
        }
        if ((responsibleParent = element.getParent()) instanceof JSVarStatement) {
            responsibleParent = responsibleParent.getParent();
        }
        if (responsibleParent instanceof JSPackageStatement || responsibleParent instanceof TypeScriptModule || responsibleParent instanceof JSClass && !DialectDetector.isActionScript(responsibleParent)) {
            return JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)((JSQualifiedNamedElement)responsibleParent), true, null);
        }
        return null;
    }

    @Nullable
    public static String buildQualifiedNameFromNamespaceAndName(JSQualifiedNamedElement element) {
        Object result2 = element.getName();
        if (result2 == null) {
            return null;
        }
        JSQualifiedName namespace = element.getNamespace();
        if (namespace != null) {
            result2 = namespace.getQualifiedName() + "." + (String)result2;
        }
        return result2;
    }

    @Nullable
    public static JSQualifiedName buildNamespaceFromQualifiedName(@NotNull JSQualifiedNamedElement element) {
        String qualifiedName;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(9);
        }
        if ((qualifiedName = element.getQualifiedName()) == null) {
            return null;
        }
        Matcher matcher = ourQuotedQualifiedNamePartPattern.matcher(qualifiedName);
        JSQualifiedNameImpl result2 = null;
        while (matcher.find()) {
            result2 = JSQualifiedNameImpl.create(matcher.group(0), result2);
        }
        return result2 != null ? result2.getParent() : null;
    }

    @Nullable
    public static ASTNode findAnnotationAttributeValueNode(ASTNode node) {
        ASTNode valueNode = node.findChildByType(JSTokenTypes.STRING_LITERAL);
        if (valueNode == null) {
            valueNode = node.findChildByType(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL);
        }
        if (valueNode == null) {
            ASTNode next;
            ASTNode eqNode = node.findChildByType(JSTokenTypes.EQ);
            ASTNode aSTNode = next = eqNode == null ? null : eqNode.getTreeNext();
            while (next != null && next.getElementType() == JSTokenTypes.WHITE_SPACE) {
                next = next.getTreeNext();
            }
            valueNode = next;
        }
        return valueNode;
    }

    @Nullable
    public static String getTypeFromAnnotationParameter(@NotNull JSAttributeList attributeList, @NotNull String annotationName, @Nullable String annotationParameter) {
        if (attributeList == null) {
            JSPsiImplUtils.$$$reportNull$$$0(10);
        }
        if (annotationName == null) {
            JSPsiImplUtils.$$$reportNull$$$0(11);
        }
        String arrayType = null;
        JSAttribute[] byName = attributeList.getAttributesByName(annotationName);
        if (byName.length > 0) {
            JSAttributeNameValuePair jsAttributeNameValuePair = byName[0].getValueByName(annotationParameter);
            arrayType = jsAttributeNameValuePair != null ? jsAttributeNameValuePair.getSimpleValue() : null;
        }
        return arrayType;
    }

    public static boolean isTheSameClass(PsiElement typeSource, JSQualifiedNamedElement jsClass) {
        boolean sameQNames;
        if (typeSource == jsClass) {
            return true;
        }
        if (!(typeSource instanceof JSClass) || !(jsClass instanceof JSClass)) {
            return false;
        }
        String qName = ((JSClass)typeSource).getQualifiedName();
        boolean bl = sameQNames = qName != null && qName.equals(jsClass.getQualifiedName());
        if (!sameQNames) {
            return false;
        }
        typeSource = typeSource.getNavigationElement();
        jsClass = (JSClass)jsClass.getNavigationElement();
        VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile((PsiElement)typeSource);
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)jsClass);
        if (virtualFile1 == null || virtualFile2 == null) {
            return false;
        }
        if (Comparing.equal((Object)virtualFile1, (Object)virtualFile2)) {
            return true;
        }
        PsiFile psiFile1 = typeSource.getContainingFile().getOriginalFile();
        PsiFile psiFile2 = jsClass.getContainingFile().getOriginalFile();
        if (JSResolveUtil.isFromPredefinedFile(psiFile1) || JSResolveUtil.isFromPredefinedFile(psiFile2) || !virtualFile1.isValid() || !virtualFile2.isValid()) {
            return true;
        }
        DirectoryIndex index = DirectoryIndex.getInstance((Project)jsClass.getProject());
        VirtualFile parent1 = virtualFile1.getParent();
        VirtualFile parent2 = virtualFile2.getParent();
        if (parent1 == null || parent2 == null) {
            return true;
        }
        DirectoryInfo info1 = index.getInfoForFile(parent1);
        DirectoryInfo info2 = index.getInfoForFile(parent2);
        if (!info1.isInProject(virtualFile1) || !info2.isInProject(virtualFile2)) {
            return false;
        }
        return info1.getModule() == null || info2.getModule() == null;
    }

    public static void doRenameParentDirectoryIfNeeded(VirtualFile file2, String name, Object requestor) throws IOException {
        VirtualFile directory;
        VirtualFile virtualFile = directory = file2.isDirectory() ? file2 : file2.getParent();
        if (!name.equals(directory.getName())) {
            directory.rename(requestor, name);
        }
    }

    @Nullable
    public static String getQNameForMove(@NotNull PsiElement targetElement, PsiElement elementToBind) {
        if (targetElement == null) {
            JSPsiImplUtils.$$$reportNull$$$0(12);
        }
        Project project = targetElement.getProject();
        if (elementToBind instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)elementToBind).getDirectories(targetElement.getResolveScope());
            return directories.length > 0 ? JSResolveUtil.getExpectedPackageNameFromFile(directories[0].getVirtualFile(), project) : null;
        }
        String qName = null;
        if (elementToBind instanceof PsiFile) {
            String newName = ((PsiNamedElement)elementToBind).getName();
            assert (newName != null);
            int index = newName.lastIndexOf(46);
            if (index != -1) {
                newName = newName.substring(0, index);
            }
            VirtualFile elementToBindFile = elementToBind.getContainingFile().getVirtualFile();
            String packageName = JSResolveUtil.getExpectedPackageNameFromFile(elementToBindFile, project);
            qName = JSPackageIndex.buildQualifiedName(packageName, newName);
        } else if (elementToBind instanceof JSQualifiedNamedElement && JSUtils.getMemberContainingClass(elementToBind) == null) {
            qName = ((JSQualifiedNamedElement)elementToBind).getQualifiedName();
        }
        if (qName != null && targetElement instanceof JSReferenceExpression) {
            String targetElementPackageName;
            if (targetElement.getContainingFile() instanceof JSFile && PsiTreeUtil.getParentOfType((PsiElement)targetElement, JSPackageStatement.class) == null && JSResolveUtil.getXmlBackedClass((JSFile)targetElement.getContainingFile()) == null) {
                targetElementPackageName = "";
            } else {
                JSExpression qualifier = ((JSReferenceExpression)targetElement).getQualifier();
                String string = targetElementPackageName = qualifier != null ? qualifier.getText() : JSResolveUtil.getExpectedPackageNameFromFile(targetElement.getContainingFile().getVirtualFile(), project);
            }
            if (!JSPsiImplUtils.differentPackageName(targetElementPackageName, StringUtil.getPackageName((String)qName))) {
                return null;
            }
        }
        return qName;
    }

    public static boolean differentPackageName(String s, String expectedPackageNameFromFile) {
        boolean sIsEmpty = JSPsiImplUtils.isEmpty(s);
        boolean expectedIsEmpty = JSPsiImplUtils.isEmpty(expectedPackageNameFromFile);
        return sIsEmpty && !expectedIsEmpty || !sIsEmpty && (expectedIsEmpty || !s.equals(expectedPackageNameFromFile));
    }

    public static boolean isEmpty(String expectedPackageNameFromFile) {
        return expectedPackageNameFromFile == null || expectedPackageNameFromFile.isEmpty();
    }

    public static boolean containsEquivalent(Collection<? extends PsiElement> array, PsiElement element) {
        for (PsiElement psiElement : array) {
            if (!psiElement.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsEquivalent(PsiElement[] array, PsiElement element) {
        return JSPsiImplUtils.containsEquivalent(Arrays.asList(array), element);
    }

    @Nullable
    public static ASTNode findNameIdentifierOfFunction(ASTNode myNode) {
        return JSPsiImplUtils.findNameIdentifierOfFunction(myNode, false);
    }

    public static boolean parensAroundArrowFunctionParametersRequired(@NotNull JSParameterList parameterList, @NotNull JSFunction function2) {
        if (parameterList == null) {
            JSPsiImplUtils.$$$reportNull$$$0(13);
        }
        if (function2 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(14);
        }
        if (function2.getReturnTypeElement() != null) {
            return true;
        }
        JSParameterListElement[] parameters = parameterList.getParameters();
        if (parameters.length != 1) {
            return true;
        }
        JSParameterListElement singleParam = parameters[0];
        return singleParam instanceof JSDestructuringParameter || singleParam.isRest() || singleParam.getTypeElement() != null || singleParam instanceof JSVariable && singleParam.hasInitializer() || singleParam instanceof TypeScriptParameterImpl && ((TypeScriptParameterImpl)singleParam).isDeclaredOptional() || ContainerUtil.or((Object[])parameterList.getChildren(), child -> child instanceof JSDocComment);
    }

    public static boolean parensAroundArrowFunctionBodyRequired(@Nullable JSExpression body) {
        return body instanceof JSObjectLiteralExpression || body instanceof TypeScriptAsExpression;
    }

    @Nullable
    public static PsiComment findTopLevelComment(@NotNull PsiFile file2, @NotNull Condition<? super PsiComment> isAcceptable) {
        if (file2 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(15);
        }
        if (isAcceptable == null) {
            JSPsiImplUtils.$$$reportNull$$$0(16);
        }
        SyntaxTraverser elements = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file2).expand(e -> !(e instanceof JSDocComment));
        for (PsiElement element : elements) {
            IElementType elementType;
            if (element instanceof PsiComment) {
                if (!isAcceptable.value((Object)((PsiComment)element))) continue;
                return (PsiComment)element;
            }
            if (!(element instanceof LeafElement) || element instanceof PsiWhiteSpace || JSTokenTypes.STRING_LITERALS.contains(elementType = ((LeafElement)element).getElementType()) || elementType == JSTokenTypes.SEMICOLON) continue;
            return null;
        }
        return null;
    }

    public static boolean isRuntimeUnqualifiedRefExpression(@Nullable PsiElement parent) {
        return parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)parent);
    }

    public static boolean isArgumentOfCallWithName(@NotNull JSExpression argument, int argumentIndex, String ... components) {
        PsiElement argumentList;
        if (argument == null) {
            JSPsiImplUtils.$$$reportNull$$$0(17);
        }
        if (!((argumentList = JSUtils.getParentSkipParentheses((PsiElement)argument)) instanceof JSArgumentList)) {
            return false;
        }
        PsiElement callExpression = argumentList.getParent();
        if (!(callExpression instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, components)) {
            return false;
        }
        if (argumentIndex >= 0) {
            JSArgumentList list2 = (JSArgumentList)argumentList;
            JSExpression[] arguments = list2.getArguments();
            if (argumentIndex + list2.getFirstArgumentIndex() >= arguments.length || arguments[argumentIndex + list2.getFirstArgumentIndex()] != argument) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static PsiElement getLastLeafChild(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(18);
        }
        PsiElement prev = element;
        while (element != null) {
            prev = element;
            element = element.getLastChild();
        }
        PsiElement psiElement = prev;
        if (psiElement == null) {
            JSPsiImplUtils.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement getFirstLeafChild(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(20);
        }
        PsiElement prev = element;
        while (element != null) {
            prev = element;
            element = element.getFirstChild();
        }
        PsiElement psiElement = prev;
        if (psiElement == null) {
            JSPsiImplUtils.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    public static boolean isConst(@NotNull PsiElement variable) {
        if (variable == null) {
            JSPsiImplUtils.$$$reportNull$$$0(22);
        }
        return JSPsiImplUtils.variableDeclaredWith(variable, JSVarStatement.VarKeyword.CONST);
    }

    public static boolean isLet(@NotNull PsiElement variable) {
        if (variable == null) {
            JSPsiImplUtils.$$$reportNull$$$0(23);
        }
        return JSPsiImplUtils.variableDeclaredWith(variable, JSVarStatement.VarKeyword.LET);
    }

    public static boolean isVar(@NotNull PsiElement variable) {
        if (variable == null) {
            JSPsiImplUtils.$$$reportNull$$$0(24);
        }
        return JSPsiImplUtils.variableDeclaredWith(variable, JSVarStatement.VarKeyword.VAR);
    }

    private static boolean variableDeclaredWith(@NotNull PsiElement element, @NotNull JSVarStatement.VarKeyword keyword) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(25);
        }
        if (keyword == null) {
            JSPsiImplUtils.$$$reportNull$$$0(26);
        }
        if (!(element instanceof JSVariable)) {
            return false;
        }
        JSVariable variable = (JSVariable)element;
        JSVarStatement statement = variable.getStatement();
        return statement != null && statement.getVarKeyword() == keyword;
    }

    @NotNull
    public static TokenSet getIdentifiers(@Nullable DialectOptionHolder dialect) {
        if (dialect != null) {
            if (dialect.isECMA4) {
                TokenSet tokenSet = JSKeywordSets.AS_IDENTIFIER_TOKENS_SET;
                if (tokenSet == null) {
                    JSPsiImplUtils.$$$reportNull$$$0(27);
                }
                return tokenSet;
            }
            if (dialect.isTypeScript) {
                TokenSet tokenSet = JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET;
                if (tokenSet == null) {
                    JSPsiImplUtils.$$$reportNull$$$0(28);
                }
                return tokenSet;
            }
            if (dialect.isJavaScript()) {
                TokenSet tokenSet = JSKeywordSets.JS_IDENTIFIER_TOKENS_SET;
                if (tokenSet == null) {
                    JSPsiImplUtils.$$$reportNull$$$0(29);
                }
                return tokenSet;
            }
        }
        TokenSet tokenSet = JSKeywordSets.IDENTIFIER_TOKENS_SET;
        if (tokenSet == null) {
            JSPsiImplUtils.$$$reportNull$$$0(30);
        }
        return tokenSet;
    }

    @Nullable
    public static ASTNode findNameIdentifierOfFunction(ASTNode myNode, boolean onlyAfterMarkerKeyword) {
        return JSPsiImplUtils.findNameIdentifierOf(myNode, onlyAfterMarkerKeyword, NamedEntityKind.Function);
    }

    @Nullable
    public static ASTNode findFallbackNameIdentifierOfVariable(ASTNode myNode) {
        return JSPsiImplUtils.findNameIdentifierOf(myNode, false, NamedEntityKind.Variable);
    }

    @Nullable
    public static ASTNode findNameIdentifierOf(ASTNode myNode, boolean onlyAfterMarkerKeyword, NamedEntityKind entityKind) {
        if (entityKind != NamedEntityKind.Function && entityKind != NamedEntityKind.Variable) {
            throw new UnsupportedOperationException("Unknown entity kind: " + entityKind);
        }
        TokenSet prefixKeywords = entityKind == NamedEntityKind.Function ? FUNCTION_NAME_PREFIX_KEYWORDS : VARIABLE_NAME_PREFIX_KEYWORDS;
        ASTNode computed = myNode.findChildByType((IElementType)ES6StubElementTypes.COMPUTED_NAME);
        if (computed != null && DialectDetector.isES6(myNode.getPsi()) && (!onlyAfterMarkerKeyword || TreeUtil.findSiblingBackward((ASTNode)computed.getTreePrev(), (TokenSet)prefixKeywords) != null)) {
            return null;
        }
        if (entityKind != NamedEntityKind.Function) {
            ASTNode child = myNode.findChildByType(JSKeywordSets.PROPERTY_NAMES);
            if (child != null && TreeUtil.findSiblingBackward((ASTNode)child.getTreePrev(), (TokenSet)prefixKeywords) == null) {
                return child;
            }
            return null;
        }
        for (ASTNode candidate = myNode.findChildByType(JSElementTypes.PARAMETER_LISTS); candidate != null; candidate = candidate.getTreePrev()) {
            if (!JSKeywordSets.PROPERTY_NAMES.contains(candidate.getElementType())) continue;
            if (onlyAfterMarkerKeyword && TreeUtil.findSiblingBackward((ASTNode)candidate.getTreePrev(), (TokenSet)prefixKeywords) == null) {
                return null;
            }
            return candidate;
        }
        return null;
    }

    @Nullable
    private static ASTNode getComputedNameOf(ASTNode myNode, boolean onlyAfterMarkerKeyword, NamedEntityKind entityKind) {
        if (entityKind != NamedEntityKind.Function && entityKind != NamedEntityKind.Variable) {
            throw new UnsupportedOperationException("Unknown entity kind: " + entityKind);
        }
        TokenSet prefixKeywords = entityKind == NamedEntityKind.Function ? FUNCTION_NAME_PREFIX_KEYWORDS : VARIABLE_NAME_PREFIX_KEYWORDS;
        ASTNode computed = myNode.findChildByType((IElementType)ES6StubElementTypes.COMPUTED_NAME);
        if (computed != null && DialectDetector.isES6(myNode.getPsi()) && (!onlyAfterMarkerKeyword || TreeUtil.findSiblingBackward((ASTNode)computed.getTreePrev(), (TokenSet)prefixKeywords) != null)) {
            return computed;
        }
        return null;
    }

    @Nullable
    public static ASTNode getComputedNameOfFunction(ASTNode myNode, boolean onlyAfterMarkerKeyword) {
        return JSPsiImplUtils.getComputedNameOf(myNode, onlyAfterMarkerKeyword, NamedEntityKind.Function);
    }

    @Nullable
    public static ASTNode getComputedNameOfVariable(ASTNode myNode, boolean onlyAfterMarkerKeyword) {
        return JSPsiImplUtils.getComputedNameOf(myNode, onlyAfterMarkerKeyword, NamedEntityKind.Variable);
    }

    public static boolean isFunctionNameReference(JSFunction function2, PsiElement elt) {
        return function2.getNameIdentifier() == elt || function2 instanceof JSFunctionExpression && ((JSFunctionExpression)function2).getOwnNameIdentifier() == elt;
    }

    public static void deleteFromTree(PsiElement element) {
        PsiComment docComment = JSDocumentationUtils.findDocComment(element);
        element.getNode().getTreeParent().removeChild(element.getNode());
        if (docComment != null && docComment.getNode().getElementType() == JSTokenTypes.DOC_COMMENT && docComment.isValid()) {
            docComment.delete();
        }
    }

    @Nullable
    public static String calcNamespaceReference(PsiElement element) {
        JSReferenceExpression namespaceElement;
        String nsName = null;
        PsiElement startFrom = null;
        if (element instanceof ActionScriptAttributeListImpl) {
            String s = ((ActionScriptAttributeListImpl)element).tryResolveNamespaceValueFromStub();
            if (s != null) {
                return s;
            }
            nsName = ((JSAttributeList)element).getNamespace();
            startFrom = JSResolveUtil.findParent(element.getParent());
        } else if (element instanceof JSReferenceExpression) {
            namespaceElement = ((JSReferenceExpression)element).getNamespaceElement();
            if (namespaceElement == null) {
                return null;
            }
            nsName = namespaceElement.getReferenceName();
        } else if (element instanceof JSUseNamespaceDirective) {
            namespaceElement = ((JSUseNamespaceDirective)element).getNamespaceReference();
            if (namespaceElement == null) {
                return null;
            }
            nsName = namespaceElement.getReferenceName();
        }
        if (nsName == null) {
            return null;
        }
        final Ref nsValueCalculated = new Ref();
        JSResolveUtil.StructureResolveProcessor processor = new JSResolveUtil.StructureResolveProcessor(nsName){
            {
                super(name);
                this.setLocalResolve(false);
                this.setForceImportsForPlace(true);
                this.setProcessingOptions(ourNsProcessingOptions);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(1);
                }
                String nsValue = null;
                if (element instanceof JSNamespaceDeclaration) {
                    nsValue = ((JSNamespaceDeclaration)element).getInitialValueString();
                    if (nsValue == null) {
                        nsValue = ((JSNamespaceDeclaration)element).getName();
                    }
                } else if (element instanceof JSVariable) {
                    JSVariable var = (JSVariable)element;
                    nsValue = var.isConst() ? var.getLiteralOrReferenceInitializerText() : "-\"-";
                }
                if (nsValue != null) {
                    nsValueCalculated.set((Object)StringUtil.unquoteString((String)nsValue));
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiElement context = startFrom != null ? startFrom : element;
        JSResolveUtil.walkOverStructure(context, processor);
        String result2 = (String)nsValueCalculated.get();
        if ("-\"-".equals(result2)) {
            return null;
        }
        if (result2 == null) {
            result2 = nsName;
        }
        return result2;
    }

    public static boolean isArrowFunction(@Nullable JSFunction function2) {
        return JSPsiImplUtils.getFunctionArrowNode(function2) != null;
    }

    @Nullable
    public static ASTNode getFunctionArrowNode(@Nullable JSFunction function2) {
        if (!(function2 instanceof JSFunctionExpression)) {
            return null;
        }
        ASTNode node = function2.getNode();
        ASTNode firstChild = node.getFirstChildNode();
        if (firstChild != null && firstChild.getElementType() == JSTokenTypes.FUNCTION_KEYWORD) {
            return null;
        }
        return node.findChildByType(JSTokenTypes.ARROWS);
    }

    @Nullable
    public static JSExpression tryGetArrowFunctionReturnExpression(@Nullable JSFunction function2) {
        if (JSPsiImplUtils.getFunctionArrowNode(function2) == null) {
            return null;
        }
        ASTNode expressionNode = function2.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return expressionNode != null ? (JSExpression)expressionNode.getPsi() : null;
    }

    public static boolean isShorthandArrowFunction(@NotNull JSFunction element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(31);
        }
        return JSPsiImplUtils.tryGetArrowFunctionReturnExpression(element) != null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static JSElement getFunctionBody(@Nullable JSFunction function2) {
        if (function2 == null) {
            return null;
        }
        JSBlockStatement blockBody = function2.getBlock();
        if (blockBody != null) {
            return blockBody;
        }
        return JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function2);
    }

    @Nullable
    public static JSExpression getReturnedExpressionIfSingle(@NotNull JSFunction function2) {
        PsiElement lastStatement;
        JSExpression arrowFunctionReturnExpression;
        if (function2 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(32);
        }
        if ((arrowFunctionReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function2)) != null) {
            return arrowFunctionReturnExpression;
        }
        JSBlockStatement block = function2.getBlock();
        PsiElement psiElement = lastStatement = block == null ? null : block.getLastChild();
        while (lastStatement != null && !(lastStatement instanceof JSStatement)) {
            lastStatement = lastStatement.getPrevSibling();
        }
        if (!(lastStatement instanceof JSReturnStatement)) {
            return null;
        }
        Collection returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions(function2, JSExpression.class);
        return returnedExpressions.size() == 1 ? (JSExpression)ContainerUtil.getFirstItem(returnedExpressions) : null;
    }

    @Nullable
    public static PsiElement getNonParenthesizeParent(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(33);
        }
        return JSUtils.getParentSkipParentheses(element);
    }

    @Nullable
    public static JSFunction getPossibleFunction(@Nullable PsiElement element) {
        if (element instanceof JSFunction) {
            return (JSFunction)element;
        }
        if (element instanceof JSProperty) {
            element = ((JSProperty)element).tryGetFunctionInitializer();
        }
        if (element instanceof JSInitializerOwner) {
            element = ((JSInitializerOwner)element).getInitializerOrStub();
        }
        return element instanceof JSFunction ? (JSFunction)element : null;
    }

    @Nullable
    public static JSFunctionItem getPossibleFunctionItem(@Nullable PsiElement element) {
        if (element instanceof JSFunctionItem) {
            return (JSFunctionItem)element;
        }
        return JSPsiImplUtils.getPossibleFunction(element);
    }

    @Nullable
    public static JSFunctionItem calculatePossibleFunction(@NotNull PsiElement element, @Nullable PsiElement methodExpression, boolean includeRawSignatures) {
        Collection<JSFunctionWithSubstitutor> functionWithSubstitutors;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(34);
        }
        if ((functionWithSubstitutors = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(element, methodExpression, null, includeRawSignatures)).isEmpty()) {
            return null;
        }
        JSFunctionWithSubstitutor item = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(functionWithSubstitutors);
        if (item != null) {
            JSFunctionItem firstFunction = item.myFunctionItem;
            JSTypeSubstitutor substitutor = item.myTypeSubstitutor;
            if (firstFunction instanceof JSImplicitFunctionImpl) {
                return firstFunction;
            }
            return functionWithSubstitutors.size() > 1 || !substitutor.isEmpty() ? null : firstFunction;
        }
        return null;
    }

    @Nullable
    public static JSExpression getRightmostInitializer(@NotNull JSInitializerOwner initializerOwner) {
        JSExpression definitionInitializer;
        JSDefinitionExpression definitionExpression;
        if (initializerOwner == null) {
            JSPsiImplUtils.$$$reportNull$$$0(35);
        }
        JSExpression initializer = initializerOwner.getInitializerOrStub();
        while (initializer instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)initializer).getDefinitionExpression()) != null && (definitionInitializer = definitionExpression.getInitializerOrStub()) != null) {
            initializer = definitionInitializer;
        }
        return initializer;
    }

    @Nullable
    public static JSFunctionExpression findConstructsFunction(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(36);
        }
        if (DialectDetector.isTypeScript(element)) {
            return null;
        }
        PsiElement scope = element;
        if (element instanceof JSDefinitionExpression && (parent = element.getParent()) instanceof JSAssignmentExpression) {
            scope = parent;
        }
        Collection<Object> objectLiterals = scope instanceof JSObjectLiteralExpression ? Collections.singleton((JSObjectLiteralExpression)scope) : JSStubBasedPsiTreeUtil.findDescendants(scope, OBJECT_LITERAL_EXPRESSION_TOKEN_SET, FIND_CONSTRUCTS_STOP_AT);
        for (JSObjectLiteralExpression jSObjectLiteralExpression : objectLiterals) {
            for (JSProperty property : jSObjectLiteralExpression.getProperties()) {
                JSFunction initializer;
                JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)property);
                if (comment == null || !comment.hasConstructsTag() || !((initializer = property.tryGetFunctionInitializer()) instanceof JSFunctionExpression)) continue;
                return (JSFunctionExpression)initializer;
            }
        }
        return null;
    }

    @Nullable
    public static JSExpression getAssignedExpression(@Nullable PsiElement element) {
        if (element instanceof JSDefinitionExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getLOperand() == element) {
                JSExpression rOperand = ((JSAssignmentExpression)parent).getROperand();
                return rOperand != null ? JSPsiImplUtils.getAssignedExpression((PsiElement)rOperand) : null;
            }
        } else {
            if (element instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)element).getROperand();
                return rOperand != null ? JSPsiImplUtils.getAssignedExpression((PsiElement)rOperand) : null;
            }
            if (element instanceof JSExpression) {
                return (JSExpression)element;
            }
            if (element instanceof JSVariable) {
                return JSPsiImplUtils.getAssignedExpression((PsiElement)((JSVariable)element).getInitializer());
            }
            if (element instanceof JSProperty) {
                return JSPsiImplUtils.getAssignedExpression((PsiElement)((JSProperty)element).getValue());
            }
            if (element instanceof ES6ExportDefaultAssignment) {
                return JSPsiImplUtils.getAssignedExpression((PsiElement)((ES6ExportDefaultAssignment)element).getExpression());
            }
        }
        return null;
    }

    @Nullable
    public static String findFunctionQualifiedName(@NotNull JSFunctionItem function2) {
        JSExpression lOperand;
        String qualifiedName;
        if (function2 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(37);
        }
        if ((qualifiedName = function2.getQualifiedName()) != null) {
            return qualifiedName;
        }
        if (!(function2 instanceof JSExpression)) {
            return null;
        }
        JSExpression expression = (JSExpression)function2;
        PsiElement parent = expression.getParent();
        if (parent instanceof JSVariable) {
            return ((JSVariable)parent).getQualifiedName();
        }
        if (parent instanceof JSProperty) {
            return ((JSProperty)parent).getName();
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == expression && (lOperand = ((JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)lOperand).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static String findFunctionName(@NotNull JSFunctionItem function2) {
        String qualifiedName;
        if (function2 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(38);
        }
        return (qualifiedName = JSPsiImplUtils.findFunctionQualifiedName(function2)) != null ? QualifiedName.fromDottedString((String)qualifiedName).getLastComponent() : null;
    }

    public static boolean isGetProperty(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(39);
        }
        return element instanceof JSFunctionItem ? ((JSFunctionItem)element).isGetProperty() : element instanceof JSProperty && ((JSProperty)element).isGetProperty();
    }

    public static boolean isSetProperty(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(40);
        }
        return element instanceof JSFunctionItem ? ((JSFunctionItem)element).isSetProperty() : element instanceof JSProperty && ((JSProperty)element).isSetProperty();
    }

    @Nullable
    public static JSExpression getRightmostOperand(@NotNull JSDefinitionExpression definitionExpression) {
        PsiElement parent;
        if (definitionExpression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(41);
        }
        if ((parent = definitionExpression.getParent()) instanceof JSAssignmentExpression) {
            JSExpression expr = ((JSAssignmentExpression)parent).getROperand();
            while (expr instanceof JSAssignmentExpression) {
                expr = ((JSAssignmentExpression)expr).getROperand();
            }
            return expr;
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static JSAttributeList.AccessType getExplicitAccessType(@Nullable JSAttributeListOwner attributeListOwner) {
        if (attributeListOwner == null) {
            return null;
        }
        JSAttributeList list2 = attributeListOwner.getAttributeList();
        if (list2 == null) {
            return null;
        }
        return list2.getExplicitAccessType();
    }

    @NotNull
    public static JSAttributeList.AccessType getAccessType(JSQualifiedNamedElement element) {
        JSAttributeList.AccessType accessType;
        JSAttributeList.AccessType accessType2;
        JSAttributeList list2;
        JSAttributeList jSAttributeList = list2 = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
        if (list2 != null && (accessType2 = list2.getExplicitAccessType()) != null) {
            JSAttributeList.AccessType accessType3 = accessType2;
            if (accessType3 == null) {
                JSPsiImplUtils.$$$reportNull$$$0(42);
            }
            return accessType3;
        }
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        if (docComment != null && (accessType = docComment.getAccessType()) != null) {
            JSAttributeList.AccessType accessType4 = accessType;
            if (accessType4 == null) {
                JSPsiImplUtils.$$$reportNull$$$0(43);
            }
            return accessType4;
        }
        JSAttributeList.AccessType accessType5 = list2 != null ? list2.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType5 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(44);
        }
        return accessType5;
    }

    @Nullable
    public static Pair<String, PsiElement> getChildStringLiteralWithText(PsiElement element) {
        ASTNode literalNode = element.getNode().findChildByType(JSTokenTypes.STRING_LITERALS);
        if (literalNode == null) {
            return null;
        }
        String modulePath = literalNode.getText();
        PsiElement literalElement = literalNode.getPsi();
        return Pair.create((Object)modulePath, (Object)literalElement);
    }

    public static JSExpression getInitializer(ASTNode ownerNode) {
        ASTNode node = JSTreeUtil.getInitializerNode(ownerNode);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static <T extends PsiReference> T findReferenceOfClass(PsiReference ref, Class<T> clazz) {
        return (T)PsiReferenceUtil.findReferenceOfClass((PsiReference)ref, clazz);
    }

    @NlsSafe
    @Nullable
    public static String getNameOrComputedPropertyName(@Nullable JSNamedElementBase element, boolean stubSafe) {
        String computedPropertyName;
        if (element == null) {
            return null;
        }
        Object name = element.getName();
        if (name != null) {
            return element instanceof TypeScriptModule ? name : JSSymbolUtil.handleSpecialPropertyNames((String)name, '\"');
        }
        if (element instanceof JSComputedPropertyNameOwner && (computedPropertyName = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)element)) != null) {
            name = "[" + computedPropertyName + "]";
        }
        if (element instanceof JSDefinitionExpressionImpl && (!stubSafe || ((JSDefinitionExpressionImpl)element).getGreenStub() == null)) {
            PsiElement identifier = ((JSDefinitionExpression)element).getNameIdentifier();
            if (identifier != null) {
                String text = identifier.getText();
                name = "[" + text + "]";
            } else {
                JSExpression indexExpression;
                JSExpression expression = ((JSDefinitionExpression)element).getExpression();
                if (expression instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression()) != null) {
                    String text = indexExpression.getText();
                    name = "[" + text + "]";
                }
            }
        }
        return name;
    }

    @Nullable
    public static String getComputedPropertyNameWithoutBrackets(JSComputedPropertyNameOwner owner) {
        ES6ComputedName expr = owner.getComputedPropertyName();
        return expr == null ? null : expr.getExpressionAsPropertyName();
    }

    @Contract(value="null -> false")
    public static boolean isSymbolRef(@Nullable JSExpression expr) {
        if (!JSSymbolUtil.isAccurateReferenceExpression(expr)) {
            return false;
        }
        JSReferenceExpression ref = (JSReferenceExpression)expr;
        JSExpression qualifier = ref.getQualifier();
        return qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, "Symbol");
    }

    @Nullable
    public static JSNamedElement findElementFromNameIdentifier(@NotNull PsiElement nameIdentifier) {
        JSNamedElement candidate;
        if (nameIdentifier == null) {
            JSPsiImplUtils.$$$reportNull$$$0(45);
        }
        PsiElement identifier = (candidate = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)nameIdentifier, JSNamedElement.class)) != null ? candidate.getNameIdentifier() : null;
        return identifier == nameIdentifier ? candidate : null;
    }

    public static boolean signatureIsExplicitlyDeclared(@NotNull JSFunctionItem function2) {
        if (function2 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(46);
        }
        if (function2 instanceof JSFunction ? ((JSFunction)function2).hasExplicitlyDeclaredReturnType() : function2.getReturnType() != null) {
            return true;
        }
        if (function2.isOverride()) {
            return true;
        }
        JSParameterItem[] parameters = function2.getParameters();
        if (parameters.length == 0) {
            return false;
        }
        for (JSParameterItem parameter : parameters) {
            JSType type = parameter.getSimpleType();
            if (type == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isUseStrictStatement(@Nullable PsiElement currentChild) {
        JSExpression expression;
        if (currentChild instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)currentChild).getExpression()) instanceof JSLiteralExpression) {
            JSLiteralExpression literal = (JSLiteralExpression)expression;
            return "use strict".equals(literal.getStringValue());
        }
        return false;
    }

    public static boolean isCompilerDirectiveStatement(@Nullable PsiElement element) {
        JSExpression expression;
        if (element instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)element).getExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isQuotedLiteral()) {
            String value = ((JSLiteralExpression)expression).getStringValue();
            return value != null && value.startsWith("use ") && StringUtil.isJavaIdentifier((String)value.substring(4));
        }
        return false;
    }

    @Nullable
    public static JSQualifiedNamedElement getInitializedElement(@NotNull JSExpression expression) {
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(47);
        }
        return JSPsiImplUtils.getInitializedElement(expression, true);
    }

    @Nullable
    public static JSQualifiedNamedElement getInitializedElement(@NotNull JSExpression expression, boolean isAstAccessAllowed) {
        JSDefinitionExpression definitionExpression;
        PsiElement parent;
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(48);
        }
        PsiElement psiElement = parent = isAstAccessAllowed ? JSUtils.getParentSkipParentheses((PsiElement)expression) : JSStubBasedPsiTreeUtil.getParentOrNull((PsiElement)expression);
        if (parent instanceof JSProperty || parent instanceof JSVariable) {
            return (JSQualifiedNamedElement)parent;
        }
        if (parent instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)parent).getDefinitionExpression()) != expression) {
            return definitionExpression;
        }
        return null;
    }

    @Nullable
    public static JSNamedElementBase getInitializedElement(@NotNull JSExpression expression, boolean isAstAccessAllowed, boolean isResolveAllowed) {
        PsiElement parent;
        JSQualifiedNamedElement initializedElement;
        if (expression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(49);
        }
        if ((initializedElement = JSPsiImplUtils.getInitializedElement(expression, isAstAccessAllowed)) != null) {
            return initializedElement;
        }
        if (isResolveAllowed && (parent = expression.getParent()) instanceof JSArgumentList) {
            return JSResolveUtil.findParameterForUsedArgument(expression, (JSArgumentList)parent);
        }
        return null;
    }

    @NotNull
    public static String getNameFromIdentifier(@NotNull ASTNode nameIdentifier) {
        Double aDouble;
        if (nameIdentifier == null) {
            JSPsiImplUtils.$$$reportNull$$$0(50);
        }
        String text = nameIdentifier.getText();
        if (nameIdentifier.getElementType() == JSTokenTypes.NUMERIC_LITERAL && (aDouble = JSNumberParser.tryParseNumericValue(text, false)) != null) {
            return JSPsiImplUtils.convertECMAScriptNumberToString(aDouble);
        }
        String string = JSStringUtil.unquoteAndUnescapeString(text);
        if (string == null) {
            JSPsiImplUtils.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public static String convertECMAScriptNumberToString(double aDouble) {
        String string = ScriptRuntime.toString((double)aDouble);
        if (string == null) {
            JSPsiImplUtils.$$$reportNull$$$0(52);
        }
        return string;
    }

    @Nullable
    public static PsiComment findTrailingEndOfLineComment(@NotNull PsiElement element) {
        PsiElement sibling;
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(53);
        }
        if ((sibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)element)) instanceof PsiComment && (sibling.getPrevSibling() == element || JSPsiImplUtils.hasInlineWhitespaceBefore(sibling))) {
            return (PsiComment)sibling;
        }
        return null;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static PsiElement findLeadingCommentOrSelf(@Nullable PsiElement element) {
        return JSPsiImplUtils.findLeadingCommentOrSelf(element, false);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static PsiElement findLeadingCommentOrSelf(@Nullable PsiElement element, boolean contiguous) {
        if (element == null) {
            return null;
        }
        return (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.findLeadingComment(element, contiguous), (Object)element);
    }

    @Nullable
    public static PsiComment findLeadingComment(@NotNull PsiElement element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(54);
        }
        return JSPsiImplUtils.findLeadingComment(element, false);
    }

    @Nullable
    public static PsiComment findLeadingComment(@NotNull PsiElement element, boolean contiguous) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(55);
        }
        PsiElement comment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (!contiguous) {
            return JSPsiImplUtils.isLeadingComment(comment) ? (PsiComment)comment : null;
        }
        PsiElement leading = null;
        PsiElement anchor = comment;
        while (JSPsiImplUtils.isLeadingComment(anchor)) {
            leading = anchor;
            anchor = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
        }
        return (PsiComment)ObjectUtils.tryCast((Object)leading, PsiComment.class);
    }

    private static boolean isLeadingComment(@Nullable PsiElement element) {
        PsiElement afterComment;
        return element instanceof PsiComment && !FlowJSAnnotation.isFlowComment((PsiComment)element) && (afterComment = element.getNextSibling()) instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)afterComment.getText(), (char)'\n') <= 1 && !JSPsiImplUtils.hasInlineWhitespaceBefore(element);
    }

    public static boolean isGetterOrSetter(@NotNull JSFunctionItem function2) {
        if (function2 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(56);
        }
        return function2.isGetProperty() || function2.isSetProperty();
    }

    private static boolean hasInlineWhitespaceBefore(@NotNull PsiElement comment) {
        PsiElement prevSibling;
        if (comment == null) {
            JSPsiImplUtils.$$$reportNull$$$0(57);
        }
        if ((prevSibling = comment.getPrevSibling()) == null) {
            return false;
        }
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return true;
        }
        return !prevSibling.textContains('\n');
    }

    public static boolean isIIFE(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSPsiImplUtils.$$$reportNull$$$0(58);
        }
        if (!(function2 instanceof JSFunctionExpression)) {
            return false;
        }
        JSExpression node = JSUtils.getTopmostParenthesizedOrSelf((JSExpression)((JSFunctionExpression)function2));
        PsiElement call = node.getParent();
        return call instanceof JSCallExpression && ((JSCallExpression)call).getMethodExpression() == node;
    }

    @NotNull
    public static List<PsiElement> getSiblingsForward(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            JSPsiImplUtils.$$$reportNull$$$0(59);
        }
        if (end == null) {
            JSPsiImplUtils.$$$reportNull$$$0(60);
        }
        if (start == end) {
            return new SmartList((Object)start);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        result2.add(start);
        PsiElement current = start;
        do {
            result2.add(current);
            current = current.getNextSibling();
            if (current != null) continue;
            ArrayList<PsiElement> arrayList = result2;
            if (arrayList == null) {
                JSPsiImplUtils.$$$reportNull$$$0(61);
            }
            return arrayList;
        } while (current != end);
        result2.add(current);
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            JSPsiImplUtils.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    @Nullable
    public static JSStatement findFirstFunctionStatement(@Nullable JSFunction function2) {
        PsiElement anchor;
        if (function2 == null) {
            return null;
        }
        JSBlockStatement body = function2.getBlock();
        if (body == null) {
            return null;
        }
        for (anchor = body.getFirstChild(); anchor != null && !(anchor instanceof JSStatement) || JSPsiImplUtils.isUseStrictStatement(anchor); anchor = anchor.getNextSibling()) {
        }
        return (JSStatement)anchor;
    }

    @Nullable
    public static JSFunction getParentFunctionThroughLambdas(@Nullable PsiElement parent) {
        JSQualifiedNamedElement parentFunction = JSPsiImplUtils.getParentFunctionOrClassThroughLambdas(parent);
        return (JSFunction)ObjectUtils.tryCast((Object)parentFunction, JSFunction.class);
    }

    @Nullable
    public static JSQualifiedNamedElement getParentFunctionOrClassThroughLambdas(@Nullable PsiElement element) {
        JSQualifiedNamedElement parent = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class, JSClass.class});
        if (parent instanceof JSFunction && ((JSFunction)parent).isArrowFunction()) {
            return JSPsiImplUtils.getParentFunctionOrClassThroughLambdas((PsiElement)parent);
        }
        return parent;
    }

    @Nullable
    public static String getValidNameFromComputedName(@Nullable ES6ComputedName computedName) {
        return computedName != null ? computedName.getExpressionAsPropertyName() : null;
    }

    public static boolean calculateTypeOfVariableForIteratedExpression(@NotNull JSTypeEvaluator evaluator, @Nullable PsiElement expression, @Nullable JSExpression rawQualifier) {
        if (evaluator == null) {
            JSPsiImplUtils.$$$reportNull$$$0(63);
        }
        JSExpression arrayExpression = null;
        if (expression instanceof JSReferenceExpression) {
            PsiElement resolve = ((JSReferenceExpression)expression).resolve();
            if (resolve != null) {
                JSType type;
                if (resolve instanceof JSTypeDeclarationOwner && (type = ((JSTypeDeclarationOwner)resolve).getJSType()) != null) {
                    return evaluator.addComponentTypeFromProcessor((JSExpression)expression, type) != null;
                }
                if ((resolve = JSPsiImplUtils.getAssignedExpression(resolve)) != null) {
                    arrayExpression = (JSExpression)resolve;
                }
            }
        } else if (expression instanceof JSExpression) {
            arrayExpression = (JSExpression)expression;
        }
        if (expression != null && arrayExpression != null) {
            return evaluator.addComponentTypeFromArrayExpression(rawQualifier, arrayExpression) != null;
        }
        return false;
    }

    @Contract(value="null,_ -> false")
    public static boolean hasModifier(@Nullable JSAttributeList attributeList, @NotNull JSAttributeList.ModifierType modifier) {
        if (modifier == null) {
            JSPsiImplUtils.$$$reportNull$$$0(64);
        }
        return attributeList != null && attributeList.hasModifier(modifier);
    }

    @Contract(value="null,_ -> false")
    public static boolean hasModifier(@Nullable JSAttributeListOwner attributeListOwner, @NotNull JSAttributeList.ModifierType modifier) {
        if (modifier == null) {
            JSPsiImplUtils.$$$reportNull$$$0(65);
        }
        if (attributeListOwner == null) {
            return false;
        }
        return JSPsiImplUtils.hasModifier(attributeListOwner.getAttributeList(), modifier);
    }

    @Contract(value="null -> false")
    public static boolean isEmbeddedTypeContext(@Nullable PsiElement parent) {
        return parent instanceof JSEmbeddedContent && parent.getNode().getElementType() == JSStubElementTypes.XML_JS_GENERIC_ARG_SCRIPT;
    }

    @Contract(value="null -> false")
    public static boolean isEmbeddedExpressionContent(@Nullable PsiElement parent) {
        return parent instanceof JSEmbeddedContent && parent.getNode().getElementType() == JSStubElementTypes.EMBEDDED_EXPRESSION || parent instanceof JSEmbeddedContent && parent.getNode().getElementType() == JSStubElementTypes.XML_JS_SCRIPT;
    }

    @Contract(value="null -> false")
    public static boolean isCatchParameter(@Nullable PsiElement element) {
        return element instanceof JSParameter && element.getParent() instanceof JSCatchBlock;
    }

    @Nullable
    public static String getInitializerReference(@NotNull JSInitializerOwner element) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(66);
        }
        if (!(element instanceof JSTypeOwner)) {
            return null;
        }
        JSType type = ((JSTypeOwner)element).getJSType();
        if (type instanceof JSTypeofTypeImpl) {
            type = ((JSTypeofTypeImpl)type).getLocallyEvaluatedType();
        }
        return type instanceof JSReferenceType ? ((JSReferenceType)type).getReferenceName() : null;
    }

    @Nullable
    public static String getInitializerReference(@NotNull JSInitializerOwner element, boolean allowAstAccess) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(67);
        }
        if (!allowAstAccess) {
            return JSPsiImplUtils.getInitializerReference(element);
        }
        JSReferenceExpression initializer = (JSReferenceExpression)ObjectUtils.tryCast((Object)element.getInitializer(), JSReferenceExpression.class);
        return initializer != null && initializer.getQualifier() == null ? initializer.getReferenceName() : null;
    }

    private static boolean hasElvisQualifier(@NotNull JSElvisOwner elvisOwner) {
        JSExpression parent;
        if (elvisOwner == null) {
            JSPsiImplUtils.$$$reportNull$$$0(68);
        }
        return (parent = JSPsiImplUtils.getElvisQualifier(elvisOwner)) instanceof JSElvisOwner && JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)parent);
    }

    @Nullable
    public static JSExpression getElvisQualifier(@NotNull JSElvisOwner elvisOwner) {
        if (elvisOwner == null) {
            JSPsiImplUtils.$$$reportNull$$$0(69);
        }
        return elvisOwner instanceof JSCallExpression ? ((JSCallExpression)elvisOwner).getMethodExpression() : (elvisOwner instanceof JSQualifiedExpression ? ((JSQualifiedExpression)elvisOwner).getQualifier() : null);
    }

    public static boolean isElvisOrInOptChain(@NotNull JSElvisOwner elvisOwner) {
        if (elvisOwner == null) {
            JSPsiImplUtils.$$$reportNull$$$0(70);
        }
        return elvisOwner.isElvis() || JSPsiImplUtils.hasElvisQualifier(elvisOwner);
    }

    public static boolean isUnqualifiedAssignment(@NotNull JSDefinitionExpression definitionExpression) {
        JSNamespace ns;
        if (definitionExpression == null) {
            JSPsiImplUtils.$$$reportNull$$$0(71);
        }
        return (ns = definitionExpression.getJSNamespace()).getQualifiedName() == null && ns.isSourceStrict();
    }

    public static TextRange @NotNull [] getTemplateStringRanges(@NotNull PsiElement element, boolean includeEmpty) {
        if (element == null) {
            JSPsiImplUtils.$$$reportNull$$$0(72);
        }
        ASTNode[] children = element.getNode().getChildren(null);
        ArrayList<TextRange> result2 = new ArrayList<TextRange>(children.length);
        int parentStart = element.getTextRange().getStartOffset();
        IElementType prevElementType = null;
        for (ASTNode child : children) {
            IElementType childElementType = child.getElementType();
            if (includeEmpty && (childElementType == JSTokenTypes.BACKQUOTE && prevElementType == JSTokenTypes.BACKQUOTE || childElementType == JSTokenTypes.DOLLAR && prevElementType != JSTokenTypes.STRING_TEMPLATE_PART || childElementType == JSTokenTypes.BACKQUOTE && prevElementType == JSTokenTypes.RBRACE)) {
                result2.add(TextRange.from((int)(child.getTextRange().getStartOffset() - parentStart), (int)0));
            }
            if (childElementType == JSTokenTypes.STRING_TEMPLATE_PART) {
                result2.add(child.getTextRange().shiftLeft(parentStart));
            }
            prevElementType = childElementType;
        }
        TextRange[] textRangeArray = result2.toArray(TextRange.EMPTY_ARRAY);
        if (textRangeArray == null) {
            JSPsiImplUtils.$$$reportNull$$$0(73);
        }
        return textRangeArray;
    }

    public static boolean isPotentialOverride(@NotNull JSFunctionItem functionItem) {
        JSDocComment docComment;
        if (functionItem == null) {
            JSPsiImplUtils.$$$reportNull$$$0(74);
        }
        if (functionItem.isOverride()) {
            return true;
        }
        JSClass aClass = JSUtils.getMemberContainingClass((PsiElement)functionItem);
        if (aClass == null) {
            return false;
        }
        if (aClass.getExtendsList() != null || aClass.getImplementsList() != null) {
            return true;
        }
        if (!(aClass instanceof JSImplicitElementProvider)) {
            return false;
        }
        JSElementIndexingData data = ((JSImplicitElementProvider)aClass).getIndexingData();
        if (data == null && (docComment = JSStubBasedPsiTreeUtil.findOwnDocComment((PsiElement)aClass)) != null) {
            data = docComment.getIndexingData();
        }
        return data != null && !ContainerUtil.isEmpty((Collection)data.getBaseTypes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 52: 
            case 61: 
            case 62: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 52: 
            case 61: 
            case 62: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 52: 
            case 61: 
            case 62: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 14: 
            case 32: 
            case 37: 
            case 38: 
            case 46: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAcceptable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerOwner";
                break;
            }
            case 41: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionExpression";
                break;
            }
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elvisOwner";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSPsiImplUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopLevelNavigatableElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastLeafChild";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLeafChild";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifiers";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameFromIdentifier";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "convertECMAScriptNumberToString";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingsForward";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateStringRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelNavigatableElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 52: 
            case 61: 
            case 62: 
            case 73: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelNavigatableElementWithSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixFromName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromParent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildNamespaceFromQualifiedName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromAnnotationParameter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQNameForMove";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parensAroundArrowFunctionParametersRequired";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelComment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentOfCallWithName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLastLeafChild";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLeafChild";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isConst";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isLet";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isVar";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "variableDeclaredWith";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandArrowFunction";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getReturnedExpressionIfSingle";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getNonParenthesizeParent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunction";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getRightmostInitializer";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findConstructsFunction";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionQualifiedName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isGetProperty";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isSetProperty";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRightmostOperand";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findElementFromNameIdentifier";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "signatureIsExplicitlyDeclared";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getInitializedElement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIdentifier";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findTrailingEndOfLineComment";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findLeadingComment";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isGetterOrSetter";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "hasInlineWhitespaceBefore";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isIIFE";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingsForward";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "calculateTypeOfVariableForIteratedExpression";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerReference";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "hasElvisQualifier";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getElvisQualifier";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isElvisOrInOptChain";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isUnqualifiedAssignment";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateStringRanges";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialOverride";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 52: 
            case 61: 
            case 62: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum NamedEntityKind {
        Function,
        Variable;

    }
}

