/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.nashorn.NashornJSElementTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpressionCommon;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSNewExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNewExpressionImpl<T extends JSNewExpressionStub<?>>
extends JSImplicitElementProviderImpl<T>
implements JSNewExpression,
StubBasedPsiElement<T>,
JSCallLikeExpressionCommon {
    private static final TokenSet argumentListTokens = TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.ARGUMENT_LIST, NashornJSElementTypes.ARGUMENT_LIST});

    public JSNewExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSNewExpressionImpl(T stub, IStubElementType type) {
        super(stub, type);
    }

    public JSNewExpressionImpl(T stub) {
        super(stub, (IStubElementType)JSStubElementTypes.NEW_EXPRESSION);
    }

    public JSExpression getMethodExpression() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public JSArgumentList getArgumentList() {
        ASTNode node = this.getNode().findChildByType(argumentListTokens);
        return node != null ? (JSArgumentList)node.getPsi() : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSNewExpressionImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSNewExpression((JSNewExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement getArrayInitializingType() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
        if (node == null) {
            return null;
        }
        ASTNode identifierNode = node.findChildByType(JSVariableBaseImpl.IDENTIFIER_TOKENS_SET);
        if (identifierNode != null) {
            return identifierNode.getPsi();
        }
        ASTNode starNode = node.findChildByType(JSTokenTypes.ANY_IDENTIFIER);
        return starNode == null ? null : starNode.getPsi();
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        JSElementIndexingDataImpl indexingData = new JSElementIndexingDataImpl();
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)this)) {
            handler.processCallExpression((JSCallExpression)this, indexingData);
        }
        return indexingData;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    public boolean isRequireCall() {
        return false;
    }

    public boolean isDefineCall() {
        return false;
    }

    public boolean isElvis() {
        return false;
    }

    public JSExpression getStubSafeMethodExpression() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSNewExpressionImpl", "accept"));
    }
}

