/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFileBaseImpl
extends PsiFileBase
implements JSFile {
    @Nullable
    private JSFileCachedData myCachedData;

    protected JSFileBaseImpl(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            JSFileBaseImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            JSFileBaseImpl.$$$reportNull$$$0(1);
        }
        super(viewProvider, language);
    }

    @NotNull
    public JSFileCachedData getCachedData() {
        JSFileCachedData cachedData = this.myCachedData;
        if (cachedData == null) {
            StubElement stub = this.getGreenStub();
            if (stub != null) {
                if (stub instanceof JSFileStubImpl) {
                    cachedData = ((JSFileStubImpl)stub).getCachedData();
                } else {
                    IStubFileElementType elementType = this.getElementTypeForStubBuilder();
                    String elementTypeName = elementType != null ? elementType.getExternalId() : null;
                    Logger.getInstance(JSFileBaseImpl.class).error("stub: " + stub.getClass().getName() + "; file: " + elementTypeName);
                }
            }
            if (cachedData == null) {
                cachedData = this.createCachedDataFromPsi();
            }
            this.myCachedData = cachedData;
        }
        JSFileCachedData jSFileCachedData = cachedData;
        if (jSFileCachedData == null) {
            JSFileBaseImpl.$$$reportNull$$$0(2);
        }
        return jSFileCachedData;
    }

    @Nullable
    public JSFileCachedData tryGetCachedData() {
        return this.myCachedData;
    }

    @NotNull
    private JSFileCachedData createCachedDataFromPsi() {
        JSFileCachedData cachedData = new JSFileCachedData();
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)this)) {
            handler.processFile((JSFile)this, cachedData);
        }
        final JSFileCachedDataEvaluator evaluator = JSDialectSpecificHandlersFactory.forLanguage(this.getLanguage()).newFileCachedDataEvaluator(cachedData);
        JSRecursiveWalkingElementVisitor recursiveVisitor = new JSRecursiveWalkingElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                evaluator.startElement(element);
                if (!evaluator.isSkipChildren()) {
                    super.visitElement(element);
                }
            }

            protected void elementFinished(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                evaluator.finishElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.accept((PsiElementVisitor)recursiveVisitor);
        JSFileCachedData jSFileCachedData = cachedData;
        if (jSFileCachedData == null) {
            JSFileBaseImpl.$$$reportNull$$$0(3);
        }
        return jSFileCachedData;
    }

    public boolean isMinified() {
        return JSMinifiedFileUtil.isFileContentMinified(this.getViewProvider().getVirtualFile());
    }

    public boolean isCommonJSModule() {
        return this.getModuleStatus() != JSFile.ModuleStatus.NONE;
    }

    @NotNull
    public JSFile.ModuleStatus getModuleStatus() {
        JSFile.ModuleStatus moduleStatus = this.getCachedData().getModuleStatus();
        if (moduleStatus == null) {
            JSFileBaseImpl.$$$reportNull$$$0(4);
        }
        return moduleStatus;
    }

    public boolean isTestFile() {
        return this.getTestFileType() != null;
    }

    @Nullable
    public JSTestFileType getTestFileType() {
        return this.getCachedData().getTestFileType();
    }

    public boolean hasES6Syntax() {
        return this.getCachedData().hasES6Syntax();
    }

    public boolean hasFlowFlag() {
        return this.getCachedData().hasFlowFlag();
    }

    @NotNull
    public Set<String> getReferencedPaths() {
        Set<String> set = this.getCachedData().getReferencedPaths();
        if (set == null) {
            JSFileBaseImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myCachedData = null;
        JSControlFlowService.getService(this.getProject()).resetFlow((JSElement)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedDataFromPsi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleStatus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

