/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSTypeOwnerStub;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.annotations.Nullable;

public interface JSCachingTypeOwner
extends JSTypeOwner,
PsiElement {
    public static final Key<ParameterizedCachedValue<JSType, JSCachingTypeOwner>> TYPE_KEY = Key.create((String)"js.element.type");
    public static final ParameterizedCachedValueProvider<JSType, JSCachingTypeOwner> TYPE_PROVIDER = psi -> {
        JSType type;
        JSTypeOwnerStub stub = (JSTypeOwnerStub)((StubBasedPsiElementBase)psi).getGreenStub();
        if (stub != null) {
            String typeString = stub.getTypeString();
            if (typeString == null) {
                type = psi.calculateDeclarationTypeStubSafe();
            } else {
                JSDocComment docComment;
                JSCachingTypeOwner sourceElement = psi;
                if (stub.isTypeFromJSDoc() && (docComment = JSStubBasedPsiTreeUtil.findOwnDocComment(psi)) != null) {
                    sourceElement = docComment;
                }
                type = JSTypeUtils.parseSerializedType(typeString, JSTypeSourceFactory.createTypeSource(sourceElement, stub.isTypeStrict()));
            }
        } else {
            type = psi.calculateType();
        }
        return CachedValueProvider.Result.create((Object)type, (Object[])new Object[]{psi});
    };

    @Nullable
    public JSType calculateType();

    @Nullable
    default public JSType calculateDeclarationTypeStubSafe() {
        return null;
    }

    @Nullable
    default public JSType getJSType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, TYPE_KEY, TYPE_PROVIDER, false, (Object)this);
    }
}

