/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionScriptClassBase<StubT extends JSQualifiedStub<?>>
extends JSClassBase<StubT> {
    @NotNull
    private volatile ThreeState myHasBindableMembers = ThreeState.UNSURE;

    protected ActionScriptClassBase(ASTNode node) {
        super(node);
    }

    public ActionScriptClassBase(StubT stub, IStubElementType<StubT, ?> aClass) {
        super(stub, aClass);
    }

    static boolean isImplicitlyDeclaringEventDispatcher(JSClass clazz) {
        if (!(clazz instanceof ActionScriptClassBase)) {
            return false;
        }
        if (ActionScriptResolveUtil.isImplicitlyDeclaringEventDispatcher(clazz.getAttributeList())) {
            return true;
        }
        ActionScriptClassBase c = (ActionScriptClassBase)clazz;
        if (c.myHasBindableMembers == ThreeState.UNSURE) {
            c.initFields();
        }
        if (c.myHasBindableMembers == ThreeState.UNSURE) {
            c.initFunctions();
        }
        if (c.myHasBindableMembers == ThreeState.UNSURE) {
            c.myHasBindableMembers = ThreeState.NO;
        }
        return c.myHasBindableMembers == ThreeState.YES;
    }

    @Override
    protected <E extends PsiElement> E @NotNull [] getStubChildrenByType(StubElement<?> stub, ArrayFactory<E> f, TokenSet set) {
        assert (!set.contains(JSStubElementTypes.INCLUDE_DIRECTIVE));
        ArrayList result2 = ContainerUtil.newArrayList((Object[])stub.getChildrenByType(set, f));
        JSIncludeDirective[] includes = (JSIncludeDirective[])stub.getChildrenByType(JSStubElementTypes.INCLUDE_DIRECTIVE, JSIncludeDirective[]::new);
        THashSet visited = new THashSet();
        TokenSet filter = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.INCLUDE_DIRECTIVE})});
        for (JSIncludeDirective include : includes) {
            PsiFile file2 = include.resolveFile();
            if (!(file2 instanceof JSFile)) continue;
            ActionScriptResolveUtil.processIncludedFiles(filter, (JSFile)file2, result2, (Collection<? super JSFile>)visited);
        }
        PsiElement[] psiElementArray = result2.toArray((PsiElement[])f.create(result2.size()));
        if (psiElementArray == null) {
            ActionScriptClassBase.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    @Override
    protected void updateStateForField(@NotNull JSField field) {
        if (field == null) {
            ActionScriptClassBase.$$$reportNull$$$0(1);
        }
        if (this.myHasBindableMembers == ThreeState.UNSURE && ActionScriptResolveUtil.isImplicitlyDeclaringEventDispatcher(field.getAttributeList())) {
            this.myHasBindableMembers = ThreeState.YES;
        }
    }

    @Override
    protected void updateStateForFunction(@NotNull JSFunction function2) {
        JSAttributeList attributeList;
        if (function2 == null) {
            ActionScriptClassBase.$$$reportNull$$$0(2);
        }
        if (this.myHasBindableMembers == ThreeState.UNSURE && JSPsiImplUtils.isGetterOrSetter((JSFunctionItem)function2) && (attributeList = function2.getAttributeList()) != null && !attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && ActionScriptResolveUtil.isImplicitlyDeclaringEventDispatcher(attributeList)) {
            this.myHasBindableMembers = ThreeState.YES;
        }
    }

    private boolean isImplicitlyDeclared(JSClass clazz) {
        return ActionScriptClassBase.isImplicitlyDeclaringEventDispatcher(this) && "flash.events.IEventDispatcher".equals(clazz.getQualifiedName());
    }

    @Override
    @NotNull
    public Collection<JSClass> getImplicitlyDeclaredInterfaces() {
        SmartList classes = null;
        for (JSClass clazz : this.getImplementedInterfaces()) {
            if (!this.isImplicitlyDeclared(clazz)) continue;
            if (classes == null) {
                classes = new SmartList();
            }
            classes.add((JSClass)clazz);
        }
        SmartList smartList = classes != null ? classes : Collections.emptyList();
        if (smartList == null) {
            ActionScriptClassBase.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @Override
    public JSFunction getConstructor() {
        return this.findFunctionByName(this.getName());
    }

    @Override
    protected boolean needProcessClass(@Nullable ResolveProcessor resolveProcessor, @Nullable PsiElement place) {
        return super.needProcessClass(resolveProcessor, place) && !this.needResolveReferenceInOtherFile(resolveProcessor, place);
    }

    protected boolean needResolveReferenceInOtherFile(ResolveProcessor resolveProcessor, @Nullable PsiElement place) {
        return DialectDetector.isActionScript((PsiElement)this.getContainingFile()) && resolveProcessor != null && resolveProcessor.isTypeContext() && resolveProcessor.getName() != null && place instanceof JSReferenceExpression && place.getContainingFile().getOriginalFile() != this.getContainingFile().getOriginalFile();
    }

    @Override
    protected JSClass[] getSuperClassesForProcess(@NotNull PsiElement place) {
        if (place == null) {
            ActionScriptClassBase.$$$reportNull$$$0(4);
        }
        return (JSClass[])JSInheritanceUtil.withEnforcedScope(this::getSuperClasses, JSResolveUtil.getResolveScope(place));
    }

    @Override
    protected String getMethodName(@NotNull JSFunction function2) {
        if (function2 == null) {
            ActionScriptClassBase.$$$reportNull$$$0(5);
        }
        return ActionScriptResolveUtil.replaceInternalName(function2.getName());
    }

    @Override
    protected void clearCachesSync() {
        super.clearCachesSync();
        this.myHasBindableMembers = ThreeState.UNSURE;
    }

    @Override
    public String getName() {
        JSQualifiedStub classStub = (JSQualifiedStub)this.getGreenStub();
        if (classStub != null) {
            return classStub.getName();
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier != null) {
            String name = JSPsiImplUtils.getNameFromIdentifier(nameIdentifier.getNode());
            return ActionScriptResolveUtil.replaceInternalName(name);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubChildrenByType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyDeclaredInterfaces";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateStateForField";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateStateForFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassesForProcess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

