/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ReferenceListStub;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSReferenceListImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSElementWithSubstitutor;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReferenceListImpl
extends JSReferenceListImpl<ES6ReferenceListStub>
implements ES6ReferenceList {
    public static final Key<ParameterizedCachedValue<ClassExpressionResolve, JSReferenceListMember>> CACHE_KEY = Key.create((String)"ES6.Ref.list");
    public static final ClassExpressionResolve NO_CONSTRUCTOR = ES6ReferenceListImpl.create(ES6ReferenceList.Errors.NO_CONSTRUCTOR);
    public static final ClassExpressionResolve CIRCLE_ERROR = ES6ReferenceListImpl.create(ES6ReferenceList.Errors.CIRCLE);
    public static final ParameterizedCachedValueProvider<ClassExpressionResolve, JSReferenceListMember> CACHED_VALUE_PROVIDER = member -> {
        ClassExpressionResolve value = (ClassExpressionResolve)RecursionManager.doPreventingRecursion((Object)member, (boolean)false, () -> ES6ReferenceListImpl.resolveReferenceListMemberNoCache(member));
        return CachedValueProvider.Result.create((Object)(value == null ? CIRCLE_ERROR : value), (Object[])new Object[]{member, JSTypeUtils.getTypeInvalidationDependency()});
    };

    @NotNull
    private static ClassExpressionResolve create(@Nullable ES6ReferenceList.Errors constructorError) {
        return new ClassExpressionResolve(ContainerUtil.emptyList(), ContainerUtil.emptyList(), constructorError);
    }

    @NotNull
    private static ClassExpressionResolve resolveMemberType(@NotNull JSReferenceListMember member, @Nullable PsiElement expression, @Nullable JSType type, @NotNull Collection<JSClass> directClassesAndInterfaces) {
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(0);
        }
        if (directClassesAndInterfaces == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(1);
        }
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSNamedType && ES6ReferenceListImpl.isCycleDefs(type, expression)) {
            ClassExpressionResolve classExpressionResolve = CIRCLE_ERROR;
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(2);
            }
            return classExpressionResolve;
        }
        if (type != null) {
            return ES6ReferenceListImpl.resolveConstructorSignatures(type, (PsiElement)member, directClassesAndInterfaces, member.getTypeArgumentsAsTypes());
        }
        return new ClassExpressionResolve(directClassesAndInterfaces, member.getTypeArgumentsAsTypes(), null);
    }

    public static boolean isCycleDefs(@NotNull JSType type, @Nullable PsiElement expressionToResolve) {
        PsiElement parentClass;
        if (type == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(3);
        }
        if (expressionToResolve == null) {
            return false;
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        PsiElement refList = PsiTreeUtil.getParentOfType((PsiElement)expressionToResolve, JSReferenceList.class);
        return refList != null && ES6ReferenceListImpl.matchCycleDefs(elements, parentClass = refList.getParent(), new HashSet<PsiElement>());
    }

    public ES6ReferenceListImpl(ASTNode node) {
        super(node);
    }

    public ES6ReferenceListImpl(ES6ReferenceListStub stub) {
        super(stub);
    }

    @Override
    public JSClass @NotNull [] getReferencedClassesImpl() {
        JSClass[] jSClassArray = (JSClass[])((StreamEx)StreamEx.of((Object[])this.getMembers()).flatMap(el -> el.getClassesWithSubstitutors().stream()).filter(el -> !el.isStaticContext())).map(el -> (JSClass)el.myElement).toArray((Object[])JSClass.EMPTY_ARRAY);
        if (jSClassArray == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(4);
        }
        return jSClassArray;
    }

    @NotNull
    private static Collection<JSElementWithSubstitutor<JSClass>> getClassesForTypes(@NotNull ClassExpressionResolve classExpressionResolve) {
        JSType type;
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(5);
        }
        if ((type = classExpressionResolve.constructorType) == null || JSTypeUtils.hasForeignGenericParameter(type)) {
            List<JSElementWithSubstitutor<JSClass>> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(6);
            }
            return list2;
        }
        Collection<JSFunctionType> types2 = classExpressionResolve.constructorFunctions;
        LinkedHashSet<JSElementWithSubstitutor<JSClass>> result2 = new LinkedHashSet<JSElementWithSubstitutor<JSClass>>();
        List<JSType> typeArguments = classExpressionResolve.myDirectTypeArguments;
        for (JSFunctionType functionType : types2) {
            Collection<JSType> expanded = ES6ReferenceListImpl.getExpandedReturnTypes(functionType);
            for (JSType returnType : expanded) {
                ES6ReferenceListImpl.resolveAndAddElement(result2, typeArguments, returnType, false);
            }
        }
        ES6ReferenceListImpl.resolveAndAddElement(result2, typeArguments, classExpressionResolve.constructorType, true);
        LinkedHashSet<JSElementWithSubstitutor<JSClass>> linkedHashSet = result2;
        if (linkedHashSet == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    private static void resolveAndAddElement(@NotNull Set<JSElementWithSubstitutor<JSClass>> result2, @NotNull List<JSType> typeArguments, @NotNull JSType type, boolean staticContext) {
        if (result2 == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(8);
        }
        if (typeArguments == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(9);
        }
        if (type == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(10);
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        staticContext &= type instanceof JSNamedType && ((JSNamedType)type).getJSContext() == JSContext.INSTANCE;
        for (PsiElement psiElement : elements) {
            List<JSType> arguments;
            if (!(psiElement instanceof JSClass)) continue;
            JSTypeSubstitutor jsTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            List<JSType> list2 = arguments = typeArguments.isEmpty() && type instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)type).getArguments() : typeArguments;
            if (psiElement instanceof TypeScriptTypeParameterListOwner && !arguments.isEmpty()) {
                jsTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)psiElement, arguments);
            }
            result2.add((JSElementWithSubstitutor<JSClass>)new JSElementWithSubstitutor((JSElement)((JSClass)psiElement), jsTypeSubstitutor, staticContext));
        }
    }

    @Nullable
    private static Pair<JSType, Collection<JSClass>> getTypeWithSourceClass(@NotNull PsiElement element) {
        if (element == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(11);
        }
        JSType type = null;
        if (element instanceof JSExpression) {
            JSTypeEvaluationResult typeResult = JSTypeEvaluator.getElementType(element);
            if (typeResult != null) {
                JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
                typeResult.applyToProcessor(processor);
                type = processor.getType();
                HashSet<JSClass> possibleClasses = new HashSet<JSClass>();
                for (JSEvaluationResultElement result2 : typeResult.getResults()) {
                    PsiElement sourceElement;
                    JSType jsType;
                    if (result2.getSource() instanceof JSClass) {
                        possibleClasses.add((JSClass)result2.getSource());
                    }
                    if ((jsType = result2.getType()) == null || !((sourceElement = jsType.getSourceElement()) instanceof JSClass)) continue;
                    possibleClasses.add((JSClass)sourceElement);
                }
                return Pair.create((Object)type, possibleClasses);
            }
        } else {
            type = JSTypeUtils.getTypeOfElement(element);
        }
        return type == null ? null : Pair.create((Object)type, null);
    }

    @NotNull
    public static ClassExpressionResolve resolveReferenceListMember(@NotNull JSReferenceListMember member) {
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(12);
        }
        ClassExpressionResolve classExpressionResolve = (ClassExpressionResolve)CachedValuesManager.getManager((Project)member.getProject()).getParameterizedCachedValue((UserDataHolder)member, CACHE_KEY, CACHED_VALUE_PROVIDER, false, (Object)member);
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(13);
        }
        return classExpressionResolve;
    }

    @NotNull
    private static ClassExpressionResolve resolveReferenceListMemberNoCache(@NotNull JSReferenceListMember member) {
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(14);
        }
        JSImportHandler handler = ES6ReferenceListImpl.getImportHandler((PsiElement)member);
        String text = member.getReferenceText();
        if (text != null) {
            Collection<? extends PsiElement> resolved = handler.resolveObjectOrTypeName(text, (PsiElement)member);
            Collection<Object> classes = StreamEx.of(resolved).map(obj -> (JSClass)ObjectUtils.tryCast((Object)obj, JSClass.class)).nonNull().toList();
            if (classes.isEmpty() || classes.stream().anyMatch(el -> !el.isInterface())) {
                if (classes.isEmpty() && !DialectDetector.isTypeScript((PsiElement)member)) {
                    classes = ES6ReferenceListImpl.resolveDirectlyToClasses(text, (PsiElement)member);
                }
                if (classes.size() > 0) {
                    return new ClassExpressionResolve(classes, member.getTypeArgumentsAsTypes(), null);
                }
            }
            if (!resolved.isEmpty()) {
                List types2 = (List)((StreamEx)StreamEx.of(resolved).filter(el -> !(el instanceof JSClass))).map(JSTypeUtils::getTypeOfElement).map(JSTypeUtils::getValuableType).nonNull().collect(Collectors.toList());
                JSType type = JSCompositeTypeFactory.createIntersectionType(types2, JSTypeSourceFactory.createTypeSource((PsiElement)member, true));
                return ES6ReferenceListImpl.resolveMemberType(member, null, type, classes);
            }
            if (!DialectDetector.isTypeScript((PsiElement)member)) {
                return new ClassExpressionResolve(ContainerUtil.emptyList(), ContainerUtil.emptyList(), null);
            }
        }
        ClassExpressionResolve classExpressionResolve = ES6ReferenceListImpl.resolveExpression(member);
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(15);
        }
        return classExpressionResolve;
    }

    private static ClassExpressionResolve resolveExpression(@NotNull JSReferenceListMember member) {
        PsiFile containingFile;
        JSExpression expressionToResolve;
        Pair<JSType, Collection<JSClass>> typeWithSourceClasses;
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(16);
        }
        if ((typeWithSourceClasses = ES6ReferenceListImpl.getTypeWithSourceClass((PsiElement)(expressionToResolve = (JSExpression)AstLoadingFilter.forceAllowTreeLoading((PsiFile)(containingFile = member.getContainingFile()), () -> member.getExpression())))) == null) {
            return NO_CONSTRUCTOR;
        }
        return ES6ReferenceListImpl.resolveMemberType(member, (PsiElement)expressionToResolve, (JSType)typeWithSourceClasses.first, (Collection)typeWithSourceClasses.second);
    }

    @NotNull
    public static ClassExpressionResolve resolveConstructorSignatures(@Nullable JSType type, @NotNull PsiElement typeArgumentsOwner, @NotNull Collection<JSClass> directClassesAndInterfaces, @NotNull List<JSType> directTypeArguments) {
        List<JSFunctionType> notMixins;
        if (typeArgumentsOwner == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(17);
        }
        if (directClassesAndInterfaces == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(18);
        }
        if (directTypeArguments == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(19);
        }
        if (type == null) {
            ClassExpressionResolve classExpressionResolve = NO_CONSTRUCTOR;
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(20);
            }
            return classExpressionResolve;
        }
        Object forFunctionTypes = (type = type.substitute()) instanceof JSGenericTypeImpl ? type.asRecordType() : type;
        Collection allFunctionTypes = JSTypeUtils.getFunctionType(forFunctionTypes, true, typeArgumentsOwner).collect(Collectors.toList());
        if (allFunctionTypes.isEmpty()) {
            return new ClassExpressionResolve(type, ContainerUtil.emptyList(), directClassesAndInterfaces, directTypeArguments, ES6ReferenceList.Errors.NO_CONSTRUCTOR);
        }
        List<JSType> argumentsForExpression = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(typeArgumentsOwner), null);
        boolean isInstanceOf = typeArgumentsOwner instanceof JSBinaryExpression && ((JSBinaryExpression)typeArgumentsOwner).getOperationSign() == JSTokenTypes.INSTANCEOF_KEYWORD;
        ArrayList<JSFunctionType> functionTypes = new ArrayList<JSFunctionType>();
        int argSize = argumentsForExpression.size();
        for (JSType constructorType : allFunctionTypes) {
            JSFunctionType functionType = constructorType instanceof JSFunctionType ? (JSFunctionType)constructorType : null;
            if (functionType == null) continue;
            JSType returnType = ES6ReferenceListImpl.getExpandedReturnType(functionType);
            if (DialectDetector.isTypeScript(typeArgumentsOwner) && (returnType == null || argSize != ES6ReferenceListImpl.getParameterListSize(constructorType) && !isInstanceOf)) continue;
            functionTypes.add(functionType);
        }
        if (functionTypes.isEmpty()) {
            return new ClassExpressionResolve(type, ContainerUtil.emptyList(), directClassesAndInterfaces, directTypeArguments, ES6ReferenceList.Errors.NO_COUNT_TYPE_ARGUMENTS);
        }
        if (functionTypes.size() > 1 && (notMixins = ES6ReferenceListImpl.excludeMixins(functionTypes)).size() > 1) {
            JSType item = ES6ReferenceListImpl.getExpandedReturnType(notMixins.get(0));
            boolean isFirst = true;
            ProcessingContext context = JSTypeComparingContextService.createProcessingContextWithCache(typeArgumentsOwner);
            for (JSFunctionType jsType : notMixins) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                if (TypeScriptTypeRelations.areTypesComparable(item, ES6ReferenceListImpl.getExpandedReturnType(jsType), context)) continue;
                return new ClassExpressionResolve(type, functionTypes, directClassesAndInterfaces, directTypeArguments, ES6ReferenceList.Errors.MANY_CONSTRUCTORS_WITH_DIFF_TYPES);
            }
        }
        return new ClassExpressionResolve(type, functionTypes, directClassesAndInterfaces, directTypeArguments, ES6ReferenceList.Errors.NO_ERROR);
    }

    @Nullable
    private static JSType getExpandedReturnType(@NotNull JSFunctionType type) {
        if (type == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(21);
        }
        JSType returnType = type.getReturnType();
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(returnType);
    }

    @NotNull
    public static Collection<JSType> getExpandedReturnTypes(@NotNull JSFunctionType type) {
        JSType returnType;
        if (type == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(22);
        }
        if ((returnType = ES6ReferenceListImpl.getExpandedReturnType(type)) instanceof JSIntersectionType) {
            List<JSType> list2 = ((JSIntersectionType)returnType).getTypes();
            if (list2 == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(23);
            }
            return list2;
        }
        List list3 = ContainerUtil.createMaybeSingletonList((Object)returnType);
        if (list3 == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(24);
        }
        return list3;
    }

    @NotNull
    private static List<JSFunctionType> excludeMixins(@NotNull Collection<JSFunctionType> functionTypes) {
        if (functionTypes == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(25);
        }
        List list2 = ((StreamEx)StreamEx.of(functionTypes).filter(current -> !ES6ReferenceListImpl.isMixinConstructor(current))).toList();
        if (list2 == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(26);
        }
        return list2;
    }

    public static boolean isMixinConstructor(@NotNull JSFunctionType functionType) {
        List parameters;
        if (functionType == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(27);
        }
        if ((parameters = functionType.getParameters()).size() != 1) {
            return false;
        }
        JSParameterTypeDecorator decorator = (JSParameterTypeDecorator)parameters.get(0);
        if (!decorator.isRest()) {
            return false;
        }
        JSType decoratorType = decorator.getSimpleType();
        return decoratorType == null || decoratorType instanceof JSAnyType;
    }

    private static int getParameterListSize(@NotNull JSType constructorType) {
        PsiElement sourceElement;
        if (constructorType == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(28);
        }
        if (!((sourceElement = constructorType.getSource().getSourceElement()) instanceof TypeScriptTypeParameterListOwner)) {
            return 0;
        }
        TypeScriptTypeParameterListOwner owner = (TypeScriptTypeParameterListOwner)sourceElement;
        TypeScriptTypeParameterList list2 = owner.getTypeParameterList();
        if (list2 == null) {
            return 0;
        }
        return list2.getTypeParameters().length;
    }

    private static boolean matchCycleDefs(@NotNull Collection<? extends PsiElement> elements, @Nullable PsiElement toFind, @NotNull Collection<PsiElement> visited) {
        if (elements == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(29);
        }
        if (visited == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(30);
        }
        if (elements.isEmpty() || toFind == null) {
            return false;
        }
        for (PsiElement psiElement : elements) {
            Object[] classes;
            JSClass jsClass;
            if (!visited.add(psiElement)) {
                return true;
            }
            if (psiElement.isEquivalentTo(toFind)) {
                return true;
            }
            if (!(psiElement instanceof JSClass) || (jsClass = (JSClass)psiElement).isInterface() || (classes = jsClass.getSuperClasses()).length <= 0 || !ES6ReferenceListImpl.matchCycleDefs(ContainerUtil.newArrayList((Object[])classes), toFind, visited)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<JSElementWithSubstitutor<JSClass>> resolveMemberClasses(@NotNull JSReferenceListMember member) {
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(31);
        }
        ClassExpressionResolve resolve = ES6ReferenceListImpl.resolveReferenceListMember(member);
        Collection<JSElementWithSubstitutor<JSClass>> collection = resolve.getDirectOrTypeClasses();
        if (collection == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @NotNull
    public Collection<JSFunction> getIndirectSuperConstructors() {
        Object[] members = this.getMembers();
        JSReferenceListMember member = (JSReferenceListMember)ArrayUtil.getFirstElement((Object[])members);
        if (member != null) {
            ClassExpressionResolve resolve = ES6ReferenceListImpl.resolveReferenceListMember(member);
            if (resolve.directClassesAndInterfaces.stream().anyMatch(el -> !el.isInterface())) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    ES6ReferenceListImpl.$$$reportNull$$$0(33);
                }
                return list2;
            }
            if (!resolve.hasError() && resolve.constructorFunctions.size() > 0) {
                SmartList result2 = new SmartList();
                for (JSFunctionType functionType : resolve.constructorFunctions) {
                    PsiElement sourceElement = functionType.getSource().getSourceElement();
                    if (!(sourceElement instanceof JSFunction)) continue;
                    result2.add((JSFunction)sourceElement);
                }
                SmartList smartList = result2;
                if (smartList == null) {
                    ES6ReferenceListImpl.$$$reportNull$$$0(34);
                }
                return smartList;
            }
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(35);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directClassesAndInterfaces";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl";
                break;
            }
            case 3: 
            case 10: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classExpressionResolve";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsOwner";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directTypeArguments";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionTypes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedClassesImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesForTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceListMember";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceListMemberNoCache";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorSignatures";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedReturnTypes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeMixins";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberClasses";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndirectSuperConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberType";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCycleDefs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClassesForTypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndAddElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithSourceClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceListMember";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceListMemberNoCache";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorSignatures";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedReturnType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedReturnTypes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "excludeMixins";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isMixinConstructor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParameterListSize";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "matchCycleDefs";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClassExpressionResolve {
        @Nullable
        public final JSType constructorType;
        @NotNull
        public final Collection<JSFunctionType> constructorFunctions;
        @NotNull
        public final Collection<JSClass> directClassesAndInterfaces;
        @NotNull
        private final List<JSType> myDirectTypeArguments;
        @Nullable
        public final ES6ReferenceList.Errors constructorError;
        private final AtomicNotNullLazyValue<Collection<JSElementWithSubstitutor<JSClass>>> classesFromConstructors;

        public ClassExpressionResolve(@NotNull Collection<JSClass> directClassesAndInterfaces, @NotNull List<JSType> directTypeArguments, @Nullable ES6ReferenceList.Errors constructorError) {
            if (directClassesAndInterfaces == null) {
                ClassExpressionResolve.$$$reportNull$$$0(0);
            }
            if (directTypeArguments == null) {
                ClassExpressionResolve.$$$reportNull$$$0(1);
            }
            this(null, ContainerUtil.emptyList(), directClassesAndInterfaces, directTypeArguments, constructorError);
        }

        public ClassExpressionResolve(@Nullable JSType constructorType, @NotNull Collection<JSFunctionType> constructorFunctions, @NotNull Collection<JSClass> directClassesAndInterfaces, @NotNull List<JSType> directTypeArguments, @Nullable ES6ReferenceList.Errors constructorError) {
            if (constructorFunctions == null) {
                ClassExpressionResolve.$$$reportNull$$$0(2);
            }
            if (directClassesAndInterfaces == null) {
                ClassExpressionResolve.$$$reportNull$$$0(3);
            }
            if (directTypeArguments == null) {
                ClassExpressionResolve.$$$reportNull$$$0(4);
            }
            this.classesFromConstructors = AtomicNotNullLazyValue.createValue(() -> ES6ReferenceListImpl.getClassesForTypes(this));
            this.constructorType = constructorType;
            this.constructorFunctions = constructorFunctions;
            this.directClassesAndInterfaces = directClassesAndInterfaces;
            this.myDirectTypeArguments = directTypeArguments;
            this.constructorError = constructorError;
        }

        public boolean hasError() {
            return this.constructorError != null && this.constructorError != ES6ReferenceList.Errors.NO_ERROR;
        }

        @NotNull
        public Collection<JSElementWithSubstitutor<JSClass>> getDirectOrTypeClasses() {
            if (this.constructorError == ES6ReferenceList.Errors.CIRCLE) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    ClassExpressionResolve.$$$reportNull$$$0(5);
                }
                return list2;
            }
            LinkedHashSet<JSElementWithSubstitutor<JSClass>> objects = new LinkedHashSet<JSElementWithSubstitutor<JSClass>>();
            objects.addAll(ES6ReferenceListImpl.toListWithSubstitutor(this.directClassesAndInterfaces, this.myDirectTypeArguments));
            objects.addAll((Collection)this.classesFromConstructors.getValue());
            LinkedHashSet<JSElementWithSubstitutor<JSClass>> linkedHashSet = objects;
            if (linkedHashSet == null) {
                ClassExpressionResolve.$$$reportNull$$$0(6);
            }
            return linkedHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directClassesAndInterfaces";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directTypeArguments";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructorFunctions";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl$ClassExpressionResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl$ClassExpressionResolve";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectOrTypeClasses";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

