/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSGoToDeclaration;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.performanceTesting.JSResolveReferencesCommandBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JSResolveReferencesUsingFlowCommand
extends JSResolveReferencesCommandBase {
    public static final String PREFIX = "%jsResolveReferencesUsingFlow";
    private static final String FLOW_EXECUTABLE_ENV = "FLOW_JS_EXECUTABLE";

    public JSResolveReferencesUsingFlowCommand(@NotNull Project project, @NotNull String text, int line) {
        if (project == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(0);
        }
        if (text == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(1);
        }
        super(project, text, line);
    }

    @Override
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        String pathToFlow;
        if (context == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(2);
        }
        if ((pathToFlow = System.getenv(FLOW_EXECUTABLE_ENV)) == null) {
            return Promises.rejectedPromise((String)"$FLOW_JS_EXECUTABLE is not specified");
        }
        String error = (String)WriteAction.computeAndWait(() -> {
            VirtualFile root = ProjectUtil.guessProjectDir((Project)this.myProject);
            if (root == null) {
                return "Can't find project root";
            }
            VirtualFile flowConfig = root.findChild(".flowconfig");
            if (flowConfig == null) {
                try {
                    root.createChildData((Object)this.myProject, ".flowconfig");
                }
                catch (IOException e) {
                    return e.toString();
                }
            }
            JSRootConfiguration.getInstance(this.myProject).storeLanguageLevelAndUpdateCaches(JSLanguageLevel.FLOW);
            FlowJSSettings settings = new FlowJSSettings();
            settings.setFlowPath(pathToFlow);
            FlowJSSettingsManager.getInstance(this.myProject).loadState(settings);
            return null;
        });
        if (error != null) {
            return Promises.rejectedPromise((String)error);
        }
        AsyncPromise result2 = new AsyncPromise();
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> result2.setResult(null)));
        return result2.thenAsync(it -> super._execute(context));
    }

    @Override
    protected ResolveResult @NotNull [] getResolveResults(@NotNull JSReferenceExpression node) {
        Document document2;
        if (node == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(3);
        }
        if ((document2 = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(node.getContainingFile())) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (DialectDetector.isJavaScript((PsiElement)node) && !DialectDetector.isFlow((PsiElement)node)) {
            Logger.getInstance(JSResolveReferencesUsingFlowCommand.class).error("Failed to switch language version to Flow for file " + node.getContainingFile().getName());
        }
        JSResolveReferencesUsingFlowCommand.waitForService(node.getContainingFile());
        PsiElement element = FlowJSGoToDeclaration.getGotoDeclarationTarget(node.getReferenceNameElement(), document2);
        if (element == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        JSResolveResult result2 = new JSResolveResult(element);
        ResolveResult[] resolveResultArray = new ResolveResult[]{result2};
        if (resolveResultArray == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    private static void waitForService(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(7);
        }
        FlowJSServerService service = FlowJSServerManager.getService(file2, false);
        while (service != null && service.checkCanUseService() && !service.isServiceStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesUsingFlowCommand";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesUsingFlowCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResults";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "waitForService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

