/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.performanceTesting.VirtualFilesVisitorCommand;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSCompareParsersCommand
extends VirtualFilesVisitorCommand {
    private static final JSLanguageDialect BASE_LANGUAGE = JavaScriptSupportLoader.ECMA_SCRIPT_6;
    private static final JSLanguageDialect TARGET_LANGUAGE = JavaScriptSupportLoader.FLOW_JS;

    public JSCompareParsersCommand(@NotNull Project project, @NotNull String text, int line) {
        if (project == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(0);
        }
        if (text == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(1);
        }
        super(project, text, line);
    }

    @Override
    protected boolean isAcceptable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(2);
        }
        if (!JavaScriptIndex.isAcceptableFile(file2)) {
            return false;
        }
        FileType type = file2.getFileType();
        return type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage() instanceof JSLanguageDialect && ((JSLanguageDialect)((LanguageFileType)type).getLanguage()).getOptionHolder().isJavaScript();
    }

    @Override
    @NotNull
    protected Runnable createTask(@NotNull List<VirtualFile> files, @NotNull VirtualFile root, @NotNull PlaybackContext context) {
        if (files == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(3);
        }
        if (root == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(5);
        }
        Runnable runnable = () -> {
            for (VirtualFile file2 : files) {
                try {
                    this.compareParsersOnFile(file2, root, context);
                }
                catch (Exception e) {
                    Logger.getInstance(JSCompareParsersCommand.class).error("Failed to compare " + file2.getPath(), (Throwable)e);
                }
            }
        };
        if (runnable == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    private void compareParsersOnFile(@NotNull VirtualFile file2, @NotNull VirtualFile root, @NotNull PlaybackContext context) throws Exception {
        String path;
        if (file2 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(7);
        }
        if (root == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(9);
        }
        if ((path = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)root, (char)'/')) == null) {
            return;
        }
        String code = VfsUtilCore.loadText((VirtualFile)file2);
        PsiFile psiFile = this.parseWithLanguage(TARGET_LANGUAGE, code);
        if (psiFile == null) {
            context.error("Failed to parse " + file2.getPath(), -1);
            return;
        }
        PsiFile psiFileBase = this.parseWithLanguage(BASE_LANGUAGE, code);
        if (psiFileBase == null) {
            context.error("Failed to parse " + file2.getPath(), -1);
            return;
        }
        Integer psiFileBaseErrors = (Integer)ReadAction.compute(() -> PsiTreeUtil.collectElementsOfType((PsiElement)psiFileBase, (Class[])new Class[]{PsiErrorElement.class}).size());
        if (psiFileBaseErrors == 0 && !((Boolean)ReadAction.compute(() -> JSCompareParsersCommand.parsedEquivalently(psiFile, psiFileBase))).booleanValue()) {
            String tree = (String)ReadAction.compute(() -> DebugUtil.psiToString((PsiElement)psiFile, (boolean)true));
            String treeBase = (String)ReadAction.compute(() -> DebugUtil.psiToString((PsiElement)psiFileBase, (boolean)true));
            context.error("Diff " + file2.getPath(), -1);
        }
    }

    private static boolean parsedEquivalently(@NotNull PsiFile file1, @NotNull PsiFile file2) {
        if (file1 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(11);
        }
        Iterator iterator1 = SyntaxTraverser.psiTraverser((PsiElement)file1).iterator();
        Iterator iterator2 = SyntaxTraverser.psiTraverser((PsiElement)file2).iterator();
        iterator1.next();
        iterator2.next();
        while (iterator1.hasNext()) {
            IElementType type2;
            if (!iterator2.hasNext()) {
                return false;
            }
            PsiElement element1 = (PsiElement)iterator1.next();
            PsiElement element2 = (PsiElement)iterator2.next();
            IElementType type1 = element1.getNode().getElementType();
            if (type1 == (type2 = element2.getNode().getElementType()) || JSKeywordSets.IDENTIFIER_NAMES.contains(type1) && JSKeywordSets.IDENTIFIER_NAMES.contains(type2)) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private PsiFile parseWithLanguage(@NotNull JSLanguageDialect language, @NotNull String code) {
        LightVirtualFile file2;
        if (language == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(12);
        }
        if (code == null) {
            JSCompareParsersCommand.$$$reportNull$$$0(13);
        }
        if (!SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)(file2 = new LightVirtualFile("js.js", (Language)language, (CharSequence)code)))) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file2);
        }
        SingleRootFileViewProvider provider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)this.myProject), (VirtualFile)file2, false);
        return provider.getPsi((Language)language);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/performanceTesting/JSCompareParsersCommand";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSCompareParsersCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareParsersOnFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parsedEquivalently";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseWithLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

