/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.performanceTesting.JSCompareParsersCommand;
import com.intellij.lang.javascript.performanceTesting.VirtualFilesVisitorCommand;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSCheckParseErrorsCommand
extends VirtualFilesVisitorCommand {
    public JSCheckParseErrorsCommand(@NotNull Project project, @NotNull String text, int line) {
        if (project == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(0);
        }
        if (text == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(1);
        }
        super(project, text, line);
    }

    @Override
    protected boolean isAcceptable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(2);
        }
        return JavaScriptIndex.isAcceptableFile(file2) && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file2.getFileType());
    }

    @Override
    @NotNull
    protected Runnable createTask(@NotNull List<VirtualFile> files, @NotNull VirtualFile root, @NotNull PlaybackContext context) {
        if (files == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(3);
        }
        if (root == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(5);
        }
        Runnable runnable = () -> {
            for (VirtualFile file2 : files) {
                try {
                    this.reportParseErrorCount(file2, root, context);
                }
                catch (Exception e) {
                    Logger.getInstance(JSCompareParsersCommand.class).error("Failed to process " + file2.getPath(), (Throwable)e);
                }
            }
        };
        if (runnable == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    private void reportParseErrorCount(@NotNull VirtualFile file2, @NotNull VirtualFile root, @NotNull PlaybackContext context) throws Exception {
        PsiFileFactory fileFactory;
        PsiFile psiFile;
        Integer errors;
        String path;
        if (file2 == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(7);
        }
        if (root == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(9);
        }
        if ((path = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)root, (char)'/')) == null) {
            return;
        }
        String code = VfsUtilCore.loadText((VirtualFile)file2);
        JSLanguageDialect dialect = (JSLanguageDialect)ReadAction.compute(() -> DialectDetector.getLanguageDialect(file2, this.myProject));
        if (dialect == null) {
            dialect = JSLanguageLevel.DEFAULT.getDialect();
        }
        if ((errors = (Integer)ReadAction.compute(() -> JSCheckParseErrorsCommand.lambda$reportParseErrorCount$2(psiFile = (fileFactory = PsiFileFactory.getInstance((Project)this.myProject)).createFileFromText("js.js", (Language)dialect, (CharSequence)code, false, false)))) != null && errors > 0) {
            String message = String.format("js-parse-errors: %s -> %d", path, (int)errors);
            context.message(message, -1);
        }
    }

    private static /* synthetic */ Integer lambda$reportParseErrorCount$2(PsiFile psiFile) throws RuntimeException {
        return PsiTreeUtil.collectElementsOfType((PsiElement)psiFile, (Class[])new Class[]{PsiErrorElement.class}).size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/performanceTesting/JSCheckParseErrorsCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSCheckParseErrorsCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportParseErrorCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

