/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSArrowFunctionDetector;
import com.intellij.lang.javascript.parsing.JSParseResult;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FunctionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    public static final Key<String> methodsEmptinessKey = Key.create((String)"methodsEmptinessKey");
    public static final String METHODS_EMPTINESS_ALWAYS = "a";
    public static final String METHODS_EMPTINESS_POSSIBLY = "p";
    public static final Key<Boolean> HAD_GET_SET = Key.create((String)"js.getsetParser");

    protected FunctionParser(T parser2) {
        super(parser2);
    }

    public boolean parseFunctionExpression() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD;
    }

    public void parseFunctionDeclaration() {
        String prevMethodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        try {
            PsiBuilder.Marker mark = this.builder.mark();
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
        this.parseAttributesList();
    }

    public boolean parseFunctionNoMarker(Context context, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            FunctionParser.$$$reportNull$$$0(0);
        }
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD && context != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSTokenTypes.MULT && this.isJSorTS()) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        boolean wasGenerator = this.isGeneratorContext();
        this.setIsGenerator(isGeneratorContext);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context)) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]));
            parsedWithoutErrors = false;
        }
        parsedWithoutErrors &= !this.parseParameterList((boolean)(context == Context.EXPRESSION || context == Context.PROPERTY ? true : false)).hasErrors;
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        String methodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        if (methodEmptiness == null) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
        } else if (METHODS_EMPTINESS_ALWAYS.equals(methodEmptiness)) {
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                String key = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? "javascript.ambient.declaration.should.have.no.body" : "interface.function.declaration.should.have.no.body";
                parsedWithoutErrors = false;
                this.builder.error(JavaScriptBundle.message((String)key, (Object[])new Object[0]));
            }
        } else if (METHODS_EMPTINESS_POSSIBLY.equals(methodEmptiness)) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            } else if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            }
        }
        functionMarker.done(context == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.setIsGenerator(wasGenerator);
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, Context context) {
        DialectOptionHolder dialect = (DialectOptionHolder)this.builder.getUserData(JS_DIALECT_KEY);
        if ((dialect == null || dialect.hasFeature(JSLanguageFeature.E4X)) && this.parseGetSetAndNameAfterFunctionKeyword(context)) {
            return true;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(this.isIdentifierToken(tokenType) || functionKeywordWasOmitted && JSKeywordSets.PROPERTY_NAMES.contains(tokenType))) {
            return context == Context.EXPRESSION;
        }
        this.parseFunctionIdentifier();
        return true;
    }

    protected boolean parseGetSetAndNameAfterFunctionKeyword(Context context) {
        IElementType firstToken = this.builder.getTokenType();
        if (JSTokenTypes.GET_SET.contains(firstToken) && context != Context.EXPRESSION) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (JSKeywordSets.PROPERTY_NAMES.contains(lookAhead)) {
                this.builder.advanceLexer();
            } else if (context == Context.PROPERTY && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(lookAhead)) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parsePropertyName();
                return true;
            }
        }
        return false;
    }

    public void parseFunctionIdentifier() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSKeywordSets.PROPERTY_NAMES.contains(tokenType)) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).advancePropertyName(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    public IElementType getFunctionDeclarationElementType() {
        return JSStubElementTypes.FUNCTION_DECLARATION;
    }

    public boolean parseAttributesList() {
        PsiBuilder.Marker mark = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.EXPORT_KEYWORD || type == JSTokenTypes.GET_KEYWORD || type == JSTokenTypes.SET_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark.done(this.getAttributeListElementType());
        return true;
    }

    public IElementType getAttributeListElementType() {
        return JSStubElementTypes.ATTRIBUTE_LIST;
    }

    public void parseES7Decorators() {
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.AT);
        while (this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker attribute = this.builder.mark();
            this.builder.advanceLexer();
            Object expressionParser = this.myJavaScriptParser.getExpressionParser();
            ((ExpressionParser)expressionParser).parseLeftHandSideExpression(false, false);
            attribute.done(JSStubElementTypes.ES6_DECORATOR);
        }
    }

    public boolean tryParseES7Decorators() {
        boolean hadAnnotation;
        boolean bl = hadAnnotation = this.builder.getTokenType() == JSTokenTypes.AT;
        if (hadAnnotation && this.hasSupportDecorators()) {
            this.parseES7Decorators();
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    public JSParseResult parseParameterList(boolean funExpr) {
        if (!((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeParameterList()) {
            return JSParseResult.UNACCEPTABLE;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]));
            if (!funExpr) {
                PsiBuilder.Marker parameterList = this.builder.mark();
                parameterList.done(this.getParameterListElementType());
            }
            return JSParseResult.UNACCEPTABLE;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasErrors = false;
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && this.allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                hasErrors = true;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.DOT || this.builder.getTokenType() == JSTokenTypes.DOT_DOT) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.parameter.name", (Object[])new Object[0]));
                while (this.builder.getTokenType() == JSTokenTypes.DOT || this.builder.getTokenType() == JSTokenTypes.DOT_DOT) {
                    this.builder.advanceLexer();
                }
                hasErrors = true;
            }
            hasErrors |= !this.parseSingleParameter(parameter);
        }
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(this.getParameterListElementType());
        return JSParseResult.acceptable(hasErrors, null);
    }

    public boolean parseSingleParameter(PsiBuilder.Marker parameter) {
        JSParseResult result2 = this.doParseSingleParameter();
        IElementType elementType = result2.elementType;
        if (elementType != null) {
            parameter.done(elementType);
        } else {
            parameter.drop();
        }
        return !result2.hasErrors;
    }

    @NotNull
    protected JSParseResult doParseSingleParameter() {
        boolean acceptResult;
        IElementType tokenType;
        boolean hasErrors = false;
        IElementType elementType = this.getParameterType();
        boolean allowPropertyNameAsIdentifier = this.parseParameterAttributeList();
        if (this.isParameterName(allowPropertyNameAsIdentifier, tokenType = this.builder.getTokenType())) {
            this.builder.advanceLexer();
            this.parseParameterOptionalMark();
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true)) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
            }
            acceptResult = true;
        } else if (this.willParseDestructuringAssignment()) {
            elementType = ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElementNoMarker(this.getParameterType(), true, true);
            acceptResult = true;
        } else {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.formal.parameter.name", (Object[])new Object[0]));
            hasErrors = true;
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true);
            } else {
                ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            }
            acceptResult = false;
        }
        JSParseResult jSParseResult = acceptResult && elementType != null ? JSParseResult.acceptable(hasErrors, elementType) : JSParseResult.UNACCEPTABLE;
        if (jSParseResult == null) {
            FunctionParser.$$$reportNull$$$0(1);
        }
        return jSParseResult;
    }

    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType);
    }

    protected boolean allowLastCommaInParameterAndArgumentList() {
        return false;
    }

    public IElementType getParameterType() {
        return JSStubElementTypes.FORMAL_PARAMETER;
    }

    public void parseParameterOptionalMark() {
    }

    public boolean willParseDestructuringAssignment() {
        return !this.isECMAL4() && FunctionParser.willParseDestructuringAssignment(this.builder.getTokenType());
    }

    public static boolean willParseDestructuringAssignment(IElementType tokenType) {
        return tokenType == JSTokenTypes.LBRACKET || tokenType == JSTokenTypes.LBRACE;
    }

    protected boolean parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.tryParseES7Decorators();
            mark.done(this.getAttributeListElementType());
        }
        return false;
    }

    public boolean parseArrowFunction() {
        return this.parseArrowFunctionWithoutModifiers(this.builder.mark());
    }

    protected boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        IElementType firstToken;
        if (arrowFunction == null) {
            FunctionParser.$$$reportNull$$$0(2);
        }
        if (this.isIdentifierToken(firstToken = this.builder.getTokenType()) && JSTokenTypes.ARROWS.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker parameterList = this.builder.mark();
            PsiBuilder.Marker parameter = this.builder.mark();
            this.builder.advanceLexer();
            parameter.done(this.getParameterType());
            parameterList.done(this.getParameterListElementType());
            parameterList.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            if (!JSArrowFunctionDetector.INSTANCE.isArrowFunctionExpression(this.builder, this)) {
                arrowFunction.rollbackTo();
                return false;
            }
            this.parseParameterList(true);
            IElementType afterParameterListToken = this.builder.getTokenType();
            if (afterParameterListToken == JSTokenTypes.COLON && !((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType()) {
                arrowFunction.rollbackTo();
                return false;
            }
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSTokenTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseBlockOrFunctionBody(StatementParser.BlockType.ARROW_FUNCTION_BODY);
        } else {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.eqgt", (Object[])new Object[0]));
        }
        arrowFunction.done(this.getFunctionExpressionElementType());
        arrowFunction.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    protected boolean isValidFirstParameterStart(IElementType next) {
        if (next == JSTokenTypes.RPAR || next == JSTokenTypes.DOT_DOT_DOT || !this.isECMAL4() && FunctionParser.willParseDestructuringAssignment(next)) {
            return true;
        }
        boolean isParameterName = this.isParameterName(true, next);
        if (!isParameterName) {
            return false;
        }
        int lookaheadSteps = 2;
        if (next == JSTokenTypes.CLASS_KEYWORD || next == JSTokenTypes.FUNCTION_KEYWORD || next == JSTokenTypes.ASYNC_KEYWORD && (next = this.builder.lookAhead(lookaheadSteps++)) == JSTokenTypes.FUNCTION_KEYWORD) {
            IElementType lookAhead = this.builder.lookAhead(lookaheadSteps);
            if (this.isIdentifierToken(lookAhead)) {
                return false;
            }
            if (next == JSTokenTypes.FUNCTION_KEYWORD) {
                return lookAhead != JSTokenTypes.LPAR && lookAhead != JSTokenTypes.MULT;
            }
            return lookAhead != JSTokenTypes.LBRACE;
        }
        return true;
    }

    protected boolean supportsColonTypeCast() {
        return false;
    }

    public IElementType getParameterListElementType() {
        return JSStubElementTypes.PARAMETER_LIST;
    }

    protected IElementType getFunctionExpressionElementType() {
        return JSStubElementTypes.FUNCTION_EXPRESSION;
    }

    public boolean isAsyncContext() {
        return JSParsingContextUtil.isAsyncContext(this.builder);
    }

    public void setIsGenerator(boolean isGenerator) {
        JSParsingContextUtil.setIsGenerator(isGenerator, this.builder);
    }

    public boolean isGeneratorContext() {
        return JSParsingContextUtil.isGeneratorContext(this.builder, this.myJavaScriptParser.getDialect());
    }

    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        boolean lexerAdvanced = !((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterList((boolean)false).hasErrors;
        lexerAdvanced |= ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/FunctionParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/FunctionParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doParseSingleParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionNoMarker";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseArrowFunctionWithoutModifiers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Context {
        EXPRESSION,
        SOURCE_ELEMENT,
        PROPERTY;

    }
}

