/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.node;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.validation.fixes.JSRequireFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportNodeJsModuleFix
extends ImportCommonJSModuleFix
implements JSRequireFix {
    private final @NotNull NotNullLazyValue<@IntentionName String> myText;

    public ImportNodeJsModuleFix(@NotNull PsiElement node, @NotNull JSImportCandidate descriptor2, @Nullable JSPlaceTail tail) {
        if (node == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(1);
        }
        super(node, descriptor2, tail);
        this.myText = NotNullLazyValue.createValue(() -> {
            PsiElement element = this.getStartElement();
            if (element == null || !element.isValid()) {
                return "";
            }
            String wholeImportWrapQuote = ES6ImportPsiUtil.invertQuote(this.getQuote());
            String statement = wholeImportWrapQuote + this.getStatementRequireCallText() + wholeImportWrapQuote;
            return IdeBundle.message((String)"quickfix.text.insert.0", (Object[])new Object[]{statement});
        });
    }

    @Override
    protected void executeImpl(@NotNull PsiElement element, @Nullable Editor editor, @NotNull PsiElement scope) {
        PsiElement created;
        if (element == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(3);
        }
        if ((created = this.createRequire(scope)) == null) {
            return;
        }
        ImportNodeJsModuleFix.insertCreatedElement(scope, editor, created);
        this.replaceReferences(element, editor);
    }

    private static void insertCreatedElement(@NotNull PsiElement scope, @Nullable Editor editor, @NotNull PsiElement created) {
        if (scope == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(4);
        }
        if (created == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(5);
        }
        ES6ImportPsiUtil.findPlaceAndInsertRequire(scope, created, editor);
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = (String)this.myText.getValue();
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"node.js.modules.dependencies.missing.family.name", (Object[])new Object[0]);
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private PsiElement createRequire(@NotNull PsiElement context) {
        if (context == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(8);
        }
        String text = this.getStatementRequireCallText();
        PsiFile file2 = ImportNodeJsModuleFix.createDummyFile(context.getProject(), text);
        return file2.getFirstChild();
    }

    @NotNull
    private String getStatementRequireCallText() {
        PsiElement element = this.getStartElement();
        return ImportNodeJsModuleFix.getRequireCallText(element, this.myCandidate);
    }

    @NotNull
    public static String getRequireCallText(@Nullable PsiElement place, @NotNull JSImportCandidate candidate) {
        String semicolon;
        JSImportDescriptor descriptor2;
        if (candidate == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(9);
        }
        if ((descriptor2 = candidate.getSingleDescriptorOrNull()) == null) {
            return "";
        }
        String varName = descriptor2.getImportedName();
        boolean isConst = DialectDetector.hasFeature(place, JSLanguageFeature.CONST_DEFINITIONS);
        JSImportExportType importType = descriptor2.getImportType();
        boolean isFileImport = !importType.isSpecifier();
        boolean isDestructuring = isConst && !isFileImport;
        String prefix = isConst ? "const " : "var ";
        String quote = place == null ? "\"" : JSCodeStyleSettings.getQuote(place);
        String call = "require(" + quote + descriptor2.getModuleName() + quote + ")";
        String string = semicolon = place == null ? "" : JSCodeStyleSettings.getSemicolon(place);
        if (isDestructuring) {
            String spaces = JSCodeStyleSettings.getSettings((PsiElement)place).SPACES_WITHIN_OBJECT_LITERAL_BRACES ? " " : "";
            String string2 = prefix + "{" + spaces + varName + spaces + "} = " + call + semicolon;
            if (string2 == null) {
                ImportNodeJsModuleFix.$$$reportNull$$$0(10);
            }
            return string2;
        }
        String postfix = isFileImport ? "" : "." + descriptor2.getExportedName();
        String string3 = prefix + varName + " = " + call + postfix + semicolon;
        if (string3 == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(11);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/node/ImportNodeJsModuleFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/node/ImportNodeJsModuleFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequireCallText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertCreatedElement";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRequire";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRequireCallText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

