/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.lang.ecmascript6.actions.ES6AddImportExecutor;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSModuleReferenceExpressionInfo;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.imports.ES6ImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSResolveBasedCandidatesProvider
extends JSImportCandidatesBase {
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;

    public JSResolveBasedCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo, @NotNull ModuleReferenceInfo info) {
        if (placeInfo == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(0);
        }
        if (info == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(1);
        }
        super(placeInfo);
        this.myModuleReferenceInfo = info;
    }

    @Override
    public boolean processCandidates(@NotNull String ref, @NotNull JSCandidatesProcessor processor, boolean forCompletion) {
        Collection<JSImportCandidate> candidates;
        if (ref == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(3);
        }
        if (forCompletion || !ref.equals(this.myModuleReferenceInfo.getContextName())) {
            return true;
        }
        String name = this.myModuleReferenceInfo.getParentName();
        if (name != null && !(candidates = this.processVariantsForQualifiedReference(ref)).isEmpty()) {
            candidates.forEach(processor::processCandidate);
            return true;
        }
        Object[] results = this.myPlaceInfo.getResolveResults();
        if (results.length > 0) {
            SmartList result2 = new SmartList();
            Set resolveResultElements = ((StreamEx)StreamEx.of((Object[])results).map(el -> (JSResolveResult)ObjectUtils.tryCast((Object)el, JSResolveResult.class)).nonNull().filter(el -> el.isValidResult() || "javascript.element.need.to.be.imported".equals(el.getResolveProblemKey()))).map(JSResolveResult::getElement).nonNull().toSet();
            for (PsiElement element : resolveResultElements) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)this.processCandidate(ref, element, true));
            }
            result2.forEach(processor::processCandidate);
        }
        return true;
    }

    @Nullable
    private JSImportCandidate processCandidate(@NotNull String refName, @NotNull PsiElement element, boolean isUnqualifiedReference) {
        JSImportCandidate candidate;
        JSElement detectParentElement;
        PsiFile file2;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(5);
        }
        if (!((file2 = element.getContainingFile()) instanceof JSFile && element.isValid() && file2.isValid())) {
            return null;
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return null;
        }
        if (!this.myModuleReferenceInfo.isAcceptable(element)) {
            return null;
        }
        JSFile jsFile = (JSFile)file2;
        if (!isUnqualifiedReference && (detectParentElement = JSResolveBasedCandidatesProvider.detectParentElement(element, this.myModuleReferenceInfo)) != null && (candidate = this.processCandidate(refName, (PsiElement)detectParentElement, true)) != null) {
            return candidate;
        }
        JSImportCandidate candidate2 = this.processModuleExports(refName, jsFile, (JSQualifiedNamedElement)element, isUnqualifiedReference);
        if (candidate2 != null) {
            return candidate2;
        }
        if (!JSResolveBasedCandidatesProvider.isES6Context(file2)) {
            return null;
        }
        if (isUnqualifiedReference) {
            return this.processUnqualifiedES6Exports(refName, element);
        }
        return this.processQualifiedES6Exports(refName, (JSQualifiedNamedElement)element);
    }

    @Nullable
    private JSImportCandidate processUnqualifiedES6Exports(@NotNull String refName, @NotNull PsiElement element) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(6);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(7);
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return null;
        }
        boolean isDefault = ((JSQualifiedNamedElement)element).isExportedWithDefault();
        boolean isExported = ((JSQualifiedNamedElement)element).isExported();
        if (isExported || isDefault) {
            return new ES6ImportCandidate(refName, (JSElement)((JSQualifiedNamedElement)element), this.myPlaceInfo.getPlace());
        }
        return null;
    }

    private JSImportCandidate processModuleExports(@NotNull String refName, @NotNull JSFile jsFile, @NotNull JSQualifiedNamedElement element, boolean isUnqualifiedReference) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(8);
        }
        if (jsFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(9);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(10);
        }
        if (isUnqualifiedReference && CommonJSUtil.isExportedWithModuleExports((JSPsiElementBase)element)) {
            return this.addFixFromFile(refName, (PsiElement)element, (PsiFile)jsFile, null, JSImportCandidate.SourceType.COMMONJS, ES6ImportPsiUtil.ImportExportType.DEFAULT);
        }
        JSQualifiedName elementNamespace = element.getJSNamespace().getQualifiedName();
        if (elementNamespace == null) {
            return null;
        }
        String namespaceName = elementNamespace.getName();
        if (JSResolveBasedCandidatesProvider.isExports(namespaceName) || JSResolveBasedCandidatesProvider.isExportsViaAlias(namespaceName, jsFile)) {
            if (isUnqualifiedReference) {
                return this.addModuleExportsWithNameFixForUnqualifiedReference(refName, jsFile, element);
            }
            return this.addModuleExportsWithNameFixForQualifiedReference(refName, jsFile, element);
        }
        return null;
    }

    @Nullable
    private static JSElement detectParentElement(@NotNull PsiElement element, @NotNull ModuleReferenceInfo moduleReferenceInfo) {
        PsiElement context;
        JSClass parentClass;
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(11);
        }
        if (moduleReferenceInfo == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(12);
        }
        if ((parentClass = JSUtils.getMemberContainingClass(element)) != null && element instanceof JSQualifiedNamedElement && (context = ((JSQualifiedNamedElement)element).getJSContext()) != moduleReferenceInfo.getContext()) {
            return null;
        }
        context = element.getContext();
        if (context == null) {
            return null;
        }
        if (context instanceof JSExpression && !(context instanceof JSQualifiedNamedElement)) {
            JSExpression initializer;
            PsiElement superParent = context.getContext();
            if (superParent instanceof ES6ExportDefaultAssignment) {
                return (JSElement)context;
            }
            if (superParent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)superParent).getInitializerOrStub()) == context) {
                context = superParent;
            }
        }
        return context instanceof JSQualifiedNamedElement ? (JSElement)context : null;
    }

    private static boolean isExports(String text) {
        return "exports".equals(text) || "module.exports".equals(text);
    }

    @NotNull
    private Collection<JSImportCandidate> processVariantsForQualifiedReference(@NotNull String refName) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(13);
        }
        Collection<PsiElement> results = this.myModuleReferenceInfo.getResolvedParent();
        SmartList candidates = new SmartList();
        for (PsiElement resolveResult : results) {
            ContainerUtil.addIfNotNull((Collection)candidates, (Object)this.processCandidate(refName, resolveResult, false));
        }
        if (candidates.size() > 0) {
            SmartList smartList = candidates;
            if (smartList == null) {
                JSResolveBasedCandidatesProvider.$$$reportNull$$$0(14);
            }
            return smartList;
        }
        String parentRefName = this.myModuleReferenceInfo.getParentName();
        if (parentRefName != null && results.isEmpty()) {
            List<JSImportCandidate> list2 = this.searchWithSymbolNameIndex(refName, this.getProject(), parentRefName);
            if (list2 == null) {
                JSResolveBasedCandidatesProvider.$$$reportNull$$$0(15);
            }
            return list2;
        }
        List<JSImportCandidate> list3 = Collections.emptyList();
        if (list3 == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(16);
        }
        return list3;
    }

    private List<JSImportCandidate> searchWithSymbolNameIndex(@NotNull String refName, @NotNull Project project, @NotNull String parentName) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(17);
        }
        if (project == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(18);
        }
        if (parentName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(19);
        }
        ArrayList elementsToProcess = new ArrayList();
        DelegatingGlobalSearchScope scope = this.getModulesOnlyScope();
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)parentName, project, (GlobalSearchScope)scope, JSElement.class, Processors.cancelableCollectProcessor(elementsToProcess));
        if (elementsToProcess.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        for (JSElement element : elementsToProcess) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)this.processCandidate(refName, (PsiElement)element, false));
        }
        return result2;
    }

    @NotNull
    private DelegatingGlobalSearchScope getModulesOnlyScope() {
        final PsiManager manager2 = this.myPlaceInfo.getPlace().getManager();
        return new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)this.getProject())){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                PsiFile psiFile = manager2.findFile(file2);
                return psiFile instanceof JSFile && ((JSFile)psiFile).isCommonJSModule();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/imports/providers/JSResolveBasedCandidatesProvider$1", "contains"));
            }
        };
    }

    @Nullable
    JSImportCandidate addModuleExportsWithNameFixForUnqualifiedReference(@NotNull String refName, @NotNull JSFile jsFile, @NotNull JSQualifiedNamedElement element) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(20);
        }
        if (jsFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(21);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(22);
        }
        return this.addFixFromFile(refName, (PsiElement)element, (PsiFile)jsFile, element.getName(), JSImportCandidate.SourceType.COMMONJS, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
    }

    @Nullable
    private JSImportCandidate addModuleExportsWithNameFixForQualifiedReference(@NotNull String refName, @NotNull JSFile jsFile, @NotNull JSQualifiedNamedElement element) {
        JSModuleNameInfo info;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(23);
        }
        if (jsFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(24);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(25);
        }
        if ((info = ES6CreateImportUtil.getModuleInfo(this.myPlaceInfo.getPlace(), (PsiElement)element, (PsiFile)jsFile)) == null) {
            return null;
        }
        return new JSImportCandidateDescriptor(JSImportCandidate.SourceType.COMMONJS, info, refName, null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.DEFAULT);
    }

    private static boolean isExportsViaAlias(@NotNull String elementNamespace, @NotNull JSFile jsFile) {
        if (elementNamespace == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(26);
        }
        if (jsFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(27);
        }
        List<? extends PsiElement> exportedElements = JSResolveUtil.getExportedElements((JSExecutionScope)jsFile);
        for (PsiElement psiElement : exportedElements) {
            JSType alias = psiElement instanceof JSTypeOwner ? ((JSTypeOwner)psiElement).getJSType() : null;
            String aliasText = alias instanceof JSReferenceType ? ((JSReferenceType)alias).getReferenceName() : null;
            if (!elementNamespace.equals(aliasText)) continue;
            return true;
        }
        return false;
    }

    private static boolean isES6Context(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(28);
        }
        return DialectDetector.isES6((PsiElement)file2) || DialectDetector.isTypeScript((PsiElement)file2);
    }

    private JSImportCandidate processQualifiedES6Exports(@NotNull String refName, @NotNull JSQualifiedNamedElement element) {
        PsiElement module;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(29);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(30);
        }
        if (element.isExportedWithDefault()) {
            return null;
        }
        if (!element.isExportedWithDefault() && element.isExported() && (module = ES6PsiUtil.findExternalModule((PsiElement)element)) != null) {
            JSImportExportType type;
            JSImportDescriptor descriptor2;
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file2 != null && (descriptor2 = ES6CreateImportUtil.getImportDescriptor(element.getName(), (PsiElement)element, file2, this.myPlaceInfo.getPlace(), false)) != null && (type = descriptor2.getImportType()).isSpecifier()) {
                return new JSImportCandidateDescriptor(JSImportCandidate.SourceType.ES6, descriptor2.getModuleDescriptor(), refName, null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL);
            }
            return this.addFixFromFile(refName, module, module.getContainingFile(), null, JSImportCandidate.SourceType.ES6, ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL);
        }
        return null;
    }

    private JSImportCandidate addFixFromFile(@NotNull String refName, @Nullable PsiElement importedElement, @NotNull PsiFile targetPsiFile, @Nullable String nameInExports, @NotNull JSImportCandidate.SourceType moduleType, @NotNull ES6ImportPsiUtil.ImportExportType type) {
        PsiElement module;
        VirtualFile targetFile;
        VirtualFile file2;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(31);
        }
        if (targetPsiFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(32);
        }
        if (moduleType == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(33);
        }
        if (type == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(34);
        }
        if (Objects.equals(file2 = PsiUtilCore.getVirtualFile((PsiElement)this.myPlaceInfo.getPlace()), targetFile = targetPsiFile.getVirtualFile())) {
            return null;
        }
        ES6ImportExportDeclaration.ImportExportPrefixKind kind = ES6AddImportExecutor.detectPrefixKind(importedElement, (PsiElement)targetPsiFile);
        if (importedElement != null && (module = ES6PsiUtil.findExternalModule(importedElement)) instanceof TypeScriptModule && !((TypeScriptModule)module).isAugmentation()) {
            return JSResolveBasedCandidatesProvider.addForTypeScriptExternalModule(refName, (TypeScriptModule)module, nameInExports, moduleType, type, kind);
        }
        JSModuleNameInfo info = ES6CreateImportUtil.getModuleInfo(this.myPlaceInfo.getPlace(), importedElement, targetPsiFile);
        if (info == null) {
            return null;
        }
        return new JSImportCandidateDescriptor(moduleType, info, refName, nameInExports, kind, (JSImportExportType)type);
    }

    @Nullable
    private static JSImportCandidate addForTypeScriptExternalModule(@NotNull String refName, @NotNull TypeScriptModule module, @Nullable String nameInExports, @NotNull JSImportCandidate.SourceType moduleType, @NotNull ES6ImportPsiUtil.ImportExportType type, @NotNull ES6ImportExportDeclaration.ImportExportPrefixKind kind) {
        String text;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(35);
        }
        if (module == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(36);
        }
        if (moduleType == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(37);
        }
        if (type == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(38);
        }
        if (kind == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(39);
        }
        if ((text = module.getExternalModuleText()) == null) {
            return null;
        }
        JSModuleDescriptor.SimpleModuleDescriptor descriptor2 = new JSModuleDescriptor.SimpleModuleDescriptor((PsiElement)module, StringUtil.unquoteString((String)text));
        return new JSImportCandidateDescriptor(moduleType, descriptor2, refName, nameInExports, kind, (JSImportExportType)type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 29: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 22: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/JSResolveBasedCandidatesProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementNamespace";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPsiFile";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/JSResolveBasedCandidatesProvider";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processVariantsForQualifiedReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processCandidate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedES6Exports";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processModuleExports";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "detectParentElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processVariantsForQualifiedReference";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "searchWithSymbolNameIndex";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addModuleExportsWithNameFixForUnqualifiedReference";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addModuleExportsWithNameFixForQualifiedReference";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isExportsViaAlias";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isES6Context";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedES6Exports";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addFixFromFile";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addForTypeScriptExternalModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            if (placeInfo.importContext() != JSImportPlaceInfo.ImportContext.SIMPLE || DialectDetector.isTypeScript(placeInfo.getPlace()) || placeInfo.isStrictTypeContext()) {
                return null;
            }
            PsiElement place = placeInfo.getPlace();
            if (!(place instanceof JSReferenceExpression)) {
                return null;
            }
            JSModuleReferenceExpressionInfo info = new JSModuleReferenceExpressionInfo((JSReferenceExpression)place);
            return new JSResolveBasedCandidatesProvider(placeInfo, info);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/JSResolveBasedCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

