/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHardcodedCandidatesProvider
extends JSImportCandidatesBase {
    private static final Map<String, String> HARDCODED_NAME_TO_MODULE = ContainerUtil.immutableMapBuilder().put((Object)"React", (Object)"react").put((Object)"PropTypes", (Object)"prop-types").build();
    @Nullable
    private final VirtualFile myModuleRoot;

    public JSHardcodedCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            JSHardcodedCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
        this.myModuleRoot = NodeModuleUtil.getMainModuleRoot(placeInfo.getPlace());
    }

    @Override
    public boolean processCandidates(@NotNull String ref, @NotNull JSCandidatesProcessor processor, boolean forCompletion) {
        if (ref == null) {
            JSHardcodedCandidatesProvider.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            JSHardcodedCandidatesProvider.$$$reportNull$$$0(2);
        }
        if (forCompletion || processor.hasElements()) {
            return true;
        }
        String moduleName = HARDCODED_NAME_TO_MODULE.get(ref);
        if (moduleName != null) {
            processor.processCandidate(this.getExplicitModuleIfExists(ref, moduleName));
        }
        return true;
    }

    @Nullable
    private JSImportCandidate getExplicitModuleIfExists(@NotNull String referenceName, @NotNull String moduleName) {
        ResolvedModuleInfo info;
        if (referenceName == null) {
            JSHardcodedCandidatesProvider.$$$reportNull$$$0(3);
        }
        if (moduleName == null) {
            JSHardcodedCandidatesProvider.$$$reportNull$$$0(4);
        }
        if (this.myModuleRoot == null) {
            return null;
        }
        VirtualFile byName = NodeModuleUtil.getProjectChildModuleByName(this.getProject(), this.myModuleRoot, moduleName);
        if (byName != null && byName.isDirectory() && (info = NodeModuleDirectorySearchProcessor.PROCESSOR.loadDirectory(this.myModuleRoot, byName, ModuleType.NODE_MODULES_DIR, true)) != null) {
            return new JSImportCandidateDescriptor(JSImportCandidate.SourceType.COMMONJS, moduleName, referenceName, null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.DEFAULT);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/JSHardcodedCandidatesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processCandidates";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getExplicitModuleIfExists";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            if (placeInfo.importContext() != JSImportPlaceInfo.ImportContext.SIMPLE || placeInfo.isStrictTypeContext()) {
                return null;
            }
            return new JSHardcodedCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/JSHardcodedCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

