/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.ES6ImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ImportDeclarationPartIndex;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportedCandidatesProvider
extends JSImportCandidatesBase {
    private final JSCompletionPlaceFilter myPlaceFilter;
    @NotNull
    private final Predicate<? super JSElement> myExportedFilter;
    @Nullable
    private MultiMap<String, JSElement> myAllRegularExternalModules;

    protected ES6ExportedCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
        PsiElement place = placeInfo.getPlace();
        boolean isTypeScript = DialectDetector.isTypeScript(place);
        this.myPlaceFilter = JSCompletionPlaceFilter.forPlace(place);
        this.myExportedFilter = element -> !(element instanceof JSPsiElementBase && !this.myPlaceFilter.isAcceptable((JSPsiElementBase)element) || !ES6ExportedCandidatesProvider.isAcceptableForImport(placeInfo, placeInfo.importContext(), element) || ES6ExportedCandidatesProvider.needToCheckConfigAccess((PsiElement)element, isTypeScript) && !TypeScriptConfigService.Provider.isAccessible(place.getProject(), placeInfo.getFile(), element.getContainingFile().getVirtualFile()));
    }

    @Override
    public boolean processCandidates(@NotNull String name, @NotNull JSCandidatesProcessor processor, boolean forCompletion) {
        PsiElement place;
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(2);
        }
        if (!(place = this.myPlaceInfo.getPlace()).isValid()) {
            return true;
        }
        Project project = place.getProject();
        GlobalSearchScope scope = ES6CreateImportUtil.createSymbolToImportSearchScope(project, place);
        ArrayList<JSElement> candidates = new ArrayList<JSElement>();
        this.addExportedElements(name, project, scope, candidates);
        this.addExportedDefaultAssignmentElements(name, project, scope, candidates);
        this.addExternalModuleNames(name, candidates);
        Collection<JSElement> result2 = this.removeOverloads(candidates);
        PsiFile file2 = place.getContainingFile();
        boolean skipNodeModulesImports = !DialectDetector.isTypeScript(place) && (!(file2 instanceof JSFile) || ((JSFile)file2).getModuleStatus() != JSFile.ModuleStatus.ES6);
        StreamEx exported = ((StreamEx)((StreamEx)StreamEx.of(result2).filter(this.myExportedFilter)).distinct()).map(el -> new ES6ImportCandidate(name, (JSElement)el, place, this.myPlaceInfo.importContext(), this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.TAG || !forCompletion || !skipNodeModulesImports || !ES6ExportedCandidatesProvider.hasNodeModulesInPath((PsiElement)el)));
        List<JSImportCandidate> defaultExport = this.getProjectImports(name);
        Stream.concat(exported, defaultExport.stream()).forEach(processor::processCandidate);
        return true;
    }

    public void addExportedDefaultAssignmentElements(@NotNull String name, Project project, GlobalSearchScope scope, List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(3);
        }
        if (this.myPlaceInfo.importContext() != JSImportPlaceInfo.ImportContext.SPECIFIER) {
            Processor assignmentProcessor = CommonProcessors.processAll(toProcess -> {
                JSElement expression = toProcess.getStubSafeElement();
                if (expression instanceof JSQualifiedNamedElement) {
                    if (expression.getName() == null) {
                        candidates.add(expression);
                    }
                } else {
                    candidates.add((JSElement)toProcess);
                }
            });
            StubIndex.getInstance().processElements(ES6DefaultAssignmentModuleIndex.KEY, (Object)name, project, scope, JSExportAssignment.class, assignmentProcessor);
        }
    }

    public void addExportedElements(@NotNull String name, Project project, GlobalSearchScope scope, List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(4);
        }
        ArrayList exportSpecifiers = new ArrayList();
        HashSet scopesWithSpecifierExports = new HashSet();
        Processor processor = CommonProcessors.processAll(toProcess -> {
            if (toProcess instanceof ES6ExportSpecifier) {
                exportSpecifiers.add((ES6ExportSpecifier)toProcess);
                return;
            }
            if (ES6CreateImportUtil.isAvailableForImport((PsiElement)toProcess, this.myPlaceInfo)) {
                JSElement exportScope;
                JSPsiElementBase element;
                candidates.add((JSElement)toProcess);
                if (toProcess instanceof JSPsiElementBase && (element = (JSPsiElementBase)toProcess).isExported() && ES6PsiUtil.isExternalModule((PsiElement)(exportScope = ES6PsiUtil.getExportScope((PsiElement)element)))) {
                    scopesWithSpecifierExports.add(exportScope);
                }
            }
        });
        StubIndex.getInstance().processElements(ES6ExportedNamesIndex.KEY, (Object)name, project, scope, JSElement.class, processor);
        for (ES6ExportSpecifier specifier : exportSpecifiers) {
            JSElement exportScope = ES6PsiUtil.getExportScope((PsiElement)specifier);
            if (exportScope == null || scopesWithSpecifierExports.contains(exportScope) || exportScope == this.myPlaceInfo.getContainer() || !ES6CreateImportUtil.isAcceptableExportSpecifier(specifier)) continue;
            candidates.add((JSElement)specifier);
        }
    }

    private static boolean hasNodeModulesInPath(@NotNull PsiElement element) {
        VirtualFile file2;
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(5);
        }
        return (file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && NodeModuleUtil.hasNodeModulesDirInPath(file2, null);
    }

    @Override
    @NotNull
    public Set<String> getNames(@NotNull Predicate<String> keyFilter) {
        if (keyFilter == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(6);
        }
        Project project = this.myPlaceInfo.getPlace().getProject();
        Set namedKeys = StubIndex.getInstance().getAllKeys(ES6ExportedNamesIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        ProgressManager.checkCanceled();
        Set defaultAssignmentKeys = this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER ? Collections.emptySet() : StubIndex.getInstance().getAllKeys(ES6DefaultAssignmentModuleIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        Set existingDefaultImportNames = this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER ? Collections.emptySet() : StubIndex.getInstance().getAllKeys(ES6ImportDeclarationPartIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        Set<String> set = Stream.concat(Stream.concat(namedKeys.stream(), defaultAssignmentKeys.stream()), existingDefaultImportNames.stream()).collect(Collectors.toSet());
        if (set == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(7);
        }
        return set;
    }

    public static boolean needToCheckConfigAccess(@NotNull PsiElement element, boolean isTypeScript) {
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(8);
        }
        if (isTypeScript && element instanceof TypeScriptModule && ((TypeScriptModule)element).isExternal()) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        return isTypeScript && (!(file2 instanceof JSFile) || !((JSFile)file2).isCommonJSModule());
    }

    public static boolean isAcceptableForImport(@NotNull JSImportPlaceInfo info, @NotNull JSImportPlaceInfo.ImportContext importContext, @NotNull JSElement element) {
        JSElement container;
        if (info == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(9);
        }
        if (importContext == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(10);
        }
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(11);
        }
        if ((container = ES6PsiUtil.getExportScope((PsiElement)element)) == info.getContainer()) {
            return false;
        }
        if (importContext != JSImportPlaceInfo.ImportContext.SPECIFIER && element instanceof TypeScriptModule && ((TypeScriptModule)element).isExternal()) {
            return true;
        }
        if (importContext != JSImportPlaceInfo.ImportContext.BINDING && element instanceof ES6ExportSpecifier && ((ES6ExportSpecifier)element).getAlias() != null) {
            return true;
        }
        if (importContext == JSImportPlaceInfo.ImportContext.SPECIFIER && element instanceof JSPsiElementBase) {
            return ((JSPsiElementBase)element).isExported() && ES6PsiUtil.findExternalModule((PsiElement)element) != null;
        }
        if (importContext == JSImportPlaceInfo.ImportContext.BINDING) {
            if (element instanceof JSElementBase && ((JSElementBase)element).isExportedWithDefault()) {
                return true;
            }
            return element instanceof ES6ExportDefaultAssignment;
        }
        if (element instanceof ES6ExportSpecifier && !ES6CreateImportUtil.isAcceptableExportSpecifier((ES6ExportSpecifier)element)) {
            return false;
        }
        return element instanceof JSExportAssignment || (importContext == JSImportPlaceInfo.ImportContext.SPECIFIER ? ES6ImportHandler.isExternalModuleExport(element) : ES6CreateImportUtil.isAvailableForImport((PsiElement)element, info));
    }

    @NotNull
    protected Collection<JSElement> removeOverloads(@NotNull Collection<? extends JSElement> candidates) {
        if (candidates == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(12);
        }
        List list2 = ContainerUtil.filter(candidates, el -> !ES6ExportedCandidatesProvider.isOverloadDeclaration(el));
        if (list2 == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private void addExternalModuleNames(@NotNull String name, @NotNull List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(14);
        }
        if (candidates == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(15);
        }
        if (this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.BINDING) {
            return;
        }
        MultiMap modules = this.myAllRegularExternalModules;
        if (modules == null) {
            modules = MultiMap.create();
            PsiElement myContext = this.myPlaceInfo.getPlace();
            for (TypeScriptModule module : TypeScriptUtil.getAllRegularExternalModules(myContext.getProject(), myContext)) {
                String rawName = module.getExternalModuleText();
                if (rawName == null) continue;
                String moduleName = StringUtil.unquoteString((String)rawName).toLowerCase(Locale.ENGLISH);
                modules.putValue((Object)moduleName, (Object)module);
            }
            this.myAllRegularExternalModules = modules;
        }
        candidates.addAll(modules.get((Object)name.toLowerCase(Locale.ENGLISH)));
    }

    private static boolean isOverloadDeclaration(@NotNull JSElement element) {
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(16);
        }
        return element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration();
    }

    @NotNull
    private List<JSImportCandidate> getProjectImports(@NotNull String referenceName) {
        if (referenceName == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(17);
        }
        if (this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER) {
            List<JSImportCandidate> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(18);
            }
            return list2;
        }
        PsiElement node = this.myPlaceInfo.getPlace();
        DelegatingGlobalSearchScope scope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(node)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.contains(file2) && !NodeModuleUtil.hasNodeModulesDirInPath(file2, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider$1", "contains"));
            }
        };
        Collection elements = StubIndex.getElements(ES6ImportDeclarationPartIndex.KEY, (Object)referenceName, (Project)node.getProject(), (GlobalSearchScope)scope, ES6ImportExportDeclarationPart.class);
        if (elements.size() == 0) {
            List<JSImportCandidate> list3 = Collections.emptyList();
            if (list3 == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(19);
            }
            return list3;
        }
        SmartList objects = new SmartList();
        HashSet<Pair<JSImportExportType, String>> visited = new HashSet<Pair<JSImportExportType, String>>();
        for (ES6ImportExportDeclarationPart part : elements) {
            ES6ImportPsiUtil.ImportExportType type;
            ES6ImportExportDeclaration declaration = part.getDeclaration();
            String text = ES6ExportedCandidatesProvider.getModuleNameFromDeclaration(declaration, type = part instanceof ES6ImportedBinding ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER, visited);
            if (text == null) continue;
            ContainerUtil.addIfNotNull((Collection)objects, (Object)this.createImportCandidateForPart(referenceName, part, declaration, type, text));
        }
        SmartList smartList = objects;
        if (smartList == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    @Nullable
    private JSImportCandidate createImportCandidateForPart(@NotNull String referenceName, @NotNull ES6ImportExportDeclarationPart element, @NotNull ES6ImportExportDeclaration declaration, @NotNull JSImportExportType type, @NotNull String text) {
        if (referenceName == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(21);
        }
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(22);
        }
        if (declaration == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(23);
        }
        if (type == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(24);
        }
        if (text == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(25);
        }
        PsiElement node = this.myPlaceInfo.getPlace();
        ES6ImportExportDeclaration.ImportExportPrefixKind kind = declaration.getImportExportPrefixKind();
        Optional result2 = ((StreamEx)((StreamEx)StreamEx.of(ES6PsiUtil.expandElements(node, Collections.singleton(element))).select(JSElement.class).filter(el -> !ES6ExportedCandidatesProvider.isOverloadDeclaration(el))).filter(t -> this.myExportedFilter.test((JSElement)t) && t instanceof JSPsiElementBase && this.myPlaceFilter.isAcceptable((JSPsiElementBase)t))).findAny();
        if (result2.isPresent()) {
            final SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)((JSElement)result2.get()));
            return new JSImportCandidateDescriptor(JSImportCandidate.SourceType.ES6, StringUtil.unquoteString((String)text), referenceName, null, kind, type){

                @Override
                public JSElement getElement() {
                    return (JSElement)pointer.getElement();
                }

                @Override
                public int getPriority() {
                    return 1;
                }
            };
        }
        return null;
    }

    @Contract(value="null,_,_->null")
    private static String getModuleNameFromDeclaration(@Nullable ES6ImportExportDeclaration declaration, @NotNull JSImportExportType type, @NotNull Set<Pair<JSImportExportType, String>> visited) {
        ES6FromClause clause;
        if (type == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(26);
        }
        if (visited == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(27);
        }
        ES6FromClause eS6FromClause = clause = declaration != null ? declaration.getFromClause() : null;
        if (clause == null) {
            return null;
        }
        String text = clause.getReferenceText();
        if (text == null) {
            return null;
        }
        String unquoted = StringUtil.unquoteString((String)text);
        if (!visited.add((Pair<JSImportExportType, String>)Pair.create((Object)type, (Object)unquoted)) || JSModuleFileReferenceSet.isRelative(unquoted)) {
            return null;
        }
        Collection resolvedElements = clause.resolveReferencedElements();
        if (resolvedElements.size() == 0) {
            return null;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem((Collection)resolvedElements);
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)item);
        if (file2 == null) {
            return null;
        }
        if (!NodeModuleUtil.hasNodeModulesDirInPath(file2, null)) {
            return null;
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importContext";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeOverloads";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExportedDefaultAssignmentElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addExportedElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasNodeModulesInPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNames";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "needToCheckConfigAccess";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableForImport";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeOverloads";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addExternalModuleNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isOverloadDeclaration";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProjectImports";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createImportCandidateForPart";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameFromDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            return new ES6ExportedCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

