/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportElementFilter;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPlaceElementFilter
implements JSImportElementFilter {
    public static final JSImportElementFilter DEFAULT_FILTER = new JSPlaceElementFilter();

    protected JSPlaceElementFilter() {
    }

    @Override
    @NotNull
    public List<? extends JSImportCandidate> filterCandidates(@NotNull PsiElement place, @NotNull List<? extends JSImportCandidate> result2) {
        if (place == null) {
            JSPlaceElementFilter.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSPlaceElementFilter.$$$reportNull$$$0(1);
        }
        if (result2.isEmpty()) {
            List<? extends JSImportCandidate> list2 = result2;
            if (list2 == null) {
                JSPlaceElementFilter.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (JSImportAction.isJSXContextPlace(place)) {
            List list3 = ContainerUtil.filter(result2, el -> {
                JSElement element = el.getElement();
                if (element == null) {
                    return JSXResolveUtil.isComponentName(el.getName());
                }
                if (!ReactXmlExtension.isPossibleReactComponent((PsiElement)element)) {
                    return false;
                }
                JSElement scope = ES6PsiUtil.getExportScope((PsiElement)element);
                if (scope == null) {
                    return false;
                }
                return ES6PsiUtil.isExternalModule((PsiElement)scope) && JSPlaceElementFilter.isAcceptableReactComponent(element);
            });
            if (list3 == null) {
                JSPlaceElementFilter.$$$reportNull$$$0(3);
            }
            return list3;
        }
        List<? extends JSImportCandidate> list4 = result2;
        if (list4 == null) {
            JSPlaceElementFilter.$$$reportNull$$$0(4);
        }
        return list4;
    }

    public static boolean isAcceptableReactComponent(JSElement element) {
        if (element instanceof JSClass) {
            JSClass jsClass = (JSClass)element;
            ThreeState state = ReactXmlExtension.isAcceptableClassComponent(jsClass);
            switch (state) {
                case YES: {
                    return true;
                }
                case NO: {
                    return false;
                }
            }
            return ReactXmlExtension.checkClassHierarchyHasComponent(jsClass, false);
        }
        if (element instanceof ES6ExportSpecifier) {
            return true;
        }
        if (!DialectDetector.isJSX((PsiElement)element)) {
            if (TypeScriptUtil.isDefinitionFile(element.getContainingFile())) {
                return JSPlaceElementFilter.addDtsFileElement(element);
            }
            return false;
        }
        return JSPlaceElementFilter.addJSXFileElement(element);
    }

    private static boolean addJSXFileElement(@NotNull JSElement element) {
        if (element == null) {
            JSPlaceElementFilter.$$$reportNull$$$0(5);
        }
        if (element instanceof JSExportAssignment) {
            return true;
        }
        if (element instanceof JSVariable) {
            return JSPlaceElementFilter.isAcceptableVariable((JSVariable)element);
        }
        if (element instanceof ES6ExportSpecifier && ((ES6ExportSpecifier)element).getAlias() != null) {
            return true;
        }
        return element instanceof JSFunction && ReactXmlExtension.isFunctionComponentBySignature((JSFunction)element);
    }

    private static boolean addDtsFileElement(@NotNull JSElement element) {
        if (element == null) {
            JSPlaceElementFilter.$$$reportNull$$$0(6);
        }
        return element instanceof JSVariable && JSPlaceElementFilter.isAcceptableVariableType(((JSVariable)element).getJSType());
    }

    private static boolean isAcceptableVariable(@NotNull JSVariable element) {
        JSType variableType;
        if (element == null) {
            JSPlaceElementFilter.$$$reportNull$$$0(7);
        }
        if (JSPlaceElementFilter.isAcceptableVariableType(variableType = element.getJSType())) {
            return true;
        }
        JSExpression expression = JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)element);
        if (expression instanceof JSFunction && ReactXmlExtension.isFunctionComponentBySignature((JSFunction)expression)) {
            return true;
        }
        return expression instanceof JSCallLikeExpression || variableType instanceof JSApplyCallType;
    }

    private static boolean isAcceptableVariableType(@Nullable JSType variableType) {
        if (variableType instanceof JSGenericTypeImpl) {
            variableType = ((JSGenericTypeImpl)variableType).getType();
        }
        return variableType instanceof JSTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSPlaceElementFilter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSPlaceElementFilter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterCandidates";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addJSXFileElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDtsFileElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

