/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface JSImportCandidate {
    public static final int DEFAULT_PRIORITY = 0;

    @NotNull
    public String getName();

    @Nullable
    public JSElement getElement();

    public boolean useAutoImport();

    @NotNull
    public List<JSImportDescriptor> getDescriptors();

    @NotNull
    public SourceType getSourceType();

    @Nullable
    default public VirtualFile getElementFile() {
        return PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
    }

    default public int getPriority() {
        return 0;
    }

    @Nullable
    default public JSImportDescriptor getSingleDescriptorOrNull() {
        List<JSImportDescriptor> descriptors = this.getDescriptors();
        return descriptors.size() == 1 ? descriptors.get(0) : null;
    }

    @NotNull
    default public String getContainerText() {
        JSElement element = this.getElement();
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file2 == null) {
            return "";
        }
        List<JSImportDescriptor> descriptors = this.getDescriptors();
        JSImportDescriptor item = (JSImportDescriptor)ContainerUtil.getFirstItem(descriptors);
        if (item == null) {
            return "";
        }
        String suffix = descriptors.size() > 1 ? "." + this.getName() : "";
        String string = JSImportCandidate.getContainerForDescriptor(item) + suffix;
        if (string == null) {
            JSImportCandidate.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getContainerForDescriptor(JSImportDescriptor item) {
        JSModuleDescriptor moduleDescriptor = item.getModuleDescriptor();
        PsiElement module = moduleDescriptor.getModule();
        if (module instanceof JSFile && !((JSFile)module).isCommonJSModule()) {
            String string = ((JSFile)module).getName();
            if (string == null) {
                JSImportCandidate.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = "\"" + item.getModuleName() + "\"";
        if (string == null) {
            JSImportCandidate.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/modules/imports/JSImportCandidate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerForDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum SourceType {
        COMMONJS,
        ES6;

    }
}

