/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.uml.UmlGraphBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSModulesDiagramUtils {
    public static final DataKey<DiagramBuilder> DIAGRAM_BUILDER = DataKey.create((String)"JS.Diagram.Builder");

    @NlsSafe
    public static String getFileNamePart(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSModulesDiagramUtils.$$$reportNull$$$0(0);
        }
        if (NodeCoreLibraryManager.getInstance(file2.getProject()).isCoreModuleLibraryFile(file2.getVirtualFile())) {
            return file2.getName() + " (node.js)";
        }
        VirtualFile folder = JSLibraryUtil.getLibraryFolder(file2.getVirtualFile());
        VirtualFile parent = file2.getVirtualFile().getParent();
        if (folder != null) {
            if (folder.equals(parent)) {
                return folder.getName() + "/" + file2.getName();
            }
            return folder.getName() + "/.../" + file2.getName();
        }
        if (parent != null && parent.toString().equals(file2.getProject().getBasePath())) {
            return file2.getName();
        }
        return (String)(parent == null ? "" : parent.getName() + "/") + file2.getName();
    }

    @Nullable
    @Nls
    public static String getJSStructuralItemTooltip(JSStructuralDiagramItem element) {
        if (element.getElementPointer() == null) {
            if (JSModulesDiagramUtils.startsWithHttpProtocol(element.getName())) {
                return element.getName();
            }
            return JavaScriptBundle.message((String)"diagram.element.not.found", (Object[])new Object[]{element.getName()});
        }
        PsiElement psiElement = element.getElementPointer().getElement();
        if (psiElement != null && psiElement.isValid()) {
            if (!element.isFile()) {
                return element.getName() + " (" + psiElement.getContainingFile().getVirtualFile().getPresentableUrl() + ")";
            }
            return psiElement.getContainingFile().getVirtualFile().getPresentableUrl();
        }
        return element.getName();
    }

    public static boolean startsWithHttpProtocol(@NotNull String s) {
        int idx;
        if (s == null) {
            JSModulesDiagramUtils.$$$reportNull$$$0(1);
        }
        return (idx = s.indexOf("://")) > 0 && s.substring(0, idx).startsWith("http");
    }

    @Nullable
    public static List<DiagramNode> getSelectedNodes(AnActionEvent e) {
        DiagramBuilder builder = (DiagramBuilder)e.getData(DIAGRAM_BUILDER);
        if (builder == null || builder.getGraph().isSelectionEmpty()) {
            return null;
        }
        UmlGraphBuilder umlBuilder = (UmlGraphBuilder)builder.getGraph().getDataProvider((Object)"GRAPH_BUILDER").get(null);
        return new ArrayList<DiagramNode>(GraphUtil.getSelectedNodes((GraphBuilder)umlBuilder));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void showMembersSelectionPopup(@NotNull @NlsContexts.Label String mainName, @Nullable SmartPsiElementPointer<?> mainPointer, final @Nullable Icon mainIcon, final @NotNull List<? extends Trinity<@NlsContexts.Label String, SmartPsiElementPointer, Icon>> children, @NotNull DataContext dc) {
        if (mainName == null) {
            JSModulesDiagramUtils.$$$reportNull$$$0(2);
        }
        if (children == null) {
            JSModulesDiagramUtils.$$$reportNull$$$0(3);
        }
        if (dc == null) {
            JSModulesDiagramUtils.$$$reportNull$$$0(4);
        }
        ArrayList<@NlsContexts.Label String> data = new ArrayList<String>();
        data.add(mainName);
        for (Trinity<String, SmartPsiElementPointer, Icon> trinity : children) {
            data.add((String)trinity.getFirst());
        }
        @NlsContexts.Label JBList list2 = new JBList();
        list2.setListData((Object[])((String[])data.toArray(String[]::new)));
        list2.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList list2, @NlsContexts.Label String value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (index < 0 || index > children.size()) {
                    return;
                }
                if (index == 0) {
                    this.setIcon(mainIcon);
                } else {
                    this.setIcon((Icon)((Trinity)children.get(index - 1)).getThird());
                }
                this.append(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils$1", "customizeCellRenderer"));
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(JavaScriptBundle.message((String)"dialog.title.select.navigation.target", (Object[])new Object[0])).setItemChoosenCallback(() -> {
            int index = list2.getSelectedIndex();
            if (index >= 0) {
                SmartPsiElementPointer target;
                SmartPsiElementPointer smartPsiElementPointer = target = index == 0 ? mainPointer : (SmartPsiElementPointer)((Trinity)children.get(index - 1)).getSecond();
                if (target != null) {
                    PsiElement element = target.getElement();
                    int offset = element == null ? 0 : (element instanceof JSImplicitElement ? element.getTextOffset() : element.getTextRange().getStartOffset());
                    PsiNavigationSupport.getInstance().createNavigatable((Project)CommonDataKeys.PROJECT.getData(dc), target.getVirtualFile(), offset).navigate(true);
                }
            }
        }).createPopup().showInBestPositionFor(dc);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileNamePart";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWithHttpProtocol";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showMembersSelectionPopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

