/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.modules.JSLiteralExpressionReferenceInfo;
import com.intellij.lang.javascript.modules.JSModuleReferenceExpressionInfo;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.LocalReferenceResolver;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSImportReferenceQuickFixProviderBase
implements JSUnresolvedReferenceErrorUpdater {
    @Override
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info, @NotNull JSReferenceExpression node, ResolveResult @NotNull [] resolveResults, boolean isTypeContext) {
        JSExpression qualifier;
        if (info == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(0);
        }
        if (node == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(1);
        }
        if (resolveResults == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(2);
        }
        if ((qualifier = node.getQualifier()) != null) {
            return;
        }
        if (!DialectDetector.isJavaScript((PsiElement)node.getContainingFile()) || !JSImportReferenceQuickFixProviderBase.checkContext((PsiElement)node)) {
            return;
        }
        ProblemHighlightType unresolvedReferenceHighlightType = JSImportReferenceQuickFixProviderBase.getUnresolvedReferenceHighlightType(node);
        if (!ProblemHighlightType.LIKE_UNKNOWN_SYMBOL.equals((Object)unresolvedReferenceHighlightType)) {
            return;
        }
        if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)node.getText()))) {
            return;
        }
        JSModuleReferenceExpressionInfo moduleReferenceInfo = new JSModuleReferenceExpressionInfo(node);
        if (moduleReferenceInfo.getContextName() == null) {
            return;
        }
        if (JSChangeUtil.isWellKnownPredefined(StringUtil.notNullize((String)moduleReferenceInfo.getParentName()))) {
            return;
        }
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo, resolveResults);
        if (modulesSuggester == null) {
            return;
        }
        JSImportReferenceQuickFixProviderBase.processResolvedElements((PsiElement)node, moduleReferenceInfo, modulesSuggester, resolveResults, info);
    }

    private static boolean checkContext(PsiElement node) {
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)node, JSEmbeddedContent.class);
        if (embeddedContent != null) {
            PsiElement parent = embeddedContent.getParent();
            return parent.getNode().getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE;
        }
        return true;
    }

    @Override
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info, @NotNull JSXmlLiteralExpression node) {
        if (info == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(4);
        }
        if (!(this.isJsxSupported((PsiElement)node) && DialectDetector.isJavaScript((PsiElement)node.getContainingFile()) && JSImportReferenceQuickFixProviderBase.checkContext((PsiElement)node))) {
            return;
        }
        String name = node.getName();
        if (!StringUtil.isCapitalized((String)name)) {
            return;
        }
        boolean isResolved = JSXResolveUtil.areReferencesResolvedOrEmpty(node);
        if (isResolved) {
            return;
        }
        JSLiteralExpressionReferenceInfo moduleReferenceInfo = new JSLiteralExpressionReferenceInfo(node);
        JsModulesSuggester modulesSuggester = this.createSuggester((PsiElement)node, moduleReferenceInfo, ResolveResult.EMPTY_ARRAY);
        if (modulesSuggester == null) {
            return;
        }
        JSImportReferenceQuickFixProviderBase.processResolvedElements((PsiElement)node, moduleReferenceInfo, modulesSuggester, ResolveResult.EMPTY_ARRAY, info);
    }

    private static void processResolvedElements(@NotNull PsiElement node, @NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull JsModulesSuggester modulesSuggester, ResolveResult @NotNull [] resolveResults, @NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info) {
        if (node == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(5);
        }
        if (moduleReferenceInfo == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(6);
        }
        if (modulesSuggester == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(7);
        }
        if (info == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(8);
        }
        if (resolveResults == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(9);
        }
        if (!JSImportReferenceQuickFixProviderBase.shouldAddFixes(node, resolveResults, modulesSuggester)) {
            return;
        }
        List<LocalQuickFix> newFixes = modulesSuggester.findFixes(resolveResults);
        if (newFixes.isEmpty()) {
            return;
        }
        info.updateMessage(modulesSuggester.getMessage(newFixes));
        Collection<LocalQuickFix> fixes = JSImportReferenceQuickFixProviderBase.sortAndFilter(newFixes);
        info.addAll(fixes);
    }

    @Nullable
    protected abstract JsModulesSuggester createSuggester(@NotNull PsiElement var1, @NotNull ModuleReferenceInfo var2, ResolveResult @NotNull [] var3);

    @NotNull
    public static Collection<LocalQuickFix> sortAndFilter(@NotNull Collection<LocalQuickFix> fixes) {
        if (fixes == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(10);
        }
        if (fixes.size() > 10) {
            List<LocalQuickFix> list2 = new ArrayList<LocalQuickFix>(fixes).subList(0, 10);
            if (list2 == null) {
                JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(11);
            }
            return list2;
        }
        Collection<LocalQuickFix> collection = fixes;
        if (collection == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static ProblemHighlightType getUnresolvedReferenceHighlightType(JSReferenceExpression node) {
        if (node.getQualifier() == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    private static boolean shouldAddFixes(@NotNull PsiElement refExpression, ResolveResult @NotNull [] resolveResults, @NotNull JsModulesSuggester modulesSuggester) {
        if (refExpression == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(13);
        }
        if (modulesSuggester == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(14);
        }
        if (resolveResults == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(15);
        }
        if (JSResolveResult.isTooManyCandidatesResult(resolveResults)) {
            return false;
        }
        PsiFile file2 = refExpression.getContainingFile();
        if (new LocalReferenceResolver(file2).checkResolveResults(resolveResults)) {
            return false;
        }
        if (resolveResults.length == 0) {
            return true;
        }
        for (ResolveResult result2 : resolveResults) {
            if (result2.isValidResult()) {
                return false;
            }
            if (!modulesSuggester.isResolvedGlobally(result2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isForBrowser(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(16);
        }
        if (vf == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(17);
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        return mappings.isLibraryInScopeFor(vf, "HTML");
    }

    protected boolean isJsxSupported(@NotNull PsiElement node) {
        if (node == null) {
            JSImportReferenceQuickFixProviderBase.$$$reportNull$$$0(18);
        }
        return DialectDetector.isJSX((PsiElement)node.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesSuggester";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSImportReferenceQuickFixProviderBase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportReferenceQuickFixProviderBase";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateError";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sortAndFilter";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddFixes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isForBrowser";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isJsxSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

