/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSSuggestImportedEntityNameMacro
extends Macro {
    public String getName() {
        return "jsSuggestImportedEntityName";
    }

    @NotNull
    public String getDefaultValue() {
        return "Namespace";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        PsiElement element;
        if (params == null) {
            JSSuggestImportedEntityNameMacro.$$$reportNull$$$0(0);
        }
        if ((element = context.getPsiElementAtStartOffset()) == null) {
            return null;
        }
        ES6ImportExportDeclaration contextOfType = (ES6ImportExportDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{ES6ImportExportDeclaration.class});
        if (contextOfType == null) {
            return null;
        }
        ES6FromClause fromClause = contextOfType.getFromClause();
        if (fromClause == null) {
            return new TextResult(this.getDefaultValue());
        }
        String referenceText = fromClause.getReferenceText();
        if (referenceText == null) {
            return null;
        }
        if ((referenceText = StringUtil.unquoteString((String)referenceText)).length() == 0) {
            referenceText = "_";
        }
        StringBuilder builder = new StringBuilder(referenceText);
        for (int i = 0; i < referenceText.length(); ++i) {
            char c = referenceText.charAt(i);
            if ((i != 0 || StringUtil.isJavaIdentifierStart((char)c)) && (i == 0 || StringUtil.isJavaIdentifierPart((char)c))) continue;
            builder.setCharAt(i, '_');
        }
        return new TextResult(builder.toString());
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return JSMacroUtil.isJSLikeContext(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/lang/javascript/macro/JSSuggestImportedEntityNameMacro", "calculateResult"));
    }
}

