/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.liveTemplates.JSLikeTemplateContextType;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMacroUtil {
    public static JSNamedElement[] getNamedElementsVisibleAt(ExpressionContext context) {
        return JSMacroUtil.getNamedElementsVisibleAt(context, true);
    }

    public static JSNamedElement[] getNamedElementsVisibleAt(final ExpressionContext context, final boolean skipElementsInsideTemplate) {
        final PsiElement elementFromContext = JSMacroUtil.getElementFromContext(context);
        final LinkedHashSet vars = new LinkedHashSet();
        if (elementFromContext != null) {
            final int elementFromContextOffset = InjectedLanguageManager.getInstance((Project)context.getProject()).injectedToHost(elementFromContext, elementFromContext.getTextOffset());
            ResolveProcessor processor = new ResolveProcessor(null){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element instanceof JSNamedElement) {
                        int varOffset = InjectedLanguageManager.getInstance((Project)context.getProject()).injectedToHost(element, element.getTextOffset());
                        if (skipElementsInsideTemplate) {
                            if (varOffset < context.getTemplateStartOffset() || varOffset > context.getTemplateEndOffset()) {
                                vars.add((JSNamedElement)element);
                            }
                        } else if (varOffset < elementFromContextOffset || varOffset > elementFromContextOffset + elementFromContext.getTextLength()) {
                            vars.add((JSNamedElement)element);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/macro/JSMacroUtil$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            processor.setLocalResolve(true);
            JSResolveUtil.treeWalkUp(processor, elementFromContext, elementFromContext.getParent(), elementFromContext);
        }
        return vars.toArray(new JSNamedElement[0]);
    }

    @Nullable
    public static PsiElement getElementFromContext(ExpressionContext context) {
        Project project = context.getProject();
        Editor editor = context.getEditor();
        if (editor == null) {
            return null;
        }
        int offset = context.getStartOffset();
        int delta = offset - editor.getCaretModel().getOffset();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file2 = psiDocumentManager.getPsiFile(editor.getDocument());
        if (file2 instanceof XmlFile) {
            PsiFile injFile;
            Editor injEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file2, (int)offset);
            if (injEditor instanceof EditorWindow && (injFile = ((EditorWindow)injEditor).getInjectedFile()) != null) {
                int injOffset = injEditor.getCaretModel().getOffset();
                return injFile.findElementAt(injOffset + delta);
            }
            if (!(file2 instanceof HtmlFileImpl)) {
                return null;
            }
        }
        return file2 == null ? null : file2.findElementAt(offset);
    }

    public static boolean isJSLikeContext(TemplateContextType type) {
        return type instanceof JSLikeTemplateContextType || type != null && JSMacroUtil.isJSLikeContext(type.getBaseContextType());
    }
}

