/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintDocumentation;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileType;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintOptionCompletionObject;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.HintHint;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String result2 = null;
        if (element != null) {
            result2 = this.doGenerateDoc(element);
        }
        if (result2 == null && originalElement != null) {
            result2 = this.doGenerateDoc(originalElement.getParent());
        }
        return result2;
    }

    @Nullable
    public String doGenerateDoc(@NotNull PsiElement element) {
        String name;
        JSHintOption option;
        PsiElement keyElement;
        JsonProperty property;
        if (element == null) {
            JSHintConfigDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (JSHintConfigFileUtil.isJSHintConfigFile(element) && (property = JSLinterConfigFileUtil.getProperty(element)) != null && (keyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property)) == element && (option = JSHintOption.findByName(name = StringUtil.stripQuotesAroundValue((String)element.getText()))) != null) {
            JSHintDocumentation documentation = JSHintDocumentation.getInstance();
            String html = documentation.getHtmlDescriptionByOption(option);
            if (html == null) {
                return null;
            }
            Component comp = null;
            HintHint hintHint = new HintHint(comp, new Point(0, 0));
            return HintUtil.prepareHintText((String)html, (HintHint)hintHint);
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof JSHintOptionCompletionObject) {
            Project project;
            JSHintOptionCompletionObject option = (JSHintOptionCompletionObject)object;
            Project project2 = project = psiManager != null ? psiManager.getProject() : null;
            if (project != null) {
                return JSHintConfigDocumentationProvider.generateElement(project, option.getName());
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement generateElement(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            JSHintConfigDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (key == null) {
            JSHintConfigDocumentationProvider.$$$reportNull$$$0(2);
        }
        String jsonText = "{" + StringUtil.wrapWithDoubleQuote((String)key) + ":\"\"}";
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(".jshintrc", (FileType)JSHintConfigFileType.INSTANCE, (CharSequence)jsonText);
        PsiElement[] topLevelChildren = psiFile.getChildren();
        JsonObject objectLiteralExpression = null;
        for (PsiElement child : topLevelChildren) {
            if (!(child instanceof JsonObject)) continue;
            objectLiteralExpression = (JsonObject)child;
            break;
        }
        if (objectLiteralExpression == null) {
            return null;
        }
        List properties = objectLiteralExpression.getPropertyList();
        for (JsonProperty property : properties) {
            String name;
            PsiElement psiElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property);
            if (psiElement == null || !key.equals(name = StringUtil.stripQuotesAroundValue((String)psiElement.getText()))) continue;
            return psiElement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doGenerateDoc";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

