/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EslintPanel {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final boolean myFullModeDialog;
    private final NodePackageField myEslintPackageField;
    private final JSLinterConfigFileView myConfigFileView;
    private final TextFieldWithBrowseButton myAdditionalRulesDirField;
    private final RawCommandLineEditor myExtraOptions;
    private final JPanel myPanel;
    private final JPanel myConfigurationPanel;
    private final JLabel myPackageErrorLabel;
    private final ComponentWithBrowseButton<ExpandableTextField> myWorkDirPatternsComponent;

    public EslintPanel(@NotNull Project project, boolean fullModeDialog, boolean addLeftIndent) {
        if (project == null) {
            EslintPanel.$$$reportNull$$$0(0);
        }
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myFullModeDialog = fullModeDialog;
        List<String> packageNames = Arrays.asList("eslint", "standard");
        this.myConfigFileView = new JSLinterConfigFileView(project, new JSLinterConfigFileTexts(JavaScriptBundle.message((String)"javascript.linter.configurable.config.autoSearch.title", (Object[])new Object[0]), JavaScriptBundle.message((String)"eslint.configurable.config.autoSearch.description.bodyInnerHtml", (Object[])new Object[0]), JavaScriptBundle.message((String)"eslint.configurable.config.select.config.text", (Object[])new Object[0])), null);
        this.myEslintPackageField = AutodetectLinterPackage.createNodePackageField(packageNames, this.myNodeInterpreterField, this.myConfigFileView);
        this.myWorkDirPatternsComponent = EslintPanel.createWorkDirPatternsComponent(project);
        this.myConfigFileView.setAdditionalConfigFilesProducer((NotNullProducer<List<VirtualFile>>)((NotNullProducer)() -> EslintUtil.findAllConfigsInScope(project)));
        this.myAdditionalRulesDirField = EslintPanel.createAdditionalRulesDirField(project);
        this.myExtraOptions = new RawCommandLineEditor();
        this.myConfigurationPanel = FormBuilder.createFormBuilder().addComponent((JComponent)this.myConfigFileView.getComponent()).addSeparator(4).addVerticalGap(4).addComponent(EslintPanel.createBottomComponent(this.myAdditionalRulesDirField, this.myExtraOptions)).addSeparator(8).getPanel();
        this.myPackageErrorLabel = new JLabel("");
        this.myPackageErrorLabel.setFont(UIUtil.getTitledBorderFont());
        FormBuilder mainBuilder = FormBuilder.createFormBuilder();
        mainBuilder.setHorizontalGap(10).setVerticalGap(4);
        if (addLeftIndent) {
            mainBuilder.setFormLeftIndent(10);
        }
        JPanel twoColumnsPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myNodeInterpreterField)).withLabel(NodeJsInterpreterField.getLabelTextForComponent())).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myEslintPackageField)).withLabel(JavaScriptBundle.message((String)"eslint.configurable.eslintPackage.label", (Object[])new Object[0]))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myPackageErrorLabel)).add((PanelBuilder)UI.PanelFactory.panel(this.myWorkDirPatternsComponent).withLabel(JavaScriptBundle.message((String)"eslint.configurable.label.working.directories", (Object[])new Object[0])).withComment(JavaScriptBundle.message((String)"eslint.configurable.working.directories.comment", (Object[])new Object[0]), false)).createPanel();
        JPanel panel2 = mainBuilder.addComponent((JComponent)twoColumnsPanel).addComponent((JComponent)this.myConfigurationPanel).getPanel();
        this.myEslintPackageField.addPackageRefSelectionListener((Consumer<NodePackageRef>)((Consumer)this::adjustUiForPackage));
        this.myPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel2);
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    @NotNull
    private static ComponentWithBrowseButton<ExpandableTextField> createWorkDirPatternsComponent(Project project) {
        Function parser2 = s -> StringUtil.split((String)s, (String)";");
        Function joiner = strings -> StringUtil.join((Collection)strings, (String)";");
        ExpandableTextField workDirPatternsTextField = new ExpandableTextField(parser2, joiner);
        workDirPatternsTextField.getEmptyText().setText(JavaScriptBundle.message((String)"eslint.configurable.working.dir.field.empty.text", (Object[])new Object[0]));
        ComponentWithBrowseButton component = new ComponentWithBrowseButton((JComponent)workDirPatternsTextField, null);
        component.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createMultipleFoldersDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        ComponentWithBrowseButton componentWithBrowseButton = component;
        if (componentWithBrowseButton == null) {
            EslintPanel.$$$reportNull$$$0(1);
        }
        return componentWithBrowseButton;
    }

    @NotNull
    private static JComponent createBottomComponent(@NotNull TextFieldWithBrowseButton field, @NotNull RawCommandLineEditor extraOptions) {
        if (field == null) {
            EslintPanel.$$$reportNull$$$0(2);
        }
        if (extraOptions == null) {
            EslintPanel.$$$reportNull$$$0(3);
        }
        JPanel jPanel = FormBuilder.createFormBuilder().setHorizontalGap(10).addLabeledComponent(JavaScriptBundle.message((String)"eslint.configurable.additionalRulesDir.label", (Object[])new Object[0]), (JComponent)field).addLabeledComponent(JavaScriptBundle.message((String)"eslint.configurable.extraOptions.label", (Object[])new Object[0]), (JComponent)extraOptions).getPanel();
        if (jPanel == null) {
            EslintPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    private static TextFieldWithBrowseButton createAdditionalRulesDirField(@NotNull Project project) {
        if (project == null) {
            EslintPanel.$$$reportNull$$$0(5);
        }
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)field, (String)JavaScriptBundle.message((String)"eslint.configurable.additionalRulesDir.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton = field;
        if (textFieldWithBrowseButton == null) {
            EslintPanel.$$$reportNull$$$0(6);
        }
        return textFieldWithBrowseButton;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            EslintPanel.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    public void handleEnableStatusChanged(boolean enabled) {
        NodePackageRef selectedRef = this.myEslintPackageField.getSelectedRef();
        this.adjustUiForPackage(selectedRef);
        if (selectedRef == AutodetectLinterPackage.INSTANCE) {
            this.myConfigFileView.setEnabled(false);
        }
        this.myConfigFileView.onEnabledStateChanged(enabled);
    }

    public void setState(@NotNull EslintState state) {
        if (state == null) {
            EslintPanel.$$$reportNull$$$0(8);
        }
        this.setEslintState(state);
        this.adjustUiForPackage(state.getNodePackageRef());
    }

    EslintState.Builder buildEslintState() {
        NodePackageRef selected = this.myEslintPackageField.getSelectedRef();
        EslintState.Builder builder = new EslintState.Builder();
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setEslintPackage(selected);
        String wdPatterns = EslintPanel.changeSlashesInFirstPathIfItIsWindowsAbsolutePath(((ExpandableTextField)this.myWorkDirPatternsComponent.getChildComponent()).getText().trim(), '/');
        builder.setWorkDirPatterns(wdPatterns);
        builder.setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath());
        builder.setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed());
        builder.setAdditionalRulesDirPath(FileUtil.toSystemIndependentName((String)this.myAdditionalRulesDirField.getText().trim()));
        builder.setExtraOptions(this.myExtraOptions.getText());
        return builder;
    }

    private void setEslintState(@NotNull EslintState state) {
        if (state == null) {
            EslintPanel.$$$reportNull$$$0(9);
        }
        this.myConfigurationPanel.setEnabled(true);
        this.myNodeInterpreterField.setInterpreterRef(state.getInterpreterRef());
        this.myEslintPackageField.setSelectedRef(state.getNodePackageRef());
        ((ExpandableTextField)this.myWorkDirPatternsComponent.getChildComponent()).setText(EslintPanel.changeSlashesInFirstPathIfItIsWindowsAbsolutePath(state.getWorkDirPatterns(), '\\'));
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(state.getCustomConfigFilePath());
        this.myAdditionalRulesDirField.setText(FileUtil.toSystemDependentName((String)state.getAdditionalRulesDirPath()));
        this.myExtraOptions.setText(state.getExtraOptions());
        if (this.myFullModeDialog) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myConfigFileView.setPreferredWidthToComponents();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)this.myAdditionalRulesDirField);
        }
    }

    @NotNull
    private static String changeSlashesInFirstPathIfItIsWindowsAbsolutePath(@NotNull String input, char slashInReturnedString) {
        boolean windowsAbsolutePath;
        if (input == null) {
            EslintPanel.$$$reportNull$$$0(10);
        }
        if (!SystemInfo.isWindows) {
            String string = input;
            if (string == null) {
                EslintPanel.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (input.isEmpty()) {
            String string = input;
            if (string == null) {
                EslintPanel.$$$reportNull$$$0(12);
            }
            return string;
        }
        int semicolonIndex = input.indexOf(59);
        String firstPath = semicolonIndex < 0 ? input : input.substring(0, semicolonIndex);
        boolean bl = windowsAbsolutePath = firstPath.length() > 2 && firstPath.charAt(1) == ':' && ('\\' == firstPath.charAt(2) || '/' == firstPath.charAt(2)) && OSAgnosticPathUtil.isDriveLetter((char)firstPath.charAt(0));
        if (windowsAbsolutePath) {
            char oldChar = slashInReturnedString == '\\' ? (char)'/' : '\\';
            String string = firstPath.replace(oldChar, slashInReturnedString) + (semicolonIndex > 0 ? input.substring(semicolonIndex) : "");
            if (string == null) {
                EslintPanel.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = input;
        if (string == null) {
            EslintPanel.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void adjustUiForPackage(NodePackageRef nodePackage) {
        this.myPackageErrorLabel.setText(JSLinterUtil.getRedErrorTextHtml(EslintPanel.formatErrorMessage(nodePackage)));
        this.myConfigurationPanel.setVisible(!EslintPanel.isStandardJs(nodePackage));
    }

    @NotNull
    @InspectionMessage
    private static String formatErrorMessage(@NotNull NodePackageRef packageRef) {
        NodePackage pkg;
        if (packageRef == null) {
            EslintPanel.$$$reportNull$$$0(15);
        }
        if ((pkg = packageRef.getConstantPackage()) == null) {
            return "";
        }
        if (pkg.getSystemDependentPath().trim().isEmpty()) {
            String string = JavaScriptBundle.message((String)"javascript.linter.error.empty.path", (Object[])new Object[0]);
            if (string == null) {
                EslintPanel.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (!pkg.isValid()) {
            String string = JavaScriptBundle.message((String)"eslint.error.package.directory.expected", (Object[])new Object[0]);
            if (string == null) {
                EslintPanel.$$$reportNull$$$0(17);
            }
            return string;
        }
        return "";
    }

    public static boolean isStandardJs(@NotNull NodePackageRef nodePackage) {
        NodePackage constantPackage;
        if (nodePackage == null) {
            EslintPanel.$$$reportNull$$$0(18);
        }
        String packageName = (constantPackage = nodePackage.getConstantPackage()) != null ? constantPackage.getName() : null;
        return "standard".equals(packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraOptions";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkDirPatternsComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createBottomComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalRulesDirField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "changeSlashesInFirstPathIfItIsWindowsAbsolutePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "formatErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createBottomComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalRulesDirField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setEslintState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "changeSlashesInFirstPathIfItIsWindowsAbsolutePath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isStandardJs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

