/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterView;
import com.intellij.lang.javascript.linter.NewLinterView;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintPanel;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.FormBuilder;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EslintConfigurable
extends UntypedJSLinterConfigurable {
    public static final String ID = "settings.javascript.linters.eslint";

    public EslintConfigurable(@NotNull Project project) {
        if (project == null) {
            EslintConfigurable.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    public EslintConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            EslintConfigurable.$$$reportNull$$$0(1);
        }
        super(project, fullModeDialog);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return JavaScriptBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected JSLinterView<EslintState> createView() {
        return new NewEslintView(this.getProject(), this.getDisplayName(), new EslintPanel(this.getProject(), this.isFullModeDialog(), false));
    }

    public void reset() {
        JSLinterView<EslintState> view = this.getEslintView();
        if (view == null) {
            return;
        }
        view.setExtendedState(this.loadUiState());
        if (view instanceof NewLinterView) {
            ((NewLinterView)view).reset();
        }
        this.resizeDialogToFitPreferredSize(view);
    }

    public void apply() {
        JSLinterView<EslintState> view = this.getEslintView();
        if (view == null) {
            return;
        }
        ExtendedLinterState<EslintState> extendedStateFromUi = view.getExtendedState();
        EslintState eslintStateFromUi = extendedStateFromUi.getState();
        boolean isStandardJS = EslintPanel.isStandardJs(eslintStateFromUi.getNodePackageRef());
        if (isStandardJS) {
            NodePackage nodePackage = Objects.requireNonNull(eslintStateFromUi.getNodePackageRef().getConstantPackage());
            StandardJSState standardJsState = new StandardJSState(eslintStateFromUi.getInterpreterRef(), nodePackage);
            this.setExtendedState(ExtendedLinterState.create(extendedStateFromUi.isEnabled(), standardJsState), StandardJSConfiguration.class);
            EslintState eslintState = new EslintState.Builder(EslintState.DEFAULT).setRunOnSave(eslintStateFromUi.isRunOnSave()).build();
            this.setExtendedState(ExtendedLinterState.create(false, eslintState), EslintConfiguration.class);
        } else {
            this.setExtendedState(ExtendedLinterState.create(false, StandardJSState.DEFAULT), StandardJSConfiguration.class);
            this.setExtendedState(ExtendedLinterState.create(extendedStateFromUi.isEnabled(), eslintStateFromUi), EslintConfiguration.class);
        }
        if (view instanceof NewLinterView) {
            ((NewLinterView)view).apply();
        }
        EslintLanguageServiceManager.getInstance(this.myProject).terminateServices();
        StandardJSLanguageServiceManager.getInstance(this.myProject).terminateServices();
    }

    @Override
    public boolean isModified() {
        JSLinterView<EslintState> view = this.getEslintView();
        if (view == null) {
            return false;
        }
        return !this.loadUiState().equals(view.getExtendedState()) || view instanceof NewLinterView && ((NewLinterView)view).isModified();
    }

    private JSLinterView<EslintState> getEslintView() {
        return this.myView;
    }

    @NotNull
    private ExtendedLinterState<EslintState> loadUiState() {
        ExtendedLinterState eslintExtendedState = this.getExtendedState(EslintConfiguration.class);
        ExtendedLinterState standardJsExtendedState = this.getExtendedState(StandardJSConfiguration.class);
        EslintState eslintState = (EslintState)eslintExtendedState.getState();
        StandardJSState standardJSState = (StandardJSState)standardJsExtendedState.getState();
        boolean isStandardJS = standardJsExtendedState.isEnabled();
        EslintState uiState = isStandardJS ? new EslintState.Builder().setEslintPackage(NodePackageRef.create(standardJSState.getNodePackage())).setInterpreterRef(standardJSState.getInterpreterRef()).setRunOnSave(eslintState.isRunOnSave()).build() : eslintState;
        ExtendedLinterState<EslintState> extendedLinterState = ExtendedLinterState.create(eslintExtendedState.isEnabled() || standardJsExtendedState.isEnabled(), uiState);
        if (extendedLinterState == null) {
            EslintConfigurable.$$$reportNull$$$0(2);
        }
        return extendedLinterState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUiState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NewEslintView
    extends NewLinterView<EslintState> {
        private final EslintPanel myEslintPanel;
        private JCheckBox myRunOnSaveCheckBox;
        private boolean myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisbled;

        NewEslintView(Project project, String displayName, EslintPanel eslintPanel) {
            super(project, displayName, eslintPanel.getComponent(), ".eslintrc.*");
            this.myEslintPanel = eslintPanel;
        }

        @Override
        protected void addBottomComponents(@NotNull FormBuilder builder) {
            if (builder == null) {
                NewEslintView.$$$reportNull$$$0(0);
            }
            this.myRunOnSaveCheckBox = new JCheckBox(JavaScriptBundle.message((String)"eslint.run.on.save", (Object[])new Object[0]));
            builder.addVerticalGap(8);
            builder.addComponent((JComponent)this.myRunOnSaveCheckBox);
        }

        @Override
        protected void setState(@NotNull EslintState state) {
            if (state == null) {
                NewEslintView.$$$reportNull$$$0(1);
            }
            this.myEslintPanel.setState(state);
            this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisbled = state.isRunOnSave();
            this.myRunOnSaveCheckBox.setSelected(state.isRunOnSave());
        }

        @Override
        @NotNull
        protected EslintState getStateWithConfiguredAutomatically() {
            EslintState eslintState = new EslintState.Builder(EslintState.DEFAULT).setRunOnSave(this.myRunOnSaveCheckBox.isSelected()).build();
            if (eslintState == null) {
                NewEslintView.$$$reportNull$$$0(2);
            }
            return eslintState;
        }

        @Override
        protected void handleEnabledStatusChanged(boolean enabled) {
            this.myEslintPanel.handleEnableStatusChanged(enabled);
            boolean checkBoxWasEnabled = this.myRunOnSaveCheckBox.isEnabled();
            this.myRunOnSaveCheckBox.setEnabled(enabled);
            if (checkBoxWasEnabled && !enabled) {
                this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisbled = this.myRunOnSaveCheckBox.isSelected();
                this.myRunOnSaveCheckBox.setSelected(false);
            }
            if (!checkBoxWasEnabled && enabled) {
                this.myRunOnSaveCheckBox.setSelected(this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisbled);
            }
        }

        @Override
        @NotNull
        protected EslintState getState() {
            EslintState.Builder builder = this.myEslintPanel.buildEslintState();
            builder.setRunOnSave(this.myRunOnSaveCheckBox.isEnabled() && this.myRunOnSaveCheckBox.isSelected());
            EslintState eslintState = builder.build();
            if (eslintState == null) {
                NewEslintView.$$$reportNull$$$0(3);
            }
            return eslintState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$NewEslintView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$NewEslintView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateWithConfiguredAutomatically";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addBottomComponents";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

