/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterFixAction
extends AnAction {
    @NotNull
    private final Supplier<String> myLinterName;

    public JSLinterFixAction(@NotNull @NonNls String linterName, @Nullable String description, @Nullable Icon icon) {
        if (linterName == null) {
            JSLinterFixAction.$$$reportNull$$$0(0);
        }
        this(() -> linterName, () -> description, icon);
    }

    public JSLinterFixAction(@NotNull Supplier<String> linterName, @NotNull Supplier<String> description, @Nullable Icon icon) {
        if (linterName == null) {
            JSLinterFixAction.$$$reportNull$$$0(1);
        }
        if (description == null) {
            JSLinterFixAction.$$$reportNull$$$0(2);
        }
        super(JavaScriptBundle.messagePointer((String)"javascript.linter.action.fix.problems.name", (Object[])new Object[]{linterName.get()}), description, icon);
        this.myLinterName = linterName;
    }

    @NotNull
    protected abstract JSLinterConfiguration getConfiguration(Project var1);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JSLinterFixAction.$$$reportNull$$$0(3);
        }
        boolean enabled = new Helper(e.getDataContext()).enabled();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            JSLinterFixAction.$$$reportNull$$$0(4);
        }
        Helper helper = new Helper(e.getDataContext());
        this.actionPerformedImpl(helper, true, false);
    }

    public void processFiles(@NotNull Project project, VirtualFile @NotNull [] files, boolean allowInteractivity, boolean modalProgress) {
        if (project == null) {
            JSLinterFixAction.$$$reportNull$$$0(5);
        }
        if (files == null) {
            JSLinterFixAction.$$$reportNull$$$0(6);
        }
        this.actionPerformedImpl(new Helper(project, files), allowInteractivity, modalProgress);
    }

    private void actionPerformedImpl(@NotNull Helper helper, boolean allowInteractivity, boolean modalProgress) {
        int result2;
        if (helper == null) {
            JSLinterFixAction.$$$reportNull$$$0(7);
        }
        if (!helper.enabled()) {
            return;
        }
        VirtualFile[] selected = helper.getFiles();
        if (allowInteractivity && (selected.length > 1 || selected.length == 1 && selected[0].isDirectory()) && (result2 = Messages.showOkCancelDialog((Project)helper.getProject(), (String)JavaScriptBundle.message((String)"javascript.linter.action.fix.prompt", (Object[])new Object[]{this.myLinterName.get()}), (String)this.getTemplatePresentation().getText(), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        Collection<VirtualFile> fromScope = helper.getFilesFromScope();
        if (!this.preProcess(helper, fromScope)) {
            return;
        }
        Runnable completeCallback = this.needRefreshFilesAfter() ? this.getRefreshFilesCallback(fromScope) : EmptyRunnable.getInstance();
        Task task = this.createTask(helper.getProject(), fromScope, completeCallback, modalProgress);
        ProgressManager.getInstance().run(task);
    }

    private boolean preProcess(@NotNull Helper helper, Collection<VirtualFile> fromScope) {
        if (helper == null) {
            JSLinterFixAction.$$$reportNull$$$0(8);
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        this.saveDocumentsIfNeeded(fileDocumentManager);
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)helper.getProject()).ensureFilesWritable(fromScope);
        if (operationStatus.hasReadonlyFiles()) {
            return false;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)helper.getProject());
        for (Document document2 : psiDocumentManager.getUncommittedDocuments()) {
            if (!this.shouldSaveBeforeToolInvocation(fileDocumentManager.getFile(document2)) && !fromScope.contains(fileDocumentManager.getFile(document2))) continue;
            psiDocumentManager.commitDocument(document2);
        }
        this.saveDocumentsIfNeeded(fileDocumentManager);
        return true;
    }

    private void saveDocumentsIfNeeded(@NotNull FileDocumentManager fileDocumentManager) {
        if (fileDocumentManager == null) {
            JSLinterFixAction.$$$reportNull$$$0(9);
        }
        for (Document document2 : fileDocumentManager.getUnsavedDocuments()) {
            if (!this.shouldSaveBeforeToolInvocation(fileDocumentManager.getFile(document2))) continue;
            fileDocumentManager.saveDocument(document2);
        }
    }

    protected boolean shouldSaveBeforeToolInvocation(@Nullable VirtualFile file2) {
        return true;
    }

    protected Runnable getRefreshFilesCallback(@NotNull Collection<VirtualFile> filesToProcess) {
        if (filesToProcess == null) {
            JSLinterFixAction.$$$reportNull$$$0(10);
        }
        List toForceRefresh = ApplicationManager.getApplication().isUnitTestMode() ? filesToProcess : ContainerUtil.filter(filesToProcess, arg_0 -> ((FileDocumentManager)FileDocumentManager.getInstance()).isFileModified(arg_0));
        Collection toRefreshAsync = ContainerUtil.subtract(filesToProcess, toForceRefresh);
        return () -> {
            RefreshSession session = RefreshQueue.getInstance().createSession(false, false, null, ModalityState.NON_MODAL);
            session.addAllFiles(toRefreshAsync);
            session.launch();
            for (VirtualFile file2 : toForceRefresh) {
                VfsImplUtil.forceSyncRefresh((VirtualFile)file2);
            }
        };
    }

    public IntentionAction asIntentionAction() {
        return new JSLinterFixIntentionAction();
    }

    protected boolean isFileAccepted(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSLinterFixAction.$$$reportNull$$$0(11);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)JavaScriptSupportLoader.JAVASCRIPT);
    }

    protected boolean needRefreshFilesAfter() {
        return true;
    }

    protected abstract Task createTask(@NotNull Project var1, @NotNull Collection<? extends VirtualFile> var2, @NotNull Runnable var3, boolean var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDocumentManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterFixAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformedImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "preProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "saveDocumentsIfNeeded";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefreshFilesCallback";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileAccepted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class JSLinterFixIntentionAction
    extends BaseIntentionAction
    implements HighPriorityAction {
        private JSLinterFixIntentionAction() {
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message((String)"javascript.linter.action.fix.problems.file.text", (Object[])new Object[]{JSLinterFixAction.this.myLinterName.get()});
            if (string == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = StringUtil.notNullize((String)JSLinterFixAction.this.getTemplatePresentation().getText());
            if (string == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(2);
            }
            return file2 != null && new Helper(project, new VirtualFile[]{file2.getVirtualFile()}).enabled();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                return;
            }
            JSLinterFixAction.this.processFiles(project, new VirtualFile[]{file2.getVirtualFile()}, true, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterFixAction$JSLinterFixIntentionAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterFixAction$JSLinterFixIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class Helper {
        private final Project myProject;
        private final VirtualFile[] myFiles;

        Helper(DataContext dataContext) {
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            this.myFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        }

        Helper(@NotNull Project project, VirtualFile[] files) {
            if (project == null) {
                Helper.$$$reportNull$$$0(0);
            }
            if (files == null) {
                Helper.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFiles = files;
        }

        public boolean enabled() {
            if (this.myProject == null) {
                return false;
            }
            if (!JSLinterFixAction.this.getConfiguration(this.myProject).isEnabled()) {
                return false;
            }
            if (this.myFiles == null) {
                return false;
            }
            VirtualFileFilter filter = this.getFilter(GlobalSearchScope.projectScope((Project)this.myProject));
            return Arrays.stream(this.myFiles).anyMatch(arg_0 -> ((VirtualFileFilter)filter).accept(arg_0));
        }

        @NotNull
        private VirtualFileFilter getFilter(GlobalSearchScope projectScope) {
            VirtualFileFilter virtualFileFilter = file2 -> projectScope.contains(file2) && (file2.isDirectory() || JSLinterFixAction.this.isFileAccepted(file2));
            if (virtualFileFilter == null) {
                Helper.$$$reportNull$$$0(2);
            }
            return virtualFileFilter;
        }

        public Project getProject() {
            return this.myProject;
        }

        public VirtualFile[] getFiles() {
            return this.myFiles;
        }

        public Collection<VirtualFile> getFilesFromScope() {
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
            for (VirtualFile fileOrDir : this.myFiles) {
                VfsUtilCore.iterateChildrenRecursively((VirtualFile)fileOrDir, (VirtualFileFilter)this.getFilter(projectScope), file2 -> {
                    result2.add(file2);
                    return true;
                });
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterFixAction$Helper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterFixAction$Helper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

