/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.typings;

import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsContributor;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsService;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsServiceKt;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsServiceKt$sam$java_lang_Runnable$0;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsServiceState;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TypeScriptExternalDefinitions", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\"B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016J\b\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\u000bJ\u0006\u0010!\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsServiceState;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/Alarm;", "usedExternalDefinitions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/util/text/SemVer;", "cacheInstalledDefinition", "", "typingsPackage", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "dispose", "evictInstalledDefinitionFromCache", "packageName", "fireRootsChanged", "getCachedExternalDefinitions", "", "getState", "installForProject", "installTypeDefinitionsPackage", "", "registry", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "loadState", "state", "resolveCachedExternalDefinitionForPackage", "sourcePackage", "scheduleUpdate", "Companion", "intellij.javascript.impl"})
@ApiStatus.Experimental
public final class TypeScriptExternalDefinitionsService
implements PersistentStateComponent<TypeScriptExternalDefinitionsServiceState>,
Disposable {
    private final Alarm alarm;
    private final ConcurrentHashMap<String, SemVer> usedExternalDefinitions;
    private final Project project;
    public static final Companion Companion = new Companion(null);

    public final void scheduleUpdate() {
        if (!TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            return;
        }
        if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Scheduling update. Used definitions: " + this.getCachedExternalDefinitions(), new Throwable());
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.installForProject();
        } else {
            this.alarm.cancelAllRequests();
            Function0 function0 = (Function0)new Function0<Unit>(this){

                public final void invoke() {
                    TypeScriptExternalDefinitionsService.access$installForProject((TypeScriptExternalDefinitionsService)this.receiver);
                }
            };
            this.alarm.addRequest((Runnable)new TypeScriptExternalDefinitionsServiceKt$sam$java_lang_Runnable$0(function0), 3000L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<TypeScriptPackageName> getCachedExternalDefinitions() {
        Set set;
        if (TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            void var2_2;
            void $this$mapTo$iv;
            Map map = this.usedExternalDefinitions;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            void var4_4 = $this$mapTo$iv;
            boolean bl = false;
            Iterator iterator = var4_4.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv;
                Map.Entry entry = item$iv = iterator.next();
                Collection collection = destination$iv;
                boolean bl2 = false;
                TypeScriptPackageName typeScriptPackageName = new TypeScriptPackageName((String)it.getKey(), (SemVer)it.getValue());
                collection.add(typeScriptPackageName);
            }
            set = (Set)var2_2;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Nullable
    public final TypeScriptPackageName resolveCachedExternalDefinitionForPackage(@NotNull String sourcePackage) {
        TypeScriptPackageName typeScriptPackageName;
        Intrinsics.checkNotNullParameter((Object)sourcePackage, (String)"sourcePackage");
        if (!TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            return null;
        }
        String packageName = TypeScriptDefinitionsUtils.getTypingsPackageName(sourcePackage);
        SemVer semVer = this.usedExternalDefinitions.get(packageName);
        if (semVer != null) {
            SemVer semVer2 = semVer;
            boolean bl = false;
            boolean bl2 = false;
            SemVer it = semVer2;
            boolean bl3 = false;
            typeScriptPackageName = new TypeScriptPackageName(packageName, it);
        } else {
            typeScriptPackageName = null;
        }
        return typeScriptPackageName;
    }

    private final void evictInstalledDefinitionFromCache(String packageName) {
        this.usedExternalDefinitions.remove(packageName);
    }

    private final void cacheInstalledDefinition(TypeScriptPackageName typingsPackage) {
        boolean bl = TypeScriptDefinitionsUtils.isTypingsPackage(typingsPackage.getName());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = typingsPackage.getName();
        SemVer semVer = typingsPackage.getVersion();
        Intrinsics.checkNotNull((Object)semVer);
        this.usedExternalDefinitions.put(string, semVer);
    }

    /*
     * WARNING - void declaration
     */
    private final void installForProject() {
        block13: {
            Set removedDefinitions;
            HashSet<String> changedDefinitions;
            block12: {
                void $this$forEach$iv;
                if (this.project.isDisposed() || !TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
                    return;
                }
                if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
                    TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Install type definitions for project [" + this.project.getName() + "] started");
                }
                HashSet<String> definitions = new HashSet<String>();
                changedDefinitions = new HashSet<String>();
                TypeScriptExternalDefinitionsRegistry registry = TypeScriptExternalDefinitionsRegistry.Companion.getInstance();
                for (TypeScriptExternalDefinitionsContributor contributor : TypeScriptExternalDefinitionsContributor.Companion.getEP_NAME().getExtensionList()) {
                    for (TypeScriptPackageName typeDefinition : contributor.getTypeDefinitions(this.project)) {
                        if (!TypeScriptDefinitionsUtils.isTypingsPackage(typeDefinition.getName()) || typeDefinition.getVersion() == null) {
                            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Invalid type definition package contributed: " + typeDefinition);
                            continue;
                        }
                        if (!definitions.add(typeDefinition.getName())) continue;
                        if (registry.ensureExternalDefinitionsInstalled$intellij_javascript_impl(typeDefinition)) {
                            if (this.usedExternalDefinitions.containsKey(typeDefinition.getName())) continue;
                            changedDefinitions.add(typeDefinition.getName());
                            this.cacheInstalledDefinition(typeDefinition);
                            continue;
                        }
                        if (!this.installTypeDefinitionsPackage(typeDefinition, registry)) continue;
                        if (registry.ensureExternalDefinitionsInstalled$intellij_javascript_impl(typeDefinition)) {
                            changedDefinitions.add(typeDefinition.getName());
                            this.cacheInstalledDefinition(typeDefinition);
                            continue;
                        }
                        TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Installation completed but not succeeded: " + typeDefinition);
                    }
                }
                ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)this.usedExternalDefinitions.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)keySetView, (String)"usedExternalDefinitions.keys");
                removedDefinitions = SetsKt.minus((Set)keySetView, (Iterable)definitions);
                Object object = removedDefinitions;
                TypeScriptExternalDefinitionsService typeScriptExternalDefinitionsService = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p1 = (String)element$iv;
                    boolean bl = false;
                    typeScriptExternalDefinitionsService.evictInstalledDefinitionFromCache(p1);
                }
                object = changedDefinitions;
                boolean bl = false;
                if (!object.isEmpty()) break block12;
                object = removedDefinitions;
                bl = false;
                if (!(!object.isEmpty())) break block13;
            }
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().info("Type definition roots changed: project [" + this.project.getName() + "], added/updated " + changedDefinitions + ", removed: " + removedDefinitions);
            this.fireRootsChanged();
        }
        if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Install type definitions for project [" + this.project.getName() + "] completed");
        }
    }

    private final void fireRootsChanged() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.project, (Runnable)new Runnable(this){
            final /* synthetic */ TypeScriptExternalDefinitionsService this$0;

            public final void run() {
                WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(this){
                    final /* synthetic */ fireRootsChanged.1 this$0;

                    public final void run() {
                        ProjectRootManagerEx.getInstanceEx((Project)TypeScriptExternalDefinitionsService.access$getProject$p(this.this$0.this$0)).makeRootsChange(EmptyRunnable.getInstance(), false, true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = typeScriptExternalDefinitionsService;
            }
        });
    }

    private final boolean installTypeDefinitionsPackage(TypeScriptPackageName typingsPackage, TypeScriptExternalDefinitionsRegistry registry) {
        try {
            boolean installed;
            if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
                TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Begin typings package installation: " + typingsPackage);
            }
            boolean bl = installed = registry.installPackage(typingsPackage, this.project, null).get(2L, TimeUnit.MINUTES) != null;
            if (!installed) {
                TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Package " + typingsPackage + " is not installed");
            }
            return installed;
        }
        catch (Exception e) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Unable to install package " + typingsPackage, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TypeScriptExternalDefinitionsServiceState getState() {
        void $this$mapValuesTo$iv;
        Map map = this.usedExternalDefinitions;
        Map destination$iv = new HashMap();
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = destination$iv;
            boolean bl = false;
            Object k = it$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            String string = ((SemVer)it.getValue()).getParsedVersion();
            map3.put(k2, string);
        }
        HashMap packages = (HashMap)destination$iv;
        return packages.isEmpty() ? TypeScriptExternalDefinitionsServiceKt.access$getEMPTY_STATE$p() : new TypeScriptExternalDefinitionsServiceState(packages);
    }

    public void loadState(@NotNull TypeScriptExternalDefinitionsServiceState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = state.getPackages();
        boolean bl = false;
        for (Map.Entry<String, String> entry : object.entrySet()) {
            object = entry.getValue();
            bl = false;
            if (!(object.length() > 0)) continue;
            this.cacheInstalledDefinition(TypeScriptPackageName.Companion.from(entry.getKey(), entry.getValue()));
        }
    }

    public void dispose() {
    }

    public TypeScriptExternalDefinitionsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.usedExternalDefinitions = new ConcurrentHashMap();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(PackageJsonFileManager.TOPIC, (Object)new PackageJsonFileManager.PackageJsonChangeListener(){

            @Override
            public final void onChange(@NotNull PackageJsonFileManager.PackageJsonChangeEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.scheduleUpdate();
            }
        });
        connection.subscribe(JSLibraryManager.TOPIC, (Object)new JSLibraryManager.JSLibraryManagerChangeListener(){

            @Override
            public final void onChange() {
                this.scheduleUpdate();
            }
        });
        Registry.get((String)"typescript.external.type.definitions").addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.fireRootsChanged();
            }
        }, (Disposable)this);
    }

    public static final /* synthetic */ void access$installForProject(TypeScriptExternalDefinitionsService $this) {
        $this.installForProject();
    }

    public static final /* synthetic */ Project access$getProject$p(TypeScriptExternalDefinitionsService $this) {
        return $this.project;
    }

    @JvmStatic
    @NotNull
    public static final TypeScriptExternalDefinitionsService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService$Companion;", "", "()V", "getInstance", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TypeScriptExternalDefinitionsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(TypeScriptExternalDefinitionsService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (TypeScriptExternalDefinitionsService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

