/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Stack;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bH\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptRelatedPackagesCollector;", "", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "modulesDirectory", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "collectFullPackageNames", "", "", "collectPackageNames", "nameGetter", "Lkotlin/Function1;", "collectShortPackageNames", "intellij.javascript.impl"})
public final class TypeScriptRelatedPackagesCollector {
    private final VirtualFile packageDirectory;
    private final VirtualFile modulesDirectory;

    @NotNull
    public final Set<String> collectShortPackageNames() {
        return this.collectPackageNames((Function1<? super String, String>)((Function1)collectShortPackageNames.1.INSTANCE));
    }

    @NotNull
    public final Set<String> collectFullPackageNames() {
        return this.collectPackageNames((Function1<? super String, String>)((Function1)collectFullPackageNames.1.INSTANCE));
    }

    private final Set<String> collectPackageNames(Function1<? super String, String> nameGetter) {
        VirtualFile mainPackageJson = PackageJsonUtil.findChildPackageJsonFile(this.packageDirectory);
        if (mainPackageJson == null) {
            return SetsKt.emptySet();
        }
        boolean bl = false;
        Set result2 = new LinkedHashSet();
        Stack toProcess = new Stack((Object[])new VirtualFile[]{mainPackageJson});
        Set processedPackageJsonFiles = SetsKt.mutableSetOf((Object[])new VirtualFile[]{mainPackageJson});
        while (!toProcess.isEmpty()) {
            PackageJsonData data;
            VirtualFile currentPackageJson = (VirtualFile)toProcess.pop();
            Intrinsics.checkNotNullExpressionValue((Object)PackageJsonData.getOrCreate(currentPackageJson), (String)"PackageJsonData.getOrCreate(currentPackageJson)");
            Iterator<String> iterator = data.getAllDependencies().iterator();
            while (iterator.hasNext()) {
                String dependency;
                String string = dependency = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependency");
                String string2 = (String)nameGetter.invoke((Object)string);
                if (string2 == null) continue;
                String string3 = string2;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string3;
                boolean bl4 = false;
                CharSequence charSequence = it;
                boolean bl5 = false;
                string2 = charSequence.length() > 0 ? string3 : null;
                if (string2 == null) {
                    continue;
                }
                String dependencyName = string2;
                VirtualFile directory = this.modulesDirectory.findFileByRelativePath(dependencyName);
                VirtualFile candidatePackageJson = PackageJsonUtil.findChildPackageJsonFile(directory);
                if (directory == null || candidatePackageJson == null || !processedPackageJsonFiles.add(candidatePackageJson)) continue;
                result2.add(dependencyName);
                toProcess.add((Object)candidatePackageJson);
            }
        }
        return result2;
    }

    public TypeScriptRelatedPackagesCollector(@NotNull VirtualFile packageDirectory, @NotNull VirtualFile modulesDirectory) {
        Intrinsics.checkNotNullParameter((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkNotNullParameter((Object)modulesDirectory, (String)"modulesDirectory");
        this.packageDirectory = packageDirectory;
        this.modulesDirectory = modulesDirectory;
    }
}

