/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatingVisitor;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.typescript.inspections.TypeScriptSmartCastInspection;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptDisableSmartCastIntention
extends JSFixFactory.FixWithComponent
implements LowPriorityAction {
    private static final String TYPESCRIPT = "TypeScript";

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"typescript.type.guard.name.disable", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"typescript.type.guard.name.disable", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiElement element;
        if (project == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(2);
        }
        if ((element = file2.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return false;
        }
        JSReferenceExpression expression = PsiUtilCore.getElementType((PsiElement)element) == JSTokenTypes.IDENTIFIER ? (JSReferenceExpression)ObjectUtils.tryCast((Object)element.getParent(), JSReferenceExpression.class) : null;
        return expression != null && TypeScriptAnnotatingVisitor.isSmartCastInspectionEnabled(expression) && JSTypeGuardUtil.getTypeIfAffectedByTypeGuard(expression) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(3);
        }
        TypeScriptDisableSmartCastIntention.doEnable(project, false);
        TypeScriptDisableSmartCastIntention.showHint(project);
    }

    private static void doEnable(@NotNull Project project, boolean enabled) {
        if (project == null) {
            TypeScriptDisableSmartCastIntention.$$$reportNull$$$0(4);
        }
        String id = JSInspection.calcShortNameFromClass(TypeScriptSmartCastInspection.class);
        InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile().setToolEnabled(id, enabled);
        for (Project it : ProjectManager.getInstance().getOpenProjects()) {
            PsiManager psiManager = PsiManager.getInstance((Project)it);
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)it);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)it);
            for (VirtualFile selectedFile : fileEditorManager.getSelectedFiles()) {
                PsiFile psiFile = psiManager.findFile(selectedFile);
                if (psiFile == null) continue;
                daemonCodeAnalyzer.restart();
            }
        }
    }

    private static void showHint(final Project project) {
        NotificationListener.Adapter listener2 = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                if (notification2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                switch (event.getDescription()) {
                    case "settings": {
                        this.showSettings();
                        break;
                    }
                    case "undo": {
                        TypeScriptDisableSmartCastIntention.doEnable(project, true);
                    }
                }
                notification2.expire();
            }

            private void showSettings() {
                String id = JSInspection.calcShortNameFromClass(TypeScriptSmartCastInspection.class);
                HighlightDisplayKey key = HighlightDisplayKey.find((String)id);
                new EditInspectionToolsSettingsAction(key).editToolSettings(project, InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/intentions/TypeScriptDisableSmartCastIntention$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        new Notification("Coloring of Type Guard Narrowed Types", JavaScriptBundle.message((String)"notification.title.coloring.types.narrowed.by.type.guard.was.disabled", (Object[])new Object[0]), JavaScriptBundle.message((String)"notification.content.html.href.settings.show.inspection.settings.or.href.undo.undo.html", (Object[])new Object[0]), NotificationType.INFORMATION, (NotificationListener)listener2).notify(project);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public JComponent getComponent() {
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(TypeScriptDisableSmartCastIntention.createSettingsLink());
        return panel2;
    }

    private static JComponent createSettingsLink() {
        final HyperlinkLabel settingsLink = new HyperlinkLabel(JavaScriptBundle.message((String)"typescript.smart.cast.hyperlink", (Object[])new Object[0]));
        settingsLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)settingsLink);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return;
                }
                Settings settings = (Settings)Settings.KEY.getData(dataContext);
                if (settings == null) {
                    return;
                }
                Configurable colorSchemeConfigurable = settings.find("reference.settingsdialog.IDE.editor.colors");
                if (colorSchemeConfigurable instanceof ColorAndFontOptions) {
                    NewColorAndFontPanel page;
                    SearchableConfigurable fontOptions = ((ColorAndFontOptions)colorSchemeConfigurable).findSubConfigurable(TypeScriptDisableSmartCastIntention.TYPESCRIPT);
                    if (fontOptions != null) {
                        settings.select((Configurable)fontOptions);
                    }
                    if ((page = ((ColorAndFontOptions)colorSchemeConfigurable).findPage(TypeScriptDisableSmartCastIntention.TYPESCRIPT)) != null) {
                        UIUtil.invokeLaterIfNeeded((Runnable)page.showOption(JavaScriptBundle.message((String)"typescript.type.guard.name", (Object[])new Object[0])));
                    }
                }
            }
        });
        return settingsLink;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptDisableSmartCastIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptDisableSmartCastIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doEnable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

