/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.intentions.ES6AddExportModifierIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6RemoveExportIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.intention.remove.export.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(2);
        }
        return currentFile;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(4);
        }
        if (!super.isAvailable(project, editor, element) || !DialectDetector.hasFeature(element, JSLanguageFeature.EXPORT_DECLARATIONS)) {
            return false;
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            ES6ExportDefaultAssignment exportDefaultAssignment = (ES6ExportDefaultAssignment)element.getParent();
            return exportDefaultAssignment.getNamedElement() != null || exportDefaultAssignment.getExpression() instanceof JSReferenceExpression;
        }
        JSNamedElement declaration = ES6RemoveExportIntention.findParentNamedElement(element, JSNamedElement.class);
        return declaration instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)declaration, JSAttributeList.ModifierType.EXPORT) || declaration != null && declaration.getParent() instanceof ES6ExportDefaultAssignment;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ES6ExportDefaultAssignment exportDefaultAssignment;
        if (project == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(6);
        }
        if ((exportDefaultAssignment = (ES6ExportDefaultAssignment)PsiTreeUtil.getParentOfType((PsiElement)element, ES6ExportDefaultAssignment.class)) != null) {
            JSElement[] declarations = new JSElement[]{exportDefaultAssignment};
            if (!ES6RemoveExportIntention.checkUsagesOutsideOfFile(declarations)) {
                return;
            }
            WriteAction.run(() -> ES6RemoveExportIntention.replaceExportDefault(exportDefaultAssignment));
        } else {
            JSVarStatement statement;
            JSAttributeListOwner declaration = ES6RemoveExportIntention.findParentNamedElement(element, JSAttributeListOwner.class);
            if (declaration == null) {
                return;
            }
            Object[] declarationsToCheck = declaration instanceof JSVariable ? ((statement = ((JSVariable)declaration).getStatement()) != null ? statement.getVariables() : JSVariable.EMPTY_ARRAY) : new JSElement[]{declaration};
            if (!ES6RemoveExportIntention.checkUsagesOutsideOfFile(declarationsToCheck)) {
                return;
            }
            WriteAction.run(() -> ES6AddExportModifierIntention.applyExportStatus(declaration, false));
        }
    }

    private static void replaceExportDefault(@NotNull ES6ExportDefaultAssignment exportDefaultAssignment) {
        if (exportDefaultAssignment == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(7);
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)exportDefaultAssignment);
        JSNamedElement namedElement = exportDefaultAssignment.getNamedElement();
        if (namedElement != null) {
            JSSourceElement created = JSPsiElementFactory.createJSSourceElement(namedElement.getText(), (PsiElement)exportDefaultAssignment);
            created = (JSSourceElement)exportDefaultAssignment.replace((PsiElement)created);
            JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)created);
        } else {
            exportDefaultAssignment.delete();
        }
    }

    private static boolean checkUsagesOutsideOfFile(JSElement @NotNull [] declarations) {
        JSElement context;
        if (declarations == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(8);
        }
        if ((context = (JSElement)ArrayUtil.getFirstElement((Object[])declarations)) == null) {
            return true;
        }
        Project project = context.getProject();
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            for (JSElement declaration : declarations) {
                PsiFile declarationFile = declaration.getContainingFile();
                String elementDescription = StringUtil.capitalize((String)ElementDescriptionUtil.getElementDescription((PsiElement)ES6RemoveExportIntention.getElementForDescription(declaration), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT));
                ReferencesSearch.search((PsiElement)declaration, (SearchScope)declaration.getUseScope()).forEach(reference -> {
                    PsiElement element = reference.getElement();
                    if (element.getContainingFile() != declarationFile) {
                        String fileDescription = ElementDescriptionUtil.getElementDescription((PsiElement)element.getContainingFile(), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT);
                        conflicts.putValue((Object)element, (Object)JavaScriptBundle.message((String)"javascript.intention.remove.export.inaccessible.conflict.text", (Object[])new Object[]{elementDescription, fileDescription}));
                    }
                });
            }
        }), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project)) {
            return false;
        }
        return BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts);
    }

    @NotNull
    private static PsiElement getElementForDescription(@NotNull JSElement declaration) {
        if (declaration == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(9);
        }
        if (declaration instanceof ES6ExportDefaultAssignment) {
            PsiElement resolve;
            ES6ExportDefaultAssignment exportDefaultAssignment = (ES6ExportDefaultAssignment)declaration;
            if (exportDefaultAssignment.getNamedElement() != null) {
                JSNamedElement jSNamedElement = exportDefaultAssignment.getNamedElement();
                if (jSNamedElement == null) {
                    ES6RemoveExportIntention.$$$reportNull$$$0(10);
                }
                return jSNamedElement;
            }
            JSExpression expression = exportDefaultAssignment.getExpression();
            if (expression instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) != null) {
                PsiElement psiElement = resolve;
                if (psiElement == null) {
                    ES6RemoveExportIntention.$$$reportNull$$$0(11);
                }
                return psiElement;
            }
        }
        JSElement jSElement = declaration;
        if (jSElement == null) {
            ES6RemoveExportIntention.$$$reportNull$$$0(12);
        }
        return jSElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6RemoveExportIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDefaultAssignment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6RemoveExportIntention";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementForDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceExportDefault";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkUsagesOutsideOfFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementForDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

