/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.unusedsymbols;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class JSUnusedSymbolsVisitor
extends JSElementVisitor {
    @NotNull
    protected final BiConsumer<PsiElement, PsiElement> myConsumer;

    public JSUnusedSymbolsVisitor(@NotNull BiConsumer<PsiElement, PsiElement> consumer) {
        if (consumer == null) {
            JSUnusedSymbolsVisitor.$$$reportNull$$$0(0);
        }
        this.myConsumer = consumer;
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (!JSResolveUtil.isSelfReference((PsiElement)node) || !(node.getParent() instanceof JSNamedElement)) {
            return;
        }
        JSNamedElement parent = (JSNamedElement)node.getParent();
        if (parent instanceof JSNamedExpression) {
            return;
        }
        this.checkUnused(parent);
    }

    public void visitJSClass(JSClass aClass) {
        if (aClass instanceof JSNamedExpression && JSUnusedSymbolsVisitor.isLocalNamedExpression((JSNamedExpression)aClass)) {
            return;
        }
        this.checkUnused((JSNamedElement)aClass);
    }

    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        if (node.getExpression() != null) {
            this.myConsumer.accept((PsiElement)node, (PsiElement)node);
        }
    }

    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        ES6ExportedDefaultBinding binding = exportDeclaration.getExportedDefaultBinding();
        if (binding != null) {
            this.myConsumer.accept((PsiElement)binding, (PsiElement)binding);
        }
        ES6ExportSpecifier[] specifiers = exportDeclaration.getExportSpecifiers();
        Arrays.stream(specifiers).forEach(specifier -> {
            ES6ExportSpecifierAlias alias = specifier.getAlias();
            if (alias != null) {
                this.myConsumer.accept((PsiElement)alias, (PsiElement)specifier);
            }
        });
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            JSUnusedSymbolsVisitor.$$$reportNull$$$0(1);
        }
        if (JSUnusedSymbolsVisitor.isLocalNamedExpression((JSNamedExpression)node)) {
            return;
        }
        this.checkUnused((JSNamedElement)node);
    }

    private static boolean isLocalNamedExpression(@NotNull JSNamedExpression node) {
        PsiElement parent;
        if (node == null) {
            JSUnusedSymbolsVisitor.$$$reportNull$$$0(2);
        }
        return (parent = node.getParent()) instanceof JSProperty || parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSCallExpression || parent instanceof JSArgumentList || parent instanceof JSReturnStatement || parent instanceof JSParenthesizedExpression && parent.getParent() instanceof JSCallExpression;
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        if (node == null) {
            JSUnusedSymbolsVisitor.$$$reportNull$$$0(3);
        }
        this.checkUnused((JSNamedElement)node);
    }

    public void visitJSVariable(JSVariable node) {
        PsiElement nameIdentifier = node.getNameIdentifier();
        if (!(nameIdentifier instanceof JSReferenceExpression)) {
            this.checkUnused((JSNamedElement)node);
        }
    }

    public void visitJSDefinitionExpression(JSDefinitionExpression node) {
        PsiElement parent;
        JSExpression expression = node.getExpression();
        if (expression instanceof JSReferenceExpression && (parent = node.getParent()) instanceof JSAssignmentExpression) {
            PsiElement resolve;
            JSReferenceExpression refExpr = (JSReferenceExpression)expression;
            JSExpression rOperand = ((JSAssignmentExpression)parent).getROperand();
            if (rOperand != null && ((resolve = refExpr.resolve()) == node || resolve == rOperand)) {
                this.checkUnused((JSNamedElement)node);
            }
        }
    }

    public void visitJSProperty(JSProperty node) {
        PsiElement nameIdentifier = node.getNameIdentifier();
        if (nameIdentifier == null || !StringUtil.isJavaIdentifier((String)nameIdentifier.getText())) {
            return;
        }
        PsiPolyVariantReference reference = node.getPropertyNameReference();
        if (reference != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = reference.multiResolve(false)) {
                if (!result2.isValidResult() || result2.getElement() == node) continue;
                return;
            }
        }
        this.checkUnused((JSNamedElement)node);
    }

    protected void checkUnused(JSNamedElement namedElement) {
        if (namedElement instanceof JSPackageStatement) {
            return;
        }
        if ((namedElement instanceof JSFunction || namedElement instanceof JSField) && !JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)namedElement, (Processor<? super JSPsiElementBase>)CommonProcessors.alwaysFalse(), false)) {
            return;
        }
        PsiElement elementParent = namedElement.getParent();
        if (JSResolveUtil.isConstructorFunction((PsiElement)namedElement) && elementParent instanceof JSFile && elementParent.getContext() != null) {
            return;
        }
        String name = namedElement.getName();
        if (name == null) {
            return;
        }
        if (JSUnusedLocalSymbolsInspection.isNotGloballyDefined(namedElement)) {
            return;
        }
        JSNamedElement elementToSearchUsages = namedElement;
        boolean isConstructor = false;
        if (elementToSearchUsages instanceof JSFunction) {
            JSFunction topOverriddenMethod;
            JSFunction fun = (JSFunction)elementToSearchUsages;
            if ("toString".equals(name)) {
                return;
            }
            JSAttributeList attrList = fun.getAttributeList();
            if (attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) && (topOverriddenMethod = JSInheritanceUtil.findTopOverriddenMethod(fun)) != null) {
                elementToSearchUsages = topOverriddenMethod;
            }
            isConstructor = fun.isConstructor();
        }
        if (elementToSearchUsages instanceof JSFunction || elementToSearchUsages instanceof JSField) {
            List implementedMethods;
            Collection<Object> collection = implementedMethods = isConstructor ? Collections.emptyList() : JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)elementToSearchUsages);
            if (!implementedMethods.isEmpty()) {
                return;
            }
        }
        this.myConsumer.accept((PsiElement)elementToSearchUsages, (PsiElement)namedElement);
        if (JSResolveUtil.isConstructorFunction((PsiElement)namedElement) && elementParent instanceof JSClass) {
            this.myConsumer.accept(elementParent, (PsiElement)namedElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/unusedsymbols/JSUnusedSymbolsVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isLocalNamedExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

