/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactCreateComponentHandler;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandlerBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXCreateComponentFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myComponentName;
    private final ReactExtractComponentHandlerBase.ComponentType myComponentType;

    public JSXCreateComponentFix(@NotNull JSXmlLiteralExpression element, @NotNull ReactExtractComponentHandlerBase.ComponentType componentType) {
        if (element == null) {
            JSXCreateComponentFix.$$$reportNull$$$0(0);
        }
        if (componentType == null) {
            JSXCreateComponentFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)element);
        this.myComponentName = element.getName();
        this.myComponentType = componentType;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSXmlLiteralExpression element;
        if (project == null) {
            JSXCreateComponentFix.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JSXCreateComponentFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            JSXCreateComponentFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            JSXCreateComponentFix.$$$reportNull$$$0(5);
        }
        if ((element = (JSXmlLiteralExpression)ObjectUtils.tryCast((Object)startElement, JSXmlLiteralExpression.class)) == null) {
            return;
        }
        ReactCreateComponentHandler handler = new ReactCreateComponentHandler(element, this.myComponentName, this.myComponentType);
        handler.invoke(project, editor, file2, DataContext.EMPTY_CONTEXT);
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.myComponentType == ReactExtractComponentHandlerBase.ComponentType.Class ? JavaScriptBundle.message((String)"javascript.fix.create.class.component.jsx.name", (Object[])new Object[]{this.myComponentName}) : JavaScriptBundle.message((String)"javascript.fix.create.function.component.jsx.name", (Object[])new Object[]{this.myComponentName});
        if (string == null) {
            JSXCreateComponentFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = this.myComponentType == ReactExtractComponentHandlerBase.ComponentType.Class ? JavaScriptBundle.message((String)"javascript.fix.create.class.component.jsx.family", (Object[])new Object[0]) : JavaScriptBundle.message((String)"javascript.fix.create.function.component.jsx.family", (Object[])new Object[0]);
        if (string == null) {
            JSXCreateComponentFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSXCreateComponentFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSXCreateComponentFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

