/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuppressByCommentFix
extends SuppressByCommentFix {
    @NotNull
    @IntentionName
    private final String myText;

    public JSSuppressByCommentFix(HighlightDisplayKey key, Class<? extends PsiElement> suppressionHolderClass, @NotNull @IntentionName String text) {
        if (text == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(0);
        }
        super(key, suppressionHolderClass);
        this.myText = text;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(3);
        }
        if (container == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(4);
        }
        String text = this.getSuppressText();
        JSSuppressByCommentFix.suppressByComment(project, element, container, text);
    }

    public static void suppressByComment(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container, @NotNull String commentText) {
        if (project == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(6);
        }
        if (container == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(7);
        }
        if (commentText == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(8);
        }
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
        String text = JSCodeStyleSettings.getLineCommentPrefix(element) + commentText;
        Language language = JSInheritedLanguagesHelper.getLanguage(element);
        PsiComment comment = parserFacade.createLineOrBlockCommentFromText(language, text);
        container.getParent().addBefore((PsiElement)comment, container);
    }

    @Nullable
    public PsiElement getContainer(PsiElement context) {
        PsiElement holder = super.getContainer(context);
        if (!(holder instanceof JSSuppressionHolder)) {
            return null;
        }
        return JSInspectionSuppressor.getContainerToAnnotate((JSSuppressionHolder)holder);
    }

    @NotNull
    protected String getSuppressText() {
        String string = "noinspection " + this.myID;
        if (string == null) {
            JSSuppressByCommentFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSSuppressByCommentFix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSSuppressByCommentFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSuppression";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "suppressByComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

