/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.validation.DuplicatesCheckUtil;
import com.intellij.lang.javascript.validation.JSNavigateToAlreadyDeclaredVariableFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDuplicatedDeclarationInspection
extends JSInspection {
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSFunctionDeclaration(JSFunction node) {
                super.visitJSFunctionDeclaration(node);
                this.checkFunctionDeclaration(node, holder);
            }

            public void visitJSVariable(JSVariable node) {
                super.visitJSVariable(node);
                if (!(node instanceof JSParameter)) {
                    JSDuplicatedDeclarationInspection.this.reportDuplicateError((PsiElement)node, DuplicatesCheckUtil.checkDuplicatesForVariable(node), holder);
                }
            }

            public void visitJSParameter(JSParameter node) {
                super.visitJSParameter(node);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)node, holder);
            }

            public void visitJSNamespaceDeclaration(JSNamespaceDeclaration namespaceDeclaration) {
                super.visitJSNamespaceDeclaration(namespaceDeclaration);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)namespaceDeclaration, holder);
            }

            public void visitJSClass(JSClass aClass) {
                super.visitJSClass(aClass);
                if (DialectDetector.isActionScript((PsiElement)aClass) || JSClassUtils.isES6ClassImplementation((PsiElement)aClass) && !(aClass instanceof JSClassExpression)) {
                    JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)aClass, holder);
                }
            }

            public void visitJSProperty(JSProperty node) {
                super.visitJSProperty(node);
                if (!JSDestructuringUtil.parentIsDestructuringAssignmentLHS(node.getValue())) {
                    JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)node, holder);
                }
            }

            public void visitImportSpecifier(ES6ImportSpecifier node) {
                super.visitImportSpecifier(node);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)node, holder);
            }

            public void visitES6ImportedBinding(ES6ImportedBinding importedBinding) {
                super.visitES6ImportedBinding(importedBinding);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)importedBinding, holder);
            }

            public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
                super.visitES6ImportSpecifierAlias(specifierAlias);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)specifierAlias, holder);
            }

            public void visitJSFunctionProperty(JSFunctionProperty functionProperty) {
                ProgressManager.checkCanceled();
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)functionProperty, holder);
            }

            private void checkFunctionDeclaration(@NotNull JSFunction function2, @NotNull ProblemsHolder holder2) {
                if (function2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (holder2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)function2)) {
                    JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)function2, holder2);
                }
            }

            public void visitTypeScriptPropertySignature(TypeScriptPropertySignature propertySignature) {
                super.visitTypeScriptPropertySignature(propertySignature);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)propertySignature, holder);
            }

            public void visitTypeScriptFunctionSignature(TypeScriptFunctionSignature functionSignature) {
                super.visitTypeScriptFunctionSignature(functionSignature);
                JSDuplicatedDeclarationInspection.this.checkDuplicates((JSPsiNamedElementBase)functionSignature, holder);
            }

            public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
                DuplicatesCheckUtil.JSDuplicatesCheckError error;
                super.visitES6ExportDefaultAssignment(node);
                JSNamedElement namedElement = node.getNamedElement();
                Object expressionToReport = namedElement != null ? namedElement.getNameIdentifier() : node.getExpression();
                if (expressionToReport != null && (error = DuplicatesCheckUtil.checkDefaultExports(node)) != null) {
                    JSDuplicatedDeclarationInspection.this.reportDuplicateError((PsiElement)expressionToReport, error, holder);
                }
            }

            public void visitTypeScriptTypeParameter(TypeScriptTypeParameter typeParameter) {
                super.visitTypeScriptTypeParameter(typeParameter);
                JSDuplicatedDeclarationInspection.this.reportDuplicateError((PsiElement)typeParameter, DuplicatesCheckUtil.checkTypeParameterDuplicates(typeParameter), holder);
            }

            public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
                super.visitES6ExportSpecifier(node);
                ES6ExportSpecifierAlias alias = node.getAlias();
                ES6ExportSpecifierAlias element = alias != null ? alias : node;
                JSDuplicatedDeclarationInspection.this.reportDuplicateError((PsiElement)element, DuplicatesCheckUtil.checkExportDuplicates((PsiNamedElement)element), holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "function";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "holder";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSDuplicatedDeclarationInspection$1";
                objectArray[2] = "checkFunctionDeclaration";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void checkDuplicates(@NotNull JSPsiNamedElementBase element, @NotNull ProblemsHolder holder) {
        if (element == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(3);
        }
        this.reportDuplicateError((PsiElement)element, DuplicatesCheckUtil.checkDuplicates(element), holder);
    }

    protected void reportDuplicateError(@NotNull PsiElement elementToReport, @Nullable DuplicatesCheckUtil.JSDuplicatesCheckError error, @NotNull ProblemsHolder holder) {
        LocalQuickFix[] localQuickFixArray;
        PsiElement nameIdentifier;
        if (elementToReport == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSDuplicatedDeclarationInspection.$$$reportNull$$$0(5);
        }
        if (error == null || error.hasErrorSeverity()) {
            return;
        }
        PsiElement psiElement = nameIdentifier = elementToReport instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)elementToReport).getNameIdentifier() : null;
        if (nameIdentifier == null) {
            nameIdentifier = elementToReport;
        }
        if (error.getDuplicatedElement() instanceof JSElement) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = new JSNavigateToAlreadyDeclaredVariableFix((JSElement)error.getDuplicatedElement());
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] actions = localQuickFixArray;
        holder.registerProblem(nameIdentifier, error.getMessage(), actions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReport";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDuplicatedDeclarationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDuplicates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportDuplicateError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

