/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.InspectionJSBundle;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6RedundantAwaitInspection
extends JSInspection {
    private static final String RESOLVE = "resolve";
    private static final String REJECT = "reject";
    private static final String CATCH_DECORATOR_PREFIX = "Catch";
    public boolean myReportForPromises = false;

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6RedundantAwaitInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6RedundantAwaitInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public boolean visitAsFunction(JSFunction function2) {
                if (function2.isAsync()) {
                    this.report(function2);
                }
                return super.visitAsFunction(function2);
            }

            private void report(JSFunction f) {
                JSAttributeList list2 = f.getAttributeList();
                if (list2 != null) {
                    ES6Decorator[] decorators;
                    for (ES6Decorator decorator : decorators = list2.getDecorators()) {
                        if (!this.isCatchDecorator(decorator)) continue;
                        return;
                    }
                }
                ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)f).filter(Conditions.instanceOf((Class[])new Class[]{JSPrefixExpression.class, JSReturnStatement.class}))).forEach(e -> ES6RedundantAwaitInspection.this.reportUnneededAwait((PsiElement)e, e instanceof JSReturnStatement ? ((JSReturnStatement)e).getExpression() : ((JSPrefixExpression)e).getExpression(), holder));
                ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)f).forceIgnore(Conditions.instanceOf(JSFunction.class))).forceIgnore(x$0 -> ES6RedundantAwaitInspection.isTryBlockBody(x$0))).filter(JSReturnStatement.class).forEach(s -> {
                    JSExpression expression = s.getExpression();
                    if (ES6PsiUtil.isAwaitExpression((PsiElement)expression)) {
                        JSExpression innerExpression = ((JSPrefixExpression)expression).getExpression();
                        if (ES6RedundantAwaitInspection.this.shouldDropAwait(innerExpression)) {
                            holder.registerProblem((PsiElement)s, JavaScriptBundle.message((String)"js.await.promise.return.await.inspection", (Object[])new Object[0]), new LocalQuickFix[]{new UnwrapAwaitFix((PsiElement)expression, false)});
                        } else if (ES6PsiUtil.isAwaitExpression((PsiElement)innerExpression)) {
                            ES6RedundantAwaitInspection.this.reportTrivialRedundantAwait((PsiElement)expression, expression, holder);
                        }
                    }
                });
            }

            private boolean isCatchDecorator(ES6Decorator decorator) {
                JSExpression expression = decorator.getExpression();
                if (!(expression instanceof JSCallExpression)) {
                    return false;
                }
                JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
                if (!(methodExpression instanceof JSReferenceExpression)) {
                    return false;
                }
                String referenceName = ((JSReferenceExpression)methodExpression).getReferenceName();
                return referenceName != null && referenceName.startsWith(ES6RedundantAwaitInspection.CATCH_DECORATOR_PREFIX);
            }
        };
    }

    private boolean shouldDropAwait(JSExpression expression) {
        if (this.myReportForPromises) {
            return true;
        }
        JSType type = JSResolveUtil.getExpressionJSType(expression);
        if (type == null || JSTypeUtils.isAnyType(type)) {
            return false;
        }
        return !JSTypeUtils.isPromiseLikeType(type);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JavaScriptBundle.message((String)"es6.redundant.await.report.for.promises", (Object[])new Object[0]), JavaScriptBundle.message((String)"es6.redundant.await.report.for.promises.hint", (Object[])new Object[0]), "myReportForPromises");
    }

    private static boolean isTryBlockBody(PsiElement e) {
        if (!(e instanceof JSStatement)) {
            return false;
        }
        PsiElement parent = e.getParent();
        return parent instanceof JSTryStatement && ((JSTryStatement)parent).getStatement() == e;
    }

    private void reportUnneededAwait(PsiElement node, JSExpression expression, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            ES6RedundantAwaitInspection.$$$reportNull$$$0(2);
        }
        if (node instanceof JSReturnStatement && !ES6PsiUtil.isAwaitExpression((PsiElement)((JSReturnStatement)node).getExpression())) {
            return;
        }
        if (node instanceof JSPrefixExpression && !ES6PsiUtil.isAwaitExpression(node)) {
            return;
        }
        if (ES6PsiUtil.isAwaitExpression(node) && node.getParent() instanceof JSReturnStatement) {
            node = node.getParent();
        }
        if ((expression = JSUtils.unparenthesize(expression)) instanceof JSCallExpression) {
            JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
            JSExpression[] arguments = ((JSCallExpression)expression).getArguments();
            if (arguments.length == 1 && (this.myReportForPromises || this.shouldDropAwait(arguments[0]))) {
                if (JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "Promise", RESOLVE)) {
                    holder.registerProblem(node, JavaScriptBundle.message((String)"js.await.promise.resolve.inspection", (Object[])new Object[0]), new LocalQuickFix[]{new SimplifyAwaitFix((PsiElement)expression, ES6RedundantAwaitInspection.shouldAwait(expression, arguments[0]), false)});
                } else if (JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "Promise", REJECT) && ES6RedundantAwaitInspection.isReturned((PsiElement)expression)) {
                    holder.registerProblem(node, JavaScriptBundle.message((String)"js.await.promise.reject.inspection", (Object[])new Object[0]), new LocalQuickFix[]{new SimplifyAwaitFix((PsiElement)expression, ES6RedundantAwaitInspection.shouldAwait(expression, arguments[0]), true)});
                }
            }
        } else if (ES6PsiUtil.isAwaitExpression((PsiElement)expression)) {
            PsiElement parent = expression.getParent();
            if (!ES6PsiUtil.isAwaitExpression(parent.getParent()) && !(ES6RedundantAwaitInspection.skipAwaitsUp(parent) instanceof JSReturnStatement)) {
                this.reportTrivialRedundantAwait(node, expression, holder);
            }
        } else if (expression != null && ES6PsiUtil.isAwaitExpression(expression.getParent()) && ES6RedundantAwaitInspection.isTrivialType(expression)) {
            holder.registerProblem(node, JavaScriptBundle.message((String)"js.await.promise.trivial.await.inspection", (Object[])new Object[0]), new LocalQuickFix[]{new UnwrapAwaitFix(expression.getParent(), false)});
        }
    }

    private void reportTrivialRedundantAwait(PsiElement node, JSExpression expression, @NotNull ProblemsHolder holder) {
        JSExpression unwrapped;
        boolean isTrivial;
        if (holder == null) {
            ES6RedundantAwaitInspection.$$$reportNull$$$0(3);
        }
        holder.registerProblem(node, (isTrivial = ES6RedundantAwaitInspection.isTrivialType(unwrapped = ES6RedundantAwaitInspection.unwrapAwaits(expression))) ? JavaScriptBundle.message((String)"js.await.promise.trivial.await.inspection", (Object[])new Object[0]) : JavaScriptBundle.message((String)"js.await.promise.double.await.inspection", (Object[])new Object[0]), new LocalQuickFix[]{new UnwrapAwaitFix((PsiElement)expression, !isTrivial || !this.shouldDropAwait(unwrapped))});
    }

    private static PsiElement skipAwaitsUp(PsiElement element) {
        while (ES6PsiUtil.isAwaitExpression(element)) {
            element = element.getParent();
        }
        return element;
    }

    @Nullable
    private static JSExpression unwrapAwaits(JSExpression element) {
        while (ES6PsiUtil.isAwaitExpression((PsiElement)element)) {
            element = ((JSPrefixExpression)element).getExpression();
        }
        return element;
    }

    private static boolean isReturned(PsiElement expression) {
        PsiElement parent = expression.getParent();
        if (ES6PsiUtil.isAwaitExpression(parent)) {
            expression = parent;
            parent = parent.getParent();
        }
        return parent instanceof JSReturnStatement && ((JSReturnStatement)parent).getExpression() == expression;
    }

    private static boolean shouldAwait(JSExpression callExpression, JSExpression argument) {
        return !ES6RedundantAwaitInspection.isReturned((PsiElement)callExpression) && !ES6RedundantAwaitInspection.isTrivialType(argument);
    }

    private static boolean isTrivialType(JSExpression argument) {
        JSType type = JSResolveUtil.getExpressionJSType(argument);
        return type instanceof JSPrimitiveType || type instanceof JSRecordType || JSTypeUtils.isArrayLikeType(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6RedundantAwaitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reportUnneededAwait";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportTrivialRedundantAwait";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SimplifyAwaitFix
    extends LocalQuickFixOnPsiElement {
        private final boolean myShouldAwait;
        private final boolean myShouldThrow;

        protected SimplifyAwaitFix(@NotNull PsiElement element, boolean shouldAwait, boolean shouldThrow) {
            if (element == null) {
                SimplifyAwaitFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myShouldAwait = shouldAwait;
            this.myShouldThrow = shouldThrow;
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message((String)"js.await.promise.resolve.fix", (Object[])new Object[]{this.tryGetExpressionText()});
            if (string == null) {
                SimplifyAwaitFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        private String tryGetExpressionText() {
            PsiElement element = this.getStartElement();
            PsiElement argument = this.getArgument(element);
            if (argument == null) {
                return "simplified expression";
            }
            Object prefix = this.getExpressionPrefix();
            if (!this.myShouldThrow && element.getParent() instanceof JSReturnStatement) {
                prefix = "return " + (String)prefix;
            }
            String string = (String)prefix + argument.getText();
            if (string == null) {
                SimplifyAwaitFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private String getExpressionPrefix() {
            return this.myShouldAwait ? "await " : (this.myShouldThrow ? "throw " : "");
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                SimplifyAwaitFix.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                SimplifyAwaitFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                SimplifyAwaitFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                SimplifyAwaitFix.$$$reportNull$$$0(6);
            }
            if (!ES6PsiUtil.isAwaitExpression(parent = (element = this.getStartElement()).getParent())) {
                parent = element;
            }
            if (parent.getParent() instanceof JSReturnStatement) {
                parent = parent.getParent();
            }
            Object prefix = this.getExpressionPrefix();
            if (parent instanceof JSExpression) {
                JSExpression newExpression = JSPsiElementFactory.createJSExpression((String)prefix + Objects.requireNonNull(this.getArgument(element)).getText(), element);
                ((JSExpression)parent).replace(newExpression);
            } else {
                assert (parent instanceof JSReturnStatement);
                if (!this.myShouldThrow) {
                    prefix = "return " + (String)prefix;
                }
                JSStatement newStatement = JSPsiElementFactory.createJSStatement((String)prefix + Objects.requireNonNull(this.getArgument(element)).getText() + JSCodeStyleSettings.getSemicolon(element), element);
                ((JSStatement)parent).replace(newStatement);
            }
        }

        @Nullable
        protected PsiElement getArgument(PsiElement element) {
            JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)element, JSCallExpression.class);
            if (callExpression == null) {
                return null;
            }
            JSExpression[] arguments = ((JSCallExpression)element).getArguments();
            return arguments.length == 1 ? arguments[0] : null;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("replace.redundant.await.family.name", new Object[0]);
            if (string == null) {
                SimplifyAwaitFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6RedundantAwaitInspection$SimplifyAwaitFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6RedundantAwaitInspection$SimplifyAwaitFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryGetExpressionText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class UnwrapAwaitFix
    extends SimplifyAwaitFix {
        protected UnwrapAwaitFix(@NotNull PsiElement element, boolean shouldAwait) {
            if (element == null) {
                UnwrapAwaitFix.$$$reportNull$$$0(0);
            }
            super(element, shouldAwait, false);
        }

        @Override
        @Nullable
        protected PsiElement getArgument(PsiElement element) {
            return ES6RedundantAwaitInspection.unwrapAwaits((JSExpression)element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6RedundantAwaitInspection$UnwrapAwaitFix", "<init>"));
        }
    }
}

