/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.inspections.JSUnresolvedLibraryURLInspection;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionDialog;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionView;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DownloadLibraryQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(JSUnresolvedLibraryURLInspection.class);
    private String myTestRoot;

    @TestOnly
    public void setTestRoot(String testRoot) {
        this.myTestRoot = testRoot;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.library.download.fix", (Object[])new Object[0]);
        if (string == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement attrValue;
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(2);
        }
        if ((attrValue = descriptor2.getPsiElement()) != null) {
            String location = StringUtil.unquoteString((String)attrValue.getText());
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            PsiFile psiFile = attrValue.getContainingFile();
            this.download(editor, project, psiFile != null ? psiFile.getVirtualFile() : null, location);
        }
    }

    public void download(final @Nullable Editor editor, final @NotNull Project project, final @Nullable VirtualFile referencingFile, final @NotNull String libraryFileUrl) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(3);
        }
        if (libraryFileUrl == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            JSDownloadManager downloadManager = new JSDownloadManager(this.myTestRoot);
            String targetPath = downloadManager.download(libraryFileUrl, "");
            if (StringUtil.isNotEmpty((String)targetPath)) {
                DownloadLibraryQuickFix.addLibrary(project, referencingFile, libraryFileUrl, targetPath);
            }
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(project, JavaScriptBundle.message((String)"js.library.downloading.library", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSDownloadManager downloadManager = new JSDownloadManager(DownloadLibraryQuickFix.this.myTestRoot);
                downloadManager.setProgressIndicator(indicator);
                JSDownloadManager.JSDownloadException exception = null;
                String downloadedLibraryFilePath = null;
                boolean tryAgain = true;
                while (tryAgain) {
                    downloadedLibraryFilePath = downloadManager.download(libraryFileUrl, "");
                    exception = downloadManager.getLastException();
                    if (exception == null) break;
                    String reason = exception.getReason();
                    String dialogText = reason.contains(libraryFileUrl) ? reason : JavaScriptBundle.message((String)"dialog.message.failed.to.download.0.1", (Object[])new Object[]{libraryFileUrl, reason});
                    tryAgain = IOExceptionDialog.showErrorDialog((String)JavaScriptBundle.message((String)"dialog.title.download.error", (Object[])new Object[0]), (String)dialogText);
                }
                if (exception != null) {
                    LOG.info(exception);
                } else {
                    DownloadLibraryQuickFix.addLibrary(project, referencingFile, libraryFileUrl, Objects.requireNonNull(downloadedLibraryFilePath));
                    if (editor != null) {
                        ApplicationManager.getApplication().invokeLater(() -> DownloadLibraryQuickFix.showStatus(project, editor, JavaScriptBundle.message((String)"js.library.successfully.downloaded", (Object[])new Object[]{downloadManager.getActualSource()})));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix$1", "run"));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    private static void showStatus(Project project, Editor editor, @NotNull @NlsContexts.PopupContent String message) {
        if (message == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(5);
        }
        JComponent component = editor.getComponent();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO.getDefaultIcon(), MessageType.INFO.getPopupBackground(), null).createBalloon();
        Point p = editor.logicalPositionToXY(editor.getCaretModel().getLogicalPosition());
        p.translate(0, 20);
        RelativePoint point = new RelativePoint((Component)component, p);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)JSDisposable.getInstance(project), (Disposable)balloon);
    }

    private static void addLibrary(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryFileUrl, @NotNull String downloadedLibraryFilePath) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(6);
        }
        if (libraryFileUrl == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(7);
        }
        if (downloadedLibraryFilePath == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLater(() -> DownloadLibraryQuickFix.doAddLibrary(project, referencingFile, libraryFileUrl, downloadedLibraryFilePath), project.getDisposed());
    }

    private static void doAddLibrary(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryFileUrl, @NotNull String downloadedLibraryFilePath) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(9);
        }
        if (libraryFileUrl == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(10);
        }
        if (downloadedLibraryFilePath == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(11);
        }
        File libFile = new File(downloadedLibraryFilePath);
        assert (libFile.exists()) : "Library file does not exist at " + downloadedLibraryFilePath;
        VirtualFile librarySourceFile = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libFile));
        if (librarySourceFile == null || !librarySourceFile.exists()) {
            LOG.error("Library file not found: " + downloadedLibraryFilePath + ", file = " + libraryFileUrl);
            return;
        }
        String libraryName = JSLibraryUtil.getLibName(libraryFileUrl);
        List<VirtualFile> roots2 = DownloadLibraryQuickFix.getRootsToAssociateWith(project, referencingFile, libraryName);
        if (roots2 == null) {
            return;
        }
        WriteAction.run(() -> {
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            Library library = libTable.getLibraryByName(libraryName);
            if (library == null) {
                String[] stringArray;
                String key;
                String libUrl = VfsUtilCore.pathToUrl((String)libFile.getAbsolutePath());
                String docUrl = null;
                ScriptingFrameworkDescriptor framework = JSProjectUtil.detectFramework(libUrl);
                if (framework != null && (key = JSExternalLibraryDocBundle.getBaseKey(framework.getFrameworkName(), framework.getFrameworkVersion())) != null) {
                    docUrl = JSExternalLibraryDocBundle.getBaseUrl(key);
                }
                VirtualFile[] virtualFileArray = new VirtualFile[]{librarySourceFile};
                if (docUrl == null) {
                    stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = docUrl;
                }
                ScriptingLibraryModel model = libraryManager.createLibrary(libraryName, virtualFileArray, VirtualFile.EMPTY_ARRAY, stringArray, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
                model.setFrameworkDescriptor(framework);
                ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
                for (VirtualFile root : roots2) {
                    mappings.associate(root, libraryName);
                }
                libraryManager.commitChanges();
            } else {
                ScriptingLibraryTable libraryTable = libraryManager.getScriptingLibraryTable();
                ScriptingLibraryModel model = libraryTable.getModel(library);
                if (model != null && model.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
                    Set sources = model.getSourceFiles();
                    HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(sources);
                    result2.add(librarySourceFile);
                    model.setSourceFiles(VfsUtilCore.toVirtualFileArray(result2));
                    libraryManager.commitChanges();
                }
            }
        });
    }

    @Nullable
    private static List<VirtualFile> getRootsToAssociateWith(@NotNull Project project, @Nullable VirtualFile referencingFile, @NotNull String libraryName) {
        if (project == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(12);
        }
        if (libraryName == null) {
            DownloadLibraryQuickFix.$$$reportNull$$$0(13);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Collections.singletonList(null);
        }
        ModuleScopeSelectionView view = new ModuleScopeSelectionView(project, referencingFile, true, false);
        if (view.isAssociateWithProjectView()) {
            return view.getLibraryScope();
        }
        ModuleScopeSelectionDialog dialog = new ModuleScopeSelectionDialog(project, libraryName, view);
        if (dialog.showAndGet()) {
            return dialog.getView().getLibraryScope();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFileUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedLibraryFilePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/DownloadLibraryQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showStatus";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doAddLibrary";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToAssociateWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

