/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSFieldFromParameterAction
extends FixAndIntentionAction {
    private final String myReferencedName;

    public CreateJSFieldFromParameterAction(String fieldName) {
        this.myReferencedName = fieldName;
    }

    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message((String)"javascript.create.field.intention.name", (Object[])new Object[]{this.myReferencedName});
        if (string == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.create.variable.intention.family", (Object[])new Object[0]);
        if (string == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file2, @Nullable Editor editor) {
        String typeString;
        if (file2 == null) {
            CreateJSFieldFromParameterAction.$$$reportNull$$$0(2);
        }
        JSParameter parameter = (JSParameter)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSParameter.class);
        JSFunction containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, JSFunction.class);
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)containingFunction);
        if (parameter == null || containingFunction == null || dialectOptionHolder == null || !dialectOptionHolder.hasFeature(JSLanguageFeature.CLASSES)) {
            return;
        }
        BaseCreateFix.InsertPlaceInfo info = new BaseCreateFix.InsertPlaceInfo((PsiElement)containingFunction, containingFunction.getContainingFile(), true, true);
        if (info.anchor == null) {
            return;
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        if (info.addNewLineBefore) {
            template.addTextSegment("\n");
        }
        CreateJSFieldFromParameterAction.addAccessModifiers(template, dialectOptionHolder, JSResolveUtil.calculateStaticFromContext(psiElement));
        template.addTextSegment(JSClassUtils.isES6ClassImplementation((PsiElement)containingFunction) ? "" : "var ");
        template.addTextSegment(this.myReferencedName);
        JSType type = parameter.getJSType();
        String string = typeString = type != null && dialectOptionHolder.hasFeature(JSLanguageFeature.TYPES) ? type.getTypeText(JSType.TypeTextFormat.CODE) : null;
        if (!StringUtil.isEmpty(typeString)) {
            template.addTextSegment(":");
            template.addTextSegment(typeString);
        }
        template.addTextSegment(JSCodeStyleSettings.getSemicolon((PsiElement)containingFunction));
        if (info.toInsertNewLineAfter) {
            template.addTextSegment("\n");
        }
        int offset = info.anchor.getTextRange().getStartOffset();
        BaseCreateFix.navigate(project, editor, offset, file2.getVirtualFile());
        templateManager.startTemplate(editor, template);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void addAccessModifiers(Template template, DialectOptionHolder dialectOptionHolder, boolean isStatic) {
        if (dialectOptionHolder.isTypeScript || dialectOptionHolder.isECMA4) {
            template.addTextSegment("private ");
        }
        if (isStatic) {
            template.addTextSegment("static ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/CreateJSFieldFromParameterAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/CreateJSFieldFromParameterAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

