/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection.dataflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.DFAEngine;
import com.intellij.codeInsight.dataflow.DFALimitExceededException;
import com.intellij.codeInsight.dataflow.DfaInstance;
import com.intellij.codeInsight.dataflow.Semilattice;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspection.dataflow.JSVariableInfo;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSConditionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSReadWriteInstruction;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSControlFlowProcessor {
    public static final DefinedValuesInfo INITIAL = new DefinedValuesInfo();
    @NotNull
    private final Map<JSVariable, Set<JSExpression>> myResultVariablesWritten;
    private final Map<JSVariable, Set<JSExpression>> myResultVariablesOverwritten;
    private final Map<JSExpression, JSVariable> myVariablesReadWithoutInitialization;
    private final Set<? super JSVariable> myReadAtLeastOnce;
    private final Set<String> myVariablesReferencedInInners;

    public void processInstructions(Instruction @NotNull [] instructions) {
        if (instructions == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(0);
        }
        Semilattice<DefinedValuesInfo> semilattice = new Semilattice<DefinedValuesInfo>(){

            public DefinedValuesInfo join(ArrayList<DefinedValuesInfo> predInstructions) {
                if (predInstructions.isEmpty()) {
                    return INITIAL;
                }
                if (predInstructions.size() == 1) {
                    return predInstructions.get(0);
                }
                DefinedValuesInfo info = new DefinedValuesInfo();
                JSControlFlowProcessor.this.mergeBranches(predInstructions, info);
                return info;
            }

            public boolean eq(@NotNull DefinedValuesInfo e1, @NotNull DefinedValuesInfo e2) {
                if (e1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return e1.equals(e2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor$1";
                objectArray[2] = "eq";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DfaInstance<DefinedValuesInfo> instance = new DfaInstance<DefinedValuesInfo>(){

            public DefinedValuesInfo fun(DefinedValuesInfo info, Instruction instruction) {
                Instruction singlePrev;
                Collection allPred = instruction.allPred();
                if (info == INITIAL) {
                    info = info.cloneState();
                } else if (allPred.size() == 1 && (singlePrev = (Instruction)allPred.iterator().next()).allSucc().size() != 1) {
                    info = info.cloneState();
                }
                return JSControlFlowProcessor.processInstruction(instruction, JSControlFlowProcessor.this, info);
            }

            @NotNull
            public DefinedValuesInfo initial() {
                DefinedValuesInfo definedValuesInfo = INITIAL;
                if (definedValuesInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                return definedValuesInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor$2", "initial"));
            }
        };
        DFAEngine engine = new DFAEngine(instructions, (DfaInstance)instance, (Semilattice)semilattice);
        try {
            List infos = engine.performDFA();
            if (infos.isEmpty()) {
                return;
            }
            Map<JSVariable, JSVariableInfo> infoMap = ((DefinedValuesInfo)infos.get((int)(infos.size() - 1))).myVariableInfo;
            for (Map.Entry<JSVariable, JSVariableInfo> entry : infoMap.entrySet()) {
                THashSet variablesWrittenResult = new THashSet();
                JSVariableInfo variableInfo = entry.getValue();
                Set<JSExpression> writtenSet = variableInfo.getVariablesWritten();
                Set<JSExpression> readSet = variableInfo.getVariablesRead();
                for (JSExpression written : writtenSet) {
                    if (readSet.contains(written)) continue;
                    variablesWrittenResult.add(written);
                }
                this.myResultVariablesWritten.put(entry.getKey(), (Set<JSExpression>)variablesWrittenResult);
                this.myResultVariablesOverwritten.put(entry.getKey(), variableInfo.getVariablesOverwritten());
            }
        }
        catch (DFALimitExceededException dFALimitExceededException) {
            // empty catch block
        }
    }

    public static void processControlFlow(@NotNull JSExecutionScope element, @NotNull JSControlFlowProcessor controlFlowProcessor) {
        JSControlFlowService.JSControlFlow flow;
        Object[] instructions;
        Instruction firstInstruction;
        if (element == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(1);
        }
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(2);
        }
        if ((firstInstruction = (Instruction)ArrayUtil.getFirstElement((Object[])(instructions = (flow = JSControlFlowService.getService(element.getProject()).getControlFlow((JSElement)element)).getInstructions()))) == null) {
            return;
        }
        controlFlowProcessor.processInstructions((Instruction[])instructions);
    }

    @NotNull
    public static DefinedValuesInfo processInstruction(@NotNull Instruction currentInstruction, @NotNull JSControlFlowProcessor controlFlowProcessor, @NotNull DefinedValuesInfo info) {
        if (currentInstruction == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(3);
        }
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(4);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(5);
        }
        PsiElement element = currentInstruction.getElement();
        if (currentInstruction instanceof JSReadWriteInstruction) {
            ReadWriteAccessDetector.Access access = ((JSReadWriteInstruction)currentInstruction).getAccess();
            if (access == ReadWriteAccessDetector.Access.Read && element instanceof JSExpression) {
                DefinedValuesInfo definedValuesInfo = controlFlowProcessor.valueRead((JSExpression)element, info);
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(6);
                }
                return definedValuesInfo;
            }
            if (element instanceof JSForInStatement) {
                return JSControlFlowProcessor.processForInStatement(controlFlowProcessor, (JSForInStatement)element, access, info);
            }
            if (element instanceof JSReferenceExpression) {
                DefinedValuesInfo definedValuesInfo = JSControlFlowProcessor.processJSReferenceExpression(controlFlowProcessor, (JSReferenceExpression)element, access, info);
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(7);
                }
                return definedValuesInfo;
            }
            if (element instanceof JSAssignmentExpression) {
                return JSControlFlowProcessor.processJSAssignmentExpression(controlFlowProcessor, (JSAssignmentExpression)element, access, info);
            }
            if (element instanceof JSDefinitionExpression) {
                return JSControlFlowProcessor.processJSDefinitionExpression(controlFlowProcessor, (JSDefinitionExpression)element, info);
            }
            if (access == ReadWriteAccessDetector.Access.Write && element instanceof JSVariable) {
                return JSControlFlowProcessor.processJSVariable(controlFlowProcessor, (JSVariable)element, info);
            }
        } else {
            if (element instanceof JSFunction) {
                controlFlowProcessor.functionEncountered((JSFunction)element);
                DefinedValuesInfo definedValuesInfo = info;
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(8);
                }
                return definedValuesInfo;
            }
            if (currentInstruction instanceof JSConditionInstruction) {
                PsiElement elementForTrueValue;
                boolean value = ((JSConditionInstruction)currentInstruction).getValue();
                Object object = value ? element : (elementForTrueValue = element instanceof JSPrefixExpression && ((JSPrefixExpression)element).getOperationSign() == JSTokenTypes.EXCL ? ((JSPrefixExpression)element).getExpression() : null);
                if (elementForTrueValue != null) {
                    DefinedValuesInfo definedValuesInfo = controlFlowProcessor.processConditionalTrueInstruction(elementForTrueValue, info);
                    if (definedValuesInfo == null) {
                        JSControlFlowProcessor.$$$reportNull$$$0(9);
                    }
                    return definedValuesInfo;
                }
            }
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(10);
        }
        return definedValuesInfo;
    }

    @NotNull
    private static DefinedValuesInfo processForInStatement(@NotNull JSControlFlowProcessor processor, @NotNull JSForInStatement element, @NotNull ReadWriteAccessDetector.Access access, @NotNull DefinedValuesInfo info) {
        if (processor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(11);
        }
        if (element == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(12);
        }
        if (access == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(13);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(14);
        }
        if (access != ReadWriteAccessDetector.Access.Write) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(15);
            }
            return definedValuesInfo;
        }
        JSExpression expression = element.getVariableExpression();
        if (expression instanceof JSReferenceExpression) {
            DefinedValuesInfo definedValuesInfo = JSControlFlowProcessor.processJSReferenceExpression(processor, (JSReferenceExpression)expression, access, info);
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(16);
            }
            return definedValuesInfo;
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(17);
        }
        return definedValuesInfo;
    }

    @NotNull
    private static DefinedValuesInfo processJSDefinitionExpression(@NotNull JSControlFlowProcessor controlFlowProcessor, @NotNull JSDefinitionExpression element, @NotNull DefinedValuesInfo info) {
        JSExpression collectionExpression;
        JSExpression expression;
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(18);
        }
        if (element == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(19);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(20);
        }
        if ((expression = element.getExpression()) == null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(21);
            }
            return definedValuesInfo;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSForInStatement && (collectionExpression = ((JSForInStatement)parent).getCollectionExpression()) != null) {
            DefinedValuesInfo definedValuesInfo = controlFlowProcessor.valueWritten((JSElement)expression, collectionExpression, info);
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(22);
            }
            return definedValuesInfo;
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(23);
        }
        return definedValuesInfo;
    }

    private static DefinedValuesInfo processJSReferenceExpression(@NotNull JSControlFlowProcessor controlFlowProcessor, @NotNull JSReferenceExpression node, @NotNull ReadWriteAccessDetector.Access access, @NotNull DefinedValuesInfo info) {
        PsiElement parent;
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(24);
        }
        if (node == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(25);
        }
        if (access == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(26);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(27);
        }
        if ((parent = node.getParent()) instanceof JSForInStatement && ((JSForInStatement)parent).getVariableExpression() == node) {
            JSForInStatement forInStatement = (JSForInStatement)parent;
            return controlFlowProcessor.valueWritten((JSElement)node, forInStatement.getCollectionExpression(), info);
        }
        if (access == ReadWriteAccessDetector.Access.Write) {
            JSExpression initializer = JSDestructuringUtil.getDestructuringAssignmentSource((JSExpression)node);
            return controlFlowProcessor.valueWritten((JSElement)node, initializer != null ? initializer : (JSExpression)node.getReference(), info);
        }
        if (access == ReadWriteAccessDetector.Access.ReadWrite) {
            DefinedValuesInfo newInfo = controlFlowProcessor.valueRead((JSExpression)node, info);
            return controlFlowProcessor.valueWritten((JSElement)node, (JSExpression)node.getReference(), newInfo);
        }
        return info;
    }

    @NotNull
    private static DefinedValuesInfo processJSVariable(@NotNull JSControlFlowProcessor processor, @NotNull JSVariable element, @NotNull DefinedValuesInfo info) {
        if (processor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(28);
        }
        if (element == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(29);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(30);
        }
        PsiElement identifier = element.getNameIdentifier();
        JSExpression initializer = element.getInitializer();
        if (initializer != null) {
            if (identifier != null) {
                DefinedValuesInfo definedValuesInfo = processor.valueWritten((JSElement)element, initializer, info);
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(31);
                }
                return definedValuesInfo;
            }
        } else {
            JSExpression collectionExpression;
            PsiElement parent;
            initializer = JSDestructuringUtil.getNearestDestructuringInitializer(element);
            if (initializer != null) {
                DefinedValuesInfo definedValuesInfo = processor.valueWritten((JSElement)element, initializer, info);
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(32);
                }
                return definedValuesInfo;
            }
            PsiElement varStatement = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)element);
            PsiElement psiElement = parent = varStatement != null ? varStatement.getParent() : null;
            if (parent instanceof JSForInStatement && ((JSForInStatement)parent).getVarDeclaration() == varStatement && (collectionExpression = ((JSForInStatement)parent).getCollectionExpression()) != null) {
                DefinedValuesInfo definedValuesInfo = processor.valueWritten((JSElement)element, collectionExpression, info);
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(33);
                }
                return definedValuesInfo;
            }
        }
        DefinedValuesInfo definedValuesInfo = processor.valueWritten((JSElement)element, null, info);
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(34);
        }
        return definedValuesInfo;
    }

    @NotNull
    private static DefinedValuesInfo processJSAssignmentExpression(@NotNull JSControlFlowProcessor controlFlowProcessor, @NotNull JSAssignmentExpression element, @NotNull ReadWriteAccessDetector.Access access, @NotNull DefinedValuesInfo info) {
        JSDefinitionExpression definitionExpression;
        if (controlFlowProcessor == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(35);
        }
        if (element == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(36);
        }
        if (access == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(37);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(38);
        }
        if ((definitionExpression = element.getDefinitionExpression()) == null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(39);
            }
            return definedValuesInfo;
        }
        JSExpression initializerExpression = JSTypeGuardUtil.getInitializerExpression((PsiElement)element);
        JSExpression expression = definitionExpression.getExpression();
        if (expression == null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(40);
            }
            return definedValuesInfo;
        }
        if (access == ReadWriteAccessDetector.Access.Write) {
            DefinedValuesInfo definedValuesInfo = controlFlowProcessor.valueWritten((JSElement)expression, initializerExpression, info);
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(41);
            }
            return definedValuesInfo;
        }
        if (access == ReadWriteAccessDetector.Access.ReadWrite) {
            DefinedValuesInfo newInfo = controlFlowProcessor.valueRead(expression, info);
            DefinedValuesInfo definedValuesInfo = controlFlowProcessor.valueWritten((JSElement)expression, initializerExpression, newInfo);
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(42);
            }
            return definedValuesInfo;
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(43);
        }
        return definedValuesInfo;
    }

    public JSControlFlowProcessor(@NotNull Map<JSVariable, Set<JSExpression>> variablesWritten, @NotNull Map<JSExpression, JSVariable> variablesReadWithoutInitialization, @NotNull Set<? super JSVariable> readAtLeastOnce, @NotNull Set<String> variablesReferencedInInners, @NotNull Map<JSVariable, Set<JSExpression>> valuesOverwritten) {
        if (variablesWritten == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(44);
        }
        if (variablesReadWithoutInitialization == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(45);
        }
        if (readAtLeastOnce == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(46);
        }
        if (variablesReferencedInInners == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(47);
        }
        if (valuesOverwritten == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(48);
        }
        this.myResultVariablesWritten = variablesWritten;
        this.myVariablesReadWithoutInitialization = variablesReadWithoutInitialization;
        this.myReadAtLeastOnce = readAtLeastOnce;
        this.myVariablesReferencedInInners = variablesReferencedInInners;
        this.myResultVariablesOverwritten = valuesOverwritten;
    }

    @NotNull
    public DefinedValuesInfo valueRead(@Nullable JSExpression expression, @NotNull DefinedValuesInfo info) {
        PsiPolyVariantReference reference;
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(49);
        }
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() == null) {
            DefinedValuesInfo definedValuesInfo = this.valueRead(expression, ((JSReferenceExpression)expression).resolve(), info);
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(50);
            }
            return definedValuesInfo;
        }
        if (expression instanceof JSXXmlLiteralExpressionImpl && (reference = JSXResolveUtil.getTopLevelReference((JSXmlLiteralExpression)expression)) != null) {
            DefinedValuesInfo definedValuesInfo = this.valueRead(expression, reference.resolve(), info);
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(51);
            }
            return definedValuesInfo;
        }
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(52);
        }
        return definedValuesInfo;
    }

    @NotNull
    public DefinedValuesInfo processConditionalTrueInstruction(@Nullable PsiElement expression, @NotNull DefinedValuesInfo info) {
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(53);
        }
        if (expression instanceof JSBinaryExpression) {
            JSExpression typeOfExpression;
            JSExpression possibleTypeOf = ((JSBinaryExpression)expression).getLOperand();
            IElementType binaryOperation = ((JSBinaryExpression)expression).getOperationSign();
            if (!JSTokenTypes.EQUALITY_OPERATIONS.contains(binaryOperation)) {
                DefinedValuesInfo definedValuesInfo = info;
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(54);
                }
                return definedValuesInfo;
            }
            if (!(possibleTypeOf instanceof JSPrefixExpression) && !((possibleTypeOf = ((JSBinaryExpression)expression).getROperand()) instanceof JSPrefixExpression)) {
                DefinedValuesInfo definedValuesInfo = info;
                if (definedValuesInfo == null) {
                    JSControlFlowProcessor.$$$reportNull$$$0(55);
                }
                return definedValuesInfo;
            }
            IElementType sign = ((JSPrefixExpression)possibleTypeOf).getOperationSign();
            if (sign == JSTokenTypes.TYPEOF_KEYWORD && (typeOfExpression = JSUtils.unparenthesize(((JSPrefixExpression)possibleTypeOf).getExpression())) instanceof JSReferenceExpression) {
                expression = typeOfExpression;
            }
        }
        if (!(expression instanceof JSReferenceExpression)) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(56);
            }
            return definedValuesInfo;
        }
        PsiElement resolved = ((JSReferenceExpression)expression).resolve();
        if (!(resolved instanceof JSVariable)) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(57);
            }
            return definedValuesInfo;
        }
        DefinedValuesInfo newInfo = info.cloneState();
        if (newInfo.conditionalVariables == null) {
            newInfo.conditionalVariables = new THashSet(1);
        }
        newInfo.conditionalVariables.add((JSVariable)resolved);
        DefinedValuesInfo definedValuesInfo = newInfo;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(58);
        }
        return definedValuesInfo;
    }

    @NotNull
    public DefinedValuesInfo valueRead(@NotNull JSExpression reference, @Nullable PsiElement resolve, @NotNull DefinedValuesInfo info) {
        if (reference == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(59);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(60);
        }
        if (!(resolve instanceof JSVariable) || resolve instanceof ImplicitJSVariableImpl) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(61);
            }
            return definedValuesInfo;
        }
        JSVariable var = (JSVariable)resolve;
        boolean readSomething = resolve instanceof JSParameter || TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var);
        JSVariableInfo variableInfo = info.myVariableInfo.get(var);
        if (variableInfo != null) {
            Set<JSExpression> written = variableInfo.getVariablesWritten();
            variableInfo.addReads(written);
            if (!written.isEmpty()) {
                readSomething = true;
            }
        }
        if (info.conditionalVariables != null && info.conditionalVariables.contains(var)) {
            readSomething = true;
        }
        if (!readSomething && JSControlFlowProcessor.isReadInConditional(reference)) {
            readSomething = true;
        }
        if (!readSomething && info.conditionalVariables != null && info.conditionalVariables.contains(var)) {
            readSomething = true;
        }
        if (!readSomething) {
            this.myVariablesReadWithoutInitialization.put(reference, var);
        }
        this.myReadAtLeastOnce.add((JSVariable)var);
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(62);
        }
        return definedValuesInfo;
    }

    public void functionEncountered(JSFunction function2) {
        ((JSFunctionBaseImpl)function2).addReferencedExternalNames(this.myVariablesReferencedInInners);
    }

    public void mergeBranches(@NotNull List<DefinedValuesInfo> merge, @NotNull DefinedValuesInfo branch) {
        if (merge == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(63);
        }
        if (branch == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(64);
        }
        assert (merge.size() > 1);
        Map<JSVariable, JSVariableInfo> result2 = branch.myVariableInfo;
        for (int i = merge.size() - 1; i >= 0; --i) {
            DefinedValuesInfo info = merge.get(i);
            for (Map.Entry<JSVariable, JSVariableInfo> entry : info.myVariableInfo.entrySet()) {
                JSVariable variable = entry.getKey();
                JSVariableInfo value = entry.getValue();
                JSVariableInfo varInfo = result2.get(variable);
                if (varInfo == null) {
                    result2.put(variable, value.cloneState());
                    continue;
                }
                varInfo.addReads(value.getVariablesRead());
                varInfo.addWrites(value.getVariablesWritten());
                varInfo.intersectOverwrittenWith(value.getVariablesOverwritten());
            }
        }
    }

    @NotNull
    public DefinedValuesInfo valueWritten(@NotNull JSElement element, @Nullable JSExpression rOperand, @NotNull DefinedValuesInfo info) {
        Set<JSExpression> valueWritten;
        if (element == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(65);
        }
        if (info == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(66);
        }
        JSVariable var = null;
        if (element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() == null) {
            PsiElement resolve = ((JSReferenceExpression)element).resolve();
            if (resolve instanceof JSVariable) {
                var = (JSVariable)resolve;
            }
        } else if (element instanceof JSVariable) {
            var = (JSVariable)element;
        }
        if (var == null) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(67);
            }
            return definedValuesInfo;
        }
        if (rOperand == null) {
            info.myVariableInfo.put(var, new JSVariableInfo());
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(68);
            }
            return definedValuesInfo;
        }
        Map<JSVariable, JSVariableInfo> infoMap = info.myVariableInfo;
        JSVariableInfo variableInfo = infoMap.get(var);
        if (variableInfo == null) {
            infoMap.put(var, new JSVariableInfo());
            variableInfo = infoMap.get(var);
        }
        if ((valueWritten = variableInfo.getVariablesWritten()).contains(rOperand)) {
            DefinedValuesInfo definedValuesInfo = info;
            if (definedValuesInfo == null) {
                JSControlFlowProcessor.$$$reportNull$$$0(69);
            }
            return definedValuesInfo;
        }
        Set<JSExpression> valueRead = variableInfo.getVariablesRead();
        for (JSExpression expression : valueWritten) {
            if (valueRead.contains(expression)) continue;
            variableInfo.addOverwritten(expression);
        }
        variableInfo.addWrite(rOperand);
        DefinedValuesInfo definedValuesInfo = info;
        if (definedValuesInfo == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(70);
        }
        return definedValuesInfo;
    }

    private static boolean isReadInConditional(@NotNull JSExpression reference) {
        IElementType sign;
        PsiElement parent;
        if (reference == null) {
            JSControlFlowProcessor.$$$reportNull$$$0(71);
        }
        if ((parent = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)reference)) instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)parent).getOperationSign()) == JSTokenTypes.EXCL || sign == JSTokenTypes.TYPEOF_KEYWORD)) {
            return true;
        }
        if (JSControlFlowProcessor.isConditionOfBlock(reference, parent)) {
            return true;
        }
        if (parent instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
            IElementType sign2 = binaryExpression.getOperationSign();
            if (sign2 == JSTokenTypes.ANDAND || sign2 == JSTokenTypes.OROR) {
                return true;
            }
            if (JSTokenTypes.EQUALITY_OPERATIONS.contains(sign2) && (reference == binaryExpression.getROperand() && JSSymbolUtil.isUndefinedExpression(binaryExpression.getLOperand()) || reference == binaryExpression.getLOperand() && JSSymbolUtil.isUndefinedExpression(binaryExpression.getROperand()))) {
                return true;
            }
        }
        return parent instanceof JSElvisOwner && ((JSElvisOwner)parent).isElvis();
    }

    @Contract(value="_, null -> false")
    private static boolean isConditionOfBlock(JSExpression key, PsiElement parent) {
        return parent instanceof JSConditionOwner && key == ((JSConditionOwner)parent).getCondition();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 1: 
            case 12: 
            case 19: 
            case 29: 
            case 36: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 18: 
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlowProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 5: 
            case 14: 
            case 20: 
            case 27: 
            case 30: 
            case 38: 
            case 49: 
            case 53: 
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesWritten";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesReadWithoutInitialization";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readAtLeastOnce";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesReferencedInInners";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesOverwritten";
                break;
            }
            case 59: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "merge";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processInstruction";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "processForInStatement";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "processJSDefinitionExpression";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "processJSVariable";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "processJSAssignmentExpression";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "valueRead";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "processConditionalTrueInstruction";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "valueWritten";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processInstructions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processControlFlow";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processInstruction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processForInStatement";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processJSDefinitionExpression";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processJSReferenceExpression";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processJSVariable";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processJSAssignmentExpression";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 49: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "valueRead";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processConditionalTrueInstruction";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "mergeBranches";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "valueWritten";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isReadInConditional";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DefinedValuesInfo {
        @NotNull
        final Map<JSVariable, JSVariableInfo> myVariableInfo;
        @Nullable
        Set<JSVariable> conditionalVariables;

        @Contract(pure=true)
        private DefinedValuesInfo(@NotNull Map<JSVariable, JSVariableInfo> variableInfo) {
            if (variableInfo == null) {
                DefinedValuesInfo.$$$reportNull$$$0(0);
            }
            this.myVariableInfo = variableInfo;
        }

        DefinedValuesInfo() {
            this((Map<JSVariable, JSVariableInfo>)new THashMap());
        }

        DefinedValuesInfo cloneState() {
            THashMap variableInfo = new THashMap(this.myVariableInfo.size() + 1);
            this.myVariableInfo.forEach((arg_0, arg_1) -> DefinedValuesInfo.lambda$cloneState$0((Map)variableInfo, arg_0, arg_1));
            DefinedValuesInfo newInfo = new DefinedValuesInfo((Map<JSVariable, JSVariableInfo>)variableInfo);
            if (this.conditionalVariables != null) {
                newInfo.conditionalVariables = new THashSet(this.conditionalVariables);
            }
            return newInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefinedValuesInfo)) {
                return false;
            }
            DefinedValuesInfo info = (DefinedValuesInfo)o;
            if (!this.myVariableInfo.equals(info.myVariableInfo)) {
                return false;
            }
            return Objects.equals(this.conditionalVariables, info.conditionalVariables);
        }

        public int hashCode() {
            int result2 = this.myVariableInfo.hashCode();
            result2 = 31 * result2 + (this.conditionalVariables != null ? this.conditionalVariables.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void lambda$cloneState$0(Map variableInfo, JSVariable variable, JSVariableInfo varInfo) {
            variableInfo.put(variable, varInfo.cloneState());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableInfo", "com/intellij/lang/javascript/inspection/dataflow/JSControlFlowProcessor$DefinedValuesInfo", "<init>"));
        }
    }
}

