/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.confusing.PointlessBooleanExpressionJSInspection;
import com.sixrr.inspectjs.control.JSSimplifyIfStatementFix;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuspiciousTypeUtil {
    public static LocalQuickFix getSimplifyFix(@NotNull JSExpression expression, boolean isAlwaysFalse) {
        PsiElement ifCandidate;
        if (expression == null) {
            JSSuspiciousTypeUtil.$$$reportNull$$$0(0);
        }
        if ((ifCandidate = expression.getParent()) instanceof JSIfStatement && ((JSIfStatement)ifCandidate).getCondition() == expression) {
            return new JSSimplifyIfStatementFix(isAlwaysFalse);
        }
        return new PointlessBooleanExpressionJSInspection.BooleanLiteralComparisonFix(isAlwaysFalse ? "false" : "true");
    }

    public static boolean isTypeWithStrictNullability(@Nullable JSType expressionJSType, @NotNull PsiElement context) {
        if (context == null) {
            JSSuspiciousTypeUtil.$$$reportNull$$$0(1);
        }
        return expressionJSType != null && expressionJSType.isTypeScript() && expressionJSType.isSourceStrict() && TypeScriptConfigUtil.strictNullChecks(context);
    }

    @NotNull
    public static JSType getGenericConstraintSelfOrAny(@Nullable JSType t) {
        if (!(t instanceof JSGenericParameterImpl)) {
            JSType jSType = t == null ? JSAnyType.get(JSTypeSource.EMPTY_TS) : t;
            if (jSType == null) {
                JSSuspiciousTypeUtil.$$$reportNull$$$0(2);
            }
            return jSType;
        }
        JSType constraintType = ((JSGenericParameterImpl)t).getConstraintType();
        JSType jSType = constraintType == null ? t : constraintType;
        if (jSType == null) {
            JSSuspiciousTypeUtil.$$$reportNull$$$0(3);
        }
        return jSType;
    }

    @NotNull
    public static JSType getConstructedType(@NotNull JSType type, @Nullable JSExpression context) {
        if (type == null) {
            JSSuspiciousTypeUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSNamespace jSNamespace = ((JSTypeImpl)type).copyWithJSContext(JSContext.INSTANCE);
            if (jSNamespace == null) {
                JSSuspiciousTypeUtil.$$$reportNull$$$0(5);
            }
            return jSNamespace;
        }
        PsiElement parent = context.getParent();
        ES6ReferenceListImpl.ClassExpressionResolve constructorSignatureType = ES6ReferenceListImpl.resolveConstructorSignatures(type, parent, ContainerUtil.emptyList(), ContainerUtil.emptyList());
        if (!constructorSignatureType.hasError() && constructorSignatureType.constructorFunctions.size() > 0) {
            ArrayList<JSType> types2 = new ArrayList<JSType>(constructorSignatureType.constructorFunctions.size());
            for (JSType jSType : constructorSignatureType.constructorFunctions) {
                JSType retType;
                if (!(jSType instanceof TypeScriptJSFunctionTypeImpl) || (retType = ((TypeScriptJSFunctionTypeImpl)jSType).getReturnType()) == null) continue;
                types2.add(retType);
            }
            if (types2.size() > 0) {
                JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource((PsiElement)context, true), types2));
                if (jSType == null) {
                    JSSuspiciousTypeUtil.$$$reportNull$$$0(6);
                }
                return jSType;
            }
        }
        JSNamespace jSNamespace = ((JSTypeImpl)type).copyWithJSContext(JSContext.INSTANCE);
        if (jSNamespace == null) {
            JSSuspiciousTypeUtil.$$$reportNull$$$0(7);
        }
        return jSNamespace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericConstraintSelfOrAny";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimplifyFix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeWithStrictNullability";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConstructedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

