/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSSubclassIndex;
import com.intellij.lang.javascript.psi.stubs.JSTypedefIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.TreeItem;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JSTypeEvaluateManager {
    protected static final Logger LOG = Logger.getInstance(JSTypeEvaluateManager.class);
    private static final AtomicBoolean ourAssertOnStubLoading = new AtomicBoolean();
    private static final boolean PROCESS_ONE_LETTER_NAMES = SystemProperties.getBooleanProperty((String)"idea.javascript.one.letter.names.inheritance", (boolean)true);

    public static String getBaseArrayType(String type) {
        if (JSTypeEvaluateManager.isArrayType(type) && type.contains("[]")) {
            return "Array";
        }
        return type;
    }

    public static Collection<JSPsiElementBase> findNearestExtendedJSTypes(JSPsiElementBase function2, @NotNull String functionQName) {
        if (functionQName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(0);
        }
        LinkedList extendedTypes = new LinkedList();
        THashSet hasNonImplicitNamespaceElement = new THashSet();
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)function2).getClassResolver();
        PsiFile psiFile = function2.getContainingFile();
        JSNamespace ns = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(functionQName), JSContext.INSTANCE, (PsiElement)function2, true);
        JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex((PsiElement)function2, ns, false, false, (Processor<JSType>)((Processor)arg_0 -> JSTypeEvaluateManager.lambda$findNearestExtendedJSTypes$0(resolver, psiFile, extendedTypes, (Set)hasNonImplicitNamespaceElement, arg_0)));
        ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>(extendedTypes.size());
        for (Pair type : extendedTypes) {
            JSPsiElementBase element = (JSPsiElementBase)type.first;
            if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() && hasNonImplicitNamespaceElement.contains(type.second)) continue;
            result2.add(element);
        }
        return result2;
    }

    public static boolean iterateTypeHierarchy(@NotNull JSNamespace type, @Nullable Processor<JSClass> baseClassProcessor, @Nullable Processor<JSType> baseTypeProcessor, @NotNull PsiElement myContext, boolean processTopClasses) {
        String typeName;
        if (type == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(1);
        }
        if (myContext == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(2);
        }
        if (baseClassProcessor != null && (typeName = JSQualifiedNameImpl.toString(type.getQualifiedName())) != null && !JSTypeEvaluateManager.iterateTypeHierarchyFromJSClasses(typeName, baseClassProcessor, myContext, processTopClasses)) {
            return false;
        }
        return baseTypeProcessor == null || JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(myContext, type, false, true, baseTypeProcessor);
    }

    private static boolean iterateTypeHierarchyFromJSClasses(@NotNull String typeName, @NotNull Processor<JSClass> processor, @NotNull PsiElement myContext, boolean processTopClasses) {
        JSClassResolver resolver;
        List<JSClass> classes;
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(4);
        }
        if (myContext == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(5);
        }
        if (!(classes = (resolver = JSDialectSpecificHandlersFactory.forElement(myContext).getClassResolver()).findClassesByQName(typeName, JSResolveUtil.getResolveScope(myContext))).isEmpty()) {
            HashSet<JSClass> visitedClasses = new HashSet<JSClass>();
            if (processTopClasses) {
                for (JSClass aClass : classes) {
                    if (!visitedClasses.add(aClass) || processor.process((Object)aClass)) continue;
                    return false;
                }
            }
            ArrayDeque<JSClass> parentClasses = new ArrayDeque<JSClass>(classes);
            while (!parentClasses.isEmpty()) {
                JSClass parentClass = (JSClass)parentClasses.removeFirst();
                for (JSClass superClass : parentClass.getSupers()) {
                    if (!visitedClasses.add(superClass)) continue;
                    if (!processor.process((Object)superClass)) {
                        return false;
                    }
                    parentClasses.add(superClass);
                }
            }
        }
        return true;
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context, @Nullable String type, @NotNull Processor<JSType> processor) {
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(7);
        }
        if (type == null) {
            return true;
        }
        JSNamespace ns = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(type), JSContext.INSTANCE, context, true);
        return JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context, ns, true, true, processor);
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context, @NotNull JSNamespace initialType, boolean processObjectClass, boolean withGrandparents, @NotNull Processor<JSType> processor) {
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(8);
        }
        if (initialType == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(10);
        }
        return JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context, initialType, processObjectClass, withGrandparents, false, processor);
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context, @NotNull JSNamespace initialType, boolean processObjectClass, boolean withGrandparents, boolean limitScopeForInitialType, @NotNull Processor<? super JSType> processor) {
        JSNamespace objectNs;
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(11);
        }
        if (initialType == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(13);
        }
        if (DialectDetector.isTypeScript(context)) {
            return true;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        PsiManager psiManager = context.getManager();
        JSHierarchyProcessingState state = new JSHierarchyProcessingState(initialType);
        while (state.hasNext()) {
            JSQualifiedName name;
            JSType currentType = state.next();
            JSNamespace ns = JSTypeUtils.getNamespaceMatchingType(currentType, false);
            if (ns == null || !PROCESS_ONE_LETTER_NAMES && (name = ns.getQualifiedName()) != null && name.getParent() == null && name.getName().length() == 1) continue;
            if (!JSTypeEvaluateManager.processNamespaceBaseTypes(ns, limitScopeForInitialType, context, scope, state)) {
                return false;
            }
            List<JSType> newResults = state.pullResults(psiManager);
            for (JSType newResult : newResults) {
                if (processor.process((Object)newResult)) continue;
                return false;
            }
            if (withGrandparents) continue;
            break;
        }
        return !processObjectClass || state.hasObjectInHierarchy() || processor.process((Object)(objectNs = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName("Object"), JSContext.INSTANCE, context, true)));
    }

    private static boolean processNamespaceBaseTypes(@NotNull JSNamespace namespace, boolean limitScopeForInitialType, @NotNull PsiElement context, @Nullable GlobalSearchScope contextScope, @NotNull JSHierarchyProcessingState state) {
        PsiFile nsFile;
        if (namespace == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(15);
        }
        if (state == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(16);
        }
        String indexKey = JSBaseTypesIndex.getHierarchyIndexKey(namespace);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for " + indexKey + " base types");
        }
        Object scope = contextScope;
        if ((namespace.isLocal() || limitScopeForInitialType && state.isInitialType(namespace)) && (nsFile = namespace.getSource().getScope()) != null) {
            scope = new GlobalSearchScopeWithIdFilter(nsFile);
        }
        return StubIndex.getInstance().processElements(JSBaseTypesIndex.KEY, (Object)indexKey, context.getProject(), scope, JSElement.class, element -> {
            if (ourAssertOnStubLoading.get()) {
                throw new RuntimeException("Inheritance checked at " + element.getContainingFile().getVirtualFile().getPath());
            }
            if (element instanceof JSImplicitElementProvider) {
                Collection baseTypes;
                PsiFile containingFile = element.getContainingFile();
                VirtualFile file2 = containingFile.getVirtualFile();
                JSElementIndexingData indexingData = ((JSImplicitElementProvider)element).getIndexingData();
                Collection collection = baseTypes = indexingData != null ? indexingData.getBaseTypes() : null;
                if (baseTypes != null) {
                    for (Pair inheritance : baseTypes) {
                        String subType = (String)inheritance.first;
                        if (!JSBaseTypesIndex.areTypesRelevant(namespace, subType, containingFile)) continue;
                        String inherited = (String)inheritance.second;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found " + subType + " extends " + (String)inheritance.second);
                        }
                        state.addBaseType(file2, inherited);
                    }
                }
            }
            return true;
        });
    }

    @NotNull
    public static TreeItem<String> buildSuperClassesHierarchy(@NotNull String type, @NotNull GlobalSearchScope scope) {
        if (type == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(18);
        }
        TreeItem root = new TreeItem((Object)type);
        THashSet visited = new THashSet();
        visited.add(type);
        JSTypeEvaluateManager.addSuperClasses((TreeItem<String>)root, (Set<String>)visited, scope);
        TreeItem treeItem = root;
        if (treeItem == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(19);
        }
        return treeItem;
    }

    private static void addSuperClasses(TreeItem<String> node, Set<String> visited, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(20);
        }
        String nsName = JSTypeUtils.getTypeMatchingNamespace((String)node.getData());
        StubIndex.getInstance().processElements(JSBaseTypesIndex.KEY, (Object)nsName, scope.getProject(), scope, JSElement.class, element -> {
            Collection baseTypes;
            JSElementIndexingData indexingData;
            JSElementIndexingData jSElementIndexingData = indexingData = element instanceof JSImplicitElementProvider ? ((JSImplicitElementProvider)element).getIndexingData() : null;
            if (indexingData != null && (baseTypes = indexingData.getBaseTypes()) != null) {
                for (Pair baseType : baseTypes) {
                    if (!nsName.equals(baseType.first)) continue;
                    node.addChild(new TreeItem((Object)((String)baseType.second)));
                }
            }
            return true;
        });
        for (TreeItem child : node.getChildren()) {
            if (!visited.add((String)child.getData())) continue;
            JSTypeEvaluateManager.addSuperClasses((TreeItem<String>)child, visited, scope);
        }
    }

    @Nullable
    public static TreeItem<String> findSuperClass(@NotNull TreeItem<String> root, @NotNull String parentClassName) {
        JSType type;
        String rootQName;
        if (root == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(21);
        }
        if (parentClassName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(22);
        }
        String string = rootQName = (type = JSTypeUtils.createType((String)root.getData(), JSTypeSource.EXPLICITLY_DECLARED)) != null ? JSTypeUtils.getQualifiedNameMatchingType(type, true) : null;
        if (parentClassName.equals(rootQName)) {
            return root;
        }
        for (TreeItem child : root.getChildren()) {
            TreeItem<String> childSuper = JSTypeEvaluateManager.findSuperClass((TreeItem<String>)child, parentClassName);
            if (childSuper == null) continue;
            return childSuper;
        }
        return null;
    }

    @Nullable
    public static JSType expandTypedefs(@Nullable PsiElement context, @NotNull String typeName) {
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(23);
        }
        THashMap visited = new THashMap();
        THashSet notVisited = new THashSet();
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor((Map)visited, (Set)notVisited){
            final /* synthetic */ Map val$visited;
            final /* synthetic */ Set val$notVisited;
            {
                this.val$visited = map;
                this.val$notVisited = set;
            }

            public void visitJSTypeImpl(@NotNull JSType type) {
                String resolvedTypeText;
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type.isSourceStrict() && !this.val$visited.containsKey(resolvedTypeText = type.getResolvedTypeText())) {
                    this.val$notVisited.add(resolvedTypeText);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/index/JSTypeEvaluateManager$1", "visitJSTypeImpl"));
            }
        };
        notVisited.add(typeName);
        while (!notVisited.isEmpty()) {
            String next = (String)notVisited.iterator().next();
            notVisited.remove(next);
            JSType value = JSTypeEvaluateManager.getTypedefValue(context, next);
            visited.put(next, value);
            if (value == null) continue;
            value.accept(visitor);
        }
        Ref substitutionsLeft = Ref.create((Object)30);
        Function expandNestedDefs = arg_0 -> JSTypeEvaluateManager.lambda$expandTypedefs$3((Map)visited, substitutionsLeft, arg_0);
        JSType typedefValue = (JSType)visited.get(typeName);
        return typedefValue != null ? JSTypeUtils.applyCompositeMapping(typedefValue, (Function<JSType, JSType>)expandNestedDefs) : null;
    }

    @Nullable
    public static JSType getTypedefValue(@Nullable PsiElement context, String typeName) {
        if (context == null) {
            return null;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        Ref associatedType = Ref.create(null);
        Ref associatedTypeSource = Ref.create(null);
        StubIndex.getInstance().processElements(JSTypedefIndex.KEY, (Object)typeName, context.getProject(), scope, JSElement.class, element -> {
            if (!(element instanceof JSImplicitElementProvider)) {
                LOG.error("only JSImplicitElementProviders should add info to typedef index, found " + element.getClass());
                return true;
            }
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            if (data == null) {
                LOG.error("JSElementIndexingData mustn't be null for element referenced in typedef index");
                return true;
            }
            Collection typedefs = data.getTypedefs();
            if (typedefs == null || typedefs.isEmpty()) {
                LOG.error("JSElementIndexingData.getTypedef() mustn't be null");
                return true;
            }
            for (Pair typedef : typedefs) {
                if (!typeName.equals(typedef.first)) continue;
                associatedType.set((Object)JSTypedefIndex.getTypeByIndexValue((String)typedef.second));
                JSElement sourceElement = element;
                Collection implicitElements = data.getImplicitElements();
                if (implicitElements != null) {
                    for (JSImplicitElement implicitElement : implicitElements) {
                        if (!((String)typedef.first).equals(implicitElement.getQualifiedName())) continue;
                        sourceElement = implicitElement;
                        break;
                    }
                }
                associatedTypeSource.set((Object)sourceElement);
            }
            return false;
        });
        if (!associatedType.isNull()) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)associatedTypeSource.get(), true);
            return JSTypeUtils.parseSerializedOrJSDocType((String)associatedType.get(), source);
        }
        return null;
    }

    public static boolean iterateSubclasses(@NotNull PsiElement context, @NotNull String typeName, @NotNull Processor<JSType> processor) {
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(24);
        }
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(26);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        THashMap indexValues = new THashMap();
        Collection elements = StubIndex.getElements(JSSubclassIndex.KEY, (Object)typeName, (Project)context.getProject(), (GlobalSearchScope)scope, JSElement.class);
        for (JSElement element : elements) {
            Collection baseTypes;
            JSElementIndexingData indexingData = element instanceof JSImplicitElementProvider ? ((JSImplicitElementProvider)element).getIndexingData() : null;
            if (indexingData == null || (baseTypes = indexingData.getBaseTypes()) == null) continue;
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            Set fileBaseTypes = (Set)indexValues.get(virtualFile);
            if (fileBaseTypes == null) {
                fileBaseTypes = new THashSet();
                indexValues.put(virtualFile, fileBaseTypes);
            }
            for (Pair baseType : baseTypes) {
                fileBaseTypes.add((String)baseType.first);
            }
        }
        PsiManager psiManager = context.getManager();
        Collection<VirtualFile> files = JSResolveUtil.sortFiles(indexValues.keySet());
        for (VirtualFile file2 : files) {
            for (String s : (Set)indexValues.get(file2)) {
                JSType type = JSBaseTypesIndex.deserializeHierarchyElement(s, psiManager.findFile(file2));
                if (type == null || processor.process((Object)type)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static boolean isArrayType(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith("[]") || s.indexOf(91) != -1 || s.startsWith("...") || s.indexOf(60) != -1 && (s.startsWith("Vector") || s.startsWith("Array") || s.startsWith("Object"));
    }

    @Deprecated
    public static String getComponentType(String s) {
        JSType type;
        if (s.endsWith("[]")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.startsWith("...")) {
            return s.substring(3);
        }
        int i = s.indexOf(91);
        if (i != -1) {
            return s.substring(i + 1);
        }
        if (s.indexOf(60) != -1 && (s.startsWith("Vector") || s.startsWith("Array") || s.startsWith("Object")) && (type = new JSTypeParser(s, JSTypeSource.EMPTY).parse()) instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            List<JSType> genericArguments = genericType.getArguments();
            JSType lastGenericType = genericArguments.get(genericArguments.size() - 1);
            return lastGenericType.getResolvedTypeText();
        }
        return s;
    }

    @TestOnly
    public static void assertOnStubLoading(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(27);
        }
        JSTypeEvaluateManager.setFlag(parentDisposable, true, ourAssertOnStubLoading);
    }

    private static void setFlag(@NotNull Disposable parentDisposable, final boolean toAssert, final @NotNull AtomicBoolean flag) {
        boolean prev;
        if (parentDisposable == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(28);
        }
        if (flag == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(29);
        }
        if (toAssert == (prev = flag.get())) {
            return;
        }
        flag.set(toAssert);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (flag.get() != toAssert) {
                    throw new IllegalStateException("Non-nested assertion flag modifications");
                }
                flag.set(prev);
            }
        });
    }

    private static /* synthetic */ JSType lambda$expandTypedefs$3(Map visited, Ref substitutionsLeft, JSType type) {
        JSType typedefValue;
        if (type instanceof JSTypeImpl && (typedefValue = (JSType)visited.get(type.getResolvedTypeText())) != null && (Integer)substitutionsLeft.get() > 0) {
            substitutionsLeft.set((Object)((Integer)substitutionsLeft.get() - 1));
            return typedefValue;
        }
        return type;
    }

    private static /* synthetic */ boolean lambda$findNearestExtendedJSTypes$0(JSClassResolver resolver, PsiFile psiFile, List extendedTypes, Set hasNonImplicitNamespaceElement, JSType type) {
        if (type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC) {
            return true;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (qName == null) {
            return true;
        }
        for (JSPsiElementBase element : resolver.findElementsByQNameIncludingImplicit(qName, JSResolveUtil.getResolveScope((PsiElement)psiFile))) {
            extendedTypes.add(Pair.create((Object)element, (Object)qName));
            if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance()) continue;
            hasNonImplicitNamespaceElement.add(qName);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionQName";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myContext";
                break;
            }
            case 3: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSuperClassesHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findNearestExtendedJSTypes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchy";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchyFromJSClasses";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchyFromBaseTypesIndex";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceBaseTypes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildSuperClassesHierarchy";
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addSuperClasses";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSuperClass";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "expandTypedefs";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "iterateSubclasses";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "assertOnStubLoading";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setFlag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class JSHierarchyProcessingState {
        private final Map<String, List<VirtualFile>> myCurrentBaseTypes;
        private final Set<String> myProcessedSerializedTypes;
        private final Deque<JSType> myBaseTypesQueue;
        private final JSNamespace myInitialType;
        private boolean myInitialTypeProcessed;

        private JSHierarchyProcessingState(@NotNull JSNamespace initialType) {
            if (initialType == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(0);
            }
            this.myCurrentBaseTypes = new LinkedHashMap<String, List<VirtualFile>>();
            this.myProcessedSerializedTypes = new HashSet<String>();
            this.myBaseTypesQueue = new ArrayDeque<JSType>();
            this.myInitialTypeProcessed = false;
            this.myInitialType = initialType;
        }

        public boolean hasNext() {
            return !this.myInitialTypeProcessed || !this.myBaseTypesQueue.isEmpty();
        }

        @NotNull
        public JSType next() {
            if (!this.myInitialTypeProcessed) {
                this.myInitialTypeProcessed = true;
                JSNamespace jSNamespace = this.myInitialType;
                if (jSNamespace == null) {
                    JSHierarchyProcessingState.$$$reportNull$$$0(1);
                }
                return jSNamespace;
            }
            JSType jSType = this.myBaseTypesQueue.removeFirst();
            if (jSType == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(2);
            }
            return jSType;
        }

        public void addBaseType(@NotNull VirtualFile file2, @NotNull String inherited) {
            if (file2 == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(3);
            }
            if (inherited == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(4);
            }
            if (!this.myProcessedSerializedTypes.contains(inherited)) {
                SmartList files = this.myCurrentBaseTypes.get(inherited);
                if (files == null) {
                    files = new SmartList();
                    this.myCurrentBaseTypes.put(inherited, (List<VirtualFile>)files);
                }
                if (!files.contains(file2)) {
                    files.add(file2);
                }
            }
        }

        @NotNull
        public List<JSType> pullResults(@NotNull PsiManager psiManager) {
            if (psiManager == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(5);
            }
            this.myProcessedSerializedTypes.addAll(this.myCurrentBaseTypes.keySet());
            SmartList result2 = new SmartList();
            for (Map.Entry<String, List<VirtualFile>> entry : this.myCurrentBaseTypes.entrySet()) {
                Collection<VirtualFile> files = JSResolveUtil.sortFiles((Collection<? extends VirtualFile>)entry.getValue());
                for (VirtualFile file2 : files) {
                    JSType type = JSBaseTypesIndex.deserializeHierarchyElement(entry.getKey(), psiManager.findFile(file2));
                    if (type == null) continue;
                    result2.add(type);
                    this.myBaseTypesQueue.addLast(type);
                }
            }
            this.myCurrentBaseTypes.clear();
            SmartList smartList = result2;
            if (smartList == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(6);
            }
            return smartList;
        }

        public boolean hasObjectInHierarchy() {
            return this.myInitialType instanceof JSObjectType || this.myProcessedSerializedTypes.contains("Object");
        }

        public boolean isInitialType(@Nullable JSNamespace type) {
            return type == this.myInitialType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialType";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager$JSHierarchyProcessingState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inherited";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager$JSHierarchyProcessingState";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "next";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pullResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addBaseType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "pullResults";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

