/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.type.jsclass;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.lang.javascript.hierarchy.type.jsclass.JSSubtypesHierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.type.jsclass.JSTypeHierarchyNodeDescriptor;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;

public final class JSTypeHierarchyTreeStructure
extends JSSubtypesHierarchyTreeStructure {
    public JSTypeHierarchyTreeStructure(Project project, JSClass jsClass) {
        super(project, JSTypeHierarchyTreeStructure.buildHierarchyElement(project, jsClass));
        this.setBaseElement(this.myBaseDescriptor);
    }

    private static HierarchyNodeDescriptor buildHierarchyElement(Project project, JSClass jsClass) {
        JSTypeHierarchyNodeDescriptor descriptor2 = null;
        JSClass[] superClasses = JSTypeHierarchyTreeStructure.createSuperClasses(jsClass);
        for (int i = superClasses.length - 1; i >= 0; --i) {
            JSClass superClass = superClasses[i];
            JSTypeHierarchyNodeDescriptor newDescriptor = new JSTypeHierarchyNodeDescriptor(project, descriptor2, superClass, false);
            if (descriptor2 != null) {
                descriptor2.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor2 = newDescriptor;
        }
        JSTypeHierarchyNodeDescriptor newDescriptor = new JSTypeHierarchyNodeDescriptor(project, descriptor2, jsClass, true);
        if (descriptor2 != null) {
            descriptor2.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static JSClass[] createSuperClasses(JSClass jsClass) {
        if (!jsClass.isValid()) {
            return JSClass.EMPTY_ARRAY;
        }
        if (jsClass.isInterface()) {
            return JSClass.EMPTY_ARRAY;
        }
        ArrayList<JSClass> superClasses = new ArrayList<JSClass>();
        while (!JSResolveUtil.isObjectClass((JSPsiElementBase)jsClass)) {
            JSClass aClass1 = jsClass;
            JSClass[] superTypes = aClass1.getSupers();
            JSClass superType = null;
            for (JSClass type : superTypes) {
                if (type.isInterface()) continue;
                superType = type;
                break;
            }
            if (superType == null || superClasses.contains(superType)) break;
            superClasses.add(superType);
            jsClass = superType;
        }
        return superClasses.toArray(JSClass.EMPTY_ARRAY);
    }
}

