/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.call;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.hierarchy.call.JSCallHierarchyNodeDescriptor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSCallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)JSCallerMethodsTreeStructure.class.getName());
    private final String myScopeType;

    public JSCallerMethodsTreeStructure(Project project, PsiElement functionOrOwner, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new JSCallHierarchyNodeDescriptor(project, null, functionOrOwner, true, false));
        this.myScopeType = scopeType;
    }

    protected final Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        JSQualifiedNamedElement initializedElement;
        PsiElement parent;
        if (descriptor2 == null) {
            JSCallerMethodsTreeStructure.$$$reportNull$$$0(0);
        }
        PsiElement candidate = ((JSCallHierarchyNodeDescriptor)descriptor2).getEnclosingElement();
        while (candidate instanceof JSFunctionExpression && JSPsiImplUtils.getInitializedElement((JSExpression)candidate) == null && (parent = candidate.getParent()) != null) {
            candidate = JSCallHierarchyNodeDescriptor.getEnclosingElement(parent);
        }
        if (!(candidate instanceof JSFunctionItem)) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                JSCallerMethodsTreeStructure.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        JSFunctionItem enclosingElement = (JSFunctionItem)candidate;
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        if ("This Class".equals(this.myScopeType)) {
            PsiElement baseMethod = ((JSCallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
            JSClass containingClass = JSResolveUtil.getClassOfContext(baseMethod);
            searchScope = containingClass == null ? GlobalSearchScope.EMPTY_SCOPE : new LocalSearchScope((PsiElement)containingClass);
        } else if ("Production".equals(this.myScopeType)) {
            searchScope = GlobalSearchScopesCore.projectProductionScope((Project)this.myProject);
        } else if ("Test".equals(this.myScopeType)) {
            searchScope = GlobalSearchScopesCore.projectTestScope((Project)this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)this.myScopeType);
            if (namedScope != null) {
                searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope);
            }
        }
        JSFunctionItem elementForHierarchySearch = enclosingElement;
        JSExpression functionExpressionToAdd = null;
        if (enclosingElement instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)enclosingElement)) != null && initializedElement != enclosingElement) {
            functionExpressionToAdd = (JSExpression)enclosingElement;
            elementForHierarchySearch = initializedElement;
        }
        SmartList methodsToFind = new SmartList();
        if (elementForHierarchySearch instanceof JSQualifiedNamedElement) {
            methodsToFind.addAll(JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)elementForHierarchySearch));
        } else {
            methodsToFind.add(elementForHierarchySearch);
        }
        LinkedHashMap methodToDescriptorMap = new LinkedHashMap();
        for (PsiElement methodToFind : methodsToFind) {
            ReferencesSearch.search((PsiElement)methodToFind, (SearchScope)searchScope, (boolean)true).forEach(reference -> this.processReference((PsiReference)reference, methodToFind, (PsiElement)enclosingElement, descriptor2, methodToDescriptorMap));
        }
        if (functionExpressionToAdd instanceof JSFunctionExpression && ((JSFunctionExpression)functionExpressionToAdd).getOwnNameIdentifier() != null) {
            JSFunctionExpression functionExpression = (JSFunctionExpression)functionExpressionToAdd;
            ReferencesSearch.search((PsiElement)functionExpression, (SearchScope)new LocalSearchScope((PsiElement)functionExpression), (boolean)true).forEach(reference -> this.processReference((PsiReference)reference, (PsiElement)functionExpression, (PsiElement)enclosingElement, descriptor2, methodToDescriptorMap));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(methodToDescriptorMap.values());
        if (objectArray == null) {
            JSCallerMethodsTreeStructure.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processReference(PsiReference reference, @NotNull PsiElement methodToFind, @NotNull PsiElement enclosingElement, @NotNull HierarchyNodeDescriptor descriptor2, @NotNull Map<PsiElement, JSCallHierarchyNodeDescriptor> methodToDescriptorMap) {
        PsiElement key;
        JSExpression qualifier;
        if (methodToFind == null) {
            JSCallerMethodsTreeStructure.$$$reportNull$$$0(3);
        }
        if (enclosingElement == null) {
            JSCallerMethodsTreeStructure.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            JSCallerMethodsTreeStructure.$$$reportNull$$$0(5);
        }
        if (methodToDescriptorMap == null) {
            JSCallerMethodsTreeStructure.$$$reportNull$$$0(6);
        }
        if (!(reference instanceof JSPsiReferenceElement)) {
            return true;
        }
        if (reference instanceof JSReferenceExpression && JSResolveUtil.isSameReference((JSReferenceExpression)reference, methodToFind)) {
            return true;
        }
        JSPsiReferenceElement element = (JSPsiReferenceElement)reference;
        if (!(element.getParent() instanceof JSCallExpression) && methodToFind instanceof JSFunctionItem) {
            ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)element);
            if (((JSFunctionItem)methodToFind).isGetProperty() ? access == ReadWriteAccessDetector.Access.Write : ((JSFunctionItem)methodToFind).isSetProperty() && access == ReadWriteAccessDetector.Access.Read) {
                return true;
            }
        }
        JSExpression jSExpression = qualifier = reference instanceof JSQualifiedExpression ? ((JSQualifiedExpression)reference).getQualifier() : null;
        if (qualifier instanceof JSSuperExpression) {
            PsiElement psiElement;
            PsiReference psiReference = qualifier.getReference();
            PsiElement psiElement2 = psiElement = psiReference == null ? null : psiReference.resolve();
            if (psiElement instanceof JSClass) {
                JSClass superClass = (JSClass)psiElement;
                JSClass methodClass = JSResolveUtil.getClassOfContext(enclosingElement);
                if (methodClass != null && JSInheritanceUtil.isParentClass(methodClass, superClass)) {
                    return true;
                }
            }
        }
        if ((key = JSCallHierarchyNodeDescriptor.getEnclosingElement((PsiElement)element)) == null) {
            LOG.debug("Enclosing element for element " + element.getText() + " in file " + element.getContainingFile() + " is null");
            return true;
        }
        Map<PsiElement, JSCallHierarchyNodeDescriptor> map = methodToDescriptorMap;
        synchronized (map) {
            JSCallHierarchyNodeDescriptor d = methodToDescriptorMap.get(key);
            if (d == null) {
                d = new JSCallHierarchyNodeDescriptor(this.myProject, descriptor2, (PsiElement)element, false, true);
                methodToDescriptorMap.put(key, d);
            } else {
                d.incrementUsageCount();
            }
            d.addReference(reference);
        }
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/call/JSCallerMethodsTreeStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodToFind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodToDescriptorMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/call/JSCallerMethodsTreeStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

