/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class WebpackUtil {
    @TestOnly
    public static final Key<WebpackVersion> FORCE_WEBPACK_VERSION_IN_TEST_KEY = Key.create((String)"JavaScript.Webpack.Version.For.Tests");
    private static final String WEBPACK = "webpack";

    @NotNull
    public static WebpackVersion getWebpackVersion(Project project) {
        WebpackVersion webpackVersion;
        WebpackVersion version;
        if (ApplicationManager.getApplication().isUnitTestMode() && (version = (WebpackVersion)((Object)project.getUserData(FORCE_WEBPACK_VERSION_IN_TEST_KEY))) != null) {
            WebpackVersion webpackVersion2 = version;
            if (webpackVersion2 == null) {
                WebpackUtil.$$$reportNull$$$0(0);
            }
            return webpackVersion2;
        }
        VirtualFile projectBaseDir = project.getBaseDir();
        if (project.isDefault() || projectBaseDir == null || project.isDisposed()) {
            WebpackVersion webpackVersion3 = WebpackVersion.NO;
            if (webpackVersion3 == null) {
                WebpackUtil.$$$reportNull$$$0(1);
            }
            return webpackVersion3;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(projectBaseDir);
        if (packageJson != null && !WebpackVersion.UNKNOWN.equals((Object)(webpackVersion = WebpackUtil.checkInPackageJsonVersion(project, packageJson)))) {
            WebpackVersion webpackVersion4 = webpackVersion;
            if (webpackVersion4 == null) {
                WebpackUtil.$$$reportNull$$$0(2);
            }
            return webpackVersion4;
        }
        WebpackVersion webpackVersion5 = WebpackUtil.getWebpackVersionFromNodeModules(projectBaseDir);
        if (webpackVersion5 == null) {
            WebpackUtil.$$$reportNull$$$0(3);
        }
        return webpackVersion5;
    }

    private static WebpackVersion getWebpackVersionFromNodeModules(@NotNull VirtualFile folder) {
        PackageJsonData data;
        VirtualFile webpackPackageJson;
        if (folder == null) {
            WebpackUtil.$$$reportNull$$$0(4);
        }
        if ((webpackPackageJson = VfsUtil.findRelativeFile((VirtualFile)folder, (String[])new String[]{"node_modules", WEBPACK, "package.json"})) != null && (data = PackageJsonData.getOrCreate(webpackPackageJson)).getVersion() != null) {
            if (data.getVersion().getMajor() >= 4) {
                return WebpackVersion.LIKE4;
            }
            if (data.getVersion().getMajor() >= 2) {
                return WebpackVersion.LIKE2;
            }
        }
        return WebpackVersion.NO;
    }

    private static WebpackVersion checkInPackageJsonVersion(Project project, VirtualFile packageJson) {
        PackageJsonDependencies dependencies = PackageJsonDependencies.getOrCreate(project, packageJson);
        if (dependencies == null) {
            return WebpackVersion.NO;
        }
        String versionText = dependencies.getDependencies().get(WEBPACK);
        if (versionText == null) {
            versionText = dependencies.getDevDependencies().get(WEBPACK);
        }
        if (versionText != null) {
            ThreeState four = PackageJsonUtil.isVersionGreaterOrEqualMajor(versionText, 4);
            if (ThreeState.YES.equals((Object)four)) {
                return WebpackVersion.LIKE4;
            }
            if (ThreeState.UNSURE.equals((Object)four)) {
                return WebpackVersion.UNKNOWN;
            }
            ThreeState two = PackageJsonUtil.isVersionGreaterOrEqualMajor(versionText, 2);
            if (ThreeState.YES.equals((Object)two)) {
                return WebpackVersion.LIKE2;
            }
            if (ThreeState.UNSURE.equals((Object)two)) {
                return WebpackVersion.UNKNOWN;
            }
        }
        return WebpackVersion.NO;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/webpack/WebpackUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebpackVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/webpack/WebpackUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWebpackVersionFromNodeModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum WebpackVersion {
        LIKE2,
        LIKE4,
        UNKNOWN,
        NO;

    }
}

