/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.systemjs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemJSIndexingHandler
extends FrameworkIndexingHandler {
    public static final String KEY = "System.config";
    public static final String SYSTEM_TEXT = "System";
    public static final String SYSTEM_JS_TEXT = "SystemJS";

    @Override
    @Nullable
    public String getCustomStringIndexKey(@NotNull PsiElement elementToIndex) {
        if (elementToIndex == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(0);
        }
        if (SystemJSIndexingHandler.isObjectLiteralInSystemConfigCall(elementToIndex)) {
            return KEY;
        }
        return super.getCustomStringIndexKey(elementToIndex);
    }

    private static boolean isObjectLiteralInSystemConfigCall(PsiElement elementToIndex) {
        if (!(elementToIndex instanceof JSObjectLiteralExpression)) {
            return false;
        }
        PsiElement parent = elementToIndex.getParent();
        if (parent instanceof JSArgumentList) {
            parent = parent.getParent();
        }
        if (!(parent instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression call = (JSCallExpression)parent;
        return SystemJSIndexingHandler.checkIndexedDataInCallExpression(call);
    }

    private static boolean checkIndexedDataInCallExpression(JSCallExpression call) {
        Map strings;
        JSElementIndexingData data = call.getIndexingData();
        return data != null && (strings = data.getUserStrings()) != null && strings.containsKey(KEY);
    }

    private static boolean checkIsSystemConfigCall(@NotNull JSCallExpression call) {
        JSExpression expression;
        if (call == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(1);
        }
        if ((expression = call.getMethodExpression()) instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            if (!(qualifier instanceof JSReferenceExpression) || ((JSReferenceExpression)qualifier).getQualifier() != null) {
                return false;
            }
            String text = ((JSReferenceExpression)expression).getReferenceName();
            String qualifierText = ((JSReferenceExpression)qualifier).getReferenceName();
            return SystemJSIndexingHandler.isSystemConfigReference(text, qualifierText);
        }
        return false;
    }

    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(2);
        }
        if (SystemJSIndexingHandler.checkIsSystemConfigCall(callExpression)) {
            this.putUserString(outData, "");
        }
        super.processCallExpression(callExpression, outData);
    }

    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode methodExpression = node.getFirstChildNode();
        if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        ASTNode qualifier = methodExpression.getFirstChildNode();
        if (qualifier == null) {
            return false;
        }
        String qualifierText = qualifier.getText();
        String refText = referencedNameElement.getText();
        return SystemJSIndexingHandler.isSystemConfigReference(refText, qualifierText);
    }

    private static boolean isSystemConfigReference(@Nullable String refText, @Nullable String qualifierText) {
        return "config".equals(refText) && (StringUtil.equalsIgnoreCase((CharSequence)SYSTEM_TEXT, (CharSequence)qualifierText) || StringUtil.equalsIgnoreCase((CharSequence)SYSTEM_JS_TEXT, (CharSequence)qualifierText));
    }

    @Override
    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        if (expression == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(3);
        }
        return this.shouldCreateStubForLiteral(expression.getNode());
    }

    private boolean checkInSystemConfigArgumentList(@Nullable ASTNode parent) {
        if (parent != null && parent.getElementType() == JSElementTypes.ARGUMENT_LIST) {
            ASTNode grandParent = parent.getTreeParent();
            return grandParent != null && grandParent.getElementType() == JSStubElementTypes.CALL_EXPRESSION && this.shouldCreateStubForCallExpression(grandParent);
        }
        return false;
    }

    @Override
    public boolean shouldCreateStubForLiteral(ASTNode node) {
        ASTNode objectLiteral = SystemJSIndexingHandler.getLiteralParentNode(node);
        if (objectLiteral == null) {
            return false;
        }
        if (this.checkInSystemConfigArgumentList(objectLiteral.getTreeParent())) {
            return true;
        }
        ASTNode grandObjectLiteral = SystemJSIndexingHandler.getLiteralParentNode(objectLiteral);
        if (grandObjectLiteral == null) {
            return false;
        }
        return this.checkInSystemConfigArgumentList(grandObjectLiteral.getTreeParent());
    }

    @Nullable
    private static ASTNode getLiteralParentNode(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        if (parent == null || !(parent.getElementType() instanceof JSPropertyElementType)) {
            return null;
        }
        ASTNode grandParent = parent.getTreeParent();
        return grandParent != null && grandParent.getElementType() == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION ? grandParent : null;
    }

    @Override
    @Nullable
    protected String getJSElementIndexingDataUserStringKey() {
        return KEY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSIndexingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomStringIndexKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIsSystemConfigCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processCallExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSignificantValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

